/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.chat.ChatUpdateMessageResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ChatUpdateMessageResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChatUpdateMessageResponse
implements ChatUpdateMessageResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final String ts;
    private final String channel;
    private final String text;

    private ChatUpdateMessageResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, String ts, String channel, String text) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.ts = ts;
        this.channel = channel;
        this.text = text;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public String getTs() {
        return this.ts;
    }

    @Override
    @JsonProperty
    public String getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public String getText() {
        return this.text;
    }

    public final ChatUpdateMessageResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new ChatUpdateMessageResponse(value, this.responseMetadata, this.ts, this.channel, this.text);
    }

    public final ChatUpdateMessageResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ChatUpdateMessageResponse(this.ok, newValue, this.ts, this.channel, this.text);
    }

    public final ChatUpdateMessageResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ChatUpdateMessageResponse(this.ok, value, this.ts, this.channel, this.text);
    }

    public final ChatUpdateMessageResponse withTs(String value) {
        String newValue = Objects.requireNonNull(value, "ts");
        if (this.ts.equals(newValue)) {
            return this;
        }
        return new ChatUpdateMessageResponse(this.ok, this.responseMetadata, newValue, this.channel, this.text);
    }

    public final ChatUpdateMessageResponse withChannel(String value) {
        String newValue = Objects.requireNonNull(value, "channel");
        if (this.channel.equals(newValue)) {
            return this;
        }
        return new ChatUpdateMessageResponse(this.ok, this.responseMetadata, this.ts, newValue, this.text);
    }

    public final ChatUpdateMessageResponse withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ChatUpdateMessageResponse(this.ok, this.responseMetadata, this.ts, this.channel, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatUpdateMessageResponse && this.equalTo(0, (ChatUpdateMessageResponse)another);
    }

    private boolean equalTo(int synthetic, ChatUpdateMessageResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.ts.equals(another.ts) && this.channel.equals(another.channel) && this.text.equals(another.text);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.ts.hashCode();
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChatUpdateMessageResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("ts=").append(this.ts);
        builder.append(", ");
        builder.append("channel=").append(this.channel);
        builder.append(", ");
        builder.append("text=").append(this.text);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChatUpdateMessageResponse fromJson(Json json) {
        Builder builder = ChatUpdateMessageResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.ts != null) {
            builder.setTs(json.ts);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        return builder.build();
    }

    public static ChatUpdateMessageResponse copyOf(ChatUpdateMessageResponseIF instance) {
        if (instance instanceof ChatUpdateMessageResponse) {
            return (ChatUpdateMessageResponse)instance;
        }
        return ChatUpdateMessageResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ChatUpdateMessageResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long INIT_BIT_TS = 2L;
        private static final long INIT_BIT_CHANNEL = 4L;
        private static final long INIT_BIT_TEXT = 8L;
        private long initBits = 15L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        @Nullable
        private String ts;
        @Nullable
        private String channel;
        @Nullable
        private String text;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ChatUpdateMessageResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof ChatUpdateMessageResponseIF) {
                instance = (ChatUpdateMessageResponseIF)object;
                this.setChannel(instance.getChannel());
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
                this.setText(instance.getText());
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                this.setTs(instance.getTs());
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder setTs(String ts) {
            this.ts = Objects.requireNonNull(ts, "ts");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setChannel(String channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setText(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ChatUpdateMessageResponse build() {
            this.checkRequiredAttributes();
            return new ChatUpdateMessageResponse(this.ok, this.responseMetadata, this.ts, this.channel, this.text);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean tsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean channelIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean textIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            if (!this.tsIsSet()) {
                attributes.add("ts");
            }
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            if (!this.textIsSet()) {
                attributes.add("text");
            }
            return "Cannot build ChatUpdateMessageResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChatUpdateMessageResponseIF", generator="Immutables")
    static final class Json
    implements ChatUpdateMessageResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        String ts;
        @Nullable
        String channel;
        @Nullable
        String text;

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setTs(String ts) {
            this.ts = ts;
        }

        @JsonProperty
        public void setChannel(String channel) {
            this.channel = channel;
        }

        @JsonProperty
        public void setText(String text) {
            this.text = text;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getText() {
            throw new UnsupportedOperationException();
        }
    }
}

