/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.chat.ChatScheduleMessageResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ChatScheduleMessageResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChatScheduleMessageResponse
implements ChatScheduleMessageResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final String channel;
    private final String scheduledMessageId;
    private final String postAt;
    private final Map<String, Object> message;

    private ChatScheduleMessageResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, String channel, String scheduledMessageId, String postAt, Map<String, Object> message) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.channel = channel;
        this.scheduledMessageId = scheduledMessageId;
        this.postAt = postAt;
        this.message = message;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public String getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public String getScheduledMessageId() {
        return this.scheduledMessageId;
    }

    @Override
    @JsonProperty
    public String getPostAt() {
        return this.postAt;
    }

    @Override
    @JsonProperty
    public Map<String, Object> getMessage() {
        return this.message;
    }

    public final ChatScheduleMessageResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new ChatScheduleMessageResponse(value, this.responseMetadata, this.channel, this.scheduledMessageId, this.postAt, this.message);
    }

    public final ChatScheduleMessageResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ChatScheduleMessageResponse(this.ok, newValue, this.channel, this.scheduledMessageId, this.postAt, this.message);
    }

    public final ChatScheduleMessageResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ChatScheduleMessageResponse(this.ok, value, this.channel, this.scheduledMessageId, this.postAt, this.message);
    }

    public final ChatScheduleMessageResponse withChannel(String value) {
        String newValue = Objects.requireNonNull(value, "channel");
        if (this.channel.equals(newValue)) {
            return this;
        }
        return new ChatScheduleMessageResponse(this.ok, this.responseMetadata, newValue, this.scheduledMessageId, this.postAt, this.message);
    }

    public final ChatScheduleMessageResponse withScheduledMessageId(String value) {
        String newValue = Objects.requireNonNull(value, "scheduledMessageId");
        if (this.scheduledMessageId.equals(newValue)) {
            return this;
        }
        return new ChatScheduleMessageResponse(this.ok, this.responseMetadata, this.channel, newValue, this.postAt, this.message);
    }

    public final ChatScheduleMessageResponse withPostAt(String value) {
        String newValue = Objects.requireNonNull(value, "postAt");
        if (this.postAt.equals(newValue)) {
            return this;
        }
        return new ChatScheduleMessageResponse(this.ok, this.responseMetadata, this.channel, this.scheduledMessageId, newValue, this.message);
    }

    public final ChatScheduleMessageResponse withMessage(Map<String, ? extends Object> entries) {
        if (this.message == entries) {
            return this;
        }
        Map<String, Object> newValue = ChatScheduleMessageResponse.createUnmodifiableMap(true, false, entries);
        return new ChatScheduleMessageResponse(this.ok, this.responseMetadata, this.channel, this.scheduledMessageId, this.postAt, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatScheduleMessageResponse && this.equalTo(0, (ChatScheduleMessageResponse)another);
    }

    private boolean equalTo(int synthetic, ChatScheduleMessageResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.channel.equals(another.channel) && this.scheduledMessageId.equals(another.scheduledMessageId) && this.postAt.equals(another.postAt) && this.message.equals(another.message);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.scheduledMessageId.hashCode();
        h += (h << 5) + this.postAt.hashCode();
        h += (h << 5) + this.message.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChatScheduleMessageResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("channel=").append(this.channel);
        builder.append(", ");
        builder.append("scheduledMessageId=").append(this.scheduledMessageId);
        builder.append(", ");
        builder.append("postAt=").append(this.postAt);
        builder.append(", ");
        builder.append("message=").append(this.message);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChatScheduleMessageResponse fromJson(Json json) {
        Builder builder = ChatScheduleMessageResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        if (json.scheduledMessageId != null) {
            builder.setScheduledMessageId(json.scheduledMessageId);
        }
        if (json.postAt != null) {
            builder.setPostAt(json.postAt);
        }
        if (json.message != null) {
            builder.putAllMessage(json.message);
        }
        return builder.build();
    }

    public static ChatScheduleMessageResponse copyOf(ChatScheduleMessageResponseIF instance) {
        if (instance instanceof ChatScheduleMessageResponse) {
            return (ChatScheduleMessageResponse)instance;
        }
        return ChatScheduleMessageResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ChatScheduleMessageResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long INIT_BIT_CHANNEL = 2L;
        private static final long INIT_BIT_SCHEDULED_MESSAGE_ID = 4L;
        private static final long INIT_BIT_POST_AT = 8L;
        private long initBits = 15L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        @Nullable
        private String channel;
        @Nullable
        private String scheduledMessageId;
        @Nullable
        private String postAt;
        private Map<String, Object> message = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ChatScheduleMessageResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof ChatScheduleMessageResponseIF) {
                instance = (ChatScheduleMessageResponseIF)object;
                this.setChannel(instance.getChannel());
                this.setPostAt(instance.getPostAt());
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
                this.putAllMessage(instance.getMessage());
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                this.setScheduledMessageId(instance.getScheduledMessageId());
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder setChannel(String channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setScheduledMessageId(String scheduledMessageId) {
            this.scheduledMessageId = Objects.requireNonNull(scheduledMessageId, "scheduledMessageId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setPostAt(String postAt) {
            this.postAt = Objects.requireNonNull(postAt, "postAt");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder putMessage(String key, Object value) {
            this.message.put(Objects.requireNonNull(key, "message key"), Objects.requireNonNull(value, value == null ? "message value for key: " + key : null));
            return this;
        }

        public final Builder putMessage(Map.Entry<String, ? extends Object> entry) {
            Object v;
            String k = entry.getKey();
            this.message.put(Objects.requireNonNull(k, "message key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "message value for key: " + k : null));
            return this;
        }

        public final Builder setMessage(Map<String, ? extends Object> entries) {
            this.message.clear();
            return this.putAllMessage(entries);
        }

        public final Builder putAllMessage(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                Object v;
                String k = e.getKey();
                this.message.put(Objects.requireNonNull(k, "message key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "message value for key: " + k : null));
            }
            return this;
        }

        public ChatScheduleMessageResponse build() {
            this.checkRequiredAttributes();
            return new ChatScheduleMessageResponse(this.ok, this.responseMetadata, this.channel, this.scheduledMessageId, this.postAt, ChatScheduleMessageResponse.createUnmodifiableMap(false, false, this.message));
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean scheduledMessageIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean postAtIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            if (!this.scheduledMessageIdIsSet()) {
                attributes.add("scheduledMessageId");
            }
            if (!this.postAtIsSet()) {
                attributes.add("postAt");
            }
            return "Cannot build ChatScheduleMessageResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChatScheduleMessageResponseIF", generator="Immutables")
    static final class Json
    implements ChatScheduleMessageResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        String channel;
        @Nullable
        String scheduledMessageId;
        @Nullable
        String postAt;
        @Nullable
        Map<String, Object> message = Collections.emptyMap();

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setChannel(String channel) {
            this.channel = channel;
        }

        @JsonProperty
        public void setScheduledMessageId(String scheduledMessageId) {
            this.scheduledMessageId = scheduledMessageId;
        }

        @JsonProperty
        public void setPostAt(String postAt) {
            this.postAt = postAt;
        }

        @JsonProperty
        public void setMessage(Map<String, Object> message) {
            this.message = message;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getScheduledMessageId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPostAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getMessage() {
            throw new UnsupportedOperationException();
        }
    }
}

