/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.chat.ChatGetPermalinkResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ChatGetPermalinkResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChatGetPermalinkResponse
implements ChatGetPermalinkResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final String channel;
    private final String permalink;

    private ChatGetPermalinkResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, String channel, String permalink) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.channel = channel;
        this.permalink = permalink;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public String getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public String getPermalink() {
        return this.permalink;
    }

    public final ChatGetPermalinkResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new ChatGetPermalinkResponse(value, this.responseMetadata, this.channel, this.permalink);
    }

    public final ChatGetPermalinkResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ChatGetPermalinkResponse(this.ok, newValue, this.channel, this.permalink);
    }

    public final ChatGetPermalinkResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ChatGetPermalinkResponse(this.ok, value, this.channel, this.permalink);
    }

    public final ChatGetPermalinkResponse withChannel(String value) {
        String newValue = Objects.requireNonNull(value, "channel");
        if (this.channel.equals(newValue)) {
            return this;
        }
        return new ChatGetPermalinkResponse(this.ok, this.responseMetadata, newValue, this.permalink);
    }

    public final ChatGetPermalinkResponse withPermalink(String value) {
        String newValue = Objects.requireNonNull(value, "permalink");
        if (this.permalink.equals(newValue)) {
            return this;
        }
        return new ChatGetPermalinkResponse(this.ok, this.responseMetadata, this.channel, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatGetPermalinkResponse && this.equalTo(0, (ChatGetPermalinkResponse)another);
    }

    private boolean equalTo(int synthetic, ChatGetPermalinkResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.channel.equals(another.channel) && this.permalink.equals(another.permalink);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.permalink.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChatGetPermalinkResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("channel=").append(this.channel);
        builder.append(", ");
        builder.append("permalink=").append(this.permalink);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChatGetPermalinkResponse fromJson(Json json) {
        Builder builder = ChatGetPermalinkResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        if (json.permalink != null) {
            builder.setPermalink(json.permalink);
        }
        return builder.build();
    }

    public static ChatGetPermalinkResponse copyOf(ChatGetPermalinkResponseIF instance) {
        if (instance instanceof ChatGetPermalinkResponse) {
            return (ChatGetPermalinkResponse)instance;
        }
        return ChatGetPermalinkResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ChatGetPermalinkResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long INIT_BIT_CHANNEL = 2L;
        private static final long INIT_BIT_PERMALINK = 4L;
        private long initBits = 7L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        @Nullable
        private String channel;
        @Nullable
        private String permalink;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ChatGetPermalinkResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof ChatGetPermalinkResponseIF) {
                instance = (ChatGetPermalinkResponseIF)object;
                this.setChannel(instance.getChannel());
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                this.setPermalink(instance.getPermalink());
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder setChannel(String channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setPermalink(String permalink) {
            this.permalink = Objects.requireNonNull(permalink, "permalink");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ChatGetPermalinkResponse build() {
            this.checkRequiredAttributes();
            return new ChatGetPermalinkResponse(this.ok, this.responseMetadata, this.channel, this.permalink);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean permalinkIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            if (!this.permalinkIsSet()) {
                attributes.add("permalink");
            }
            return "Cannot build ChatGetPermalinkResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChatGetPermalinkResponseIF", generator="Immutables")
    static final class Json
    implements ChatGetPermalinkResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        String channel;
        @Nullable
        String permalink;

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setChannel(String channel) {
            this.channel = channel;
        }

        @JsonProperty
        public void setPermalink(String permalink) {
            this.permalink = permalink;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPermalink() {
            throw new UnsupportedOperationException();
        }
    }
}

