/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.chat.ChatDeleteResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ChatDeleteResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChatDeleteResponse
implements ChatDeleteResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final String channelId;
    private final String deletedMessageTs;

    private ChatDeleteResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, String channelId, String deletedMessageTs) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.channelId = channelId;
        this.deletedMessageTs = deletedMessageTs;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty(value="ts")
    public String getDeletedMessageTs() {
        return this.deletedMessageTs;
    }

    public final ChatDeleteResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new ChatDeleteResponse(value, this.responseMetadata, this.channelId, this.deletedMessageTs);
    }

    public final ChatDeleteResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ChatDeleteResponse(this.ok, newValue, this.channelId, this.deletedMessageTs);
    }

    public final ChatDeleteResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ChatDeleteResponse(this.ok, value, this.channelId, this.deletedMessageTs);
    }

    public final ChatDeleteResponse withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new ChatDeleteResponse(this.ok, this.responseMetadata, newValue, this.deletedMessageTs);
    }

    public final ChatDeleteResponse withDeletedMessageTs(String value) {
        String newValue = Objects.requireNonNull(value, "deletedMessageTs");
        if (this.deletedMessageTs.equals(newValue)) {
            return this;
        }
        return new ChatDeleteResponse(this.ok, this.responseMetadata, this.channelId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatDeleteResponse && this.equalTo(0, (ChatDeleteResponse)another);
    }

    private boolean equalTo(int synthetic, ChatDeleteResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.channelId.equals(another.channelId) && this.deletedMessageTs.equals(another.deletedMessageTs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.deletedMessageTs.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChatDeleteResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("deletedMessageTs=").append(this.deletedMessageTs);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChatDeleteResponse fromJson(Json json) {
        Builder builder = ChatDeleteResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.deletedMessageTs != null) {
            builder.setDeletedMessageTs(json.deletedMessageTs);
        }
        return builder.build();
    }

    public static ChatDeleteResponse copyOf(ChatDeleteResponseIF instance) {
        if (instance instanceof ChatDeleteResponse) {
            return (ChatDeleteResponse)instance;
        }
        return ChatDeleteResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ChatDeleteResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long INIT_BIT_CHANNEL_ID = 2L;
        private static final long INIT_BIT_DELETED_MESSAGE_TS = 4L;
        private long initBits = 7L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        @Nullable
        private String channelId;
        @Nullable
        private String deletedMessageTs;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ChatDeleteResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof ChatDeleteResponseIF) {
                instance = (ChatDeleteResponseIF)object;
                this.setDeletedMessageTs(instance.getDeletedMessageTs());
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                this.setChannelId(instance.getChannelId());
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setDeletedMessageTs(String deletedMessageTs) {
            this.deletedMessageTs = Objects.requireNonNull(deletedMessageTs, "deletedMessageTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ChatDeleteResponse build() {
            this.checkRequiredAttributes();
            return new ChatDeleteResponse(this.ok, this.responseMetadata, this.channelId, this.deletedMessageTs);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean deletedMessageTsIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.deletedMessageTsIsSet()) {
                attributes.add("deletedMessageTs");
            }
            return "Cannot build ChatDeleteResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChatDeleteResponseIF", generator="Immutables")
    static final class Json
    implements ChatDeleteResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        String channelId;
        @Nullable
        String deletedMessageTs;

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="ts")
        public void setDeletedMessageTs(String deletedMessageTs) {
            this.deletedMessageTs = deletedMessageTs;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDeletedMessageTs() {
            throw new UnsupportedOperationException();
        }
    }
}

