/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.channels;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.channels.ChannelsListResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ChannelsListResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChannelsListResponse
implements ChannelsListResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final List<SlackChannel> channels;

    private ChannelsListResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, List<SlackChannel> channels) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.channels = channels;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public List<SlackChannel> getChannels() {
        return this.channels;
    }

    public final ChannelsListResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new ChannelsListResponse(value, this.responseMetadata, this.channels);
    }

    public final ChannelsListResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ChannelsListResponse(this.ok, newValue, this.channels);
    }

    public final ChannelsListResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ChannelsListResponse(this.ok, value, this.channels);
    }

    public final ChannelsListResponse withChannels(SlackChannel ... elements) {
        List<SlackChannel> newValue = ChannelsListResponse.createUnmodifiableList(false, ChannelsListResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ChannelsListResponse(this.ok, this.responseMetadata, newValue);
    }

    public final ChannelsListResponse withChannels(Iterable<? extends SlackChannel> elements) {
        if (this.channels == elements) {
            return this;
        }
        List<SlackChannel> newValue = ChannelsListResponse.createUnmodifiableList(false, ChannelsListResponse.createSafeList(elements, true, false));
        return new ChannelsListResponse(this.ok, this.responseMetadata, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChannelsListResponse && this.equalTo(0, (ChannelsListResponse)another);
    }

    private boolean equalTo(int synthetic, ChannelsListResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.channels.equals(another.channels);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.channels.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChannelsListResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("channels=").append(this.channels);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChannelsListResponse fromJson(Json json) {
        Builder builder = ChannelsListResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.channels != null) {
            builder.addAllChannels(json.channels);
        }
        return builder.build();
    }

    public static ChannelsListResponse copyOf(ChannelsListResponseIF instance) {
        if (instance instanceof ChannelsListResponse) {
            return (ChannelsListResponse)instance;
        }
        return ChannelsListResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ChannelsListResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private long initBits = 1L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        private List<SlackChannel> channels = new ArrayList<SlackChannel>();

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ChannelsListResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof ChannelsListResponseIF) {
                instance = (ChannelsListResponseIF)object;
                this.addAllChannels(instance.getChannels());
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder addChannels(SlackChannel element) {
            this.channels.add(Objects.requireNonNull(element, "channels element"));
            return this;
        }

        public final Builder addChannels(SlackChannel ... elements) {
            for (SlackChannel element : elements) {
                this.channels.add(Objects.requireNonNull(element, "channels element"));
            }
            return this;
        }

        public final Builder setChannels(Iterable<? extends SlackChannel> elements) {
            this.channels.clear();
            return this.addAllChannels(elements);
        }

        public final Builder addAllChannels(Iterable<? extends SlackChannel> elements) {
            for (SlackChannel slackChannel : elements) {
                this.channels.add(Objects.requireNonNull(slackChannel, "channels element"));
            }
            return this;
        }

        public ChannelsListResponse build() {
            this.checkRequiredAttributes();
            return new ChannelsListResponse(this.ok, this.responseMetadata, ChannelsListResponse.createUnmodifiableList(true, this.channels));
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build ChannelsListResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChannelsListResponseIF", generator="Immutables")
    static final class Json
    implements ChannelsListResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        List<SlackChannel> channels = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setChannels(List<SlackChannel> channels) {
            this.channels = channels;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SlackChannel> getChannels() {
            throw new UnsupportedOperationException();
        }
    }
}

