/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.bookmarks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.bookmarks.Bookmark;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.bookmarks.BookmarkListResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="BookmarkListResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class BookmarkListResponse
implements BookmarkListResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final List<Bookmark> bookmarks;

    private BookmarkListResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, List<Bookmark> bookmarks) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.bookmarks = bookmarks;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public List<Bookmark> getBookmarks() {
        return this.bookmarks;
    }

    public final BookmarkListResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new BookmarkListResponse(value, this.responseMetadata, this.bookmarks);
    }

    public final BookmarkListResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new BookmarkListResponse(this.ok, newValue, this.bookmarks);
    }

    public final BookmarkListResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new BookmarkListResponse(this.ok, value, this.bookmarks);
    }

    public final BookmarkListResponse withBookmarks(Bookmark ... elements) {
        List<Bookmark> newValue = BookmarkListResponse.createUnmodifiableList(false, BookmarkListResponse.createSafeList(Arrays.asList(elements), true, false));
        return new BookmarkListResponse(this.ok, this.responseMetadata, newValue);
    }

    public final BookmarkListResponse withBookmarks(Iterable<? extends Bookmark> elements) {
        if (this.bookmarks == elements) {
            return this;
        }
        List<Bookmark> newValue = BookmarkListResponse.createUnmodifiableList(false, BookmarkListResponse.createSafeList(elements, true, false));
        return new BookmarkListResponse(this.ok, this.responseMetadata, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BookmarkListResponse && this.equalTo(0, (BookmarkListResponse)another);
    }

    private boolean equalTo(int synthetic, BookmarkListResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.bookmarks.equals(another.bookmarks);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.bookmarks.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BookmarkListResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("bookmarks=").append(this.bookmarks);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static BookmarkListResponse fromJson(Json json) {
        Builder builder = BookmarkListResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.bookmarks != null) {
            builder.addAllBookmarks(json.bookmarks);
        }
        return builder.build();
    }

    public static BookmarkListResponse copyOf(BookmarkListResponseIF instance) {
        if (instance instanceof BookmarkListResponse) {
            return (BookmarkListResponse)instance;
        }
        return BookmarkListResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="BookmarkListResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private long initBits = 1L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        private List<Bookmark> bookmarks = new ArrayList<Bookmark>();

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(BookmarkListResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof BookmarkListResponseIF) {
                instance = (BookmarkListResponseIF)object;
                this.addAllBookmarks(instance.getBookmarks());
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder addBookmarks(Bookmark element) {
            this.bookmarks.add(Objects.requireNonNull(element, "bookmarks element"));
            return this;
        }

        public final Builder addBookmarks(Bookmark ... elements) {
            for (Bookmark element : elements) {
                this.bookmarks.add(Objects.requireNonNull(element, "bookmarks element"));
            }
            return this;
        }

        public final Builder setBookmarks(Iterable<? extends Bookmark> elements) {
            this.bookmarks.clear();
            return this.addAllBookmarks(elements);
        }

        public final Builder addAllBookmarks(Iterable<? extends Bookmark> elements) {
            for (Bookmark bookmark : elements) {
                this.bookmarks.add(Objects.requireNonNull(bookmark, "bookmarks element"));
            }
            return this;
        }

        public BookmarkListResponse build() {
            this.checkRequiredAttributes();
            return new BookmarkListResponse(this.ok, this.responseMetadata, BookmarkListResponse.createUnmodifiableList(true, this.bookmarks));
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build BookmarkListResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BookmarkListResponseIF", generator="Immutables")
    static final class Json
    implements BookmarkListResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        List<Bookmark> bookmarks = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setBookmarks(List<Bookmark> bookmarks) {
            this.bookmarks = bookmarks;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Bookmark> getBookmarks() {
            throw new UnsupportedOperationException();
        }
    }
}

