/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.auth;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.auth.AuthRevokeResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AuthRevokeResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class AuthRevokeResponse
implements AuthRevokeResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final boolean revoked;

    private AuthRevokeResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, boolean revoked) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.revoked = revoked;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public boolean isRevoked() {
        return this.revoked;
    }

    public final AuthRevokeResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new AuthRevokeResponse(value, this.responseMetadata, this.revoked);
    }

    public final AuthRevokeResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new AuthRevokeResponse(this.ok, newValue, this.revoked);
    }

    public final AuthRevokeResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new AuthRevokeResponse(this.ok, value, this.revoked);
    }

    public final AuthRevokeResponse withRevoked(boolean value) {
        if (this.revoked == value) {
            return this;
        }
        return new AuthRevokeResponse(this.ok, this.responseMetadata, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AuthRevokeResponse && this.equalTo(0, (AuthRevokeResponse)another);
    }

    private boolean equalTo(int synthetic, AuthRevokeResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.revoked == another.revoked;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + Boolean.hashCode(this.revoked);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AuthRevokeResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("revoked=").append(this.revoked);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static AuthRevokeResponse fromJson(Json json) {
        Builder builder = AuthRevokeResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.revokedIsSet) {
            builder.setRevoked(json.revoked);
        }
        return builder.build();
    }

    public static AuthRevokeResponse copyOf(AuthRevokeResponseIF instance) {
        if (instance instanceof AuthRevokeResponse) {
            return (AuthRevokeResponse)instance;
        }
        return AuthRevokeResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AuthRevokeResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long INIT_BIT_REVOKED = 2L;
        private long initBits = 3L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        private boolean revoked;

        private Builder() {
        }

        public final Builder from(AuthRevokeResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof AuthRevokeResponseIF) {
                instance = (AuthRevokeResponseIF)object;
                this.setRevoked(instance.isRevoked());
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder setRevoked(boolean revoked) {
            this.revoked = revoked;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public AuthRevokeResponse build() {
            this.checkRequiredAttributes();
            return new AuthRevokeResponse(this.ok, this.responseMetadata, this.revoked);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean revokedIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            if (!this.revokedIsSet()) {
                attributes.add("revoked");
            }
            return "Cannot build AuthRevokeResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AuthRevokeResponseIF", generator="Immutables")
    static final class Json
    implements AuthRevokeResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        boolean revoked;
        boolean revokedIsSet;

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setRevoked(boolean revoked) {
            this.revoked = revoked;
            this.revokedIsSet = true;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isRevoked() {
            throw new UnsupportedOperationException();
        }
    }
}

