/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.assistant;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.slack.client.models.response.assistant.AssistantThreadContextIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AssistantThreadContextIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class AssistantThreadContext
implements AssistantThreadContextIF {
    @Nullable
    private final String channelId;
    @Nullable
    private final String teamId;
    @Nullable
    private final String enterpriseId;
    @Nullable
    private final String threadEntryPoint;
    @Nullable
    private final Boolean forceSearch;

    private AssistantThreadContext(@Nullable String channelId, @Nullable String teamId, @Nullable String enterpriseId, @Nullable String threadEntryPoint, @Nullable Boolean forceSearch) {
        this.channelId = channelId;
        this.teamId = teamId;
        this.enterpriseId = enterpriseId;
        this.threadEntryPoint = threadEntryPoint;
        this.forceSearch = forceSearch;
    }

    @Override
    @JsonProperty
    public Optional<String> getChannelId() {
        return Optional.ofNullable(this.channelId);
    }

    @Override
    @JsonProperty
    public Optional<String> getTeamId() {
        return Optional.ofNullable(this.teamId);
    }

    @Override
    @JsonProperty
    public Optional<String> getEnterpriseId() {
        return Optional.ofNullable(this.enterpriseId);
    }

    @Override
    @JsonProperty
    public Optional<String> getThreadEntryPoint() {
        return Optional.ofNullable(this.threadEntryPoint);
    }

    @Override
    @JsonProperty(value="force_search")
    public Optional<Boolean> isForceSearch() {
        return Optional.ofNullable(this.forceSearch);
    }

    public final AssistantThreadContext withChannelId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.channelId, newValue)) {
            return this;
        }
        return new AssistantThreadContext(newValue, this.teamId, this.enterpriseId, this.threadEntryPoint, this.forceSearch);
    }

    public final AssistantThreadContext withChannelId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.channelId, value)) {
            return this;
        }
        return new AssistantThreadContext(value, this.teamId, this.enterpriseId, this.threadEntryPoint, this.forceSearch);
    }

    public final AssistantThreadContext withTeamId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.teamId, newValue)) {
            return this;
        }
        return new AssistantThreadContext(this.channelId, newValue, this.enterpriseId, this.threadEntryPoint, this.forceSearch);
    }

    public final AssistantThreadContext withTeamId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.teamId, value)) {
            return this;
        }
        return new AssistantThreadContext(this.channelId, value, this.enterpriseId, this.threadEntryPoint, this.forceSearch);
    }

    public final AssistantThreadContext withEnterpriseId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.enterpriseId, newValue)) {
            return this;
        }
        return new AssistantThreadContext(this.channelId, this.teamId, newValue, this.threadEntryPoint, this.forceSearch);
    }

    public final AssistantThreadContext withEnterpriseId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.enterpriseId, value)) {
            return this;
        }
        return new AssistantThreadContext(this.channelId, this.teamId, value, this.threadEntryPoint, this.forceSearch);
    }

    public final AssistantThreadContext withThreadEntryPoint(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.threadEntryPoint, newValue)) {
            return this;
        }
        return new AssistantThreadContext(this.channelId, this.teamId, this.enterpriseId, newValue, this.forceSearch);
    }

    public final AssistantThreadContext withThreadEntryPoint(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.threadEntryPoint, value)) {
            return this;
        }
        return new AssistantThreadContext(this.channelId, this.teamId, this.enterpriseId, value, this.forceSearch);
    }

    public final AssistantThreadContext withForceSearch(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.forceSearch, newValue)) {
            return this;
        }
        return new AssistantThreadContext(this.channelId, this.teamId, this.enterpriseId, this.threadEntryPoint, newValue);
    }

    public final AssistantThreadContext withForceSearch(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.forceSearch, value)) {
            return this;
        }
        return new AssistantThreadContext(this.channelId, this.teamId, this.enterpriseId, this.threadEntryPoint, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AssistantThreadContext && this.equalTo(0, (AssistantThreadContext)another);
    }

    private boolean equalTo(int synthetic, AssistantThreadContext another) {
        return Objects.equals(this.channelId, another.channelId) && Objects.equals(this.teamId, another.teamId) && Objects.equals(this.enterpriseId, another.enterpriseId) && Objects.equals(this.threadEntryPoint, another.threadEntryPoint) && Objects.equals(this.forceSearch, another.forceSearch);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.channelId);
        h += (h << 5) + Objects.hashCode(this.teamId);
        h += (h << 5) + Objects.hashCode(this.enterpriseId);
        h += (h << 5) + Objects.hashCode(this.threadEntryPoint);
        h += (h << 5) + Objects.hashCode(this.forceSearch);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AssistantThreadContext{");
        if (this.channelId != null) {
            builder.append("channelId=").append(this.channelId);
        }
        if (this.teamId != null) {
            if (builder.length() > 23) {
                builder.append(", ");
            }
            builder.append("teamId=").append(this.teamId);
        }
        if (this.enterpriseId != null) {
            if (builder.length() > 23) {
                builder.append(", ");
            }
            builder.append("enterpriseId=").append(this.enterpriseId);
        }
        if (this.threadEntryPoint != null) {
            if (builder.length() > 23) {
                builder.append(", ");
            }
            builder.append("threadEntryPoint=").append(this.threadEntryPoint);
        }
        if (this.forceSearch != null) {
            if (builder.length() > 23) {
                builder.append(", ");
            }
            builder.append("forceSearch=").append(this.forceSearch);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static AssistantThreadContext fromJson(Json json) {
        Builder builder = AssistantThreadContext.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.teamId != null) {
            builder.setTeamId(json.teamId);
        }
        if (json.enterpriseId != null) {
            builder.setEnterpriseId(json.enterpriseId);
        }
        if (json.threadEntryPoint != null) {
            builder.setThreadEntryPoint(json.threadEntryPoint);
        }
        if (json.forceSearch != null) {
            builder.setForceSearch(json.forceSearch);
        }
        return builder.build();
    }

    public static AssistantThreadContext copyOf(AssistantThreadContextIF instance) {
        if (instance instanceof AssistantThreadContext) {
            return (AssistantThreadContext)instance;
        }
        return AssistantThreadContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AssistantThreadContextIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String channelId;
        @Nullable
        private String teamId;
        @Nullable
        private String enterpriseId;
        @Nullable
        private String threadEntryPoint;
        @Nullable
        private Boolean forceSearch;

        private Builder() {
        }

        public final Builder from(AssistantThreadContextIF instance) {
            Optional<Boolean> forceSearchOptional;
            Optional<String> threadEntryPointOptional;
            Optional<String> enterpriseIdOptional;
            Optional<String> teamIdOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> channelIdOptional = instance.getChannelId();
            if (channelIdOptional.isPresent()) {
                this.setChannelId(channelIdOptional);
            }
            if ((teamIdOptional = instance.getTeamId()).isPresent()) {
                this.setTeamId(teamIdOptional);
            }
            if ((enterpriseIdOptional = instance.getEnterpriseId()).isPresent()) {
                this.setEnterpriseId(enterpriseIdOptional);
            }
            if ((threadEntryPointOptional = instance.getThreadEntryPoint()).isPresent()) {
                this.setThreadEntryPoint(threadEntryPointOptional);
            }
            if ((forceSearchOptional = instance.isForceSearch()).isPresent()) {
                this.setForceSearch(forceSearchOptional);
            }
            return this;
        }

        public final Builder setChannelId(@Nullable String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final Builder setChannelId(Optional<String> channelId) {
            this.channelId = channelId.orElse(null);
            return this;
        }

        public final Builder setTeamId(@Nullable String teamId) {
            this.teamId = teamId;
            return this;
        }

        public final Builder setTeamId(Optional<String> teamId) {
            this.teamId = teamId.orElse(null);
            return this;
        }

        public final Builder setEnterpriseId(@Nullable String enterpriseId) {
            this.enterpriseId = enterpriseId;
            return this;
        }

        public final Builder setEnterpriseId(Optional<String> enterpriseId) {
            this.enterpriseId = enterpriseId.orElse(null);
            return this;
        }

        public final Builder setThreadEntryPoint(@Nullable String threadEntryPoint) {
            this.threadEntryPoint = threadEntryPoint;
            return this;
        }

        public final Builder setThreadEntryPoint(Optional<String> threadEntryPoint) {
            this.threadEntryPoint = threadEntryPoint.orElse(null);
            return this;
        }

        public final Builder setForceSearch(@Nullable Boolean forceSearch) {
            this.forceSearch = forceSearch;
            return this;
        }

        public final Builder setForceSearch(Optional<Boolean> forceSearch) {
            this.forceSearch = forceSearch.orElse(null);
            return this;
        }

        public AssistantThreadContext build() {
            return new AssistantThreadContext(this.channelId, this.teamId, this.enterpriseId, this.threadEntryPoint, this.forceSearch);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AssistantThreadContextIF", generator="Immutables")
    static final class Json
    implements AssistantThreadContextIF {
        @Nullable
        Optional<String> channelId = Optional.empty();
        @Nullable
        Optional<String> teamId = Optional.empty();
        @Nullable
        Optional<String> enterpriseId = Optional.empty();
        @Nullable
        Optional<String> threadEntryPoint = Optional.empty();
        @Nullable
        Optional<Boolean> forceSearch = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setChannelId(Optional<String> channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setTeamId(Optional<String> teamId) {
            this.teamId = teamId;
        }

        @JsonProperty
        public void setEnterpriseId(Optional<String> enterpriseId) {
            this.enterpriseId = enterpriseId;
        }

        @JsonProperty
        public void setThreadEntryPoint(Optional<String> threadEntryPoint) {
            this.threadEntryPoint = threadEntryPoint;
        }

        @JsonProperty(value="force_search")
        public void setForceSearch(Optional<Boolean> forceSearch) {
            this.forceSearch = forceSearch;
        }

        @Override
        public Optional<String> getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTeamId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getEnterpriseId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThreadEntryPoint() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isForceSearch() {
            throw new UnsupportedOperationException();
        }
    }
}

