/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.assistant;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.assistant.AssistantThreadContext;
import com.hubspot.slack.client.models.response.assistant.AssistantThreadIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AssistantThreadIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class AssistantThread
implements AssistantThreadIF {
    private final String userId;
    private final AssistantThreadContext context;
    private final String channelId;
    private final String threadTs;

    private AssistantThread(String userId, AssistantThreadContext context, String channelId, String threadTs) {
        this.userId = userId;
        this.context = context;
        this.channelId = channelId;
        this.threadTs = threadTs;
    }

    @Override
    @JsonProperty
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty
    public AssistantThreadContext getContext() {
        return this.context;
    }

    @Override
    @JsonProperty
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public String getThreadTs() {
        return this.threadTs;
    }

    public final AssistantThread withUserId(String value) {
        String newValue = Objects.requireNonNull(value, "userId");
        if (this.userId.equals(newValue)) {
            return this;
        }
        return new AssistantThread(newValue, this.context, this.channelId, this.threadTs);
    }

    public final AssistantThread withContext(AssistantThreadContext value) {
        if (this.context == value) {
            return this;
        }
        AssistantThreadContext newValue = Objects.requireNonNull(value, "context");
        return new AssistantThread(this.userId, newValue, this.channelId, this.threadTs);
    }

    public final AssistantThread withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new AssistantThread(this.userId, this.context, newValue, this.threadTs);
    }

    public final AssistantThread withThreadTs(String value) {
        String newValue = Objects.requireNonNull(value, "threadTs");
        if (this.threadTs.equals(newValue)) {
            return this;
        }
        return new AssistantThread(this.userId, this.context, this.channelId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AssistantThread && this.equalTo(0, (AssistantThread)another);
    }

    private boolean equalTo(int synthetic, AssistantThread another) {
        return this.userId.equals(another.userId) && this.context.equals(another.context) && this.channelId.equals(another.channelId) && this.threadTs.equals(another.threadTs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.context.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.threadTs.hashCode();
        return h;
    }

    public String toString() {
        return "AssistantThread{userId=" + this.userId + ", context=" + String.valueOf(this.context) + ", channelId=" + this.channelId + ", threadTs=" + this.threadTs + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static AssistantThread fromJson(Json json) {
        Builder builder = AssistantThread.builder();
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.context != null) {
            builder.setContext(json.context);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.threadTs != null) {
            builder.setThreadTs(json.threadTs);
        }
        return builder.build();
    }

    public static AssistantThread copyOf(AssistantThreadIF instance) {
        if (instance instanceof AssistantThread) {
            return (AssistantThread)instance;
        }
        return AssistantThread.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AssistantThreadIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_CONTEXT = 2L;
        private static final long INIT_BIT_CHANNEL_ID = 4L;
        private static final long INIT_BIT_THREAD_TS = 8L;
        private long initBits = 15L;
        @Nullable
        private String userId;
        @Nullable
        private AssistantThreadContext context;
        @Nullable
        private String channelId;
        @Nullable
        private String threadTs;

        private Builder() {
        }

        public final Builder from(AssistantThreadIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setUserId(instance.getUserId());
            this.setContext(instance.getContext());
            this.setChannelId(instance.getChannelId());
            this.setThreadTs(instance.getThreadTs());
            return this;
        }

        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setContext(AssistantThreadContext context) {
            this.context = Objects.requireNonNull(context, "context");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setThreadTs(String threadTs) {
            this.threadTs = Objects.requireNonNull(threadTs, "threadTs");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public AssistantThread build() {
            this.checkRequiredAttributes();
            return new AssistantThread(this.userId, this.context, this.channelId, this.threadTs);
        }

        private boolean userIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean contextIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean threadTsIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            if (!this.contextIsSet()) {
                attributes.add("context");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.threadTsIsSet()) {
                attributes.add("threadTs");
            }
            return "Cannot build AssistantThread, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AssistantThreadIF", generator="Immutables")
    static final class Json
    implements AssistantThreadIF {
        @Nullable
        String userId;
        @Nullable
        AssistantThreadContext context;
        @Nullable
        String channelId;
        @Nullable
        String threadTs;

        Json() {
        }

        @JsonProperty
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty
        public void setContext(AssistantThreadContext context) {
            this.context = context;
        }

        @JsonProperty
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setThreadTs(String threadTs) {
            this.threadTs = threadTs;
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AssistantThreadContext getContext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getThreadTs() {
            throw new UnsupportedOperationException();
        }
    }
}

