/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.views.ViewInput;
import com.hubspot.slack.client.models.interaction.views.ViewInputType;
import com.hubspot.slack.client.models.interaction.views.ViewTimePickerIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ViewTimePickerIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ViewTimePicker
implements ViewTimePickerIF {
    private final ViewInputType type;
    @Nullable
    private final String stringValue;
    @Nullable
    private final LocalTime selectedTime;

    private ViewTimePicker(ViewInputType type, @Nullable String stringValue, @Nullable LocalTime selectedTime) {
        this.type = type;
        this.stringValue = stringValue;
        this.selectedTime = selectedTime;
    }

    @Override
    @JsonProperty
    public ViewInputType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public Optional<String> getStringValue() {
        return Optional.ofNullable(this.stringValue);
    }

    @Override
    @JsonProperty
    public Optional<LocalTime> getSelectedTime() {
        return Optional.ofNullable(this.selectedTime);
    }

    public final ViewTimePicker withType(ViewInputType value) {
        ViewInputType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ViewTimePicker(newValue, this.stringValue, this.selectedTime);
    }

    public final ViewTimePicker withStringValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.stringValue, newValue)) {
            return this;
        }
        return new ViewTimePicker(this.type, newValue, this.selectedTime);
    }

    public final ViewTimePicker withStringValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.stringValue, value)) {
            return this;
        }
        return new ViewTimePicker(this.type, value, this.selectedTime);
    }

    public final ViewTimePicker withSelectedTime(@Nullable LocalTime value) {
        LocalTime newValue = value;
        if (this.selectedTime == newValue) {
            return this;
        }
        return new ViewTimePicker(this.type, this.stringValue, newValue);
    }

    public final ViewTimePicker withSelectedTime(Optional<? extends LocalTime> optional) {
        LocalTime value = optional.orElse(null);
        if (this.selectedTime == value) {
            return this;
        }
        return new ViewTimePicker(this.type, this.stringValue, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ViewTimePicker && this.equalTo(0, (ViewTimePicker)another);
    }

    private boolean equalTo(int synthetic, ViewTimePicker another) {
        return this.type.equals((Object)another.type) && Objects.equals(this.stringValue, another.stringValue) && Objects.equals(this.selectedTime, another.selectedTime);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.stringValue);
        h += (h << 5) + Objects.hashCode(this.selectedTime);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ViewTimePicker{");
        builder.append("type=").append((Object)this.type);
        if (this.stringValue != null) {
            builder.append(", ");
            builder.append("stringValue=").append(this.stringValue);
        }
        if (this.selectedTime != null) {
            builder.append(", ");
            builder.append("selectedTime=").append(this.selectedTime);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ViewTimePicker fromJson(Json json) {
        Builder builder = ViewTimePicker.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.stringValue != null) {
            builder.setStringValue(json.stringValue);
        }
        if (json.selectedTime != null) {
            builder.setSelectedTime(json.selectedTime);
        }
        return builder.build();
    }

    public static ViewTimePicker copyOf(ViewTimePickerIF instance) {
        if (instance instanceof ViewTimePicker) {
            return (ViewTimePicker)instance;
        }
        return ViewTimePicker.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ViewTimePickerIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private ViewInputType type;
        @Nullable
        private String stringValue;
        @Nullable
        private LocalTime selectedTime;

        private Builder() {
        }

        public final Builder from(ViewTimePickerIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ViewInput instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            ViewInput instance;
            long bits = 0L;
            if (object instanceof ViewTimePickerIF) {
                instance = (ViewTimePickerIF)object;
                Optional<LocalTime> selectedTimeOptional = instance.getSelectedTime();
                if (selectedTimeOptional.isPresent()) {
                    this.setSelectedTime(selectedTimeOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    Optional<String> stringValueOptional = instance.getStringValue();
                    if (stringValueOptional.isPresent()) {
                        this.setStringValue(stringValueOptional);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof ViewInput) {
                instance = (ViewInput)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    Optional<String> stringValueOptional = instance.getStringValue();
                    if (stringValueOptional.isPresent()) {
                        this.setStringValue(stringValueOptional);
                    }
                    bits |= 2L;
                }
            }
        }

        public final Builder setType(ViewInputType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setStringValue(@Nullable String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final Builder setStringValue(Optional<String> stringValue) {
            this.stringValue = stringValue.orElse(null);
            return this;
        }

        public final Builder setSelectedTime(@Nullable LocalTime selectedTime) {
            this.selectedTime = selectedTime;
            return this;
        }

        public final Builder setSelectedTime(Optional<? extends LocalTime> selectedTime) {
            this.selectedTime = selectedTime.orElse(null);
            return this;
        }

        public ViewTimePicker build() {
            this.checkRequiredAttributes();
            return new ViewTimePicker(this.type, this.stringValue, this.selectedTime);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build ViewTimePicker, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ViewTimePickerIF", generator="Immutables")
    static final class Json
    implements ViewTimePickerIF {
        @Nullable
        ViewInputType type;
        @Nullable
        Optional<String> stringValue = Optional.empty();
        @Nullable
        Optional<LocalTime> selectedTime = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setType(ViewInputType type) {
            this.type = type;
        }

        @JsonProperty
        @JsonIgnore
        public void setStringValue(Optional<String> stringValue) {
            this.stringValue = stringValue;
        }

        @JsonProperty
        public void setSelectedTime(Optional<LocalTime> selectedTime) {
            this.selectedTime = selectedTime;
        }

        @Override
        public ViewInputType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getStringValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LocalTime> getSelectedTime() {
            throw new UnsupportedOperationException();
        }
    }
}

