/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.views.ViewConversationsSelectIF;
import com.hubspot.slack.client.models.interaction.views.ViewInput;
import com.hubspot.slack.client.models.interaction.views.ViewInputType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ViewConversationsSelectIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ViewConversationsSelect
implements ViewConversationsSelectIF {
    private final ViewInputType type;
    @Nullable
    private final String selectedConversation;

    private ViewConversationsSelect(ViewInputType type, @Nullable String selectedConversation) {
        this.type = type;
        this.selectedConversation = selectedConversation;
    }

    @Override
    @JsonProperty
    public ViewInputType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Optional<String> getSelectedConversation() {
        return Optional.ofNullable(this.selectedConversation);
    }

    public final ViewConversationsSelect withType(ViewInputType value) {
        ViewInputType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ViewConversationsSelect(newValue, this.selectedConversation);
    }

    public final ViewConversationsSelect withSelectedConversation(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.selectedConversation, newValue)) {
            return this;
        }
        return new ViewConversationsSelect(this.type, newValue);
    }

    public final ViewConversationsSelect withSelectedConversation(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.selectedConversation, value)) {
            return this;
        }
        return new ViewConversationsSelect(this.type, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ViewConversationsSelect && this.equalTo(0, (ViewConversationsSelect)another);
    }

    private boolean equalTo(int synthetic, ViewConversationsSelect another) {
        return this.type.equals((Object)another.type) && Objects.equals(this.selectedConversation, another.selectedConversation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.selectedConversation);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ViewConversationsSelect{");
        builder.append("type=").append((Object)this.type);
        if (this.selectedConversation != null) {
            builder.append(", ");
            builder.append("selectedConversation=").append(this.selectedConversation);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ViewConversationsSelect fromJson(Json json) {
        Builder builder = ViewConversationsSelect.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.selectedConversation != null) {
            builder.setSelectedConversation(json.selectedConversation);
        }
        return builder.build();
    }

    public static ViewConversationsSelect copyOf(ViewConversationsSelectIF instance) {
        if (instance instanceof ViewConversationsSelect) {
            return (ViewConversationsSelect)instance;
        }
        return ViewConversationsSelect.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ViewConversationsSelectIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private ViewInputType type;
        @Nullable
        private String selectedConversation;

        private Builder() {
        }

        public final Builder from(ViewInput instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ViewConversationsSelectIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            ViewInput instance;
            long bits = 0L;
            if (object instanceof ViewInput) {
                instance = (ViewInput)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
            }
            if (object instanceof ViewConversationsSelectIF) {
                Optional<String> selectedConversationOptional;
                instance = (ViewConversationsSelectIF)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((selectedConversationOptional = instance.getSelectedConversation()).isPresent()) {
                    this.setSelectedConversation(selectedConversationOptional);
                }
            }
        }

        public final Builder setType(ViewInputType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setSelectedConversation(@Nullable String selectedConversation) {
            this.selectedConversation = selectedConversation;
            return this;
        }

        public final Builder setSelectedConversation(Optional<String> selectedConversation) {
            this.selectedConversation = selectedConversation.orElse(null);
            return this;
        }

        public ViewConversationsSelect build() {
            this.checkRequiredAttributes();
            return new ViewConversationsSelect(this.type, this.selectedConversation);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build ViewConversationsSelect, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ViewConversationsSelectIF", generator="Immutables")
    static final class Json
    implements ViewConversationsSelectIF {
        @Nullable
        ViewInputType type;
        @Nullable
        Optional<String> selectedConversation = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setType(ViewInputType type) {
            this.type = type;
        }

        @JsonProperty
        public void setSelectedConversation(Optional<String> selectedConversation) {
            this.selectedConversation = selectedConversation;
        }

        @Override
        public ViewInputType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getSelectedConversation() {
            throw new UnsupportedOperationException();
        }
    }
}

