/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.json.OptionOrOptionGroupDeserializer;
import com.hubspot.slack.client.models.blocks.objects.Option;
import com.hubspot.slack.client.models.interaction.views.ViewCheckboxesIF;
import com.hubspot.slack.client.models.interaction.views.ViewInput;
import com.hubspot.slack.client.models.interaction.views.ViewInputType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ViewCheckboxesIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ViewCheckboxes
implements ViewCheckboxesIF {
    private final ViewInputType type;
    @Nullable
    private final String stringValue;
    private final List<Option> selectedOptions;

    private ViewCheckboxes(ViewInputType type, @Nullable String stringValue, List<Option> selectedOptions) {
        this.type = type;
        this.stringValue = stringValue;
        this.selectedOptions = selectedOptions;
    }

    @Override
    @JsonProperty
    public ViewInputType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public Optional<String> getStringValue() {
        return Optional.ofNullable(this.stringValue);
    }

    @Override
    @JsonProperty
    @JsonDeserialize(contentUsing=OptionOrOptionGroupDeserializer.class)
    public List<Option> getSelectedOptions() {
        return this.selectedOptions;
    }

    public final ViewCheckboxes withType(ViewInputType value) {
        ViewInputType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ViewCheckboxes(newValue, this.stringValue, this.selectedOptions);
    }

    public final ViewCheckboxes withStringValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.stringValue, newValue)) {
            return this;
        }
        return new ViewCheckboxes(this.type, newValue, this.selectedOptions);
    }

    public final ViewCheckboxes withStringValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.stringValue, value)) {
            return this;
        }
        return new ViewCheckboxes(this.type, value, this.selectedOptions);
    }

    public final ViewCheckboxes withSelectedOptions(Option ... elements) {
        List<Option> newValue = ViewCheckboxes.createUnmodifiableList(false, ViewCheckboxes.createSafeList(Arrays.asList(elements), true, false));
        return new ViewCheckboxes(this.type, this.stringValue, newValue);
    }

    public final ViewCheckboxes withSelectedOptions(Iterable<? extends Option> elements) {
        if (this.selectedOptions == elements) {
            return this;
        }
        List<Option> newValue = ViewCheckboxes.createUnmodifiableList(false, ViewCheckboxes.createSafeList(elements, true, false));
        return new ViewCheckboxes(this.type, this.stringValue, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ViewCheckboxes && this.equalTo(0, (ViewCheckboxes)another);
    }

    private boolean equalTo(int synthetic, ViewCheckboxes another) {
        return this.type.equals((Object)another.type) && Objects.equals(this.stringValue, another.stringValue) && this.selectedOptions.equals(another.selectedOptions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.stringValue);
        h += (h << 5) + this.selectedOptions.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ViewCheckboxes{");
        builder.append("type=").append((Object)this.type);
        if (this.stringValue != null) {
            builder.append(", ");
            builder.append("stringValue=").append(this.stringValue);
        }
        builder.append(", ");
        builder.append("selectedOptions=").append(this.selectedOptions);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ViewCheckboxes fromJson(Json json) {
        Builder builder = ViewCheckboxes.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.stringValue != null) {
            builder.setStringValue(json.stringValue);
        }
        if (json.selectedOptions != null) {
            builder.addAllSelectedOptions(json.selectedOptions);
        }
        return builder.build();
    }

    public static ViewCheckboxes copyOf(ViewCheckboxesIF instance) {
        if (instance instanceof ViewCheckboxes) {
            return (ViewCheckboxes)instance;
        }
        return ViewCheckboxes.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ViewCheckboxesIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private ViewInputType type;
        @Nullable
        private String stringValue;
        private List<Option> selectedOptions = new ArrayList<Option>();

        private Builder() {
        }

        public final Builder from(ViewCheckboxesIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ViewInput instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> stringValueOptional;
            ViewInput instance;
            long bits = 0L;
            if (object instanceof ViewCheckboxesIF) {
                instance = (ViewCheckboxesIF)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                this.addAllSelectedOptions(instance.getSelectedOptions());
                if ((bits & 2L) == 0L) {
                    stringValueOptional = instance.getStringValue();
                    if (stringValueOptional.isPresent()) {
                        this.setStringValue(stringValueOptional);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof ViewInput) {
                instance = (ViewInput)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    stringValueOptional = instance.getStringValue();
                    if (stringValueOptional.isPresent()) {
                        this.setStringValue(stringValueOptional);
                    }
                    bits |= 2L;
                }
            }
        }

        public final Builder setType(ViewInputType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setStringValue(@Nullable String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final Builder setStringValue(Optional<String> stringValue) {
            this.stringValue = stringValue.orElse(null);
            return this;
        }

        public final Builder addSelectedOptions(Option element) {
            this.selectedOptions.add(Objects.requireNonNull(element, "selectedOptions element"));
            return this;
        }

        public final Builder addSelectedOptions(Option ... elements) {
            for (Option element : elements) {
                this.selectedOptions.add(Objects.requireNonNull(element, "selectedOptions element"));
            }
            return this;
        }

        public final Builder setSelectedOptions(Iterable<? extends Option> elements) {
            this.selectedOptions.clear();
            return this.addAllSelectedOptions(elements);
        }

        public final Builder addAllSelectedOptions(Iterable<? extends Option> elements) {
            for (Option option : elements) {
                this.selectedOptions.add(Objects.requireNonNull(option, "selectedOptions element"));
            }
            return this;
        }

        public ViewCheckboxes build() {
            this.checkRequiredAttributes();
            return new ViewCheckboxes(this.type, this.stringValue, ViewCheckboxes.createUnmodifiableList(true, this.selectedOptions));
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build ViewCheckboxes, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ViewCheckboxesIF", generator="Immutables")
    static final class Json
    implements ViewCheckboxesIF {
        @Nullable
        ViewInputType type;
        @Nullable
        Optional<String> stringValue = Optional.empty();
        @Nullable
        List<Option> selectedOptions = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setType(ViewInputType type) {
            this.type = type;
        }

        @JsonProperty
        @JsonIgnore
        public void setStringValue(Optional<String> stringValue) {
            this.stringValue = stringValue;
        }

        @JsonProperty
        @JsonDeserialize(contentUsing=OptionOrOptionGroupDeserializer.class)
        public void setSelectedOptions(List<Option> selectedOptions) {
            this.selectedOptions = selectedOptions;
        }

        @Override
        public ViewInputType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getStringValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Option> getSelectedOptions() {
            throw new UnsupportedOperationException();
        }
    }
}

