/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.hubspot.slack.client.models.blocks.elements.BlockElement;
import com.hubspot.slack.client.models.interaction.BlockElementAction;
import java.io.IOException;
import java.util.Optional;

public class BlockElementActionSerializer
extends StdSerializer<BlockElementAction> {
    private static final String BLOCK_ID_FIELD = "block_id";
    private static final String ACTION_ID_FIELD = "action_id";
    private static final String VALUE_FIELD = "value";
    private static final String ACTION_TS_FIELD = "action_ts";

    protected BlockElementActionSerializer() {
        super(BlockElementAction.class);
    }

    public void serialize(BlockElementAction value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        this.writeBlockElement(value.getElement(), gen, provider);
        gen.writeStringField(BLOCK_ID_FIELD, value.getBlockId());
        gen.writeStringField(ACTION_ID_FIELD, value.getActionId());
        this.writeOptionalString(value.getSelectedValue(), gen, VALUE_FIELD);
        this.writeOptionalString(value.getActionTs(), gen, ACTION_TS_FIELD);
        gen.writeEndObject();
    }

    private void writeBlockElement(BlockElement element, JsonGenerator gen, SerializerProvider provider) throws IOException {
        JavaType javaType = provider.constructType(element.getClass());
        BeanDescription beanDesc = provider.getConfig().introspect(javaType);
        JsonSerializer serializer = BeanSerializerFactory.instance.findBeanOrAddOnSerializer(provider, javaType, beanDesc, false);
        serializer.unwrappingSerializer(null).serialize((Object)element, gen, provider);
    }

    private void writeOptionalString(Optional<String> value, JsonGenerator gen, String fieldName) throws IOException {
        if (value.isPresent()) {
            gen.writeStringField(fieldName, value.get());
        }
    }
}

