/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.interaction.StateValuesPayload;
import com.hubspot.slack.client.models.interaction.ViewInteractionPayloadIF;
import com.hubspot.slack.client.models.views.ViewPayloadBase;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ViewInteractionPayloadIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ViewInteractionPayload
implements ViewInteractionPayloadIF {
    private final String type;
    private final List<Block> blocks;
    @Nullable
    private final String privateMetadata;
    @Nullable
    private final String callbackId;
    @Nullable
    private final String externalId;
    private final StateValuesPayload state;
    private final String hash;

    private ViewInteractionPayload(String type, List<Block> blocks, @Nullable String privateMetadata, @Nullable String callbackId, @Nullable String externalId, StateValuesPayload state, String hash) {
        this.type = type;
        this.blocks = blocks;
        this.privateMetadata = privateMetadata;
        this.callbackId = callbackId;
        this.externalId = externalId;
        this.state = state;
        this.hash = hash;
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public List<Block> getBlocks() {
        return this.blocks;
    }

    @Override
    @JsonProperty
    public Optional<String> getPrivateMetadata() {
        return Optional.ofNullable(this.privateMetadata);
    }

    @Override
    @JsonProperty
    public Optional<String> getCallbackId() {
        return Optional.ofNullable(this.callbackId);
    }

    @Override
    @JsonProperty
    public Optional<String> getExternalId() {
        return Optional.ofNullable(this.externalId);
    }

    @Override
    @JsonProperty
    public StateValuesPayload getState() {
        return this.state;
    }

    @Override
    @JsonProperty
    public String getHash() {
        return this.hash;
    }

    public final ViewInteractionPayload withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ViewInteractionPayload(newValue, this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.state, this.hash);
    }

    public final ViewInteractionPayload withBlocks(Block ... elements) {
        List<Block> newValue = ViewInteractionPayload.createUnmodifiableList(false, ViewInteractionPayload.createSafeList(Arrays.asList(elements), true, false));
        return new ViewInteractionPayload(this.type, newValue, this.privateMetadata, this.callbackId, this.externalId, this.state, this.hash);
    }

    public final ViewInteractionPayload withBlocks(Iterable<? extends Block> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<Block> newValue = ViewInteractionPayload.createUnmodifiableList(false, ViewInteractionPayload.createSafeList(elements, true, false));
        return new ViewInteractionPayload(this.type, newValue, this.privateMetadata, this.callbackId, this.externalId, this.state, this.hash);
    }

    public final ViewInteractionPayload withPrivateMetadata(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.privateMetadata, newValue)) {
            return this;
        }
        return new ViewInteractionPayload(this.type, this.blocks, newValue, this.callbackId, this.externalId, this.state, this.hash);
    }

    public final ViewInteractionPayload withPrivateMetadata(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.privateMetadata, value)) {
            return this;
        }
        return new ViewInteractionPayload(this.type, this.blocks, value, this.callbackId, this.externalId, this.state, this.hash);
    }

    public final ViewInteractionPayload withCallbackId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.callbackId, newValue)) {
            return this;
        }
        return new ViewInteractionPayload(this.type, this.blocks, this.privateMetadata, newValue, this.externalId, this.state, this.hash);
    }

    public final ViewInteractionPayload withCallbackId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.callbackId, value)) {
            return this;
        }
        return new ViewInteractionPayload(this.type, this.blocks, this.privateMetadata, value, this.externalId, this.state, this.hash);
    }

    public final ViewInteractionPayload withExternalId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.externalId, newValue)) {
            return this;
        }
        return new ViewInteractionPayload(this.type, this.blocks, this.privateMetadata, this.callbackId, newValue, this.state, this.hash);
    }

    public final ViewInteractionPayload withExternalId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.externalId, value)) {
            return this;
        }
        return new ViewInteractionPayload(this.type, this.blocks, this.privateMetadata, this.callbackId, value, this.state, this.hash);
    }

    public final ViewInteractionPayload withState(StateValuesPayload value) {
        if (this.state == value) {
            return this;
        }
        StateValuesPayload newValue = Objects.requireNonNull(value, "state");
        return new ViewInteractionPayload(this.type, this.blocks, this.privateMetadata, this.callbackId, this.externalId, newValue, this.hash);
    }

    public final ViewInteractionPayload withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (this.hash.equals(newValue)) {
            return this;
        }
        return new ViewInteractionPayload(this.type, this.blocks, this.privateMetadata, this.callbackId, this.externalId, this.state, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ViewInteractionPayload && this.equalTo(0, (ViewInteractionPayload)another);
    }

    private boolean equalTo(int synthetic, ViewInteractionPayload another) {
        return this.type.equals(another.type) && this.blocks.equals(another.blocks) && Objects.equals(this.privateMetadata, another.privateMetadata) && Objects.equals(this.callbackId, another.callbackId) && Objects.equals(this.externalId, another.externalId) && this.state.equals(another.state) && this.hash.equals(another.hash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.blocks.hashCode();
        h += (h << 5) + Objects.hashCode(this.privateMetadata);
        h += (h << 5) + Objects.hashCode(this.callbackId);
        h += (h << 5) + Objects.hashCode(this.externalId);
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + this.hash.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ViewInteractionPayload{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("blocks=").append(this.blocks);
        if (this.privateMetadata != null) {
            builder.append(", ");
            builder.append("privateMetadata=").append(this.privateMetadata);
        }
        if (this.callbackId != null) {
            builder.append(", ");
            builder.append("callbackId=").append(this.callbackId);
        }
        if (this.externalId != null) {
            builder.append(", ");
            builder.append("externalId=").append(this.externalId);
        }
        builder.append(", ");
        builder.append("state=").append(this.state);
        builder.append(", ");
        builder.append("hash=").append(this.hash);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ViewInteractionPayload fromJson(Json json) {
        Builder builder = ViewInteractionPayload.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.blocks != null) {
            builder.addAllBlocks(json.blocks);
        }
        if (json.privateMetadata != null) {
            builder.setPrivateMetadata(json.privateMetadata);
        }
        if (json.callbackId != null) {
            builder.setCallbackId(json.callbackId);
        }
        if (json.externalId != null) {
            builder.setExternalId(json.externalId);
        }
        if (json.state != null) {
            builder.setState(json.state);
        }
        if (json.hash != null) {
            builder.setHash(json.hash);
        }
        return builder.build();
    }

    public static ViewInteractionPayload copyOf(ViewInteractionPayloadIF instance) {
        if (instance instanceof ViewInteractionPayload) {
            return (ViewInteractionPayload)instance;
        }
        return ViewInteractionPayload.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ViewInteractionPayloadIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_STATE = 2L;
        private static final long INIT_BIT_HASH = 4L;
        private long initBits = 7L;
        @Nullable
        private String type;
        private List<Block> blocks = new ArrayList<Block>();
        @Nullable
        private String privateMetadata;
        @Nullable
        private String callbackId;
        @Nullable
        private String externalId;
        @Nullable
        private StateValuesPayload state;
        @Nullable
        private String hash;

        private Builder() {
        }

        public final Builder from(ViewInteractionPayloadIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ViewPayloadBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> privateMetadataOptional;
            Optional<String> externalIdOptional;
            Optional<String> callbackIdOptional;
            ViewPayloadBase instance;
            long bits = 0L;
            if (object instanceof ViewInteractionPayloadIF) {
                instance = (ViewInteractionPayloadIF)object;
                if ((bits & 0x10L) == 0L) {
                    callbackIdOptional = instance.getCallbackId();
                    if (callbackIdOptional.isPresent()) {
                        this.setCallbackId(callbackIdOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    externalIdOptional = instance.getExternalId();
                    if (externalIdOptional.isPresent()) {
                        this.setExternalId(externalIdOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    privateMetadataOptional = instance.getPrivateMetadata();
                    if (privateMetadataOptional.isPresent()) {
                        this.setPrivateMetadata(privateMetadataOptional);
                    }
                    bits |= 4L;
                }
                this.setState(instance.getState());
                if ((bits & 8L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 8L;
                }
                this.setHash(instance.getHash());
            }
            if (object instanceof ViewPayloadBase) {
                instance = (ViewPayloadBase)object;
                if ((bits & 2L) == 0L) {
                    externalIdOptional = instance.getExternalId();
                    if (externalIdOptional.isPresent()) {
                        this.setExternalId(externalIdOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    privateMetadataOptional = instance.getPrivateMetadata();
                    if (privateMetadataOptional.isPresent()) {
                        this.setPrivateMetadata(privateMetadataOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    callbackIdOptional = instance.getCallbackId();
                    if (callbackIdOptional.isPresent()) {
                        this.setCallbackId(callbackIdOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 1L;
                }
            }
        }

        public final Builder setType(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addBlocks(Block element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            return this;
        }

        public final Builder addBlocks(Block ... elements) {
            for (Block element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            return this;
        }

        public final Builder setBlocks(Iterable<? extends Block> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Builder addAllBlocks(Iterable<? extends Block> elements) {
            for (Block block : elements) {
                this.blocks.add(Objects.requireNonNull(block, "blocks element"));
            }
            return this;
        }

        public final Builder setPrivateMetadata(@Nullable String privateMetadata) {
            this.privateMetadata = privateMetadata;
            return this;
        }

        public final Builder setPrivateMetadata(Optional<String> privateMetadata) {
            this.privateMetadata = privateMetadata.orElse(null);
            return this;
        }

        public final Builder setCallbackId(@Nullable String callbackId) {
            this.callbackId = callbackId;
            return this;
        }

        public final Builder setCallbackId(Optional<String> callbackId) {
            this.callbackId = callbackId.orElse(null);
            return this;
        }

        public final Builder setExternalId(@Nullable String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final Builder setExternalId(Optional<String> externalId) {
            this.externalId = externalId.orElse(null);
            return this;
        }

        public final Builder setState(StateValuesPayload state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setHash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ViewInteractionPayload build() {
            this.checkRequiredAttributes();
            return new ViewInteractionPayload(this.type, ViewInteractionPayload.createUnmodifiableList(true, this.blocks), this.privateMetadata, this.callbackId, this.externalId, this.state, this.hash);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean stateIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean hashIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.stateIsSet()) {
                attributes.add("state");
            }
            if (!this.hashIsSet()) {
                attributes.add("hash");
            }
            return "Cannot build ViewInteractionPayload, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ViewInteractionPayloadIF", generator="Immutables")
    static final class Json
    implements ViewInteractionPayloadIF {
        @Nullable
        String type;
        @Nullable
        List<Block> blocks = Collections.emptyList();
        @Nullable
        Optional<String> privateMetadata = Optional.empty();
        @Nullable
        Optional<String> callbackId = Optional.empty();
        @Nullable
        Optional<String> externalId = Optional.empty();
        @Nullable
        StateValuesPayload state;
        @Nullable
        String hash;

        Json() {
        }

        @JsonProperty
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty
        public void setBlocks(List<Block> blocks) {
            this.blocks = blocks;
        }

        @JsonProperty
        public void setPrivateMetadata(Optional<String> privateMetadata) {
            this.privateMetadata = privateMetadata;
        }

        @JsonProperty
        public void setCallbackId(Optional<String> callbackId) {
            this.callbackId = callbackId;
        }

        @JsonProperty
        public void setExternalId(Optional<String> externalId) {
            this.externalId = externalId;
        }

        @JsonProperty
        public void setState(StateValuesPayload state) {
            this.state = state;
        }

        @JsonProperty
        public void setHash(String hash) {
            this.hash = hash;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Block> getBlocks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPrivateMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getCallbackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getExternalId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public StateValuesPayload getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }
    }
}

