/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.LiteMessage;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.interaction.InteractiveCallbackType;
import com.hubspot.slack.client.models.interaction.MessageActionIF;
import com.hubspot.slack.client.models.interaction.SlackInteractiveCallback;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="MessageActionIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class MessageAction
implements MessageActionIF {
    private final InteractiveCallbackType type;
    private final String token;
    private final SlackTeam team;
    private final SlackUserLite user;
    private final SlackChannel channel;
    private final String actionTs;
    private final String callbackId;
    private final String triggerId;
    private final String responseUrl;
    private final LiteMessage message;

    private MessageAction(InteractiveCallbackType type, String token, SlackTeam team, SlackUserLite user, SlackChannel channel, String actionTs, String callbackId, String triggerId, String responseUrl, LiteMessage message) {
        this.type = type;
        this.token = token;
        this.team = team;
        this.user = user;
        this.channel = channel;
        this.actionTs = actionTs;
        this.callbackId = callbackId;
        this.triggerId = triggerId;
        this.responseUrl = responseUrl;
        this.message = message;
    }

    @Override
    @JsonProperty
    public InteractiveCallbackType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty
    public SlackTeam getTeam() {
        return this.team;
    }

    @Override
    @JsonProperty
    public SlackUserLite getUser() {
        return this.user;
    }

    @Override
    @JsonProperty
    public SlackChannel getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public String getActionTs() {
        return this.actionTs;
    }

    @Override
    @JsonProperty
    public String getCallbackId() {
        return this.callbackId;
    }

    @Override
    @JsonProperty
    public String getTriggerId() {
        return this.triggerId;
    }

    @Override
    @JsonProperty
    public String getResponseUrl() {
        return this.responseUrl;
    }

    @Override
    @JsonProperty
    public LiteMessage getMessage() {
        return this.message;
    }

    public final MessageAction withType(InteractiveCallbackType value) {
        InteractiveCallbackType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new MessageAction(newValue, this.token, this.team, this.user, this.channel, this.actionTs, this.callbackId, this.triggerId, this.responseUrl, this.message);
    }

    public final MessageAction withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (this.token.equals(newValue)) {
            return this;
        }
        return new MessageAction(this.type, newValue, this.team, this.user, this.channel, this.actionTs, this.callbackId, this.triggerId, this.responseUrl, this.message);
    }

    public final MessageAction withTeam(SlackTeam value) {
        if (this.team == value) {
            return this;
        }
        SlackTeam newValue = Objects.requireNonNull(value, "team");
        return new MessageAction(this.type, this.token, newValue, this.user, this.channel, this.actionTs, this.callbackId, this.triggerId, this.responseUrl, this.message);
    }

    public final MessageAction withUser(SlackUserLite value) {
        if (this.user == value) {
            return this;
        }
        SlackUserLite newValue = Objects.requireNonNull(value, "user");
        return new MessageAction(this.type, this.token, this.team, newValue, this.channel, this.actionTs, this.callbackId, this.triggerId, this.responseUrl, this.message);
    }

    public final MessageAction withChannel(SlackChannel value) {
        if (this.channel == value) {
            return this;
        }
        SlackChannel newValue = Objects.requireNonNull(value, "channel");
        return new MessageAction(this.type, this.token, this.team, this.user, newValue, this.actionTs, this.callbackId, this.triggerId, this.responseUrl, this.message);
    }

    public final MessageAction withActionTs(String value) {
        String newValue = Objects.requireNonNull(value, "actionTs");
        if (this.actionTs.equals(newValue)) {
            return this;
        }
        return new MessageAction(this.type, this.token, this.team, this.user, this.channel, newValue, this.callbackId, this.triggerId, this.responseUrl, this.message);
    }

    public final MessageAction withCallbackId(String value) {
        String newValue = Objects.requireNonNull(value, "callbackId");
        if (this.callbackId.equals(newValue)) {
            return this;
        }
        return new MessageAction(this.type, this.token, this.team, this.user, this.channel, this.actionTs, newValue, this.triggerId, this.responseUrl, this.message);
    }

    public final MessageAction withTriggerId(String value) {
        String newValue = Objects.requireNonNull(value, "triggerId");
        if (this.triggerId.equals(newValue)) {
            return this;
        }
        return new MessageAction(this.type, this.token, this.team, this.user, this.channel, this.actionTs, this.callbackId, newValue, this.responseUrl, this.message);
    }

    public final MessageAction withResponseUrl(String value) {
        String newValue = Objects.requireNonNull(value, "responseUrl");
        if (this.responseUrl.equals(newValue)) {
            return this;
        }
        return new MessageAction(this.type, this.token, this.team, this.user, this.channel, this.actionTs, this.callbackId, this.triggerId, newValue, this.message);
    }

    public final MessageAction withMessage(LiteMessage value) {
        if (this.message == value) {
            return this;
        }
        LiteMessage newValue = Objects.requireNonNull(value, "message");
        return new MessageAction(this.type, this.token, this.team, this.user, this.channel, this.actionTs, this.callbackId, this.triggerId, this.responseUrl, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MessageAction && this.equalTo(0, (MessageAction)another);
    }

    private boolean equalTo(int synthetic, MessageAction another) {
        return this.type.equals((Object)another.type) && this.token.equals(another.token) && this.team.equals(another.team) && this.user.equals(another.user) && this.channel.equals(another.channel) && this.actionTs.equals(another.actionTs) && this.callbackId.equals(another.callbackId) && this.triggerId.equals(another.triggerId) && this.responseUrl.equals(another.responseUrl) && this.message.equals(another.message);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.team.hashCode();
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.actionTs.hashCode();
        h += (h << 5) + this.callbackId.hashCode();
        h += (h << 5) + this.triggerId.hashCode();
        h += (h << 5) + this.responseUrl.hashCode();
        h += (h << 5) + this.message.hashCode();
        return h;
    }

    public String toString() {
        return "MessageAction{type=" + String.valueOf((Object)this.type) + ", token=" + this.token + ", team=" + String.valueOf(this.team) + ", user=" + String.valueOf(this.user) + ", channel=" + String.valueOf(this.channel) + ", actionTs=" + this.actionTs + ", callbackId=" + this.callbackId + ", triggerId=" + this.triggerId + ", responseUrl=" + this.responseUrl + ", message=" + String.valueOf(this.message) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static MessageAction fromJson(Json json) {
        Builder builder = MessageAction.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.token != null) {
            builder.setToken(json.token);
        }
        if (json.team != null) {
            builder.setTeam(json.team);
        }
        if (json.user != null) {
            builder.setUser(json.user);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        if (json.actionTs != null) {
            builder.setActionTs(json.actionTs);
        }
        if (json.callbackId != null) {
            builder.setCallbackId(json.callbackId);
        }
        if (json.triggerId != null) {
            builder.setTriggerId(json.triggerId);
        }
        if (json.responseUrl != null) {
            builder.setResponseUrl(json.responseUrl);
        }
        if (json.message != null) {
            builder.setMessage(json.message);
        }
        return builder.build();
    }

    public static MessageAction copyOf(MessageActionIF instance) {
        if (instance instanceof MessageAction) {
            return (MessageAction)instance;
        }
        return MessageAction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MessageActionIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_TOKEN = 2L;
        private static final long INIT_BIT_TEAM = 4L;
        private static final long INIT_BIT_USER = 8L;
        private static final long INIT_BIT_CHANNEL = 16L;
        private static final long INIT_BIT_ACTION_TS = 32L;
        private static final long INIT_BIT_CALLBACK_ID = 64L;
        private static final long INIT_BIT_TRIGGER_ID = 128L;
        private static final long INIT_BIT_RESPONSE_URL = 256L;
        private static final long INIT_BIT_MESSAGE = 512L;
        private long initBits = 1023L;
        @Nullable
        private InteractiveCallbackType type;
        @Nullable
        private String token;
        @Nullable
        private SlackTeam team;
        @Nullable
        private SlackUserLite user;
        @Nullable
        private SlackChannel channel;
        @Nullable
        private String actionTs;
        @Nullable
        private String callbackId;
        @Nullable
        private String triggerId;
        @Nullable
        private String responseUrl;
        @Nullable
        private LiteMessage message;

        private Builder() {
        }

        public final Builder from(SlackInteractiveCallback instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(MessageActionIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            SlackInteractiveCallback instance;
            long bits = 0L;
            if (object instanceof SlackInteractiveCallback) {
                instance = (SlackInteractiveCallback)object;
                if ((bits & 0x10L) == 0L) {
                    this.setCallbackId(instance.getCallbackId());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.setChannel(instance.getChannel());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setTeam(instance.getTeam());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 4L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setUser(instance.getUser());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.setActionTs(instance.getActionTs());
                    bits |= 0x40L;
                }
                if ((bits & 8L) == 0L) {
                    this.setToken(instance.getToken());
                    bits |= 8L;
                }
            }
            if (object instanceof MessageActionIF) {
                instance = (MessageActionIF)object;
                this.setResponseUrl(instance.getResponseUrl());
                if ((bits & 0x10L) == 0L) {
                    this.setCallbackId(instance.getCallbackId());
                    bits |= 0x10L;
                }
                this.setTriggerId(instance.getTriggerId());
                if ((bits & 1L) == 0L) {
                    this.setChannel(instance.getChannel());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setTeam(instance.getTeam());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 4L;
                }
                this.setMessage(instance.getMessage());
                if ((bits & 0x20L) == 0L) {
                    this.setUser(instance.getUser());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.setActionTs(instance.getActionTs());
                    bits |= 0x40L;
                }
                if ((bits & 8L) == 0L) {
                    this.setToken(instance.getToken());
                    bits |= 8L;
                }
            }
        }

        public final Builder setType(InteractiveCallbackType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setToken(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setTeam(SlackTeam team) {
            this.team = Objects.requireNonNull(team, "team");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setUser(SlackUserLite user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setChannel(SlackChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setActionTs(String actionTs) {
            this.actionTs = Objects.requireNonNull(actionTs, "actionTs");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setCallbackId(String callbackId) {
            this.callbackId = Objects.requireNonNull(callbackId, "callbackId");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder setTriggerId(String triggerId) {
            this.triggerId = Objects.requireNonNull(triggerId, "triggerId");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder setResponseUrl(String responseUrl) {
            this.responseUrl = Objects.requireNonNull(responseUrl, "responseUrl");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder setMessage(LiteMessage message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public MessageAction build() {
            this.checkRequiredAttributes();
            return new MessageAction(this.type, this.token, this.team, this.user, this.channel, this.actionTs, this.callbackId, this.triggerId, this.responseUrl, this.message);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean tokenIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean teamIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean userIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean channelIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean actionTsIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean callbackIdIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private boolean triggerIdIsSet() {
            return (this.initBits & 0x80L) == 0L;
        }

        private boolean responseUrlIsSet() {
            return (this.initBits & 0x100L) == 0L;
        }

        private boolean messageIsSet() {
            return (this.initBits & 0x200L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.tokenIsSet()) {
                attributes.add("token");
            }
            if (!this.teamIsSet()) {
                attributes.add("team");
            }
            if (!this.userIsSet()) {
                attributes.add("user");
            }
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            if (!this.actionTsIsSet()) {
                attributes.add("actionTs");
            }
            if (!this.callbackIdIsSet()) {
                attributes.add("callbackId");
            }
            if (!this.triggerIdIsSet()) {
                attributes.add("triggerId");
            }
            if (!this.responseUrlIsSet()) {
                attributes.add("responseUrl");
            }
            if (!this.messageIsSet()) {
                attributes.add("message");
            }
            return "Cannot build MessageAction, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MessageActionIF", generator="Immutables")
    static final class Json
    implements MessageActionIF {
        @Nullable
        InteractiveCallbackType type;
        @Nullable
        String token;
        @Nullable
        SlackTeam team;
        @Nullable
        SlackUserLite user;
        @Nullable
        SlackChannel channel;
        @Nullable
        String actionTs;
        @Nullable
        String callbackId;
        @Nullable
        String triggerId;
        @Nullable
        String responseUrl;
        @Nullable
        LiteMessage message;

        Json() {
        }

        @JsonProperty
        public void setType(InteractiveCallbackType type) {
            this.type = type;
        }

        @JsonProperty
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty
        public void setTeam(SlackTeam team) {
            this.team = team;
        }

        @JsonProperty
        public void setUser(SlackUserLite user) {
            this.user = user;
        }

        @JsonProperty
        public void setChannel(SlackChannel channel) {
            this.channel = channel;
        }

        @JsonProperty
        public void setActionTs(String actionTs) {
            this.actionTs = actionTs;
        }

        @JsonProperty
        public void setCallbackId(String callbackId) {
            this.callbackId = callbackId;
        }

        @JsonProperty
        public void setTriggerId(String triggerId) {
            this.triggerId = triggerId;
        }

        @JsonProperty
        public void setResponseUrl(String responseUrl) {
            this.responseUrl = responseUrl;
        }

        @JsonProperty
        public void setMessage(LiteMessage message) {
            this.message = message;
        }

        @Override
        public InteractiveCallbackType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackTeam getTeam() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackUserLite getUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackChannel getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCallbackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTriggerId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getResponseUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LiteMessage getMessage() {
            throw new UnsupportedOperationException();
        }
    }
}

