/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.interaction.InteractiveLoadOptionsRequestIF;
import com.hubspot.slack.client.models.interaction.InteractiveLoadOptionsRequestType;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="InteractiveLoadOptionsRequestIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class InteractiveLoadOptionsRequest
implements InteractiveLoadOptionsRequestIF {
    private final String name;
    private final String value;
    private final String callbackId;
    private final SlackTeam team;
    private final SlackChannel channel;
    private final SlackUserLite user;
    private final InteractiveLoadOptionsRequestType type;
    private final String actionTs;
    @Nullable
    private final String messageTs;
    @Nullable
    private final String attachmentId;
    private final String token;

    private InteractiveLoadOptionsRequest(String name, String value, String callbackId, SlackTeam team, SlackChannel channel, SlackUserLite user, InteractiveLoadOptionsRequestType type, String actionTs, @Nullable String messageTs, @Nullable String attachmentId, String token) {
        this.name = name;
        this.value = value;
        this.callbackId = callbackId;
        this.team = team;
        this.channel = channel;
        this.user = user;
        this.type = type;
        this.actionTs = actionTs;
        this.messageTs = messageTs;
        this.attachmentId = attachmentId;
        this.token = token;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @Override
    @JsonProperty
    public String getCallbackId() {
        return this.callbackId;
    }

    @Override
    @JsonProperty
    public SlackTeam getTeam() {
        return this.team;
    }

    @Override
    @JsonProperty
    public SlackChannel getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public SlackUserLite getUser() {
        return this.user;
    }

    @Override
    @JsonProperty
    public InteractiveLoadOptionsRequestType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getActionTs() {
        return this.actionTs;
    }

    @Override
    @JsonProperty
    public Optional<String> getMessageTs() {
        return Optional.ofNullable(this.messageTs);
    }

    @Override
    @JsonProperty
    public Optional<String> getAttachmentId() {
        return Optional.ofNullable(this.attachmentId);
    }

    @Override
    @JsonProperty
    public String getToken() {
        return this.token;
    }

    public final InteractiveLoadOptionsRequest withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new InteractiveLoadOptionsRequest(newValue, this.value, this.callbackId, this.team, this.channel, this.user, this.type, this.actionTs, this.messageTs, this.attachmentId, this.token);
    }

    public final InteractiveLoadOptionsRequest withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new InteractiveLoadOptionsRequest(this.name, newValue, this.callbackId, this.team, this.channel, this.user, this.type, this.actionTs, this.messageTs, this.attachmentId, this.token);
    }

    public final InteractiveLoadOptionsRequest withCallbackId(String value) {
        String newValue = Objects.requireNonNull(value, "callbackId");
        if (this.callbackId.equals(newValue)) {
            return this;
        }
        return new InteractiveLoadOptionsRequest(this.name, this.value, newValue, this.team, this.channel, this.user, this.type, this.actionTs, this.messageTs, this.attachmentId, this.token);
    }

    public final InteractiveLoadOptionsRequest withTeam(SlackTeam value) {
        if (this.team == value) {
            return this;
        }
        SlackTeam newValue = Objects.requireNonNull(value, "team");
        return new InteractiveLoadOptionsRequest(this.name, this.value, this.callbackId, newValue, this.channel, this.user, this.type, this.actionTs, this.messageTs, this.attachmentId, this.token);
    }

    public final InteractiveLoadOptionsRequest withChannel(SlackChannel value) {
        if (this.channel == value) {
            return this;
        }
        SlackChannel newValue = Objects.requireNonNull(value, "channel");
        return new InteractiveLoadOptionsRequest(this.name, this.value, this.callbackId, this.team, newValue, this.user, this.type, this.actionTs, this.messageTs, this.attachmentId, this.token);
    }

    public final InteractiveLoadOptionsRequest withUser(SlackUserLite value) {
        if (this.user == value) {
            return this;
        }
        SlackUserLite newValue = Objects.requireNonNull(value, "user");
        return new InteractiveLoadOptionsRequest(this.name, this.value, this.callbackId, this.team, this.channel, newValue, this.type, this.actionTs, this.messageTs, this.attachmentId, this.token);
    }

    public final InteractiveLoadOptionsRequest withType(InteractiveLoadOptionsRequestType value) {
        InteractiveLoadOptionsRequestType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new InteractiveLoadOptionsRequest(this.name, this.value, this.callbackId, this.team, this.channel, this.user, newValue, this.actionTs, this.messageTs, this.attachmentId, this.token);
    }

    public final InteractiveLoadOptionsRequest withActionTs(String value) {
        String newValue = Objects.requireNonNull(value, "actionTs");
        if (this.actionTs.equals(newValue)) {
            return this;
        }
        return new InteractiveLoadOptionsRequest(this.name, this.value, this.callbackId, this.team, this.channel, this.user, this.type, newValue, this.messageTs, this.attachmentId, this.token);
    }

    public final InteractiveLoadOptionsRequest withMessageTs(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.messageTs, newValue)) {
            return this;
        }
        return new InteractiveLoadOptionsRequest(this.name, this.value, this.callbackId, this.team, this.channel, this.user, this.type, this.actionTs, newValue, this.attachmentId, this.token);
    }

    public final InteractiveLoadOptionsRequest withMessageTs(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.messageTs, value)) {
            return this;
        }
        return new InteractiveLoadOptionsRequest(this.name, this.value, this.callbackId, this.team, this.channel, this.user, this.type, this.actionTs, value, this.attachmentId, this.token);
    }

    public final InteractiveLoadOptionsRequest withAttachmentId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.attachmentId, newValue)) {
            return this;
        }
        return new InteractiveLoadOptionsRequest(this.name, this.value, this.callbackId, this.team, this.channel, this.user, this.type, this.actionTs, this.messageTs, newValue, this.token);
    }

    public final InteractiveLoadOptionsRequest withAttachmentId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.attachmentId, value)) {
            return this;
        }
        return new InteractiveLoadOptionsRequest(this.name, this.value, this.callbackId, this.team, this.channel, this.user, this.type, this.actionTs, this.messageTs, value, this.token);
    }

    public final InteractiveLoadOptionsRequest withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (this.token.equals(newValue)) {
            return this;
        }
        return new InteractiveLoadOptionsRequest(this.name, this.value, this.callbackId, this.team, this.channel, this.user, this.type, this.actionTs, this.messageTs, this.attachmentId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof InteractiveLoadOptionsRequest && this.equalTo(0, (InteractiveLoadOptionsRequest)another);
    }

    private boolean equalTo(int synthetic, InteractiveLoadOptionsRequest another) {
        return this.name.equals(another.name) && this.value.equals(another.value) && this.callbackId.equals(another.callbackId) && this.team.equals(another.team) && this.channel.equals(another.channel) && this.user.equals(another.user) && this.type.equals((Object)another.type) && this.actionTs.equals(another.actionTs) && Objects.equals(this.messageTs, another.messageTs) && Objects.equals(this.attachmentId, another.attachmentId) && this.token.equals(another.token);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.callbackId.hashCode();
        h += (h << 5) + this.team.hashCode();
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.actionTs.hashCode();
        h += (h << 5) + Objects.hashCode(this.messageTs);
        h += (h << 5) + Objects.hashCode(this.attachmentId);
        h += (h << 5) + this.token.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("InteractiveLoadOptionsRequest{");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("value=").append(this.value);
        builder.append(", ");
        builder.append("callbackId=").append(this.callbackId);
        builder.append(", ");
        builder.append("team=").append(this.team);
        builder.append(", ");
        builder.append("channel=").append(this.channel);
        builder.append(", ");
        builder.append("user=").append(this.user);
        builder.append(", ");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("actionTs=").append(this.actionTs);
        if (this.messageTs != null) {
            builder.append(", ");
            builder.append("messageTs=").append(this.messageTs);
        }
        if (this.attachmentId != null) {
            builder.append(", ");
            builder.append("attachmentId=").append(this.attachmentId);
        }
        builder.append(", ");
        builder.append("token=").append(this.token);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static InteractiveLoadOptionsRequest fromJson(Json json) {
        Builder builder = InteractiveLoadOptionsRequest.builder();
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.value != null) {
            builder.setValue(json.value);
        }
        if (json.callbackId != null) {
            builder.setCallbackId(json.callbackId);
        }
        if (json.team != null) {
            builder.setTeam(json.team);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        if (json.user != null) {
            builder.setUser(json.user);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.actionTs != null) {
            builder.setActionTs(json.actionTs);
        }
        if (json.messageTs != null) {
            builder.setMessageTs(json.messageTs);
        }
        if (json.attachmentId != null) {
            builder.setAttachmentId(json.attachmentId);
        }
        if (json.token != null) {
            builder.setToken(json.token);
        }
        return builder.build();
    }

    public static InteractiveLoadOptionsRequest copyOf(InteractiveLoadOptionsRequestIF instance) {
        if (instance instanceof InteractiveLoadOptionsRequest) {
            return (InteractiveLoadOptionsRequest)instance;
        }
        return InteractiveLoadOptionsRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InteractiveLoadOptionsRequestIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private static final long INIT_BIT_CALLBACK_ID = 4L;
        private static final long INIT_BIT_TEAM = 8L;
        private static final long INIT_BIT_CHANNEL = 16L;
        private static final long INIT_BIT_USER = 32L;
        private static final long INIT_BIT_TYPE = 64L;
        private static final long INIT_BIT_ACTION_TS = 128L;
        private static final long INIT_BIT_TOKEN = 256L;
        private long initBits = 511L;
        @Nullable
        private String name;
        @Nullable
        private String value;
        @Nullable
        private String callbackId;
        @Nullable
        private SlackTeam team;
        @Nullable
        private SlackChannel channel;
        @Nullable
        private SlackUserLite user;
        @Nullable
        private InteractiveLoadOptionsRequestType type;
        @Nullable
        private String actionTs;
        @Nullable
        private String messageTs;
        @Nullable
        private String attachmentId;
        @Nullable
        private String token;

        private Builder() {
        }

        public final Builder from(InteractiveLoadOptionsRequestIF instance) {
            Optional<String> attachmentIdOptional;
            Objects.requireNonNull(instance, "instance");
            this.setName(instance.getName());
            this.setValue(instance.getValue());
            this.setCallbackId(instance.getCallbackId());
            this.setTeam(instance.getTeam());
            this.setChannel(instance.getChannel());
            this.setUser(instance.getUser());
            this.setType(instance.getType());
            this.setActionTs(instance.getActionTs());
            Optional<String> messageTsOptional = instance.getMessageTs();
            if (messageTsOptional.isPresent()) {
                this.setMessageTs(messageTsOptional);
            }
            if ((attachmentIdOptional = instance.getAttachmentId()).isPresent()) {
                this.setAttachmentId(attachmentIdOptional);
            }
            this.setToken(instance.getToken());
            return this;
        }

        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setValue(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setCallbackId(String callbackId) {
            this.callbackId = Objects.requireNonNull(callbackId, "callbackId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setTeam(SlackTeam team) {
            this.team = Objects.requireNonNull(team, "team");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setChannel(SlackChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setUser(SlackUserLite user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setType(InteractiveLoadOptionsRequestType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder setActionTs(String actionTs) {
            this.actionTs = Objects.requireNonNull(actionTs, "actionTs");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder setMessageTs(@Nullable String messageTs) {
            this.messageTs = messageTs;
            return this;
        }

        public final Builder setMessageTs(Optional<String> messageTs) {
            this.messageTs = messageTs.orElse(null);
            return this;
        }

        public final Builder setAttachmentId(@Nullable String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final Builder setAttachmentId(Optional<String> attachmentId) {
            this.attachmentId = attachmentId.orElse(null);
            return this;
        }

        public final Builder setToken(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public InteractiveLoadOptionsRequest build() {
            this.checkRequiredAttributes();
            return new InteractiveLoadOptionsRequest(this.name, this.value, this.callbackId, this.team, this.channel, this.user, this.type, this.actionTs, this.messageTs, this.attachmentId, this.token);
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean valueIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean callbackIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean teamIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean channelIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean userIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private boolean actionTsIsSet() {
            return (this.initBits & 0x80L) == 0L;
        }

        private boolean tokenIsSet() {
            return (this.initBits & 0x100L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.valueIsSet()) {
                attributes.add("value");
            }
            if (!this.callbackIdIsSet()) {
                attributes.add("callbackId");
            }
            if (!this.teamIsSet()) {
                attributes.add("team");
            }
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            if (!this.userIsSet()) {
                attributes.add("user");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.actionTsIsSet()) {
                attributes.add("actionTs");
            }
            if (!this.tokenIsSet()) {
                attributes.add("token");
            }
            return "Cannot build InteractiveLoadOptionsRequest, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="InteractiveLoadOptionsRequestIF", generator="Immutables")
    static final class Json
    implements InteractiveLoadOptionsRequestIF {
        @Nullable
        String name;
        @Nullable
        String value;
        @Nullable
        String callbackId;
        @Nullable
        SlackTeam team;
        @Nullable
        SlackChannel channel;
        @Nullable
        SlackUserLite user;
        @Nullable
        InteractiveLoadOptionsRequestType type;
        @Nullable
        String actionTs;
        @Nullable
        Optional<String> messageTs = Optional.empty();
        @Nullable
        Optional<String> attachmentId = Optional.empty();
        @Nullable
        String token;

        Json() {
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty
        public void setCallbackId(String callbackId) {
            this.callbackId = callbackId;
        }

        @JsonProperty
        public void setTeam(SlackTeam team) {
            this.team = team;
        }

        @JsonProperty
        public void setChannel(SlackChannel channel) {
            this.channel = channel;
        }

        @JsonProperty
        public void setUser(SlackUserLite user) {
            this.user = user;
        }

        @JsonProperty
        public void setType(InteractiveLoadOptionsRequestType type) {
            this.type = type;
        }

        @JsonProperty
        public void setActionTs(String actionTs) {
            this.actionTs = actionTs;
        }

        @JsonProperty
        public void setMessageTs(Optional<String> messageTs) {
            this.messageTs = messageTs;
        }

        @JsonProperty
        public void setAttachmentId(Optional<String> attachmentId) {
            this.attachmentId = attachmentId;
        }

        @JsonProperty
        public void setToken(String token) {
            this.token = token;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCallbackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackTeam getTeam() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackChannel getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackUserLite getUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public InteractiveLoadOptionsRequestType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getMessageTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAttachmentId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }
    }
}

