/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.interaction.DialogSubmissionIF;
import com.hubspot.slack.client.models.interaction.InteractiveCallbackType;
import com.hubspot.slack.client.models.interaction.SlackInteractiveCallback;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="DialogSubmissionIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class DialogSubmission
implements DialogSubmissionIF {
    private final InteractiveCallbackType type;
    private final String callbackId;
    private final String actionTs;
    private final String token;
    private final SlackTeam team;
    private final SlackUserLite user;
    private final SlackChannel channel;
    private final Map<String, Optional<String>> submission;
    @Nullable
    private final String state;

    private DialogSubmission(InteractiveCallbackType type, String callbackId, String actionTs, String token, SlackTeam team, SlackUserLite user, SlackChannel channel, Map<String, Optional<String>> submission, @Nullable String state) {
        this.type = type;
        this.callbackId = callbackId;
        this.actionTs = actionTs;
        this.token = token;
        this.team = team;
        this.user = user;
        this.channel = channel;
        this.submission = submission;
        this.state = state;
    }

    @Override
    @JsonProperty
    public InteractiveCallbackType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getCallbackId() {
        return this.callbackId;
    }

    @Override
    @JsonProperty
    public String getActionTs() {
        return this.actionTs;
    }

    @Override
    @JsonProperty
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty
    public SlackTeam getTeam() {
        return this.team;
    }

    @Override
    @JsonProperty
    public SlackUserLite getUser() {
        return this.user;
    }

    @Override
    @JsonProperty
    public SlackChannel getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public Map<String, Optional<String>> getSubmission() {
        return this.submission;
    }

    @Override
    @JsonProperty
    public Optional<String> getState() {
        return Optional.ofNullable(this.state);
    }

    public final DialogSubmission withType(InteractiveCallbackType value) {
        InteractiveCallbackType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new DialogSubmission(newValue, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel, this.submission, this.state);
    }

    public final DialogSubmission withCallbackId(String value) {
        String newValue = Objects.requireNonNull(value, "callbackId");
        if (this.callbackId.equals(newValue)) {
            return this;
        }
        return new DialogSubmission(this.type, newValue, this.actionTs, this.token, this.team, this.user, this.channel, this.submission, this.state);
    }

    public final DialogSubmission withActionTs(String value) {
        String newValue = Objects.requireNonNull(value, "actionTs");
        if (this.actionTs.equals(newValue)) {
            return this;
        }
        return new DialogSubmission(this.type, this.callbackId, newValue, this.token, this.team, this.user, this.channel, this.submission, this.state);
    }

    public final DialogSubmission withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (this.token.equals(newValue)) {
            return this;
        }
        return new DialogSubmission(this.type, this.callbackId, this.actionTs, newValue, this.team, this.user, this.channel, this.submission, this.state);
    }

    public final DialogSubmission withTeam(SlackTeam value) {
        if (this.team == value) {
            return this;
        }
        SlackTeam newValue = Objects.requireNonNull(value, "team");
        return new DialogSubmission(this.type, this.callbackId, this.actionTs, this.token, newValue, this.user, this.channel, this.submission, this.state);
    }

    public final DialogSubmission withUser(SlackUserLite value) {
        if (this.user == value) {
            return this;
        }
        SlackUserLite newValue = Objects.requireNonNull(value, "user");
        return new DialogSubmission(this.type, this.callbackId, this.actionTs, this.token, this.team, newValue, this.channel, this.submission, this.state);
    }

    public final DialogSubmission withChannel(SlackChannel value) {
        if (this.channel == value) {
            return this;
        }
        SlackChannel newValue = Objects.requireNonNull(value, "channel");
        return new DialogSubmission(this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, newValue, this.submission, this.state);
    }

    public final DialogSubmission withSubmission(Map<String, ? extends Optional<String>> entries) {
        if (this.submission == entries) {
            return this;
        }
        Map<String, Optional<String>> newValue = DialogSubmission.createUnmodifiableMap(true, false, entries);
        return new DialogSubmission(this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel, newValue, this.state);
    }

    public final DialogSubmission withState(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.state, newValue)) {
            return this;
        }
        return new DialogSubmission(this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel, this.submission, newValue);
    }

    public final DialogSubmission withState(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return new DialogSubmission(this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel, this.submission, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DialogSubmission && this.equalTo(0, (DialogSubmission)another);
    }

    private boolean equalTo(int synthetic, DialogSubmission another) {
        return this.type.equals((Object)another.type) && this.callbackId.equals(another.callbackId) && this.actionTs.equals(another.actionTs) && this.token.equals(another.token) && this.team.equals(another.team) && this.user.equals(another.user) && this.channel.equals(another.channel) && this.submission.equals(another.submission) && Objects.equals(this.state, another.state);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.callbackId.hashCode();
        h += (h << 5) + this.actionTs.hashCode();
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.team.hashCode();
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.submission.hashCode();
        h += (h << 5) + Objects.hashCode(this.state);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DialogSubmission{");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("callbackId=").append(this.callbackId);
        builder.append(", ");
        builder.append("actionTs=").append(this.actionTs);
        builder.append(", ");
        builder.append("token=").append(this.token);
        builder.append(", ");
        builder.append("team=").append(this.team);
        builder.append(", ");
        builder.append("user=").append(this.user);
        builder.append(", ");
        builder.append("channel=").append(this.channel);
        builder.append(", ");
        builder.append("submission=").append(this.submission);
        if (this.state != null) {
            builder.append(", ");
            builder.append("state=").append(this.state);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static DialogSubmission fromJson(Json json) {
        Builder builder = DialogSubmission.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.callbackId != null) {
            builder.setCallbackId(json.callbackId);
        }
        if (json.actionTs != null) {
            builder.setActionTs(json.actionTs);
        }
        if (json.token != null) {
            builder.setToken(json.token);
        }
        if (json.team != null) {
            builder.setTeam(json.team);
        }
        if (json.user != null) {
            builder.setUser(json.user);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        if (json.submission != null) {
            builder.putAllSubmission(json.submission);
        }
        if (json.state != null) {
            builder.setState(json.state);
        }
        return builder.build();
    }

    public static DialogSubmission copyOf(DialogSubmissionIF instance) {
        if (instance instanceof DialogSubmission) {
            return (DialogSubmission)instance;
        }
        return DialogSubmission.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="DialogSubmissionIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_CALLBACK_ID = 2L;
        private static final long INIT_BIT_ACTION_TS = 4L;
        private static final long INIT_BIT_TOKEN = 8L;
        private static final long INIT_BIT_TEAM = 16L;
        private static final long INIT_BIT_USER = 32L;
        private static final long INIT_BIT_CHANNEL = 64L;
        private long initBits = 127L;
        @Nullable
        private InteractiveCallbackType type;
        @Nullable
        private String callbackId;
        @Nullable
        private String actionTs;
        @Nullable
        private String token;
        @Nullable
        private SlackTeam team;
        @Nullable
        private SlackUserLite user;
        @Nullable
        private SlackChannel channel;
        private Map<String, Optional<String>> submission = new LinkedHashMap<String, Optional<String>>();
        @Nullable
        private String state;

        private Builder() {
        }

        public final Builder from(DialogSubmissionIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackInteractiveCallback instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            SlackInteractiveCallback instance;
            long bits = 0L;
            if (object instanceof DialogSubmissionIF) {
                Optional<String> stateOptional;
                instance = (DialogSubmissionIF)object;
                if ((bits & 0x10L) == 0L) {
                    this.setCallbackId(instance.getCallbackId());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.setChannel(instance.getChannel());
                    bits |= 1L;
                }
                this.putAllSubmission(instance.getSubmission());
                if ((bits & 2L) == 0L) {
                    this.setTeam(instance.getTeam());
                    bits |= 2L;
                }
                if ((stateOptional = instance.getState()).isPresent()) {
                    this.setState(stateOptional);
                }
                if ((bits & 4L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 4L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setActionTs(instance.getActionTs());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.setUser(instance.getUser());
                    bits |= 0x40L;
                }
                if ((bits & 8L) == 0L) {
                    this.setToken(instance.getToken());
                    bits |= 8L;
                }
            }
            if (object instanceof SlackInteractiveCallback) {
                instance = (SlackInteractiveCallback)object;
                if ((bits & 0x10L) == 0L) {
                    this.setCallbackId(instance.getCallbackId());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.setChannel(instance.getChannel());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setTeam(instance.getTeam());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 4L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setActionTs(instance.getActionTs());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.setUser(instance.getUser());
                    bits |= 0x40L;
                }
                if ((bits & 8L) == 0L) {
                    this.setToken(instance.getToken());
                    bits |= 8L;
                }
            }
        }

        public final Builder setType(InteractiveCallbackType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setCallbackId(String callbackId) {
            this.callbackId = Objects.requireNonNull(callbackId, "callbackId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setActionTs(String actionTs) {
            this.actionTs = Objects.requireNonNull(actionTs, "actionTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setToken(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setTeam(SlackTeam team) {
            this.team = Objects.requireNonNull(team, "team");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setUser(SlackUserLite user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setChannel(SlackChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder putSubmission(String key, Optional<String> value) {
            this.submission.put(Objects.requireNonNull(key, "submission key"), Objects.requireNonNull(value, value == null ? "submission value for key: " + key : null));
            return this;
        }

        public final Builder putSubmission(Map.Entry<String, ? extends Optional<String>> entry) {
            Optional<String> v;
            String k = entry.getKey();
            this.submission.put(Objects.requireNonNull(k, "submission key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "submission value for key: " + k : null));
            return this;
        }

        public final Builder setSubmission(Map<String, ? extends Optional<String>> entries) {
            this.submission.clear();
            return this.putAllSubmission(entries);
        }

        public final Builder putAllSubmission(Map<String, ? extends Optional<String>> entries) {
            for (Map.Entry<String, ? extends Optional<String>> e : entries.entrySet()) {
                Optional<String> v;
                String k = e.getKey();
                this.submission.put(Objects.requireNonNull(k, "submission key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "submission value for key: " + k : null));
            }
            return this;
        }

        public final Builder setState(@Nullable String state) {
            this.state = state;
            return this;
        }

        public final Builder setState(Optional<String> state) {
            this.state = state.orElse(null);
            return this;
        }

        public DialogSubmission build() {
            this.checkRequiredAttributes();
            return new DialogSubmission(this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.channel, DialogSubmission.createUnmodifiableMap(false, false, this.submission), this.state);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean callbackIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean actionTsIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean tokenIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean teamIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean userIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean channelIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.callbackIdIsSet()) {
                attributes.add("callbackId");
            }
            if (!this.actionTsIsSet()) {
                attributes.add("actionTs");
            }
            if (!this.tokenIsSet()) {
                attributes.add("token");
            }
            if (!this.teamIsSet()) {
                attributes.add("team");
            }
            if (!this.userIsSet()) {
                attributes.add("user");
            }
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            return "Cannot build DialogSubmission, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DialogSubmissionIF", generator="Immutables")
    static final class Json
    implements DialogSubmissionIF {
        @Nullable
        InteractiveCallbackType type;
        @Nullable
        String callbackId;
        @Nullable
        String actionTs;
        @Nullable
        String token;
        @Nullable
        SlackTeam team;
        @Nullable
        SlackUserLite user;
        @Nullable
        SlackChannel channel;
        @Nullable
        Map<String, Optional<String>> submission = Collections.emptyMap();
        @Nullable
        Optional<String> state = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setType(InteractiveCallbackType type) {
            this.type = type;
        }

        @JsonProperty
        public void setCallbackId(String callbackId) {
            this.callbackId = callbackId;
        }

        @JsonProperty
        public void setActionTs(String actionTs) {
            this.actionTs = actionTs;
        }

        @JsonProperty
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty
        public void setTeam(SlackTeam team) {
            this.team = team;
        }

        @JsonProperty
        public void setUser(SlackUserLite user) {
            this.user = user;
        }

        @JsonProperty
        public void setChannel(SlackChannel channel) {
            this.channel = channel;
        }

        @JsonProperty
        public void setSubmission(Map<String, Optional<String>> submission) {
            this.submission = submission;
        }

        @JsonProperty
        public void setState(Optional<String> state) {
            this.state = state;
        }

        @Override
        public InteractiveCallbackType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCallbackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackTeam getTeam() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackUserLite getUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackChannel getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Optional<String>> getSubmission() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getState() {
            throw new UnsupportedOperationException();
        }
    }
}

