/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.slack.client.models.blocks.objects.Option;
import com.hubspot.slack.client.models.blocks.objects.OptionGroup;
import com.hubspot.slack.client.models.interaction.BlocksLoadOptionsResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="BlocksLoadOptionsResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class BlocksLoadOptionsResponse
implements BlocksLoadOptionsResponseIF {
    private final List<Option> options;
    private final List<OptionGroup> optionGroups;

    private BlocksLoadOptionsResponse(List<Option> options, List<OptionGroup> optionGroups) {
        this.options = options;
        this.optionGroups = optionGroups;
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<Option> getOptions() {
        return this.options;
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<OptionGroup> getOptionGroups() {
        return this.optionGroups;
    }

    public final BlocksLoadOptionsResponse withOptions(Option ... elements) {
        List<Option> newValue = BlocksLoadOptionsResponse.createUnmodifiableList(false, BlocksLoadOptionsResponse.createSafeList(Arrays.asList(elements), true, false));
        return BlocksLoadOptionsResponse.validate(new BlocksLoadOptionsResponse(newValue, this.optionGroups));
    }

    public final BlocksLoadOptionsResponse withOptions(Iterable<? extends Option> elements) {
        if (this.options == elements) {
            return this;
        }
        List<Option> newValue = BlocksLoadOptionsResponse.createUnmodifiableList(false, BlocksLoadOptionsResponse.createSafeList(elements, true, false));
        return BlocksLoadOptionsResponse.validate(new BlocksLoadOptionsResponse(newValue, this.optionGroups));
    }

    public final BlocksLoadOptionsResponse withOptionGroups(OptionGroup ... elements) {
        List<OptionGroup> newValue = BlocksLoadOptionsResponse.createUnmodifiableList(false, BlocksLoadOptionsResponse.createSafeList(Arrays.asList(elements), true, false));
        return BlocksLoadOptionsResponse.validate(new BlocksLoadOptionsResponse(this.options, newValue));
    }

    public final BlocksLoadOptionsResponse withOptionGroups(Iterable<? extends OptionGroup> elements) {
        if (this.optionGroups == elements) {
            return this;
        }
        List<OptionGroup> newValue = BlocksLoadOptionsResponse.createUnmodifiableList(false, BlocksLoadOptionsResponse.createSafeList(elements, true, false));
        return BlocksLoadOptionsResponse.validate(new BlocksLoadOptionsResponse(this.options, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BlocksLoadOptionsResponse && this.equalTo(0, (BlocksLoadOptionsResponse)another);
    }

    private boolean equalTo(int synthetic, BlocksLoadOptionsResponse another) {
        return this.options.equals(another.options) && this.optionGroups.equals(another.optionGroups);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.options.hashCode();
        h += (h << 5) + this.optionGroups.hashCode();
        return h;
    }

    public String toString() {
        return "BlocksLoadOptionsResponse{options=" + String.valueOf(this.options) + ", optionGroups=" + String.valueOf(this.optionGroups) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static BlocksLoadOptionsResponse fromJson(Json json) {
        Builder builder = BlocksLoadOptionsResponse.builder();
        if (json.options != null) {
            builder.addAllOptions(json.options);
        }
        if (json.optionGroups != null) {
            builder.addAllOptionGroups(json.optionGroups);
        }
        return builder.build();
    }

    private static BlocksLoadOptionsResponse validate(BlocksLoadOptionsResponse instance) {
        instance = (BlocksLoadOptionsResponse)instance.validate();
        return instance;
    }

    public static BlocksLoadOptionsResponse copyOf(BlocksLoadOptionsResponseIF instance) {
        if (instance instanceof BlocksLoadOptionsResponse) {
            return (BlocksLoadOptionsResponse)instance;
        }
        return BlocksLoadOptionsResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="BlocksLoadOptionsResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<Option> options = new ArrayList<Option>();
        private List<OptionGroup> optionGroups = new ArrayList<OptionGroup>();

        private Builder() {
        }

        public final Builder from(BlocksLoadOptionsResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllOptions(instance.getOptions());
            this.addAllOptionGroups(instance.getOptionGroups());
            return this;
        }

        public final Builder addOptions(Option element) {
            this.options.add(Objects.requireNonNull(element, "options element"));
            return this;
        }

        public final Builder addOptions(Option ... elements) {
            for (Option element : elements) {
                this.options.add(Objects.requireNonNull(element, "options element"));
            }
            return this;
        }

        public final Builder setOptions(Iterable<? extends Option> elements) {
            this.options.clear();
            return this.addAllOptions(elements);
        }

        public final Builder addAllOptions(Iterable<? extends Option> elements) {
            for (Option option : elements) {
                this.options.add(Objects.requireNonNull(option, "options element"));
            }
            return this;
        }

        public final Builder addOptionGroups(OptionGroup element) {
            this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
            return this;
        }

        public final Builder addOptionGroups(OptionGroup ... elements) {
            for (OptionGroup element : elements) {
                this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
            }
            return this;
        }

        public final Builder setOptionGroups(Iterable<? extends OptionGroup> elements) {
            this.optionGroups.clear();
            return this.addAllOptionGroups(elements);
        }

        public final Builder addAllOptionGroups(Iterable<? extends OptionGroup> elements) {
            for (OptionGroup optionGroup : elements) {
                this.optionGroups.add(Objects.requireNonNull(optionGroup, "optionGroups element"));
            }
            return this;
        }

        public BlocksLoadOptionsResponse build() {
            return BlocksLoadOptionsResponse.validate(new BlocksLoadOptionsResponse(BlocksLoadOptionsResponse.createUnmodifiableList(true, this.options), BlocksLoadOptionsResponse.createUnmodifiableList(true, this.optionGroups)));
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BlocksLoadOptionsResponseIF", generator="Immutables")
    static final class Json
    implements BlocksLoadOptionsResponseIF {
        @Nullable
        List<Option> options = Collections.emptyList();
        @Nullable
        List<OptionGroup> optionGroups = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setOptions(List<Option> options) {
            this.options = options;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setOptionGroups(List<OptionGroup> optionGroups) {
            this.optionGroups = optionGroups;
        }

        @Override
        public List<Option> getOptions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<OptionGroup> getOptionGroups() {
            throw new UnsupportedOperationException();
        }
    }
}

