/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.BlocksLoadOptionsRequestIF;
import com.hubspot.slack.client.models.interaction.Container;
import com.hubspot.slack.client.models.response.views.ViewResponseBase;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="BlocksLoadOptionsRequestIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class BlocksLoadOptionsRequest
implements BlocksLoadOptionsRequestIF {
    private final String type;
    private final SlackUserLite user;
    private final SlackTeam team;
    private final String token;
    private final String actionId;
    private final String blockId;
    private final String value;
    private final Container container;
    @Nullable
    private final ViewResponseBase view;

    private BlocksLoadOptionsRequest(String type, SlackUserLite user, SlackTeam team, String token, String actionId, String blockId, String value, Container container, @Nullable ViewResponseBase view) {
        this.type = type;
        this.user = user;
        this.team = team;
        this.token = token;
        this.actionId = actionId;
        this.blockId = blockId;
        this.value = value;
        this.container = container;
        this.view = view;
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public SlackUserLite getUser() {
        return this.user;
    }

    @Override
    @JsonProperty
    public SlackTeam getTeam() {
        return this.team;
    }

    @Override
    @JsonProperty
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty
    public String getBlockId() {
        return this.blockId;
    }

    @Override
    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @Override
    @JsonProperty
    public Container getContainer() {
        return this.container;
    }

    @Override
    @JsonProperty
    public Optional<ViewResponseBase> getView() {
        return Optional.ofNullable(this.view);
    }

    public final BlocksLoadOptionsRequest withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new BlocksLoadOptionsRequest(newValue, this.user, this.team, this.token, this.actionId, this.blockId, this.value, this.container, this.view);
    }

    public final BlocksLoadOptionsRequest withUser(SlackUserLite value) {
        if (this.user == value) {
            return this;
        }
        SlackUserLite newValue = Objects.requireNonNull(value, "user");
        return new BlocksLoadOptionsRequest(this.type, newValue, this.team, this.token, this.actionId, this.blockId, this.value, this.container, this.view);
    }

    public final BlocksLoadOptionsRequest withTeam(SlackTeam value) {
        if (this.team == value) {
            return this;
        }
        SlackTeam newValue = Objects.requireNonNull(value, "team");
        return new BlocksLoadOptionsRequest(this.type, this.user, newValue, this.token, this.actionId, this.blockId, this.value, this.container, this.view);
    }

    public final BlocksLoadOptionsRequest withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (this.token.equals(newValue)) {
            return this;
        }
        return new BlocksLoadOptionsRequest(this.type, this.user, this.team, newValue, this.actionId, this.blockId, this.value, this.container, this.view);
    }

    public final BlocksLoadOptionsRequest withActionId(String value) {
        String newValue = Objects.requireNonNull(value, "actionId");
        if (this.actionId.equals(newValue)) {
            return this;
        }
        return new BlocksLoadOptionsRequest(this.type, this.user, this.team, this.token, newValue, this.blockId, this.value, this.container, this.view);
    }

    public final BlocksLoadOptionsRequest withBlockId(String value) {
        String newValue = Objects.requireNonNull(value, "blockId");
        if (this.blockId.equals(newValue)) {
            return this;
        }
        return new BlocksLoadOptionsRequest(this.type, this.user, this.team, this.token, this.actionId, newValue, this.value, this.container, this.view);
    }

    public final BlocksLoadOptionsRequest withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new BlocksLoadOptionsRequest(this.type, this.user, this.team, this.token, this.actionId, this.blockId, newValue, this.container, this.view);
    }

    public final BlocksLoadOptionsRequest withContainer(Container value) {
        if (this.container == value) {
            return this;
        }
        Container newValue = Objects.requireNonNull(value, "container");
        return new BlocksLoadOptionsRequest(this.type, this.user, this.team, this.token, this.actionId, this.blockId, this.value, newValue, this.view);
    }

    public final BlocksLoadOptionsRequest withView(@Nullable ViewResponseBase value) {
        ViewResponseBase newValue = value;
        if (this.view == newValue) {
            return this;
        }
        return new BlocksLoadOptionsRequest(this.type, this.user, this.team, this.token, this.actionId, this.blockId, this.value, this.container, newValue);
    }

    public final BlocksLoadOptionsRequest withView(Optional<? extends ViewResponseBase> optional) {
        ViewResponseBase value = optional.orElse(null);
        if (this.view == value) {
            return this;
        }
        return new BlocksLoadOptionsRequest(this.type, this.user, this.team, this.token, this.actionId, this.blockId, this.value, this.container, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BlocksLoadOptionsRequest && this.equalTo(0, (BlocksLoadOptionsRequest)another);
    }

    private boolean equalTo(int synthetic, BlocksLoadOptionsRequest another) {
        return this.type.equals(another.type) && this.user.equals(another.user) && this.team.equals(another.team) && this.token.equals(another.token) && this.actionId.equals(another.actionId) && this.blockId.equals(another.blockId) && this.value.equals(another.value) && this.container.equals(another.container) && Objects.equals(this.view, another.view);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.team.hashCode();
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.actionId.hashCode();
        h += (h << 5) + this.blockId.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.container.hashCode();
        h += (h << 5) + Objects.hashCode(this.view);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BlocksLoadOptionsRequest{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("user=").append(this.user);
        builder.append(", ");
        builder.append("team=").append(this.team);
        builder.append(", ");
        builder.append("token=").append(this.token);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        builder.append(", ");
        builder.append("blockId=").append(this.blockId);
        builder.append(", ");
        builder.append("value=").append(this.value);
        builder.append(", ");
        builder.append("container=").append(this.container);
        if (this.view != null) {
            builder.append(", ");
            builder.append("view=").append(this.view);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static BlocksLoadOptionsRequest fromJson(Json json) {
        Builder builder = BlocksLoadOptionsRequest.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.user != null) {
            builder.setUser(json.user);
        }
        if (json.team != null) {
            builder.setTeam(json.team);
        }
        if (json.token != null) {
            builder.setToken(json.token);
        }
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.blockId != null) {
            builder.setBlockId(json.blockId);
        }
        if (json.value != null) {
            builder.setValue(json.value);
        }
        if (json.container != null) {
            builder.setContainer(json.container);
        }
        if (json.view != null) {
            builder.setView(json.view);
        }
        return builder.build();
    }

    public static BlocksLoadOptionsRequest copyOf(BlocksLoadOptionsRequestIF instance) {
        if (instance instanceof BlocksLoadOptionsRequest) {
            return (BlocksLoadOptionsRequest)instance;
        }
        return BlocksLoadOptionsRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BlocksLoadOptionsRequestIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_USER = 2L;
        private static final long INIT_BIT_TEAM = 4L;
        private static final long INIT_BIT_TOKEN = 8L;
        private static final long INIT_BIT_ACTION_ID = 16L;
        private static final long INIT_BIT_BLOCK_ID = 32L;
        private static final long INIT_BIT_VALUE = 64L;
        private static final long INIT_BIT_CONTAINER = 128L;
        private long initBits = 255L;
        @Nullable
        private String type;
        @Nullable
        private SlackUserLite user;
        @Nullable
        private SlackTeam team;
        @Nullable
        private String token;
        @Nullable
        private String actionId;
        @Nullable
        private String blockId;
        @Nullable
        private String value;
        @Nullable
        private Container container;
        @Nullable
        private ViewResponseBase view;

        private Builder() {
        }

        public final Builder from(BlocksLoadOptionsRequestIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setType(instance.getType());
            this.setUser(instance.getUser());
            this.setTeam(instance.getTeam());
            this.setToken(instance.getToken());
            this.setActionId(instance.getActionId());
            this.setBlockId(instance.getBlockId());
            this.setValue(instance.getValue());
            this.setContainer(instance.getContainer());
            Optional<ViewResponseBase> viewOptional = instance.getView();
            if (viewOptional.isPresent()) {
                this.setView(viewOptional);
            }
            return this;
        }

        public final Builder setType(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setUser(SlackUserLite user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setTeam(SlackTeam team) {
            this.team = Objects.requireNonNull(team, "team");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setToken(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setBlockId(String blockId) {
            this.blockId = Objects.requireNonNull(blockId, "blockId");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setValue(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder setContainer(Container container) {
            this.container = Objects.requireNonNull(container, "container");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder setView(@Nullable ViewResponseBase view) {
            this.view = view;
            return this;
        }

        public final Builder setView(Optional<? extends ViewResponseBase> view) {
            this.view = view.orElse(null);
            return this;
        }

        public BlocksLoadOptionsRequest build() {
            this.checkRequiredAttributes();
            return new BlocksLoadOptionsRequest(this.type, this.user, this.team, this.token, this.actionId, this.blockId, this.value, this.container, this.view);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean userIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean teamIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean tokenIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean blockIdIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean valueIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private boolean containerIsSet() {
            return (this.initBits & 0x80L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.userIsSet()) {
                attributes.add("user");
            }
            if (!this.teamIsSet()) {
                attributes.add("team");
            }
            if (!this.tokenIsSet()) {
                attributes.add("token");
            }
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            if (!this.blockIdIsSet()) {
                attributes.add("blockId");
            }
            if (!this.valueIsSet()) {
                attributes.add("value");
            }
            if (!this.containerIsSet()) {
                attributes.add("container");
            }
            return "Cannot build BlocksLoadOptionsRequest, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BlocksLoadOptionsRequestIF", generator="Immutables")
    static final class Json
    implements BlocksLoadOptionsRequestIF {
        @Nullable
        String type;
        @Nullable
        SlackUserLite user;
        @Nullable
        SlackTeam team;
        @Nullable
        String token;
        @Nullable
        String actionId;
        @Nullable
        String blockId;
        @Nullable
        String value;
        @Nullable
        Container container;
        @Nullable
        Optional<ViewResponseBase> view = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty
        public void setUser(SlackUserLite user) {
            this.user = user;
        }

        @JsonProperty
        public void setTeam(SlackTeam team) {
            this.team = team;
        }

        @JsonProperty
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty
        public void setBlockId(String blockId) {
            this.blockId = blockId;
        }

        @JsonProperty
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty
        public void setContainer(Container container) {
            this.container = container;
        }

        @JsonProperty
        public void setView(Optional<ViewResponseBase> view) {
            this.view = view;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackUserLite getUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackTeam getTeam() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBlockId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Container getContainer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ViewResponseBase> getView() {
            throw new UnsupportedOperationException();
        }
    }
}

