/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.files;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.files.SlackFile;
import com.hubspot.slack.client.models.files.SlackFileDeletedFileIF;
import com.hubspot.slack.client.models.files.SlackFileError;
import com.hubspot.slack.client.models.files.SlackFileType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackFileDeletedFileIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackFileDeletedFile
implements SlackFileDeletedFileIF {
    private final String fileAccess;
    private final String id;
    private final long createdEpochSeconds;
    private final long timestampEpochSeconds;
    private final String name;
    private final String title;
    private final String mimetype;
    private final SlackFileType filetype;
    private final String prettyType;
    private final String userId;
    private final boolean editable;
    private final long size;
    private final String mode;
    private final boolean external;
    private final boolean isPublic;
    private final boolean publicUrlShared;
    private final boolean displayAsBot;
    private final String username;
    private final String urlPrivate;
    @Nullable
    private final String urlPrivateDownload;
    private final String permalink;
    @Nullable
    private final String permalinkPublic;
    private final int commentsCount;
    @Nullable
    private final Boolean starred;
    private final List<String> channelIds;
    private final List<String> groupIds;
    private final List<String> imIds;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SlackFileDeletedFile(Builder builder) {
        this.fileAccess = builder.fileAccess;
        this.urlPrivateDownload = builder.urlPrivateDownload;
        this.permalinkPublic = builder.permalinkPublic;
        this.starred = builder.starred;
        this.channelIds = SlackFileDeletedFile.createUnmodifiableList(true, builder.channelIds);
        this.groupIds = SlackFileDeletedFile.createUnmodifiableList(true, builder.groupIds);
        this.imIds = SlackFileDeletedFile.createUnmodifiableList(true, builder.imIds);
        if (builder.id != null) {
            this.initShim.setId(builder.id);
        }
        if (builder.createdEpochSecondsIsSet()) {
            this.initShim.setCreatedEpochSeconds(builder.createdEpochSeconds);
        }
        if (builder.timestampEpochSecondsIsSet()) {
            this.initShim.setTimestampEpochSeconds(builder.timestampEpochSeconds);
        }
        if (builder.name != null) {
            this.initShim.setName(builder.name);
        }
        if (builder.title != null) {
            this.initShim.setTitle(builder.title);
        }
        if (builder.mimetype != null) {
            this.initShim.setMimetype(builder.mimetype);
        }
        if (builder.filetype != null) {
            this.initShim.setFiletype(builder.filetype);
        }
        if (builder.prettyType != null) {
            this.initShim.setPrettyType(builder.prettyType);
        }
        if (builder.userId != null) {
            this.initShim.setUserId(builder.userId);
        }
        if (builder.editableIsSet()) {
            this.initShim.setEditable(builder.editable);
        }
        if (builder.sizeIsSet()) {
            this.initShim.setSize(builder.size);
        }
        if (builder.mode != null) {
            this.initShim.setMode(builder.mode);
        }
        if (builder.externalIsSet()) {
            this.initShim.setExternal(builder.external);
        }
        if (builder.publicIsSet()) {
            this.initShim.setPublic(builder.isPublic);
        }
        if (builder.publicUrlSharedIsSet()) {
            this.initShim.setPublicUrlShared(builder.publicUrlShared);
        }
        if (builder.displayAsBotIsSet()) {
            this.initShim.setDisplayAsBot(builder.displayAsBot);
        }
        if (builder.username != null) {
            this.initShim.setUsername(builder.username);
        }
        if (builder.urlPrivate != null) {
            this.initShim.setUrlPrivate(builder.urlPrivate);
        }
        if (builder.permalink != null) {
            this.initShim.setPermalink(builder.permalink);
        }
        if (builder.commentsCountIsSet()) {
            this.initShim.setCommentsCount(builder.commentsCount);
        }
        this.id = this.initShim.getId();
        this.createdEpochSeconds = this.initShim.getCreatedEpochSeconds();
        this.timestampEpochSeconds = this.initShim.getTimestampEpochSeconds();
        this.name = this.initShim.getName();
        this.title = this.initShim.getTitle();
        this.mimetype = this.initShim.getMimetype();
        this.filetype = this.initShim.getFiletype();
        this.prettyType = this.initShim.getPrettyType();
        this.userId = this.initShim.getUserId();
        this.editable = this.initShim.isEditable();
        this.size = this.initShim.getSize();
        this.mode = this.initShim.getMode();
        this.external = this.initShim.isExternal();
        this.isPublic = this.initShim.isPublic();
        this.publicUrlShared = this.initShim.isPublicUrlShared();
        this.displayAsBot = this.initShim.getDisplayAsBot();
        this.username = this.initShim.getUsername();
        this.urlPrivate = this.initShim.getUrlPrivate();
        this.permalink = this.initShim.getPermalink();
        this.commentsCount = this.initShim.getCommentsCount();
        this.initShim = null;
    }

    private SlackFileDeletedFile(String fileAccess, String id, long createdEpochSeconds, long timestampEpochSeconds, String name, String title, String mimetype, SlackFileType filetype, String prettyType, String userId, boolean editable, long size, String mode, boolean external, boolean isPublic, boolean publicUrlShared, boolean displayAsBot, String username, String urlPrivate, @Nullable String urlPrivateDownload, String permalink, @Nullable String permalinkPublic, int commentsCount, @Nullable Boolean starred, List<String> channelIds, List<String> groupIds, List<String> imIds) {
        this.fileAccess = fileAccess;
        this.id = id;
        this.createdEpochSeconds = createdEpochSeconds;
        this.timestampEpochSeconds = timestampEpochSeconds;
        this.name = name;
        this.title = title;
        this.mimetype = mimetype;
        this.filetype = filetype;
        this.prettyType = prettyType;
        this.userId = userId;
        this.editable = editable;
        this.size = size;
        this.mode = mode;
        this.external = external;
        this.isPublic = isPublic;
        this.publicUrlShared = publicUrlShared;
        this.displayAsBot = displayAsBot;
        this.username = username;
        this.urlPrivate = urlPrivate;
        this.urlPrivateDownload = urlPrivateDownload;
        this.permalink = permalink;
        this.permalinkPublic = permalinkPublic;
        this.commentsCount = commentsCount;
        this.starred = starred;
        this.channelIds = channelIds;
        this.groupIds = groupIds;
        this.imIds = imIds;
        this.initShim = null;
    }

    private String getIdInitialize() {
        return SlackFileDeletedFileIF.super.getId();
    }

    private long getCreatedEpochSecondsInitialize() {
        return SlackFileDeletedFileIF.super.getCreatedEpochSeconds();
    }

    private long getTimestampEpochSecondsInitialize() {
        return SlackFileDeletedFileIF.super.getTimestampEpochSeconds();
    }

    private String getNameInitialize() {
        return SlackFileDeletedFileIF.super.getName();
    }

    private String getTitleInitialize() {
        return SlackFileDeletedFileIF.super.getTitle();
    }

    private String getMimetypeInitialize() {
        return SlackFileDeletedFileIF.super.getMimetype();
    }

    private SlackFileType getFiletypeInitialize() {
        return SlackFileDeletedFileIF.super.getFiletype();
    }

    private String getPrettyTypeInitialize() {
        return SlackFileDeletedFileIF.super.getPrettyType();
    }

    private String getUserIdInitialize() {
        return SlackFileDeletedFileIF.super.getUserId();
    }

    private boolean isEditableInitialize() {
        return SlackFileDeletedFileIF.super.isEditable();
    }

    private long getSizeInitialize() {
        return SlackFileDeletedFileIF.super.getSize();
    }

    private String getModeInitialize() {
        return SlackFileDeletedFileIF.super.getMode();
    }

    private boolean isExternalInitialize() {
        return SlackFileDeletedFileIF.super.isExternal();
    }

    private boolean isPublicInitialize() {
        return SlackFileDeletedFileIF.super.isPublic();
    }

    private boolean isPublicUrlSharedInitialize() {
        return SlackFileDeletedFileIF.super.isPublicUrlShared();
    }

    private boolean getDisplayAsBotInitialize() {
        return SlackFileDeletedFileIF.super.getDisplayAsBot();
    }

    private String getUsernameInitialize() {
        return SlackFileDeletedFileIF.super.getUsername();
    }

    private String getUrlPrivateInitialize() {
        return SlackFileDeletedFileIF.super.getUrlPrivate();
    }

    private String getPermalinkInitialize() {
        return SlackFileDeletedFileIF.super.getPermalink();
    }

    private int getCommentsCountInitialize() {
        return SlackFileDeletedFileIF.super.getCommentsCount();
    }

    @Override
    @JsonProperty
    public String getFileAccess() {
        return this.fileAccess;
    }

    @Override
    @JsonProperty
    public String getId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getId() : this.id;
    }

    @Override
    @JsonProperty
    public long getCreatedEpochSeconds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCreatedEpochSeconds() : this.createdEpochSeconds;
    }

    @Override
    @JsonProperty
    public long getTimestampEpochSeconds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTimestampEpochSeconds() : this.timestampEpochSeconds;
    }

    @Override
    @JsonProperty
    public String getName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getName() : this.name;
    }

    @Override
    @JsonProperty
    public String getTitle() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTitle() : this.title;
    }

    @Override
    @JsonProperty
    public String getMimetype() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMimetype() : this.mimetype;
    }

    @Override
    @JsonProperty
    public SlackFileType getFiletype() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getFiletype() : this.filetype;
    }

    @Override
    @JsonProperty
    public String getPrettyType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPrettyType() : this.prettyType;
    }

    @Override
    @JsonProperty
    public String getUserId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getUserId() : this.userId;
    }

    @Override
    @JsonProperty
    public boolean isEditable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isEditable() : this.editable;
    }

    @Override
    @JsonProperty
    public long getSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSize() : this.size;
    }

    @Override
    @JsonProperty
    public String getMode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMode() : this.mode;
    }

    @Override
    @JsonProperty
    public boolean isExternal() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isExternal() : this.external;
    }

    @Override
    @JsonProperty
    public boolean isPublic() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isPublic() : this.isPublic;
    }

    @Override
    @JsonProperty
    public boolean isPublicUrlShared() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isPublicUrlShared() : this.publicUrlShared;
    }

    @Override
    @JsonProperty
    public boolean getDisplayAsBot() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDisplayAsBot() : this.displayAsBot;
    }

    @Override
    @JsonProperty
    public String getUsername() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getUsername() : this.username;
    }

    @Override
    @JsonProperty
    public String getUrlPrivate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getUrlPrivate() : this.urlPrivate;
    }

    @Override
    @JsonProperty
    public Optional<String> getUrlPrivateDownload() {
        return Optional.ofNullable(this.urlPrivateDownload);
    }

    @Override
    @JsonProperty
    public String getPermalink() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPermalink() : this.permalink;
    }

    @Override
    @JsonProperty
    public Optional<String> getPermalinkPublic() {
        return Optional.ofNullable(this.permalinkPublic);
    }

    @Override
    @JsonProperty
    public int getCommentsCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCommentsCount() : this.commentsCount;
    }

    @Override
    @JsonProperty
    public Optional<Boolean> isStarred() {
        return Optional.ofNullable(this.starred);
    }

    @Override
    @JsonProperty
    public List<String> getChannelIds() {
        return this.channelIds;
    }

    @Override
    @JsonProperty
    public List<String> getGroupIds() {
        return this.groupIds;
    }

    @Override
    @JsonProperty
    public List<String> getImIds() {
        return this.imIds;
    }

    public final SlackFileDeletedFile withFileAccess(String value) {
        String newValue = Objects.requireNonNull(value, "fileAccess");
        if (this.fileAccess.equals(newValue)) {
            return this;
        }
        return new SlackFileDeletedFile(newValue, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, newValue, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withCreatedEpochSeconds(long value) {
        if (this.createdEpochSeconds == value) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, value, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withTimestampEpochSeconds(long value) {
        if (this.timestampEpochSeconds == value) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, value, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, newValue, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, newValue, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withMimetype(String value) {
        String newValue = Objects.requireNonNull(value, "mimetype");
        if (this.mimetype.equals(newValue)) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, newValue, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withFiletype(SlackFileType value) {
        SlackFileType newValue = Objects.requireNonNull(value, "filetype");
        if (this.filetype == newValue) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, newValue, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withPrettyType(String value) {
        String newValue = Objects.requireNonNull(value, "prettyType");
        if (this.prettyType.equals(newValue)) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, newValue, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withUserId(String value) {
        String newValue = Objects.requireNonNull(value, "userId");
        if (this.userId.equals(newValue)) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, newValue, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withEditable(boolean value) {
        if (this.editable == value) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, value, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withSize(long value) {
        if (this.size == value) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, value, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withMode(String value) {
        String newValue = Objects.requireNonNull(value, "mode");
        if (this.mode.equals(newValue)) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, newValue, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withExternal(boolean value) {
        if (this.external == value) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, value, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withPublic(boolean value) {
        if (this.isPublic == value) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, value, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withPublicUrlShared(boolean value) {
        if (this.publicUrlShared == value) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, value, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withDisplayAsBot(boolean value) {
        if (this.displayAsBot == value) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, value, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, newValue, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withUrlPrivate(String value) {
        String newValue = Objects.requireNonNull(value, "urlPrivate");
        if (this.urlPrivate.equals(newValue)) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, newValue, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withUrlPrivateDownload(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.urlPrivateDownload, newValue)) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, newValue, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withUrlPrivateDownload(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.urlPrivateDownload, value)) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, value, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withPermalink(String value) {
        String newValue = Objects.requireNonNull(value, "permalink");
        if (this.permalink.equals(newValue)) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, newValue, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withPermalinkPublic(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.permalinkPublic, newValue)) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, newValue, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withPermalinkPublic(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.permalinkPublic, value)) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, value, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withCommentsCount(int value) {
        if (this.commentsCount == value) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, value, this.starred, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withStarred(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.starred, newValue)) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, newValue, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withStarred(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.starred, value)) {
            return this;
        }
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, value, this.channelIds, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withChannelIds(String ... elements) {
        List<String> newValue = SlackFileDeletedFile.createUnmodifiableList(false, SlackFileDeletedFile.createSafeList(Arrays.asList(elements), true, false));
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, newValue, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withChannelIds(Iterable<String> elements) {
        if (this.channelIds == elements) {
            return this;
        }
        List<String> newValue = SlackFileDeletedFile.createUnmodifiableList(false, SlackFileDeletedFile.createSafeList(elements, true, false));
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, newValue, this.groupIds, this.imIds);
    }

    public final SlackFileDeletedFile withGroupIds(String ... elements) {
        List<String> newValue = SlackFileDeletedFile.createUnmodifiableList(false, SlackFileDeletedFile.createSafeList(Arrays.asList(elements), true, false));
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, newValue, this.imIds);
    }

    public final SlackFileDeletedFile withGroupIds(Iterable<String> elements) {
        if (this.groupIds == elements) {
            return this;
        }
        List<String> newValue = SlackFileDeletedFile.createUnmodifiableList(false, SlackFileDeletedFile.createSafeList(elements, true, false));
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, newValue, this.imIds);
    }

    public final SlackFileDeletedFile withImIds(String ... elements) {
        List<String> newValue = SlackFileDeletedFile.createUnmodifiableList(false, SlackFileDeletedFile.createSafeList(Arrays.asList(elements), true, false));
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, newValue);
    }

    public final SlackFileDeletedFile withImIds(Iterable<String> elements) {
        if (this.imIds == elements) {
            return this;
        }
        List<String> newValue = SlackFileDeletedFile.createUnmodifiableList(false, SlackFileDeletedFile.createSafeList(elements, true, false));
        return new SlackFileDeletedFile(this.fileAccess, this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.filetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackFileDeletedFile && this.equalTo(0, (SlackFileDeletedFile)another);
    }

    private boolean equalTo(int synthetic, SlackFileDeletedFile another) {
        return this.fileAccess.equals(another.fileAccess) && this.id.equals(another.id) && this.createdEpochSeconds == another.createdEpochSeconds && this.timestampEpochSeconds == another.timestampEpochSeconds && this.name.equals(another.name) && this.title.equals(another.title) && this.mimetype.equals(another.mimetype) && this.filetype.equals((Object)another.filetype) && this.prettyType.equals(another.prettyType) && this.userId.equals(another.userId) && this.editable == another.editable && this.size == another.size && this.mode.equals(another.mode) && this.external == another.external && this.isPublic == another.isPublic && this.publicUrlShared == another.publicUrlShared && this.displayAsBot == another.displayAsBot && this.username.equals(another.username) && this.urlPrivate.equals(another.urlPrivate) && Objects.equals(this.urlPrivateDownload, another.urlPrivateDownload) && this.permalink.equals(another.permalink) && Objects.equals(this.permalinkPublic, another.permalinkPublic) && this.commentsCount == another.commentsCount && Objects.equals(this.starred, another.starred) && this.channelIds.equals(another.channelIds) && this.groupIds.equals(another.groupIds) && this.imIds.equals(another.imIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.fileAccess.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Long.hashCode(this.createdEpochSeconds);
        h += (h << 5) + Long.hashCode(this.timestampEpochSeconds);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.mimetype.hashCode();
        h += (h << 5) + this.filetype.hashCode();
        h += (h << 5) + this.prettyType.hashCode();
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + Boolean.hashCode(this.editable);
        h += (h << 5) + Long.hashCode(this.size);
        h += (h << 5) + this.mode.hashCode();
        h += (h << 5) + Boolean.hashCode(this.external);
        h += (h << 5) + Boolean.hashCode(this.isPublic);
        h += (h << 5) + Boolean.hashCode(this.publicUrlShared);
        h += (h << 5) + Boolean.hashCode(this.displayAsBot);
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.urlPrivate.hashCode();
        h += (h << 5) + Objects.hashCode(this.urlPrivateDownload);
        h += (h << 5) + this.permalink.hashCode();
        h += (h << 5) + Objects.hashCode(this.permalinkPublic);
        h += (h << 5) + this.commentsCount;
        h += (h << 5) + Objects.hashCode(this.starred);
        h += (h << 5) + this.channelIds.hashCode();
        h += (h << 5) + this.groupIds.hashCode();
        h += (h << 5) + this.imIds.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackFileDeletedFile{");
        builder.append("fileAccess=").append(this.fileAccess);
        builder.append(", ");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("createdEpochSeconds=").append(this.createdEpochSeconds);
        builder.append(", ");
        builder.append("timestampEpochSeconds=").append(this.timestampEpochSeconds);
        builder.append(", ");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("title=").append(this.title);
        builder.append(", ");
        builder.append("mimetype=").append(this.mimetype);
        builder.append(", ");
        builder.append("filetype=").append((Object)this.filetype);
        builder.append(", ");
        builder.append("prettyType=").append(this.prettyType);
        builder.append(", ");
        builder.append("userId=").append(this.userId);
        builder.append(", ");
        builder.append("editable=").append(this.editable);
        builder.append(", ");
        builder.append("size=").append(this.size);
        builder.append(", ");
        builder.append("mode=").append(this.mode);
        builder.append(", ");
        builder.append("external=").append(this.external);
        builder.append(", ");
        builder.append("public=").append(this.isPublic);
        builder.append(", ");
        builder.append("publicUrlShared=").append(this.publicUrlShared);
        builder.append(", ");
        builder.append("displayAsBot=").append(this.displayAsBot);
        builder.append(", ");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("urlPrivate=").append(this.urlPrivate);
        if (this.urlPrivateDownload != null) {
            builder.append(", ");
            builder.append("urlPrivateDownload=").append(this.urlPrivateDownload);
        }
        builder.append(", ");
        builder.append("permalink=").append(this.permalink);
        if (this.permalinkPublic != null) {
            builder.append(", ");
            builder.append("permalinkPublic=").append(this.permalinkPublic);
        }
        builder.append(", ");
        builder.append("commentsCount=").append(this.commentsCount);
        if (this.starred != null) {
            builder.append(", ");
            builder.append("starred=").append(this.starred);
        }
        builder.append(", ");
        builder.append("channelIds=").append(this.channelIds);
        builder.append(", ");
        builder.append("groupIds=").append(this.groupIds);
        builder.append(", ");
        builder.append("imIds=").append(this.imIds);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackFileDeletedFile fromJson(Json json) {
        Builder builder = SlackFileDeletedFile.builder();
        if (json.fileAccess != null) {
            builder.setFileAccess(json.fileAccess);
        }
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.createdEpochSecondsIsSet) {
            builder.setCreatedEpochSeconds(json.createdEpochSeconds);
        }
        if (json.timestampEpochSecondsIsSet) {
            builder.setTimestampEpochSeconds(json.timestampEpochSeconds);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.mimetype != null) {
            builder.setMimetype(json.mimetype);
        }
        if (json.filetype != null) {
            builder.setFiletype(json.filetype);
        }
        if (json.prettyType != null) {
            builder.setPrettyType(json.prettyType);
        }
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.editableIsSet) {
            builder.setEditable(json.editable);
        }
        if (json.sizeIsSet) {
            builder.setSize(json.size);
        }
        if (json.mode != null) {
            builder.setMode(json.mode);
        }
        if (json.externalIsSet) {
            builder.setExternal(json.external);
        }
        if (json.isPublicIsSet) {
            builder.setPublic(json.isPublic);
        }
        if (json.publicUrlSharedIsSet) {
            builder.setPublicUrlShared(json.publicUrlShared);
        }
        if (json.displayAsBotIsSet) {
            builder.setDisplayAsBot(json.displayAsBot);
        }
        if (json.username != null) {
            builder.setUsername(json.username);
        }
        if (json.urlPrivate != null) {
            builder.setUrlPrivate(json.urlPrivate);
        }
        if (json.urlPrivateDownload != null) {
            builder.setUrlPrivateDownload(json.urlPrivateDownload);
        }
        if (json.permalink != null) {
            builder.setPermalink(json.permalink);
        }
        if (json.permalinkPublic != null) {
            builder.setPermalinkPublic(json.permalinkPublic);
        }
        if (json.commentsCountIsSet) {
            builder.setCommentsCount(json.commentsCount);
        }
        if (json.starred != null) {
            builder.setStarred(json.starred);
        }
        if (json.channelIds != null) {
            builder.addAllChannelIds(json.channelIds);
        }
        if (json.groupIds != null) {
            builder.addAllGroupIds(json.groupIds);
        }
        if (json.imIds != null) {
            builder.addAllImIds(json.imIds);
        }
        return builder.build();
    }

    public static SlackFileDeletedFile copyOf(SlackFileDeletedFileIF instance) {
        if (instance instanceof SlackFileDeletedFile) {
            return (SlackFileDeletedFile)instance;
        }
        return SlackFileDeletedFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="SlackFileDeletedFileIF", generator="Immutables")
    private final class InitShim {
        private byte idBuildStage = 0;
        private String id;
        private byte createdEpochSecondsBuildStage = 0;
        private long createdEpochSeconds;
        private byte timestampEpochSecondsBuildStage = 0;
        private long timestampEpochSeconds;
        private byte nameBuildStage = 0;
        private String name;
        private byte titleBuildStage = 0;
        private String title;
        private byte mimetypeBuildStage = 0;
        private String mimetype;
        private byte filetypeBuildStage = 0;
        private SlackFileType filetype;
        private byte prettyTypeBuildStage = 0;
        private String prettyType;
        private byte userIdBuildStage = 0;
        private String userId;
        private byte editableBuildStage = 0;
        private boolean editable;
        private byte sizeBuildStage = 0;
        private long size;
        private byte modeBuildStage = 0;
        private String mode;
        private byte externalBuildStage = 0;
        private boolean external;
        private byte isPublicBuildStage = 0;
        private boolean isPublic;
        private byte publicUrlSharedBuildStage = 0;
        private boolean publicUrlShared;
        private byte displayAsBotBuildStage = 0;
        private boolean displayAsBot;
        private byte usernameBuildStage = 0;
        private String username;
        private byte urlPrivateBuildStage = 0;
        private String urlPrivate;
        private byte permalinkBuildStage = 0;
        private String permalink;
        private byte commentsCountBuildStage = 0;
        private int commentsCount;

        private InitShim() {
        }

        String getId() {
            if (this.idBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.idBuildStage == 0) {
                this.idBuildStage = (byte)-1;
                this.id = Objects.requireNonNull(SlackFileDeletedFile.this.getIdInitialize(), "id");
                this.idBuildStage = 1;
            }
            return this.id;
        }

        void setId(String id) {
            this.id = id;
            this.idBuildStage = 1;
        }

        long getCreatedEpochSeconds() {
            if (this.createdEpochSecondsBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.createdEpochSecondsBuildStage == 0) {
                this.createdEpochSecondsBuildStage = (byte)-1;
                this.createdEpochSeconds = SlackFileDeletedFile.this.getCreatedEpochSecondsInitialize();
                this.createdEpochSecondsBuildStage = 1;
            }
            return this.createdEpochSeconds;
        }

        void setCreatedEpochSeconds(long createdEpochSeconds) {
            this.createdEpochSeconds = createdEpochSeconds;
            this.createdEpochSecondsBuildStage = 1;
        }

        long getTimestampEpochSeconds() {
            if (this.timestampEpochSecondsBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.timestampEpochSecondsBuildStage == 0) {
                this.timestampEpochSecondsBuildStage = (byte)-1;
                this.timestampEpochSeconds = SlackFileDeletedFile.this.getTimestampEpochSecondsInitialize();
                this.timestampEpochSecondsBuildStage = 1;
            }
            return this.timestampEpochSeconds;
        }

        void setTimestampEpochSeconds(long timestampEpochSeconds) {
            this.timestampEpochSeconds = timestampEpochSeconds;
            this.timestampEpochSecondsBuildStage = 1;
        }

        String getName() {
            if (this.nameBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.nameBuildStage == 0) {
                this.nameBuildStage = (byte)-1;
                this.name = Objects.requireNonNull(SlackFileDeletedFile.this.getNameInitialize(), "name");
                this.nameBuildStage = 1;
            }
            return this.name;
        }

        void setName(String name) {
            this.name = name;
            this.nameBuildStage = 1;
        }

        String getTitle() {
            if (this.titleBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.titleBuildStage == 0) {
                this.titleBuildStage = (byte)-1;
                this.title = Objects.requireNonNull(SlackFileDeletedFile.this.getTitleInitialize(), "title");
                this.titleBuildStage = 1;
            }
            return this.title;
        }

        void setTitle(String title) {
            this.title = title;
            this.titleBuildStage = 1;
        }

        String getMimetype() {
            if (this.mimetypeBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.mimetypeBuildStage == 0) {
                this.mimetypeBuildStage = (byte)-1;
                this.mimetype = Objects.requireNonNull(SlackFileDeletedFile.this.getMimetypeInitialize(), "mimetype");
                this.mimetypeBuildStage = 1;
            }
            return this.mimetype;
        }

        void setMimetype(String mimetype) {
            this.mimetype = mimetype;
            this.mimetypeBuildStage = 1;
        }

        SlackFileType getFiletype() {
            if (this.filetypeBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.filetypeBuildStage == 0) {
                this.filetypeBuildStage = (byte)-1;
                this.filetype = Objects.requireNonNull(SlackFileDeletedFile.this.getFiletypeInitialize(), "filetype");
                this.filetypeBuildStage = 1;
            }
            return this.filetype;
        }

        void setFiletype(SlackFileType filetype) {
            this.filetype = filetype;
            this.filetypeBuildStage = 1;
        }

        String getPrettyType() {
            if (this.prettyTypeBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.prettyTypeBuildStage == 0) {
                this.prettyTypeBuildStage = (byte)-1;
                this.prettyType = Objects.requireNonNull(SlackFileDeletedFile.this.getPrettyTypeInitialize(), "prettyType");
                this.prettyTypeBuildStage = 1;
            }
            return this.prettyType;
        }

        void setPrettyType(String prettyType) {
            this.prettyType = prettyType;
            this.prettyTypeBuildStage = 1;
        }

        String getUserId() {
            if (this.userIdBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.userIdBuildStage == 0) {
                this.userIdBuildStage = (byte)-1;
                this.userId = Objects.requireNonNull(SlackFileDeletedFile.this.getUserIdInitialize(), "userId");
                this.userIdBuildStage = 1;
            }
            return this.userId;
        }

        void setUserId(String userId) {
            this.userId = userId;
            this.userIdBuildStage = 1;
        }

        boolean isEditable() {
            if (this.editableBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.editableBuildStage == 0) {
                this.editableBuildStage = (byte)-1;
                this.editable = SlackFileDeletedFile.this.isEditableInitialize();
                this.editableBuildStage = 1;
            }
            return this.editable;
        }

        void setEditable(boolean editable) {
            this.editable = editable;
            this.editableBuildStage = 1;
        }

        long getSize() {
            if (this.sizeBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.sizeBuildStage == 0) {
                this.sizeBuildStage = (byte)-1;
                this.size = SlackFileDeletedFile.this.getSizeInitialize();
                this.sizeBuildStage = 1;
            }
            return this.size;
        }

        void setSize(long size) {
            this.size = size;
            this.sizeBuildStage = 1;
        }

        String getMode() {
            if (this.modeBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.modeBuildStage == 0) {
                this.modeBuildStage = (byte)-1;
                this.mode = Objects.requireNonNull(SlackFileDeletedFile.this.getModeInitialize(), "mode");
                this.modeBuildStage = 1;
            }
            return this.mode;
        }

        void setMode(String mode) {
            this.mode = mode;
            this.modeBuildStage = 1;
        }

        boolean isExternal() {
            if (this.externalBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.externalBuildStage == 0) {
                this.externalBuildStage = (byte)-1;
                this.external = SlackFileDeletedFile.this.isExternalInitialize();
                this.externalBuildStage = 1;
            }
            return this.external;
        }

        void setExternal(boolean external) {
            this.external = external;
            this.externalBuildStage = 1;
        }

        boolean isPublic() {
            if (this.isPublicBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.isPublicBuildStage == 0) {
                this.isPublicBuildStage = (byte)-1;
                this.isPublic = SlackFileDeletedFile.this.isPublicInitialize();
                this.isPublicBuildStage = 1;
            }
            return this.isPublic;
        }

        void setPublic(boolean isPublic) {
            this.isPublic = isPublic;
            this.isPublicBuildStage = 1;
        }

        boolean isPublicUrlShared() {
            if (this.publicUrlSharedBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.publicUrlSharedBuildStage == 0) {
                this.publicUrlSharedBuildStage = (byte)-1;
                this.publicUrlShared = SlackFileDeletedFile.this.isPublicUrlSharedInitialize();
                this.publicUrlSharedBuildStage = 1;
            }
            return this.publicUrlShared;
        }

        void setPublicUrlShared(boolean publicUrlShared) {
            this.publicUrlShared = publicUrlShared;
            this.publicUrlSharedBuildStage = 1;
        }

        boolean getDisplayAsBot() {
            if (this.displayAsBotBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.displayAsBotBuildStage == 0) {
                this.displayAsBotBuildStage = (byte)-1;
                this.displayAsBot = SlackFileDeletedFile.this.getDisplayAsBotInitialize();
                this.displayAsBotBuildStage = 1;
            }
            return this.displayAsBot;
        }

        void setDisplayAsBot(boolean displayAsBot) {
            this.displayAsBot = displayAsBot;
            this.displayAsBotBuildStage = 1;
        }

        String getUsername() {
            if (this.usernameBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(SlackFileDeletedFile.this.getUsernameInitialize(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void setUsername(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        String getUrlPrivate() {
            if (this.urlPrivateBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.urlPrivateBuildStage == 0) {
                this.urlPrivateBuildStage = (byte)-1;
                this.urlPrivate = Objects.requireNonNull(SlackFileDeletedFile.this.getUrlPrivateInitialize(), "urlPrivate");
                this.urlPrivateBuildStage = 1;
            }
            return this.urlPrivate;
        }

        void setUrlPrivate(String urlPrivate) {
            this.urlPrivate = urlPrivate;
            this.urlPrivateBuildStage = 1;
        }

        String getPermalink() {
            if (this.permalinkBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.permalinkBuildStage == 0) {
                this.permalinkBuildStage = (byte)-1;
                this.permalink = Objects.requireNonNull(SlackFileDeletedFile.this.getPermalinkInitialize(), "permalink");
                this.permalinkBuildStage = 1;
            }
            return this.permalink;
        }

        void setPermalink(String permalink) {
            this.permalink = permalink;
            this.permalinkBuildStage = 1;
        }

        int getCommentsCount() {
            if (this.commentsCountBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.commentsCountBuildStage == 0) {
                this.commentsCountBuildStage = (byte)-1;
                this.commentsCount = SlackFileDeletedFile.this.getCommentsCountInitialize();
                this.commentsCountBuildStage = 1;
            }
            return this.commentsCount;
        }

        void setCommentsCount(int commentsCount) {
            this.commentsCount = commentsCount;
            this.commentsCountBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.idBuildStage == -1) {
                attributes.add("id");
            }
            if (this.createdEpochSecondsBuildStage == -1) {
                attributes.add("createdEpochSeconds");
            }
            if (this.timestampEpochSecondsBuildStage == -1) {
                attributes.add("timestampEpochSeconds");
            }
            if (this.nameBuildStage == -1) {
                attributes.add("name");
            }
            if (this.titleBuildStage == -1) {
                attributes.add("title");
            }
            if (this.mimetypeBuildStage == -1) {
                attributes.add("mimetype");
            }
            if (this.filetypeBuildStage == -1) {
                attributes.add("filetype");
            }
            if (this.prettyTypeBuildStage == -1) {
                attributes.add("prettyType");
            }
            if (this.userIdBuildStage == -1) {
                attributes.add("userId");
            }
            if (this.editableBuildStage == -1) {
                attributes.add("editable");
            }
            if (this.sizeBuildStage == -1) {
                attributes.add("size");
            }
            if (this.modeBuildStage == -1) {
                attributes.add("mode");
            }
            if (this.externalBuildStage == -1) {
                attributes.add("external");
            }
            if (this.isPublicBuildStage == -1) {
                attributes.add("isPublic");
            }
            if (this.publicUrlSharedBuildStage == -1) {
                attributes.add("publicUrlShared");
            }
            if (this.displayAsBotBuildStage == -1) {
                attributes.add("displayAsBot");
            }
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.urlPrivateBuildStage == -1) {
                attributes.add("urlPrivate");
            }
            if (this.permalinkBuildStage == -1) {
                attributes.add("permalink");
            }
            if (this.commentsCountBuildStage == -1) {
                attributes.add("commentsCount");
            }
            return "Cannot build SlackFileDeletedFile, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="SlackFileDeletedFileIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FILE_ACCESS = 1L;
        private static final long OPT_BIT_CREATED_EPOCH_SECONDS = 1L;
        private static final long OPT_BIT_TIMESTAMP_EPOCH_SECONDS = 2L;
        private static final long OPT_BIT_EDITABLE = 4L;
        private static final long OPT_BIT_SIZE = 8L;
        private static final long OPT_BIT_EXTERNAL = 16L;
        private static final long OPT_BIT_IS_PUBLIC = 32L;
        private static final long OPT_BIT_PUBLIC_URL_SHARED = 64L;
        private static final long OPT_BIT_DISPLAY_AS_BOT = 128L;
        private static final long OPT_BIT_COMMENTS_COUNT = 256L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String fileAccess;
        @Nullable
        private String id;
        private long createdEpochSeconds;
        private long timestampEpochSeconds;
        @Nullable
        private String name;
        @Nullable
        private String title;
        @Nullable
        private String mimetype;
        @Nullable
        private SlackFileType filetype;
        @Nullable
        private String prettyType;
        @Nullable
        private String userId;
        private boolean editable;
        private long size;
        @Nullable
        private String mode;
        private boolean external;
        private boolean isPublic;
        private boolean publicUrlShared;
        private boolean displayAsBot;
        @Nullable
        private String username;
        @Nullable
        private String urlPrivate;
        @Nullable
        private String urlPrivateDownload;
        @Nullable
        private String permalink;
        @Nullable
        private String permalinkPublic;
        private int commentsCount;
        @Nullable
        private Boolean starred;
        private List<String> channelIds = new ArrayList<String>();
        private List<String> groupIds = new ArrayList<String>();
        private List<String> imIds = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(SlackFileDeletedFileIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackFileError instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> permalinkPublicOptional;
            Optional<Boolean> starredOptional;
            Optional<String> urlPrivateDownloadOptional;
            SlackFile instance;
            long bits = 0L;
            if (object instanceof SlackFileDeletedFileIF) {
                instance = (SlackFileDeletedFileIF)object;
                if ((bits & 1L) == 0L) {
                    this.setFiletype(instance.getFiletype());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setTitle(instance.getTitle());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.setDisplayAsBot(instance.getDisplayAsBot());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.addAllImIds(instance.getImIds());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    urlPrivateDownloadOptional = instance.getUrlPrivateDownload();
                    if (urlPrivateDownloadOptional.isPresent()) {
                        this.setUrlPrivateDownload(urlPrivateDownloadOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setMode(instance.getMode());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    starredOptional = instance.isStarred();
                    if (starredOptional.isPresent()) {
                        this.setStarred(starredOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.setUrlPrivate(instance.getUrlPrivate());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.setPrettyType(instance.getPrettyType());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.addAllGroupIds(instance.getGroupIds());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.setPublicUrlShared(instance.isPublicUrlShared());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.setTimestampEpochSeconds(instance.getTimestampEpochSeconds());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.setPublic(instance.isPublic());
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.setId(instance.getId());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    this.addAllChannelIds(instance.getChannelIds());
                    bits |= 0x4000L;
                }
                if ((bits & 0x8000L) == 0L) {
                    this.setCreatedEpochSeconds(instance.getCreatedEpochSeconds());
                    bits |= 0x8000L;
                }
                if ((bits & 0x10000L) == 0L) {
                    this.setEditable(instance.isEditable());
                    bits |= 0x10000L;
                }
                if ((bits & 0x20000L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 0x20000L;
                }
                if ((bits & 0x40000L) == 0L) {
                    this.setExternal(instance.isExternal());
                    bits |= 0x40000L;
                }
                if ((bits & 0x80000L) == 0L) {
                    this.setSize(instance.getSize());
                    bits |= 0x80000L;
                }
                if ((bits & 0x100000L) == 0L) {
                    this.setFileAccess(instance.getFileAccess());
                    bits |= 0x100000L;
                }
                if ((bits & 0x200000L) == 0L) {
                    this.setCommentsCount(instance.getCommentsCount());
                    bits |= 0x200000L;
                }
                if ((bits & 0x400000L) == 0L) {
                    this.setName(instance.getName());
                    bits |= 0x400000L;
                }
                if ((bits & 0x800000L) == 0L) {
                    this.setMimetype(instance.getMimetype());
                    bits |= 0x800000L;
                }
                if ((bits & 0x1000000L) == 0L) {
                    permalinkPublicOptional = instance.getPermalinkPublic();
                    if (permalinkPublicOptional.isPresent()) {
                        this.setPermalinkPublic(permalinkPublicOptional);
                    }
                    bits |= 0x1000000L;
                }
                if ((bits & 0x2000000L) == 0L) {
                    this.setPermalink(instance.getPermalink());
                    bits |= 0x2000000L;
                }
                if ((bits & 0x4000000L) == 0L) {
                    this.setUsername(instance.getUsername());
                    bits |= 0x4000000L;
                }
            }
            if (object instanceof SlackFileError) {
                instance = (SlackFileError)object;
                if ((bits & 1L) == 0L) {
                    this.setFiletype(instance.getFiletype());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setTitle(instance.getTitle());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.setDisplayAsBot(instance.getDisplayAsBot());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.addAllImIds(instance.getImIds());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    urlPrivateDownloadOptional = instance.getUrlPrivateDownload();
                    if (urlPrivateDownloadOptional.isPresent()) {
                        this.setUrlPrivateDownload(urlPrivateDownloadOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setMode(instance.getMode());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    starredOptional = instance.isStarred();
                    if (starredOptional.isPresent()) {
                        this.setStarred(starredOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.setUrlPrivate(instance.getUrlPrivate());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.setPrettyType(instance.getPrettyType());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.addAllGroupIds(instance.getGroupIds());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.setPublicUrlShared(instance.isPublicUrlShared());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.setTimestampEpochSeconds(instance.getTimestampEpochSeconds());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.setPublic(instance.isPublic());
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.setId(instance.getId());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    this.addAllChannelIds(instance.getChannelIds());
                    bits |= 0x4000L;
                }
                if ((bits & 0x8000L) == 0L) {
                    this.setCreatedEpochSeconds(instance.getCreatedEpochSeconds());
                    bits |= 0x8000L;
                }
                if ((bits & 0x10000L) == 0L) {
                    this.setEditable(instance.isEditable());
                    bits |= 0x10000L;
                }
                if ((bits & 0x20000L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 0x20000L;
                }
                if ((bits & 0x40000L) == 0L) {
                    this.setExternal(instance.isExternal());
                    bits |= 0x40000L;
                }
                if ((bits & 0x80000L) == 0L) {
                    this.setSize(instance.getSize());
                    bits |= 0x80000L;
                }
                if ((bits & 0x100000L) == 0L) {
                    this.setFileAccess(instance.getFileAccess());
                    bits |= 0x100000L;
                }
                if ((bits & 0x200000L) == 0L) {
                    this.setCommentsCount(instance.getCommentsCount());
                    bits |= 0x200000L;
                }
                if ((bits & 0x400000L) == 0L) {
                    this.setName(instance.getName());
                    bits |= 0x400000L;
                }
                if ((bits & 0x800000L) == 0L) {
                    this.setMimetype(instance.getMimetype());
                    bits |= 0x800000L;
                }
                if ((bits & 0x1000000L) == 0L) {
                    permalinkPublicOptional = instance.getPermalinkPublic();
                    if (permalinkPublicOptional.isPresent()) {
                        this.setPermalinkPublic(permalinkPublicOptional);
                    }
                    bits |= 0x1000000L;
                }
                if ((bits & 0x2000000L) == 0L) {
                    this.setPermalink(instance.getPermalink());
                    bits |= 0x2000000L;
                }
                if ((bits & 0x4000000L) == 0L) {
                    this.setUsername(instance.getUsername());
                    bits |= 0x4000000L;
                }
            }
            if (object instanceof SlackFile) {
                instance = (SlackFile)object;
                if ((bits & 1L) == 0L) {
                    this.setFiletype(instance.getFiletype());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setTitle(instance.getTitle());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.setDisplayAsBot(instance.getDisplayAsBot());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.addAllImIds(instance.getImIds());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    urlPrivateDownloadOptional = instance.getUrlPrivateDownload();
                    if (urlPrivateDownloadOptional.isPresent()) {
                        this.setUrlPrivateDownload(urlPrivateDownloadOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setMode(instance.getMode());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    starredOptional = instance.isStarred();
                    if (starredOptional.isPresent()) {
                        this.setStarred(starredOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.setUrlPrivate(instance.getUrlPrivate());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.setPrettyType(instance.getPrettyType());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.addAllGroupIds(instance.getGroupIds());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.setPublicUrlShared(instance.isPublicUrlShared());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.setTimestampEpochSeconds(instance.getTimestampEpochSeconds());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.setPublic(instance.isPublic());
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.setId(instance.getId());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    this.addAllChannelIds(instance.getChannelIds());
                    bits |= 0x4000L;
                }
                if ((bits & 0x8000L) == 0L) {
                    this.setCreatedEpochSeconds(instance.getCreatedEpochSeconds());
                    bits |= 0x8000L;
                }
                if ((bits & 0x10000L) == 0L) {
                    this.setEditable(instance.isEditable());
                    bits |= 0x10000L;
                }
                if ((bits & 0x20000L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 0x20000L;
                }
                if ((bits & 0x40000L) == 0L) {
                    this.setExternal(instance.isExternal());
                    bits |= 0x40000L;
                }
                if ((bits & 0x80000L) == 0L) {
                    this.setSize(instance.getSize());
                    bits |= 0x80000L;
                }
                if ((bits & 0x200000L) == 0L) {
                    this.setCommentsCount(instance.getCommentsCount());
                    bits |= 0x200000L;
                }
                if ((bits & 0x400000L) == 0L) {
                    this.setName(instance.getName());
                    bits |= 0x400000L;
                }
                if ((bits & 0x800000L) == 0L) {
                    this.setMimetype(instance.getMimetype());
                    bits |= 0x800000L;
                }
                if ((bits & 0x1000000L) == 0L) {
                    permalinkPublicOptional = instance.getPermalinkPublic();
                    if (permalinkPublicOptional.isPresent()) {
                        this.setPermalinkPublic(permalinkPublicOptional);
                    }
                    bits |= 0x1000000L;
                }
                if ((bits & 0x2000000L) == 0L) {
                    this.setPermalink(instance.getPermalink());
                    bits |= 0x2000000L;
                }
                if ((bits & 0x4000000L) == 0L) {
                    this.setUsername(instance.getUsername());
                    bits |= 0x4000000L;
                }
            }
        }

        @JsonProperty
        public final Builder setFileAccess(String fileAccess) {
            this.fileAccess = Objects.requireNonNull(fileAccess, "fileAccess");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty
        public final Builder setCreatedEpochSeconds(long createdEpochSeconds) {
            this.createdEpochSeconds = createdEpochSeconds;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty
        public final Builder setTimestampEpochSeconds(long timestampEpochSeconds) {
            this.timestampEpochSeconds = timestampEpochSeconds;
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty
        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        @JsonProperty
        public final Builder setTitle(String title) {
            this.title = Objects.requireNonNull(title, "title");
            return this;
        }

        @JsonProperty
        public final Builder setMimetype(String mimetype) {
            this.mimetype = Objects.requireNonNull(mimetype, "mimetype");
            return this;
        }

        @JsonProperty
        public final Builder setFiletype(SlackFileType filetype) {
            this.filetype = Objects.requireNonNull(filetype, "filetype");
            return this;
        }

        @JsonProperty
        public final Builder setPrettyType(String prettyType) {
            this.prettyType = Objects.requireNonNull(prettyType, "prettyType");
            return this;
        }

        @JsonProperty
        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            return this;
        }

        @JsonProperty
        public final Builder setEditable(boolean editable) {
            this.editable = editable;
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty
        public final Builder setSize(long size) {
            this.size = size;
            this.optBits |= 8L;
            return this;
        }

        @JsonProperty
        public final Builder setMode(String mode) {
            this.mode = Objects.requireNonNull(mode, "mode");
            return this;
        }

        @JsonProperty
        public final Builder setExternal(boolean external) {
            this.external = external;
            this.optBits |= 0x10L;
            return this;
        }

        @JsonProperty
        public final Builder setPublic(boolean isPublic) {
            this.isPublic = isPublic;
            this.optBits |= 0x20L;
            return this;
        }

        @JsonProperty
        public final Builder setPublicUrlShared(boolean publicUrlShared) {
            this.publicUrlShared = publicUrlShared;
            this.optBits |= 0x40L;
            return this;
        }

        @JsonProperty
        public final Builder setDisplayAsBot(boolean displayAsBot) {
            this.displayAsBot = displayAsBot;
            this.optBits |= 0x80L;
            return this;
        }

        @JsonProperty
        public final Builder setUsername(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        @JsonProperty
        public final Builder setUrlPrivate(String urlPrivate) {
            this.urlPrivate = Objects.requireNonNull(urlPrivate, "urlPrivate");
            return this;
        }

        public final Builder setUrlPrivateDownload(@Nullable String urlPrivateDownload) {
            this.urlPrivateDownload = urlPrivateDownload;
            return this;
        }

        @JsonProperty
        public final Builder setUrlPrivateDownload(Optional<String> urlPrivateDownload) {
            this.urlPrivateDownload = urlPrivateDownload.orElse(null);
            return this;
        }

        @JsonProperty
        public final Builder setPermalink(String permalink) {
            this.permalink = Objects.requireNonNull(permalink, "permalink");
            return this;
        }

        public final Builder setPermalinkPublic(@Nullable String permalinkPublic) {
            this.permalinkPublic = permalinkPublic;
            return this;
        }

        @JsonProperty
        public final Builder setPermalinkPublic(Optional<String> permalinkPublic) {
            this.permalinkPublic = permalinkPublic.orElse(null);
            return this;
        }

        @JsonProperty
        public final Builder setCommentsCount(int commentsCount) {
            this.commentsCount = commentsCount;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder setStarred(@Nullable Boolean starred) {
            this.starred = starred;
            return this;
        }

        @JsonProperty
        public final Builder setStarred(Optional<Boolean> starred) {
            this.starred = starred.orElse(null);
            return this;
        }

        public final Builder addChannelIds(String element) {
            this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
            return this;
        }

        public final Builder addChannelIds(String ... elements) {
            for (String element : elements) {
                this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
            }
            return this;
        }

        @JsonProperty
        public final Builder setChannelIds(Iterable<String> elements) {
            this.channelIds.clear();
            return this.addAllChannelIds(elements);
        }

        public final Builder addAllChannelIds(Iterable<String> elements) {
            for (String element : elements) {
                this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
            }
            return this;
        }

        public final Builder addGroupIds(String element) {
            this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
            return this;
        }

        public final Builder addGroupIds(String ... elements) {
            for (String element : elements) {
                this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
            }
            return this;
        }

        @JsonProperty
        public final Builder setGroupIds(Iterable<String> elements) {
            this.groupIds.clear();
            return this.addAllGroupIds(elements);
        }

        public final Builder addAllGroupIds(Iterable<String> elements) {
            for (String element : elements) {
                this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
            }
            return this;
        }

        public final Builder addImIds(String element) {
            this.imIds.add(Objects.requireNonNull(element, "imIds element"));
            return this;
        }

        public final Builder addImIds(String ... elements) {
            for (String element : elements) {
                this.imIds.add(Objects.requireNonNull(element, "imIds element"));
            }
            return this;
        }

        @JsonProperty
        public final Builder setImIds(Iterable<String> elements) {
            this.imIds.clear();
            return this.addAllImIds(elements);
        }

        public final Builder addAllImIds(Iterable<String> elements) {
            for (String element : elements) {
                this.imIds.add(Objects.requireNonNull(element, "imIds element"));
            }
            return this;
        }

        public SlackFileDeletedFile build() {
            this.checkRequiredAttributes();
            return new SlackFileDeletedFile(this);
        }

        private boolean createdEpochSecondsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean timestampEpochSecondsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean editableIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean sizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean externalIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean publicIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean publicUrlSharedIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean displayAsBotIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean commentsCountIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean fileAccessIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.fileAccessIsSet()) {
                attributes.add("fileAccess");
            }
            return "Cannot build SlackFileDeletedFile, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackFileDeletedFileIF", generator="Immutables")
    static final class Json
    implements SlackFileDeletedFileIF {
        @Nullable
        String fileAccess;
        @Nullable
        String id;
        long createdEpochSeconds;
        boolean createdEpochSecondsIsSet;
        long timestampEpochSeconds;
        boolean timestampEpochSecondsIsSet;
        @Nullable
        String name;
        @Nullable
        String title;
        @Nullable
        String mimetype;
        @Nullable
        SlackFileType filetype;
        @Nullable
        String prettyType;
        @Nullable
        String userId;
        boolean editable;
        boolean editableIsSet;
        long size;
        boolean sizeIsSet;
        @Nullable
        String mode;
        boolean external;
        boolean externalIsSet;
        boolean isPublic;
        boolean isPublicIsSet;
        boolean publicUrlShared;
        boolean publicUrlSharedIsSet;
        boolean displayAsBot;
        boolean displayAsBotIsSet;
        @Nullable
        String username;
        @Nullable
        String urlPrivate;
        @Nullable
        Optional<String> urlPrivateDownload = Optional.empty();
        @Nullable
        String permalink;
        @Nullable
        Optional<String> permalinkPublic = Optional.empty();
        int commentsCount;
        boolean commentsCountIsSet;
        @Nullable
        Optional<Boolean> starred = Optional.empty();
        @Nullable
        List<String> channelIds = Collections.emptyList();
        @Nullable
        List<String> groupIds = Collections.emptyList();
        @Nullable
        List<String> imIds = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setFileAccess(String fileAccess) {
            this.fileAccess = fileAccess;
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        public void setCreatedEpochSeconds(long createdEpochSeconds) {
            this.createdEpochSeconds = createdEpochSeconds;
            this.createdEpochSecondsIsSet = true;
        }

        @JsonProperty
        public void setTimestampEpochSeconds(long timestampEpochSeconds) {
            this.timestampEpochSeconds = timestampEpochSeconds;
            this.timestampEpochSecondsIsSet = true;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty
        public void setMimetype(String mimetype) {
            this.mimetype = mimetype;
        }

        @JsonProperty
        public void setFiletype(SlackFileType filetype) {
            this.filetype = filetype;
        }

        @JsonProperty
        public void setPrettyType(String prettyType) {
            this.prettyType = prettyType;
        }

        @JsonProperty
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty
        public void setEditable(boolean editable) {
            this.editable = editable;
            this.editableIsSet = true;
        }

        @JsonProperty
        public void setSize(long size) {
            this.size = size;
            this.sizeIsSet = true;
        }

        @JsonProperty
        public void setMode(String mode) {
            this.mode = mode;
        }

        @JsonProperty
        public void setExternal(boolean external) {
            this.external = external;
            this.externalIsSet = true;
        }

        @JsonProperty
        public void setPublic(boolean isPublic) {
            this.isPublic = isPublic;
            this.isPublicIsSet = true;
        }

        @JsonProperty
        public void setPublicUrlShared(boolean publicUrlShared) {
            this.publicUrlShared = publicUrlShared;
            this.publicUrlSharedIsSet = true;
        }

        @JsonProperty
        public void setDisplayAsBot(boolean displayAsBot) {
            this.displayAsBot = displayAsBot;
            this.displayAsBotIsSet = true;
        }

        @JsonProperty
        public void setUsername(String username) {
            this.username = username;
        }

        @JsonProperty
        public void setUrlPrivate(String urlPrivate) {
            this.urlPrivate = urlPrivate;
        }

        @JsonProperty
        public void setUrlPrivateDownload(Optional<String> urlPrivateDownload) {
            this.urlPrivateDownload = urlPrivateDownload;
        }

        @JsonProperty
        public void setPermalink(String permalink) {
            this.permalink = permalink;
        }

        @JsonProperty
        public void setPermalinkPublic(Optional<String> permalinkPublic) {
            this.permalinkPublic = permalinkPublic;
        }

        @JsonProperty
        public void setCommentsCount(int commentsCount) {
            this.commentsCount = commentsCount;
            this.commentsCountIsSet = true;
        }

        @JsonProperty
        public void setStarred(Optional<Boolean> starred) {
            this.starred = starred;
        }

        @JsonProperty
        public void setChannelIds(List<String> channelIds) {
            this.channelIds = channelIds;
        }

        @JsonProperty
        public void setGroupIds(List<String> groupIds) {
            this.groupIds = groupIds;
        }

        @JsonProperty
        public void setImIds(List<String> imIds) {
            this.imIds = imIds;
        }

        @Override
        public String getFileAccess() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getCreatedEpochSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getTimestampEpochSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMimetype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackFileType getFiletype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPrettyType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEditable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isExternal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPublic() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPublicUrlShared() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getDisplayAsBot() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUrlPrivate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUrlPrivateDownload() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPermalink() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPermalinkPublic() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getCommentsCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isStarred() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getChannelIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getGroupIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getImIds() {
            throw new UnsupportedOperationException();
        }
    }
}

