/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.interceptor.HasUser;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventMessageBase;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.SlackMessageSubtype;
import com.hubspot.slack.client.models.events.util.AbstractSlackReplyMessage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AbstractSlackReplyMessage", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackReplyMessage
extends AbstractSlackReplyMessage {
    private final SlackEventType type;
    private final String ts;
    @Nullable
    private final SlackMessageSubtype subtype;
    private final List<Attachment> attachments;
    private final String threadTs;
    private final String userId;
    private final String channelId;
    private final int replyCount;
    @Nullable
    private final List<String> replyUserIds;
    @Nullable
    private final Integer replyUsersCount;
    @Nullable
    private final String latestReplyTimestamp;

    private SlackReplyMessage(Builder builder) {
        this.type = builder.type;
        this.ts = builder.ts;
        this.subtype = builder.subtype;
        this.attachments = SlackReplyMessage.createUnmodifiableList(true, builder.attachments);
        this.threadTs = builder.threadTs;
        this.userId = builder.userId;
        this.channelId = builder.channelId;
        this.replyUserIds = builder.replyUserIds;
        this.replyUsersCount = builder.replyUsersCount;
        this.latestReplyTimestamp = builder.latestReplyTimestamp;
        this.replyCount = builder.replyCountIsSet() ? builder.replyCount : super.getReplyCount();
    }

    private SlackReplyMessage(SlackEventType type, String ts, @Nullable SlackMessageSubtype subtype, List<Attachment> attachments, String threadTs, String userId, String channelId, int replyCount, @Nullable List<String> replyUserIds, @Nullable Integer replyUsersCount, @Nullable String latestReplyTimestamp) {
        this.type = type;
        this.ts = ts;
        this.subtype = subtype;
        this.attachments = attachments;
        this.threadTs = threadTs;
        this.userId = userId;
        this.channelId = channelId;
        this.replyCount = replyCount;
        this.replyUserIds = replyUserIds;
        this.replyUsersCount = replyUsersCount;
        this.latestReplyTimestamp = latestReplyTimestamp;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getTs() {
        return this.ts;
    }

    @Override
    @JsonProperty
    public Optional<SlackMessageSubtype> getSubtype() {
        return Optional.ofNullable(this.subtype);
    }

    @Override
    @JsonProperty
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    @JsonProperty
    public String getThreadTs() {
        return this.threadTs;
    }

    @Override
    @JsonProperty(value="user")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public int getReplyCount() {
        return this.replyCount;
    }

    @Override
    @JsonProperty(value="reply_users")
    public Optional<List<String>> getReplyUserIds() {
        return Optional.ofNullable(this.replyUserIds);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getReplyUsersCount() {
        return Optional.ofNullable(this.replyUsersCount);
    }

    @Override
    @JsonProperty(value="latest_reply")
    public Optional<String> getLatestReplyTimestamp() {
        return Optional.ofNullable(this.latestReplyTimestamp);
    }

    public final SlackReplyMessage withType(SlackEventType value) {
        SlackEventType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new SlackReplyMessage(newValue, this.ts, this.subtype, this.attachments, this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final SlackReplyMessage withTs(String value) {
        String newValue = Objects.requireNonNull(value, "ts");
        if (this.ts.equals(newValue)) {
            return this;
        }
        return new SlackReplyMessage(this.type, newValue, this.subtype, this.attachments, this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final SlackReplyMessage withSubtype(@Nullable SlackMessageSubtype value) {
        SlackMessageSubtype newValue = value;
        if (this.subtype == newValue) {
            return this;
        }
        return new SlackReplyMessage(this.type, this.ts, newValue, this.attachments, this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final SlackReplyMessage withSubtype(Optional<? extends SlackMessageSubtype> optional) {
        SlackMessageSubtype value = optional.orElse(null);
        if (this.subtype == value) {
            return this;
        }
        return new SlackReplyMessage(this.type, this.ts, value, this.attachments, this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final SlackReplyMessage withAttachments(Attachment ... elements) {
        List<Attachment> newValue = SlackReplyMessage.createUnmodifiableList(false, SlackReplyMessage.createSafeList(Arrays.asList(elements), true, false));
        return new SlackReplyMessage(this.type, this.ts, this.subtype, newValue, this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final SlackReplyMessage withAttachments(Iterable<? extends Attachment> elements) {
        if (this.attachments == elements) {
            return this;
        }
        List<Attachment> newValue = SlackReplyMessage.createUnmodifiableList(false, SlackReplyMessage.createSafeList(elements, true, false));
        return new SlackReplyMessage(this.type, this.ts, this.subtype, newValue, this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final SlackReplyMessage withThreadTs(String value) {
        String newValue = Objects.requireNonNull(value, "threadTs");
        if (this.threadTs.equals(newValue)) {
            return this;
        }
        return new SlackReplyMessage(this.type, this.ts, this.subtype, this.attachments, newValue, this.userId, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final SlackReplyMessage withUserId(String value) {
        String newValue = Objects.requireNonNull(value, "userId");
        if (this.userId.equals(newValue)) {
            return this;
        }
        return new SlackReplyMessage(this.type, this.ts, this.subtype, this.attachments, this.threadTs, newValue, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final SlackReplyMessage withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new SlackReplyMessage(this.type, this.ts, this.subtype, this.attachments, this.threadTs, this.userId, newValue, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final SlackReplyMessage withReplyCount(int value) {
        if (this.replyCount == value) {
            return this;
        }
        return new SlackReplyMessage(this.type, this.ts, this.subtype, this.attachments, this.threadTs, this.userId, this.channelId, value, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final SlackReplyMessage withReplyUserIds(@Nullable List<String> value) {
        List<String> newValue = value;
        if (this.replyUserIds == newValue) {
            return this;
        }
        return new SlackReplyMessage(this.type, this.ts, this.subtype, this.attachments, this.threadTs, this.userId, this.channelId, this.replyCount, newValue, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final SlackReplyMessage withReplyUserIds(Optional<? extends List<String>> optional) {
        List value = optional.orElse(null);
        if (this.replyUserIds == value) {
            return this;
        }
        return new SlackReplyMessage(this.type, this.ts, this.subtype, this.attachments, this.threadTs, this.userId, this.channelId, this.replyCount, value, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final SlackReplyMessage withReplyUsersCount(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.replyUsersCount, newValue)) {
            return this;
        }
        return new SlackReplyMessage(this.type, this.ts, this.subtype, this.attachments, this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, newValue, this.latestReplyTimestamp);
    }

    public final SlackReplyMessage withReplyUsersCount(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.replyUsersCount, value)) {
            return this;
        }
        return new SlackReplyMessage(this.type, this.ts, this.subtype, this.attachments, this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, value, this.latestReplyTimestamp);
    }

    public final SlackReplyMessage withLatestReplyTimestamp(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.latestReplyTimestamp, newValue)) {
            return this;
        }
        return new SlackReplyMessage(this.type, this.ts, this.subtype, this.attachments, this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, newValue);
    }

    public final SlackReplyMessage withLatestReplyTimestamp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.latestReplyTimestamp, value)) {
            return this;
        }
        return new SlackReplyMessage(this.type, this.ts, this.subtype, this.attachments, this.threadTs, this.userId, this.channelId, this.replyCount, this.replyUserIds, this.replyUsersCount, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackReplyMessage && this.equalTo(0, (SlackReplyMessage)another);
    }

    private boolean equalTo(int synthetic, SlackReplyMessage another) {
        return this.type.equals((Object)another.type) && this.ts.equals(another.ts) && Objects.equals((Object)this.subtype, (Object)another.subtype) && this.attachments.equals(another.attachments) && this.threadTs.equals(another.threadTs) && this.userId.equals(another.userId) && this.channelId.equals(another.channelId) && this.replyCount == another.replyCount && Objects.equals(this.replyUserIds, another.replyUserIds) && Objects.equals(this.replyUsersCount, another.replyUsersCount) && Objects.equals(this.latestReplyTimestamp, another.latestReplyTimestamp);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.ts.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.subtype);
        h += (h << 5) + this.attachments.hashCode();
        h += (h << 5) + this.threadTs.hashCode();
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.replyCount;
        h += (h << 5) + Objects.hashCode(this.replyUserIds);
        h += (h << 5) + Objects.hashCode(this.replyUsersCount);
        h += (h << 5) + Objects.hashCode(this.latestReplyTimestamp);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackReplyMessage{");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("ts=").append(this.ts);
        if (this.subtype != null) {
            builder.append(", ");
            builder.append("subtype=").append((Object)this.subtype);
        }
        builder.append(", ");
        builder.append("attachments=").append(this.attachments);
        builder.append(", ");
        builder.append("threadTs=").append(this.threadTs);
        builder.append(", ");
        builder.append("userId=").append(this.userId);
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("replyCount=").append(this.replyCount);
        if (this.replyUserIds != null) {
            builder.append(", ");
            builder.append("replyUserIds=").append(this.replyUserIds);
        }
        if (this.replyUsersCount != null) {
            builder.append(", ");
            builder.append("replyUsersCount=").append(this.replyUsersCount);
        }
        if (this.latestReplyTimestamp != null) {
            builder.append(", ");
            builder.append("latestReplyTimestamp=").append(this.latestReplyTimestamp);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackReplyMessage fromJson(Json json) {
        Builder builder = SlackReplyMessage.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.ts != null) {
            builder.setTs(json.ts);
        }
        if (json.subtype != null) {
            builder.setSubtype(json.subtype);
        }
        if (json.attachments != null) {
            builder.addAllAttachments(json.attachments);
        }
        if (json.threadTs != null) {
            builder.setThreadTs(json.threadTs);
        }
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.replyCountIsSet) {
            builder.setReplyCount(json.replyCount);
        }
        if (json.replyUserIds != null) {
            builder.setReplyUserIds(json.replyUserIds);
        }
        if (json.replyUsersCount != null) {
            builder.setReplyUsersCount(json.replyUsersCount);
        }
        if (json.latestReplyTimestamp != null) {
            builder.setLatestReplyTimestamp(json.latestReplyTimestamp);
        }
        return builder.build();
    }

    public static SlackReplyMessage copyOf(AbstractSlackReplyMessage instance) {
        if (instance instanceof SlackReplyMessage) {
            return (SlackReplyMessage)instance;
        }
        return SlackReplyMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AbstractSlackReplyMessage", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_TS = 2L;
        private static final long INIT_BIT_THREAD_TS = 4L;
        private static final long INIT_BIT_USER_ID = 8L;
        private static final long INIT_BIT_CHANNEL_ID = 16L;
        private static final long OPT_BIT_REPLY_COUNT = 1L;
        private long initBits = 31L;
        private long optBits;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String ts;
        @Nullable
        private SlackMessageSubtype subtype;
        private List<Attachment> attachments = new ArrayList<Attachment>();
        @Nullable
        private String threadTs;
        @Nullable
        private String userId;
        @Nullable
        private String channelId;
        private int replyCount;
        @Nullable
        private List<String> replyUserIds;
        @Nullable
        private Integer replyUsersCount;
        @Nullable
        private String latestReplyTimestamp;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEventMessageBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(HasUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractSlackReplyMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 0x10L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 0x10L;
                }
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setTs(instance.getTs());
                    bits |= 0x20L;
                }
            }
            if (object instanceof SlackEventMessageBase) {
                instance = (SlackEventMessageBase)object;
                if ((bits & 1L) == 0L) {
                    this.addAllAttachments(((SlackEventMessageBase)instance).getAttachments());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    Optional<SlackMessageSubtype> subtypeOptional = ((SlackEventMessageBase)instance).getSubtype();
                    if (subtypeOptional.isPresent()) {
                        this.setSubtype(subtypeOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setTs(instance.getTs());
                    bits |= 0x20L;
                }
            }
            if (object instanceof HasUser) {
                instance = (HasUser)object;
                if ((bits & 4L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 4L;
                }
            }
            if (object instanceof AbstractSlackReplyMessage) {
                Optional<String> latestReplyTimestampOptional;
                Optional<List<String>> replyUserIdsOptional;
                Optional<Integer> replyUsersCountOptional;
                instance = (AbstractSlackReplyMessage)object;
                this.setReplyCount(((AbstractSlackReplyMessage)instance).getReplyCount());
                if ((bits & 1L) == 0L) {
                    this.addAllAttachments(((SlackEventMessageBase)instance).getAttachments());
                    bits |= 1L;
                }
                if ((replyUsersCountOptional = ((AbstractSlackReplyMessage)instance).getReplyUsersCount()).isPresent()) {
                    this.setReplyUsersCount(replyUsersCountOptional);
                }
                if ((replyUserIdsOptional = ((AbstractSlackReplyMessage)instance).getReplyUserIds()).isPresent()) {
                    this.setReplyUserIds(replyUserIdsOptional);
                }
                if ((bits & 8L) == 0L) {
                    Optional<SlackMessageSubtype> subtypeOptional = ((SlackEventMessageBase)instance).getSubtype();
                    if (subtypeOptional.isPresent()) {
                        this.setSubtype(subtypeOptional);
                    }
                    bits |= 8L;
                }
                if ((latestReplyTimestampOptional = ((AbstractSlackReplyMessage)instance).getLatestReplyTimestamp()).isPresent()) {
                    this.setLatestReplyTimestamp(latestReplyTimestampOptional);
                }
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
                this.setThreadTs(((AbstractSlackReplyMessage)instance).getThreadTs());
                if ((bits & 4L) == 0L) {
                    this.setUserId(((AbstractSlackReplyMessage)instance).getUserId());
                    bits |= 4L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.setChannelId(((AbstractSlackReplyMessage)instance).getChannelId());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setTs(instance.getTs());
                    bits |= 0x20L;
                }
            }
        }

        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setTs(String ts) {
            this.ts = Objects.requireNonNull(ts, "ts");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setSubtype(@Nullable SlackMessageSubtype subtype) {
            this.subtype = subtype;
            return this;
        }

        public final Builder setSubtype(Optional<? extends SlackMessageSubtype> subtype) {
            this.subtype = subtype.orElse(null);
            return this;
        }

        public final Builder addAttachments(Attachment element) {
            this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            return this;
        }

        public final Builder addAttachments(Attachment ... elements) {
            for (Attachment element : elements) {
                this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            }
            return this;
        }

        public final Builder setAttachments(Iterable<? extends Attachment> elements) {
            this.attachments.clear();
            return this.addAllAttachments(elements);
        }

        public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
            for (Attachment attachment : elements) {
                this.attachments.add(Objects.requireNonNull(attachment, "attachments element"));
            }
            return this;
        }

        public final Builder setThreadTs(String threadTs) {
            this.threadTs = Objects.requireNonNull(threadTs, "threadTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setReplyCount(int replyCount) {
            this.replyCount = replyCount;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setReplyUserIds(@Nullable List<String> replyUserIds) {
            this.replyUserIds = replyUserIds;
            return this;
        }

        public final Builder setReplyUserIds(Optional<? extends List<String>> replyUserIds) {
            this.replyUserIds = replyUserIds.orElse(null);
            return this;
        }

        public final Builder setReplyUsersCount(@Nullable Integer replyUsersCount) {
            this.replyUsersCount = replyUsersCount;
            return this;
        }

        public final Builder setReplyUsersCount(Optional<Integer> replyUsersCount) {
            this.replyUsersCount = replyUsersCount.orElse(null);
            return this;
        }

        public final Builder setLatestReplyTimestamp(@Nullable String latestReplyTimestamp) {
            this.latestReplyTimestamp = latestReplyTimestamp;
            return this;
        }

        public final Builder setLatestReplyTimestamp(Optional<String> latestReplyTimestamp) {
            this.latestReplyTimestamp = latestReplyTimestamp.orElse(null);
            return this;
        }

        public SlackReplyMessage build() {
            this.checkRequiredAttributes();
            return new SlackReplyMessage(this);
        }

        private boolean replyCountIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean tsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean threadTsIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean userIdIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.tsIsSet()) {
                attributes.add("ts");
            }
            if (!this.threadTsIsSet()) {
                attributes.add("threadTs");
            }
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            return "Cannot build SlackReplyMessage, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractSlackReplyMessage", generator="Immutables")
    static final class Json
    extends AbstractSlackReplyMessage {
        @Nullable
        SlackEventType type;
        @Nullable
        String ts;
        @Nullable
        Optional<SlackMessageSubtype> subtype = Optional.empty();
        @Nullable
        List<Attachment> attachments = Collections.emptyList();
        @Nullable
        String threadTs;
        @Nullable
        String userId;
        @Nullable
        String channelId;
        int replyCount;
        boolean replyCountIsSet;
        @Nullable
        Optional<List<String>> replyUserIds = Optional.empty();
        @Nullable
        Optional<Integer> replyUsersCount = Optional.empty();
        @Nullable
        Optional<String> latestReplyTimestamp = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty
        public void setTs(String ts) {
            this.ts = ts;
        }

        @JsonProperty
        public void setSubtype(Optional<SlackMessageSubtype> subtype) {
            this.subtype = subtype;
        }

        @JsonProperty
        public void setAttachments(List<Attachment> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty
        public void setThreadTs(String threadTs) {
            this.threadTs = threadTs;
        }

        @JsonProperty(value="user")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setReplyCount(int replyCount) {
            this.replyCount = replyCount;
            this.replyCountIsSet = true;
        }

        @JsonProperty(value="reply_users")
        public void setReplyUserIds(Optional<List<String>> replyUserIds) {
            this.replyUserIds = replyUserIds;
        }

        @JsonProperty
        public void setReplyUsersCount(Optional<Integer> replyUsersCount) {
            this.replyUsersCount = replyUsersCount;
        }

        @JsonProperty(value="latest_reply")
        public void setLatestReplyTimestamp(Optional<String> latestReplyTimestamp) {
            this.latestReplyTimestamp = latestReplyTimestamp;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SlackMessageSubtype> getSubtype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Attachment> getAttachments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getThreadTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getReplyCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<String>> getReplyUserIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getReplyUsersCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getLatestReplyTimestamp() {
            throw new UnsupportedOperationException();
        }
    }
}

