/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.user;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.models.ChannelType;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.user.SlackMemberJoinedChannelEventIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackMemberJoinedChannelEventIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackMemberJoinedChannelEvent
implements SlackMemberJoinedChannelEventIF {
    private final SlackEventType type;
    private final String userId;
    private final String channelId;
    private final ChannelType channelType;
    private final String team;
    @Nullable
    private final String inviterId;

    private SlackMemberJoinedChannelEvent(SlackEventType type, String userId, String channelId, ChannelType channelType, String team, @Nullable String inviterId) {
        this.type = type;
        this.userId = userId;
        this.channelId = channelId;
        this.channelType = channelType;
        this.team = team;
        this.inviterId = inviterId;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="user")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public ChannelType getChannelType() {
        return this.channelType;
    }

    @Override
    @JsonProperty
    public String getTeam() {
        return this.team;
    }

    @Override
    @JsonProperty(value="inviter")
    public Optional<String> getInviterId() {
        return Optional.ofNullable(this.inviterId);
    }

    public final SlackMemberJoinedChannelEvent withType(SlackEventType value) {
        SlackEventType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new SlackMemberJoinedChannelEvent(newValue, this.userId, this.channelId, this.channelType, this.team, this.inviterId);
    }

    public final SlackMemberJoinedChannelEvent withUserId(String value) {
        String newValue = Objects.requireNonNull(value, "userId");
        if (this.userId.equals(newValue)) {
            return this;
        }
        return new SlackMemberJoinedChannelEvent(this.type, newValue, this.channelId, this.channelType, this.team, this.inviterId);
    }

    public final SlackMemberJoinedChannelEvent withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new SlackMemberJoinedChannelEvent(this.type, this.userId, newValue, this.channelType, this.team, this.inviterId);
    }

    public final SlackMemberJoinedChannelEvent withChannelType(ChannelType value) {
        ChannelType newValue = Objects.requireNonNull(value, "channelType");
        if (this.channelType == newValue) {
            return this;
        }
        return new SlackMemberJoinedChannelEvent(this.type, this.userId, this.channelId, newValue, this.team, this.inviterId);
    }

    public final SlackMemberJoinedChannelEvent withTeam(String value) {
        String newValue = Objects.requireNonNull(value, "team");
        if (this.team.equals(newValue)) {
            return this;
        }
        return new SlackMemberJoinedChannelEvent(this.type, this.userId, this.channelId, this.channelType, newValue, this.inviterId);
    }

    public final SlackMemberJoinedChannelEvent withInviterId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.inviterId, newValue)) {
            return this;
        }
        return new SlackMemberJoinedChannelEvent(this.type, this.userId, this.channelId, this.channelType, this.team, newValue);
    }

    public final SlackMemberJoinedChannelEvent withInviterId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.inviterId, value)) {
            return this;
        }
        return new SlackMemberJoinedChannelEvent(this.type, this.userId, this.channelId, this.channelType, this.team, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackMemberJoinedChannelEvent && this.equalTo(0, (SlackMemberJoinedChannelEvent)another);
    }

    private boolean equalTo(int synthetic, SlackMemberJoinedChannelEvent another) {
        return this.type.equals((Object)another.type) && this.userId.equals(another.userId) && this.channelId.equals(another.channelId) && this.channelType.equals((Object)another.channelType) && this.team.equals(another.team) && Objects.equals(this.inviterId, another.inviterId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.channelType.hashCode();
        h += (h << 5) + this.team.hashCode();
        h += (h << 5) + Objects.hashCode(this.inviterId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackMemberJoinedChannelEvent{");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("userId=").append(this.userId);
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("channelType=").append((Object)this.channelType);
        builder.append(", ");
        builder.append("team=").append(this.team);
        if (this.inviterId != null) {
            builder.append(", ");
            builder.append("inviterId=").append(this.inviterId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackMemberJoinedChannelEvent fromJson(Json json) {
        Builder builder = SlackMemberJoinedChannelEvent.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.channelType != null) {
            builder.setChannelType(json.channelType);
        }
        if (json.team != null) {
            builder.setTeam(json.team);
        }
        if (json.inviterId != null) {
            builder.setInviterId(json.inviterId);
        }
        return builder.build();
    }

    public static SlackMemberJoinedChannelEvent copyOf(SlackMemberJoinedChannelEventIF instance) {
        if (instance instanceof SlackMemberJoinedChannelEvent) {
            return (SlackMemberJoinedChannelEvent)instance;
        }
        return SlackMemberJoinedChannelEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SlackMemberJoinedChannelEventIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long INIT_BIT_CHANNEL_ID = 4L;
        private static final long INIT_BIT_CHANNEL_TYPE = 8L;
        private static final long INIT_BIT_TEAM = 16L;
        private long initBits = 31L;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String userId;
        @Nullable
        private String channelId;
        @Nullable
        private ChannelType channelType;
        @Nullable
        private String team;
        @Nullable
        private String inviterId;

        private Builder() {
        }

        public final Builder from(SlackMemberJoinedChannelEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof SlackMemberJoinedChannelEventIF) {
                instance = (SlackMemberJoinedChannelEventIF)object;
                this.setChannelType(instance.getChannelType());
                this.setTeam(instance.getTeam());
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                this.setUserId(instance.getUserId());
                Optional<String> inviterIdOptional = instance.getInviterId();
                if (inviterIdOptional.isPresent()) {
                    this.setInviterId(inviterIdOptional);
                }
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
            }
        }

        @JsonProperty
        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="user")
        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="channel")
        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty
        public final Builder setChannelType(ChannelType channelType) {
            this.channelType = Objects.requireNonNull(channelType, "channelType");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty
        public final Builder setTeam(String team) {
            this.team = Objects.requireNonNull(team, "team");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setInviterId(@Nullable String inviterId) {
            this.inviterId = inviterId;
            return this;
        }

        @JsonProperty(value="inviter")
        public final Builder setInviterId(Optional<String> inviterId) {
            this.inviterId = inviterId.orElse(null);
            return this;
        }

        public SlackMemberJoinedChannelEvent build() {
            this.checkRequiredAttributes();
            return new SlackMemberJoinedChannelEvent(this.type, this.userId, this.channelId, this.channelType, this.team, this.inviterId);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean userIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean channelTypeIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean teamIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.channelTypeIsSet()) {
                attributes.add("channelType");
            }
            if (!this.teamIsSet()) {
                attributes.add("team");
            }
            return "Cannot build SlackMemberJoinedChannelEvent, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackMemberJoinedChannelEventIF", generator="Immutables")
    static final class Json
    implements SlackMemberJoinedChannelEventIF {
        @Nullable
        SlackEventType type;
        @Nullable
        String userId;
        @Nullable
        String channelId;
        @Nullable
        ChannelType channelType;
        @Nullable
        String team;
        @Nullable
        Optional<String> inviterId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty(value="user")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setChannelType(ChannelType channelType) {
            this.channelType = channelType;
        }

        @JsonProperty
        public void setTeam(String team) {
            this.team = team;
        }

        @JsonProperty(value="inviter")
        public void setInviterId(Optional<String> inviterId) {
            this.inviterId = inviterId;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelType getChannelType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTeam() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getInviterId() {
            throw new UnsupportedOperationException();
        }
    }
}

