/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.links;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.chat.workobject.ExternalRef;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.links.EntityDetailsRequestedEventIF;
import com.hubspot.slack.client.models.events.links.Link;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="EntityDetailsRequestedEventIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class EntityDetailsRequestedEvent
implements EntityDetailsRequestedEventIF {
    private final SlackEventType type;
    private final String userId;
    @Nullable
    private final String channelId;
    private final ExternalRef externalRef;
    private final String entityUrl;
    private final Link link;
    private final String appUnfurlUrl;
    private final String eventTs;
    private final String triggerId;
    private final String userLocale;
    @Nullable
    private final String messageTs;
    @Nullable
    private final String threadTs;

    private EntityDetailsRequestedEvent(SlackEventType type, String userId, @Nullable String channelId, ExternalRef externalRef, String entityUrl, Link link, String appUnfurlUrl, String eventTs, String triggerId, String userLocale, @Nullable String messageTs, @Nullable String threadTs) {
        this.type = type;
        this.userId = userId;
        this.channelId = channelId;
        this.externalRef = externalRef;
        this.entityUrl = entityUrl;
        this.link = link;
        this.appUnfurlUrl = appUnfurlUrl;
        this.eventTs = eventTs;
        this.triggerId = triggerId;
        this.userLocale = userLocale;
        this.messageTs = messageTs;
        this.threadTs = threadTs;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="user")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="channel")
    public Optional<String> getChannelId() {
        return Optional.ofNullable(this.channelId);
    }

    @Override
    @JsonProperty
    public ExternalRef getExternalRef() {
        return this.externalRef;
    }

    @Override
    @JsonProperty
    public String getEntityUrl() {
        return this.entityUrl;
    }

    @Override
    @JsonProperty
    public Link getLink() {
        return this.link;
    }

    @Override
    @JsonProperty
    public String getAppUnfurlUrl() {
        return this.appUnfurlUrl;
    }

    @Override
    @JsonProperty
    public String getEventTs() {
        return this.eventTs;
    }

    @Override
    @JsonProperty
    public String getTriggerId() {
        return this.triggerId;
    }

    @Override
    @JsonProperty
    public String getUserLocale() {
        return this.userLocale;
    }

    @Override
    @JsonProperty
    public Optional<String> getMessageTs() {
        return Optional.ofNullable(this.messageTs);
    }

    @Override
    @JsonProperty
    public Optional<String> getThreadTs() {
        return Optional.ofNullable(this.threadTs);
    }

    public final EntityDetailsRequestedEvent withType(SlackEventType value) {
        SlackEventType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new EntityDetailsRequestedEvent(newValue, this.userId, this.channelId, this.externalRef, this.entityUrl, this.link, this.appUnfurlUrl, this.eventTs, this.triggerId, this.userLocale, this.messageTs, this.threadTs);
    }

    public final EntityDetailsRequestedEvent withUserId(String value) {
        String newValue = Objects.requireNonNull(value, "userId");
        if (this.userId.equals(newValue)) {
            return this;
        }
        return new EntityDetailsRequestedEvent(this.type, newValue, this.channelId, this.externalRef, this.entityUrl, this.link, this.appUnfurlUrl, this.eventTs, this.triggerId, this.userLocale, this.messageTs, this.threadTs);
    }

    public final EntityDetailsRequestedEvent withChannelId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.channelId, newValue)) {
            return this;
        }
        return new EntityDetailsRequestedEvent(this.type, this.userId, newValue, this.externalRef, this.entityUrl, this.link, this.appUnfurlUrl, this.eventTs, this.triggerId, this.userLocale, this.messageTs, this.threadTs);
    }

    public final EntityDetailsRequestedEvent withChannelId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.channelId, value)) {
            return this;
        }
        return new EntityDetailsRequestedEvent(this.type, this.userId, value, this.externalRef, this.entityUrl, this.link, this.appUnfurlUrl, this.eventTs, this.triggerId, this.userLocale, this.messageTs, this.threadTs);
    }

    public final EntityDetailsRequestedEvent withExternalRef(ExternalRef value) {
        if (this.externalRef == value) {
            return this;
        }
        ExternalRef newValue = Objects.requireNonNull(value, "externalRef");
        return new EntityDetailsRequestedEvent(this.type, this.userId, this.channelId, newValue, this.entityUrl, this.link, this.appUnfurlUrl, this.eventTs, this.triggerId, this.userLocale, this.messageTs, this.threadTs);
    }

    public final EntityDetailsRequestedEvent withEntityUrl(String value) {
        String newValue = Objects.requireNonNull(value, "entityUrl");
        if (this.entityUrl.equals(newValue)) {
            return this;
        }
        return new EntityDetailsRequestedEvent(this.type, this.userId, this.channelId, this.externalRef, newValue, this.link, this.appUnfurlUrl, this.eventTs, this.triggerId, this.userLocale, this.messageTs, this.threadTs);
    }

    public final EntityDetailsRequestedEvent withLink(Link value) {
        if (this.link == value) {
            return this;
        }
        Link newValue = Objects.requireNonNull(value, "link");
        return new EntityDetailsRequestedEvent(this.type, this.userId, this.channelId, this.externalRef, this.entityUrl, newValue, this.appUnfurlUrl, this.eventTs, this.triggerId, this.userLocale, this.messageTs, this.threadTs);
    }

    public final EntityDetailsRequestedEvent withAppUnfurlUrl(String value) {
        String newValue = Objects.requireNonNull(value, "appUnfurlUrl");
        if (this.appUnfurlUrl.equals(newValue)) {
            return this;
        }
        return new EntityDetailsRequestedEvent(this.type, this.userId, this.channelId, this.externalRef, this.entityUrl, this.link, newValue, this.eventTs, this.triggerId, this.userLocale, this.messageTs, this.threadTs);
    }

    public final EntityDetailsRequestedEvent withEventTs(String value) {
        String newValue = Objects.requireNonNull(value, "eventTs");
        if (this.eventTs.equals(newValue)) {
            return this;
        }
        return new EntityDetailsRequestedEvent(this.type, this.userId, this.channelId, this.externalRef, this.entityUrl, this.link, this.appUnfurlUrl, newValue, this.triggerId, this.userLocale, this.messageTs, this.threadTs);
    }

    public final EntityDetailsRequestedEvent withTriggerId(String value) {
        String newValue = Objects.requireNonNull(value, "triggerId");
        if (this.triggerId.equals(newValue)) {
            return this;
        }
        return new EntityDetailsRequestedEvent(this.type, this.userId, this.channelId, this.externalRef, this.entityUrl, this.link, this.appUnfurlUrl, this.eventTs, newValue, this.userLocale, this.messageTs, this.threadTs);
    }

    public final EntityDetailsRequestedEvent withUserLocale(String value) {
        String newValue = Objects.requireNonNull(value, "userLocale");
        if (this.userLocale.equals(newValue)) {
            return this;
        }
        return new EntityDetailsRequestedEvent(this.type, this.userId, this.channelId, this.externalRef, this.entityUrl, this.link, this.appUnfurlUrl, this.eventTs, this.triggerId, newValue, this.messageTs, this.threadTs);
    }

    public final EntityDetailsRequestedEvent withMessageTs(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.messageTs, newValue)) {
            return this;
        }
        return new EntityDetailsRequestedEvent(this.type, this.userId, this.channelId, this.externalRef, this.entityUrl, this.link, this.appUnfurlUrl, this.eventTs, this.triggerId, this.userLocale, newValue, this.threadTs);
    }

    public final EntityDetailsRequestedEvent withMessageTs(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.messageTs, value)) {
            return this;
        }
        return new EntityDetailsRequestedEvent(this.type, this.userId, this.channelId, this.externalRef, this.entityUrl, this.link, this.appUnfurlUrl, this.eventTs, this.triggerId, this.userLocale, value, this.threadTs);
    }

    public final EntityDetailsRequestedEvent withThreadTs(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.threadTs, newValue)) {
            return this;
        }
        return new EntityDetailsRequestedEvent(this.type, this.userId, this.channelId, this.externalRef, this.entityUrl, this.link, this.appUnfurlUrl, this.eventTs, this.triggerId, this.userLocale, this.messageTs, newValue);
    }

    public final EntityDetailsRequestedEvent withThreadTs(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.threadTs, value)) {
            return this;
        }
        return new EntityDetailsRequestedEvent(this.type, this.userId, this.channelId, this.externalRef, this.entityUrl, this.link, this.appUnfurlUrl, this.eventTs, this.triggerId, this.userLocale, this.messageTs, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof EntityDetailsRequestedEvent && this.equalTo(0, (EntityDetailsRequestedEvent)another);
    }

    private boolean equalTo(int synthetic, EntityDetailsRequestedEvent another) {
        return this.type.equals((Object)another.type) && this.userId.equals(another.userId) && Objects.equals(this.channelId, another.channelId) && this.externalRef.equals(another.externalRef) && this.entityUrl.equals(another.entityUrl) && this.link.equals(another.link) && this.appUnfurlUrl.equals(another.appUnfurlUrl) && this.eventTs.equals(another.eventTs) && this.triggerId.equals(another.triggerId) && this.userLocale.equals(another.userLocale) && Objects.equals(this.messageTs, another.messageTs) && Objects.equals(this.threadTs, another.threadTs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + Objects.hashCode(this.channelId);
        h += (h << 5) + this.externalRef.hashCode();
        h += (h << 5) + this.entityUrl.hashCode();
        h += (h << 5) + this.link.hashCode();
        h += (h << 5) + this.appUnfurlUrl.hashCode();
        h += (h << 5) + this.eventTs.hashCode();
        h += (h << 5) + this.triggerId.hashCode();
        h += (h << 5) + this.userLocale.hashCode();
        h += (h << 5) + Objects.hashCode(this.messageTs);
        h += (h << 5) + Objects.hashCode(this.threadTs);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("EntityDetailsRequestedEvent{");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("userId=").append(this.userId);
        if (this.channelId != null) {
            builder.append(", ");
            builder.append("channelId=").append(this.channelId);
        }
        builder.append(", ");
        builder.append("externalRef=").append(this.externalRef);
        builder.append(", ");
        builder.append("entityUrl=").append(this.entityUrl);
        builder.append(", ");
        builder.append("link=").append(this.link);
        builder.append(", ");
        builder.append("appUnfurlUrl=").append(this.appUnfurlUrl);
        builder.append(", ");
        builder.append("eventTs=").append(this.eventTs);
        builder.append(", ");
        builder.append("triggerId=").append(this.triggerId);
        builder.append(", ");
        builder.append("userLocale=").append(this.userLocale);
        if (this.messageTs != null) {
            builder.append(", ");
            builder.append("messageTs=").append(this.messageTs);
        }
        if (this.threadTs != null) {
            builder.append(", ");
            builder.append("threadTs=").append(this.threadTs);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static EntityDetailsRequestedEvent fromJson(Json json) {
        Builder builder = EntityDetailsRequestedEvent.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.externalRef != null) {
            builder.setExternalRef(json.externalRef);
        }
        if (json.entityUrl != null) {
            builder.setEntityUrl(json.entityUrl);
        }
        if (json.link != null) {
            builder.setLink(json.link);
        }
        if (json.appUnfurlUrl != null) {
            builder.setAppUnfurlUrl(json.appUnfurlUrl);
        }
        if (json.eventTs != null) {
            builder.setEventTs(json.eventTs);
        }
        if (json.triggerId != null) {
            builder.setTriggerId(json.triggerId);
        }
        if (json.userLocale != null) {
            builder.setUserLocale(json.userLocale);
        }
        if (json.messageTs != null) {
            builder.setMessageTs(json.messageTs);
        }
        if (json.threadTs != null) {
            builder.setThreadTs(json.threadTs);
        }
        return builder.build();
    }

    public static EntityDetailsRequestedEvent copyOf(EntityDetailsRequestedEventIF instance) {
        if (instance instanceof EntityDetailsRequestedEvent) {
            return (EntityDetailsRequestedEvent)instance;
        }
        return EntityDetailsRequestedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EntityDetailsRequestedEventIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long INIT_BIT_EXTERNAL_REF = 4L;
        private static final long INIT_BIT_ENTITY_URL = 8L;
        private static final long INIT_BIT_LINK = 16L;
        private static final long INIT_BIT_APP_UNFURL_URL = 32L;
        private static final long INIT_BIT_EVENT_TS = 64L;
        private static final long INIT_BIT_TRIGGER_ID = 128L;
        private static final long INIT_BIT_USER_LOCALE = 256L;
        private long initBits = 511L;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String userId;
        @Nullable
        private String channelId;
        @Nullable
        private ExternalRef externalRef;
        @Nullable
        private String entityUrl;
        @Nullable
        private Link link;
        @Nullable
        private String appUnfurlUrl;
        @Nullable
        private String eventTs;
        @Nullable
        private String triggerId;
        @Nullable
        private String userLocale;
        @Nullable
        private String messageTs;
        @Nullable
        private String threadTs;

        private Builder() {
        }

        public final Builder from(EntityDetailsRequestedEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            SlackEvent instance;
            long bits = 0L;
            if (object instanceof EntityDetailsRequestedEventIF) {
                Optional<String> channelIdOptional;
                Optional<String> threadTsOptional;
                instance = (EntityDetailsRequestedEventIF)object;
                this.setUserLocale(instance.getUserLocale());
                this.setTriggerId(instance.getTriggerId());
                this.setEntityUrl(instance.getEntityUrl());
                this.setLink(instance.getLink());
                this.setAppUnfurlUrl(instance.getAppUnfurlUrl());
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((threadTsOptional = instance.getThreadTs()).isPresent()) {
                    this.setThreadTs(threadTsOptional);
                }
                this.setUserId(instance.getUserId());
                this.setExternalRef(instance.getExternalRef());
                this.setEventTs(instance.getEventTs());
                Optional<String> messageTsOptional = instance.getMessageTs();
                if (messageTsOptional.isPresent()) {
                    this.setMessageTs(messageTsOptional);
                }
                if ((channelIdOptional = instance.getChannelId()).isPresent()) {
                    this.setChannelId(channelIdOptional);
                }
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
            }
        }

        @JsonProperty
        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="user")
        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setChannelId(@Nullable String channelId) {
            this.channelId = channelId;
            return this;
        }

        @JsonProperty(value="channel")
        public final Builder setChannelId(Optional<String> channelId) {
            this.channelId = channelId.orElse(null);
            return this;
        }

        @JsonProperty
        public final Builder setExternalRef(ExternalRef externalRef) {
            this.externalRef = Objects.requireNonNull(externalRef, "externalRef");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty
        public final Builder setEntityUrl(String entityUrl) {
            this.entityUrl = Objects.requireNonNull(entityUrl, "entityUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty
        public final Builder setLink(Link link) {
            this.link = Objects.requireNonNull(link, "link");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty
        public final Builder setAppUnfurlUrl(String appUnfurlUrl) {
            this.appUnfurlUrl = Objects.requireNonNull(appUnfurlUrl, "appUnfurlUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty
        public final Builder setEventTs(String eventTs) {
            this.eventTs = Objects.requireNonNull(eventTs, "eventTs");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty
        public final Builder setTriggerId(String triggerId) {
            this.triggerId = Objects.requireNonNull(triggerId, "triggerId");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty
        public final Builder setUserLocale(String userLocale) {
            this.userLocale = Objects.requireNonNull(userLocale, "userLocale");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder setMessageTs(@Nullable String messageTs) {
            this.messageTs = messageTs;
            return this;
        }

        @JsonProperty
        public final Builder setMessageTs(Optional<String> messageTs) {
            this.messageTs = messageTs.orElse(null);
            return this;
        }

        public final Builder setThreadTs(@Nullable String threadTs) {
            this.threadTs = threadTs;
            return this;
        }

        @JsonProperty
        public final Builder setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs.orElse(null);
            return this;
        }

        public EntityDetailsRequestedEvent build() {
            this.checkRequiredAttributes();
            return new EntityDetailsRequestedEvent(this.type, this.userId, this.channelId, this.externalRef, this.entityUrl, this.link, this.appUnfurlUrl, this.eventTs, this.triggerId, this.userLocale, this.messageTs, this.threadTs);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean userIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean externalRefIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean entityUrlIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean linkIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean appUnfurlUrlIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean eventTsIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private boolean triggerIdIsSet() {
            return (this.initBits & 0x80L) == 0L;
        }

        private boolean userLocaleIsSet() {
            return (this.initBits & 0x100L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            if (!this.externalRefIsSet()) {
                attributes.add("externalRef");
            }
            if (!this.entityUrlIsSet()) {
                attributes.add("entityUrl");
            }
            if (!this.linkIsSet()) {
                attributes.add("link");
            }
            if (!this.appUnfurlUrlIsSet()) {
                attributes.add("appUnfurlUrl");
            }
            if (!this.eventTsIsSet()) {
                attributes.add("eventTs");
            }
            if (!this.triggerIdIsSet()) {
                attributes.add("triggerId");
            }
            if (!this.userLocaleIsSet()) {
                attributes.add("userLocale");
            }
            return "Cannot build EntityDetailsRequestedEvent, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="EntityDetailsRequestedEventIF", generator="Immutables")
    static final class Json
    implements EntityDetailsRequestedEventIF {
        @Nullable
        SlackEventType type;
        @Nullable
        String userId;
        @Nullable
        Optional<String> channelId = Optional.empty();
        @Nullable
        ExternalRef externalRef;
        @Nullable
        String entityUrl;
        @Nullable
        Link link;
        @Nullable
        String appUnfurlUrl;
        @Nullable
        String eventTs;
        @Nullable
        String triggerId;
        @Nullable
        String userLocale;
        @Nullable
        Optional<String> messageTs = Optional.empty();
        @Nullable
        Optional<String> threadTs = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty(value="user")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="channel")
        public void setChannelId(Optional<String> channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setExternalRef(ExternalRef externalRef) {
            this.externalRef = externalRef;
        }

        @JsonProperty
        public void setEntityUrl(String entityUrl) {
            this.entityUrl = entityUrl;
        }

        @JsonProperty
        public void setLink(Link link) {
            this.link = link;
        }

        @JsonProperty
        public void setAppUnfurlUrl(String appUnfurlUrl) {
            this.appUnfurlUrl = appUnfurlUrl;
        }

        @JsonProperty
        public void setEventTs(String eventTs) {
            this.eventTs = eventTs;
        }

        @JsonProperty
        public void setTriggerId(String triggerId) {
            this.triggerId = triggerId;
        }

        @JsonProperty
        public void setUserLocale(String userLocale) {
            this.userLocale = userLocale;
        }

        @JsonProperty
        public void setMessageTs(Optional<String> messageTs) {
            this.messageTs = messageTs;
        }

        @JsonProperty
        public void setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ExternalRef getExternalRef() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEntityUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Link getLink() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAppUnfurlUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEventTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTriggerId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserLocale() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getMessageTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThreadTs() {
            throw new UnsupportedOperationException();
        }
    }
}

