/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.group;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.conversation.SlackConversationEventCore;
import com.hubspot.slack.client.models.events.conversation.SlackConversationEventWithChannel;
import com.hubspot.slack.client.models.events.group.SlackGroupRenameEventIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackGroupRenameEventIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackGroupRenameEvent
implements SlackGroupRenameEventIF {
    private final SlackEventType type;
    private final SlackChannel channel;
    private final transient String channelId;

    private SlackGroupRenameEvent(SlackEventType type, SlackChannel channel) {
        this.type = type;
        this.channel = channel;
        this.channelId = Objects.requireNonNull(SlackGroupRenameEventIF.super.getChannelId(), "channelId");
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public SlackChannel getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public String getChannelId() {
        return this.channelId;
    }

    public final SlackGroupRenameEvent withType(SlackEventType value) {
        SlackEventType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new SlackGroupRenameEvent(newValue, this.channel);
    }

    public final SlackGroupRenameEvent withChannel(SlackChannel value) {
        if (this.channel == value) {
            return this;
        }
        SlackChannel newValue = Objects.requireNonNull(value, "channel");
        return new SlackGroupRenameEvent(this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackGroupRenameEvent && this.equalTo(0, (SlackGroupRenameEvent)another);
    }

    private boolean equalTo(int synthetic, SlackGroupRenameEvent another) {
        return this.type.equals((Object)another.type) && this.channel.equals(another.channel) && this.channelId.equals(another.channelId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        return h;
    }

    public String toString() {
        return "SlackGroupRenameEvent{type=" + String.valueOf((Object)this.type) + ", channel=" + String.valueOf(this.channel) + ", channelId=" + this.channelId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackGroupRenameEvent fromJson(Json json) {
        Builder builder = SlackGroupRenameEvent.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        return builder.build();
    }

    public static SlackGroupRenameEvent copyOf(SlackGroupRenameEventIF instance) {
        if (instance instanceof SlackGroupRenameEvent) {
            return (SlackGroupRenameEvent)instance;
        }
        return SlackGroupRenameEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SlackGroupRenameEventIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_CHANNEL = 2L;
        private long initBits = 3L;
        @Nullable
        private SlackEventType type;
        @Nullable
        private SlackChannel channel;

        private Builder() {
        }

        public final Builder from(SlackGroupRenameEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackConversationEventCore instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackConversationEventWithChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            SlackEvent instance;
            long bits = 0L;
            if (object instanceof SlackGroupRenameEventIF) {
                instance = (SlackGroupRenameEventIF)object;
                if ((bits & 1L) == 0L) {
                    this.setChannel(instance.getChannel());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
            }
            if (object instanceof SlackConversationEventCore) {
                instance = (SlackConversationEventCore)object;
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
            }
            if (object instanceof SlackConversationEventWithChannel) {
                instance = (SlackConversationEventWithChannel)object;
                if ((bits & 1L) == 0L) {
                    this.setChannel(instance.getChannel());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty
        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        public final Builder setChannel(SlackChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public SlackGroupRenameEvent build() {
            this.checkRequiredAttributes();
            return new SlackGroupRenameEvent(this.type, this.channel);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            return "Cannot build SlackGroupRenameEvent, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackGroupRenameEventIF", generator="Immutables")
    static final class Json
    implements SlackGroupRenameEventIF {
        @Nullable
        SlackEventType type;
        @Nullable
        SlackChannel channel;

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty
        public void setChannel(SlackChannel channel) {
            this.channel = channel;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackChannel getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }
    }
}

