/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.group;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.conversation.SlackConversationEventCore;
import com.hubspot.slack.client.models.events.group.SlackGroupDeletedEventIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackGroupDeletedEventIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackGroupDeletedEvent
implements SlackGroupDeletedEventIF {
    private final SlackEventType type;
    private final String channelId;

    private SlackGroupDeletedEvent(SlackEventType type, String channelId) {
        this.type = type;
        this.channelId = channelId;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    public final SlackGroupDeletedEvent withType(SlackEventType value) {
        SlackEventType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new SlackGroupDeletedEvent(newValue, this.channelId);
    }

    public final SlackGroupDeletedEvent withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new SlackGroupDeletedEvent(this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackGroupDeletedEvent && this.equalTo(0, (SlackGroupDeletedEvent)another);
    }

    private boolean equalTo(int synthetic, SlackGroupDeletedEvent another) {
        return this.type.equals((Object)another.type) && this.channelId.equals(another.channelId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        return h;
    }

    public String toString() {
        return "SlackGroupDeletedEvent{type=" + String.valueOf((Object)this.type) + ", channelId=" + this.channelId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackGroupDeletedEvent fromJson(Json json) {
        Builder builder = SlackGroupDeletedEvent.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        return builder.build();
    }

    public static SlackGroupDeletedEvent copyOf(SlackGroupDeletedEventIF instance) {
        if (instance instanceof SlackGroupDeletedEvent) {
            return (SlackGroupDeletedEvent)instance;
        }
        return SlackGroupDeletedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SlackGroupDeletedEventIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_CHANNEL_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String channelId;

        private Builder() {
        }

        public final Builder from(SlackConversationEventCore instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackGroupDeletedEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            SlackEvent instance;
            long bits = 0L;
            if (object instanceof SlackConversationEventCore) {
                instance = (SlackConversationEventCore)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
            }
            if (object instanceof SlackGroupDeletedEventIF) {
                instance = (SlackGroupDeletedEventIF)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty
        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="channel")
        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public SlackGroupDeletedEvent build() {
            this.checkRequiredAttributes();
            return new SlackGroupDeletedEvent(this.type, this.channelId);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            return "Cannot build SlackGroupDeletedEvent, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackGroupDeletedEventIF", generator="Immutables")
    static final class Json
    implements SlackGroupDeletedEventIF {
        @Nullable
        SlackEventType type;
        @Nullable
        String channelId;

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }
    }
}

