/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.channel;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.channel.SlackChannelSharedEventIF;
import com.hubspot.slack.client.models.events.conversation.SlackConversationEventCore;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackChannelSharedEventIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackChannelSharedEvent
implements SlackChannelSharedEventIF {
    private final SlackEventType type;
    private final String channelId;
    private final String connectedTeamId;

    private SlackChannelSharedEvent(SlackEventType type, String channelId, String connectedTeamId) {
        this.type = type;
        this.channelId = channelId;
        this.connectedTeamId = connectedTeamId;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty(value="connected_team_id")
    public String getConnectedTeamId() {
        return this.connectedTeamId;
    }

    public final SlackChannelSharedEvent withType(SlackEventType value) {
        SlackEventType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new SlackChannelSharedEvent(newValue, this.channelId, this.connectedTeamId);
    }

    public final SlackChannelSharedEvent withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new SlackChannelSharedEvent(this.type, newValue, this.connectedTeamId);
    }

    public final SlackChannelSharedEvent withConnectedTeamId(String value) {
        String newValue = Objects.requireNonNull(value, "connectedTeamId");
        if (this.connectedTeamId.equals(newValue)) {
            return this;
        }
        return new SlackChannelSharedEvent(this.type, this.channelId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackChannelSharedEvent && this.equalTo(0, (SlackChannelSharedEvent)another);
    }

    private boolean equalTo(int synthetic, SlackChannelSharedEvent another) {
        return this.type.equals((Object)another.type) && this.channelId.equals(another.channelId) && this.connectedTeamId.equals(another.connectedTeamId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.connectedTeamId.hashCode();
        return h;
    }

    public String toString() {
        return "SlackChannelSharedEvent{type=" + String.valueOf((Object)this.type) + ", channelId=" + this.channelId + ", connectedTeamId=" + this.connectedTeamId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackChannelSharedEvent fromJson(Json json) {
        Builder builder = SlackChannelSharedEvent.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.connectedTeamId != null) {
            builder.setConnectedTeamId(json.connectedTeamId);
        }
        return builder.build();
    }

    public static SlackChannelSharedEvent copyOf(SlackChannelSharedEventIF instance) {
        if (instance instanceof SlackChannelSharedEvent) {
            return (SlackChannelSharedEvent)instance;
        }
        return SlackChannelSharedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SlackChannelSharedEventIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_CHANNEL_ID = 2L;
        private static final long INIT_BIT_CONNECTED_TEAM_ID = 4L;
        private long initBits = 7L;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String channelId;
        @Nullable
        private String connectedTeamId;

        private Builder() {
        }

        public final Builder from(SlackConversationEventCore instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackChannelSharedEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            SlackEvent instance;
            long bits = 0L;
            if (object instanceof SlackConversationEventCore) {
                instance = (SlackConversationEventCore)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
            }
            if (object instanceof SlackChannelSharedEventIF) {
                instance = (SlackChannelSharedEventIF)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                this.setConnectedTeamId(instance.getConnectedTeamId());
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty
        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="channel")
        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="connected_team_id")
        public final Builder setConnectedTeamId(String connectedTeamId) {
            this.connectedTeamId = Objects.requireNonNull(connectedTeamId, "connectedTeamId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public SlackChannelSharedEvent build() {
            this.checkRequiredAttributes();
            return new SlackChannelSharedEvent(this.type, this.channelId, this.connectedTeamId);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean connectedTeamIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.connectedTeamIdIsSet()) {
                attributes.add("connectedTeamId");
            }
            return "Cannot build SlackChannelSharedEvent, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackChannelSharedEventIF", generator="Immutables")
    static final class Json
    implements SlackChannelSharedEventIF {
        @Nullable
        SlackEventType type;
        @Nullable
        String channelId;
        @Nullable
        String connectedTeamId;

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="connected_team_id")
        public void setConnectedTeamId(String connectedTeamId) {
            this.connectedTeamId = connectedTeamId;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getConnectedTeamId() {
            throw new UnsupportedOperationException();
        }
    }
}

