/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.channel;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.channel.SlackChannelDeletedEventIF;
import com.hubspot.slack.client.models.events.conversation.SlackConversationEventCore;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackChannelDeletedEventIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackChannelDeletedEvent
implements SlackChannelDeletedEventIF {
    private final SlackEventType type;
    private final String channelId;

    private SlackChannelDeletedEvent(SlackEventType type, String channelId) {
        this.type = type;
        this.channelId = channelId;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    public final SlackChannelDeletedEvent withType(SlackEventType value) {
        SlackEventType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new SlackChannelDeletedEvent(newValue, this.channelId);
    }

    public final SlackChannelDeletedEvent withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new SlackChannelDeletedEvent(this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackChannelDeletedEvent && this.equalTo(0, (SlackChannelDeletedEvent)another);
    }

    private boolean equalTo(int synthetic, SlackChannelDeletedEvent another) {
        return this.type.equals((Object)another.type) && this.channelId.equals(another.channelId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        return h;
    }

    public String toString() {
        return "SlackChannelDeletedEvent{type=" + String.valueOf((Object)this.type) + ", channelId=" + this.channelId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackChannelDeletedEvent fromJson(Json json) {
        Builder builder = SlackChannelDeletedEvent.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        return builder.build();
    }

    public static SlackChannelDeletedEvent copyOf(SlackChannelDeletedEventIF instance) {
        if (instance instanceof SlackChannelDeletedEvent) {
            return (SlackChannelDeletedEvent)instance;
        }
        return SlackChannelDeletedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SlackChannelDeletedEventIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_CHANNEL_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String channelId;

        private Builder() {
        }

        public final Builder from(SlackConversationEventCore instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackChannelDeletedEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            SlackEvent instance;
            long bits = 0L;
            if (object instanceof SlackConversationEventCore) {
                instance = (SlackConversationEventCore)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
            if (object instanceof SlackChannelDeletedEventIF) {
                instance = (SlackChannelDeletedEventIF)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
            }
        }

        @JsonProperty
        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="channel")
        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public SlackChannelDeletedEvent build() {
            this.checkRequiredAttributes();
            return new SlackChannelDeletedEvent(this.type, this.channelId);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            return "Cannot build SlackChannelDeletedEvent, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackChannelDeletedEventIF", generator="Immutables")
    static final class Json
    implements SlackChannelDeletedEventIF {
        @Nullable
        SlackEventType type;
        @Nullable
        String channelId;

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }
    }
}

