/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.assistant;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.assistant.SlackAssistantThreadContextChangedEventIF;
import com.hubspot.slack.client.models.response.assistant.AssistantThread;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackAssistantThreadContextChangedEventIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackAssistantThreadContextChangedEvent
implements SlackAssistantThreadContextChangedEventIF {
    private final SlackEventType type;
    private final AssistantThread assistantThread;
    private final String eventTs;

    private SlackAssistantThreadContextChangedEvent(SlackEventType type, AssistantThread assistantThread, String eventTs) {
        this.type = type;
        this.assistantThread = assistantThread;
        this.eventTs = eventTs;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public AssistantThread getAssistantThread() {
        return this.assistantThread;
    }

    @Override
    @JsonProperty
    public String getEventTs() {
        return this.eventTs;
    }

    public final SlackAssistantThreadContextChangedEvent withType(SlackEventType value) {
        SlackEventType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new SlackAssistantThreadContextChangedEvent(newValue, this.assistantThread, this.eventTs);
    }

    public final SlackAssistantThreadContextChangedEvent withAssistantThread(AssistantThread value) {
        if (this.assistantThread == value) {
            return this;
        }
        AssistantThread newValue = Objects.requireNonNull(value, "assistantThread");
        return new SlackAssistantThreadContextChangedEvent(this.type, newValue, this.eventTs);
    }

    public final SlackAssistantThreadContextChangedEvent withEventTs(String value) {
        String newValue = Objects.requireNonNull(value, "eventTs");
        if (this.eventTs.equals(newValue)) {
            return this;
        }
        return new SlackAssistantThreadContextChangedEvent(this.type, this.assistantThread, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackAssistantThreadContextChangedEvent && this.equalTo(0, (SlackAssistantThreadContextChangedEvent)another);
    }

    private boolean equalTo(int synthetic, SlackAssistantThreadContextChangedEvent another) {
        return this.type.equals((Object)another.type) && this.assistantThread.equals(another.assistantThread) && this.eventTs.equals(another.eventTs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.assistantThread.hashCode();
        h += (h << 5) + this.eventTs.hashCode();
        return h;
    }

    public String toString() {
        return "SlackAssistantThreadContextChangedEvent{type=" + String.valueOf((Object)this.type) + ", assistantThread=" + String.valueOf(this.assistantThread) + ", eventTs=" + this.eventTs + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackAssistantThreadContextChangedEvent fromJson(Json json) {
        Builder builder = SlackAssistantThreadContextChangedEvent.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.assistantThread != null) {
            builder.setAssistantThread(json.assistantThread);
        }
        if (json.eventTs != null) {
            builder.setEventTs(json.eventTs);
        }
        return builder.build();
    }

    public static SlackAssistantThreadContextChangedEvent copyOf(SlackAssistantThreadContextChangedEventIF instance) {
        if (instance instanceof SlackAssistantThreadContextChangedEvent) {
            return (SlackAssistantThreadContextChangedEvent)instance;
        }
        return SlackAssistantThreadContextChangedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SlackAssistantThreadContextChangedEventIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_ASSISTANT_THREAD = 2L;
        private static final long INIT_BIT_EVENT_TS = 4L;
        private long initBits = 7L;
        @Nullable
        private SlackEventType type;
        @Nullable
        private AssistantThread assistantThread;
        @Nullable
        private String eventTs;

        private Builder() {
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackAssistantThreadContextChangedEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            SlackEvent instance;
            long bits = 0L;
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
            }
            if (object instanceof SlackAssistantThreadContextChangedEventIF) {
                instance = (SlackAssistantThreadContextChangedEventIF)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                this.setAssistantThread(instance.getAssistantThread());
                this.setEventTs(instance.getEventTs());
            }
        }

        @JsonProperty
        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        public final Builder setAssistantThread(AssistantThread assistantThread) {
            this.assistantThread = Objects.requireNonNull(assistantThread, "assistantThread");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        public final Builder setEventTs(String eventTs) {
            this.eventTs = Objects.requireNonNull(eventTs, "eventTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public SlackAssistantThreadContextChangedEvent build() {
            this.checkRequiredAttributes();
            return new SlackAssistantThreadContextChangedEvent(this.type, this.assistantThread, this.eventTs);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean assistantThreadIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean eventTsIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.assistantThreadIsSet()) {
                attributes.add("assistantThread");
            }
            if (!this.eventTsIsSet()) {
                attributes.add("eventTs");
            }
            return "Cannot build SlackAssistantThreadContextChangedEvent, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackAssistantThreadContextChangedEventIF", generator="Immutables")
    static final class Json
    implements SlackAssistantThreadContextChangedEventIF {
        @Nullable
        SlackEventType type;
        @Nullable
        AssistantThread assistantThread;
        @Nullable
        String eventTs;

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty
        public void setAssistantThread(AssistantThread assistantThread) {
            this.assistantThread = assistantThread;
        }

        @JsonProperty
        public void setEventTs(String eventTs) {
            this.eventTs = eventTs;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AssistantThread getAssistantThread() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEventTs() {
            throw new UnsupportedOperationException();
        }
    }
}

