/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventSkeletonIF;
import com.hubspot.slack.client.models.events.SlackEventType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackEventSkeletonIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackEventSkeleton
implements SlackEventSkeletonIF {
    private final SlackEventType type;
    private final String ts;
    @Nullable
    private final String channelMaybe;

    private SlackEventSkeleton(SlackEventType type, String ts, @Nullable String channelMaybe) {
        this.type = type;
        this.ts = ts;
        this.channelMaybe = channelMaybe;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getTs() {
        return this.ts;
    }

    @Override
    @JsonProperty(value="channel")
    public Optional<String> getChannelMaybe() {
        return Optional.ofNullable(this.channelMaybe);
    }

    public final SlackEventSkeleton withType(SlackEventType value) {
        SlackEventType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new SlackEventSkeleton(newValue, this.ts, this.channelMaybe);
    }

    public final SlackEventSkeleton withTs(String value) {
        String newValue = Objects.requireNonNull(value, "ts");
        if (this.ts.equals(newValue)) {
            return this;
        }
        return new SlackEventSkeleton(this.type, newValue, this.channelMaybe);
    }

    public final SlackEventSkeleton withChannelMaybe(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.channelMaybe, newValue)) {
            return this;
        }
        return new SlackEventSkeleton(this.type, this.ts, newValue);
    }

    public final SlackEventSkeleton withChannelMaybe(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.channelMaybe, value)) {
            return this;
        }
        return new SlackEventSkeleton(this.type, this.ts, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackEventSkeleton && this.equalTo(0, (SlackEventSkeleton)another);
    }

    private boolean equalTo(int synthetic, SlackEventSkeleton another) {
        return this.type.equals((Object)another.type) && this.ts.equals(another.ts) && Objects.equals(this.channelMaybe, another.channelMaybe);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.ts.hashCode();
        h += (h << 5) + Objects.hashCode(this.channelMaybe);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackEventSkeleton{");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("ts=").append(this.ts);
        if (this.channelMaybe != null) {
            builder.append(", ");
            builder.append("channelMaybe=").append(this.channelMaybe);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackEventSkeleton fromJson(Json json) {
        Builder builder = SlackEventSkeleton.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.ts != null) {
            builder.setTs(json.ts);
        }
        if (json.channelMaybe != null) {
            builder.setChannelMaybe(json.channelMaybe);
        }
        return builder.build();
    }

    public static SlackEventSkeleton copyOf(SlackEventSkeletonIF instance) {
        if (instance instanceof SlackEventSkeleton) {
            return (SlackEventSkeleton)instance;
        }
        return SlackEventSkeleton.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SlackEventSkeletonIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_TS = 2L;
        private long initBits = 3L;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String ts;
        @Nullable
        private String channelMaybe;

        private Builder() {
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEventSkeletonIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            SlackEvent instance;
            long bits = 0L;
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setTs(instance.getTs());
                    bits |= 2L;
                }
            }
            if (object instanceof SlackEventSkeletonIF) {
                Optional<String> channelMaybeOptional;
                instance = (SlackEventSkeletonIF)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((channelMaybeOptional = instance.getChannelMaybe()).isPresent()) {
                    this.setChannelMaybe(channelMaybeOptional);
                }
                if ((bits & 2L) == 0L) {
                    this.setTs(instance.getTs());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty
        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        public final Builder setTs(String ts) {
            this.ts = Objects.requireNonNull(ts, "ts");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setChannelMaybe(@Nullable String channelMaybe) {
            this.channelMaybe = channelMaybe;
            return this;
        }

        @JsonProperty(value="channel")
        public final Builder setChannelMaybe(Optional<String> channelMaybe) {
            this.channelMaybe = channelMaybe.orElse(null);
            return this;
        }

        public SlackEventSkeleton build() {
            this.checkRequiredAttributes();
            return new SlackEventSkeleton(this.type, this.ts, this.channelMaybe);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean tsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.tsIsSet()) {
                attributes.add("ts");
            }
            return "Cannot build SlackEventSkeleton, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackEventSkeletonIF", generator="Immutables")
    static final class Json
    implements SlackEventSkeletonIF {
        @Nullable
        SlackEventType type;
        @Nullable
        String ts;
        @Nullable
        Optional<String> channelMaybe = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty
        public void setTs(String ts) {
            this.ts = ts;
        }

        @JsonProperty(value="channel")
        public void setChannelMaybe(Optional<String> channelMaybe) {
            this.channelMaybe = channelMaybe;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getChannelMaybe() {
            throw new UnsupportedOperationException();
        }
    }
}

