/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.interceptor.HasUser;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.events.AbstractSlackEventMessage;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventMessageBase;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.SlackMessageSubtype;
import com.hubspot.slack.client.models.files.SlackFile;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AbstractSlackEventMessage", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackEventMessage
extends AbstractSlackEventMessage {
    private final SlackEventType type;
    private final String ts;
    @Nullable
    private final SlackMessageSubtype subtype;
    private final List<Attachment> attachments;
    private final String channelId;
    @Nullable
    private final String threadTs;
    @Nullable
    private final String botId;
    private final String userId;
    private final String text;
    private final List<SlackFile> files;

    private SlackEventMessage(SlackEventType type, String ts, @Nullable SlackMessageSubtype subtype, List<Attachment> attachments, String channelId, @Nullable String threadTs, @Nullable String botId, String userId, String text, List<SlackFile> files) {
        this.type = type;
        this.ts = ts;
        this.subtype = subtype;
        this.attachments = attachments;
        this.channelId = channelId;
        this.threadTs = threadTs;
        this.botId = botId;
        this.userId = userId;
        this.text = text;
        this.files = files;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getTs() {
        return this.ts;
    }

    @Override
    @JsonProperty
    public Optional<SlackMessageSubtype> getSubtype() {
        return Optional.ofNullable(this.subtype);
    }

    @Override
    @JsonProperty
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public Optional<String> getThreadTs() {
        return Optional.ofNullable(this.threadTs);
    }

    @Override
    @JsonProperty
    public Optional<String> getBotId() {
        return Optional.ofNullable(this.botId);
    }

    @Override
    @JsonProperty(value="user")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty
    public String getText() {
        return this.text;
    }

    @Override
    @JsonProperty
    public List<SlackFile> getFiles() {
        return this.files;
    }

    public final SlackEventMessage withType(SlackEventType value) {
        SlackEventType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new SlackEventMessage(newValue, this.ts, this.subtype, this.attachments, this.channelId, this.threadTs, this.botId, this.userId, this.text, this.files);
    }

    public final SlackEventMessage withTs(String value) {
        String newValue = Objects.requireNonNull(value, "ts");
        if (this.ts.equals(newValue)) {
            return this;
        }
        return new SlackEventMessage(this.type, newValue, this.subtype, this.attachments, this.channelId, this.threadTs, this.botId, this.userId, this.text, this.files);
    }

    public final SlackEventMessage withSubtype(@Nullable SlackMessageSubtype value) {
        SlackMessageSubtype newValue = value;
        if (this.subtype == newValue) {
            return this;
        }
        return new SlackEventMessage(this.type, this.ts, newValue, this.attachments, this.channelId, this.threadTs, this.botId, this.userId, this.text, this.files);
    }

    public final SlackEventMessage withSubtype(Optional<? extends SlackMessageSubtype> optional) {
        SlackMessageSubtype value = optional.orElse(null);
        if (this.subtype == value) {
            return this;
        }
        return new SlackEventMessage(this.type, this.ts, value, this.attachments, this.channelId, this.threadTs, this.botId, this.userId, this.text, this.files);
    }

    public final SlackEventMessage withAttachments(Attachment ... elements) {
        List<Attachment> newValue = SlackEventMessage.createUnmodifiableList(false, SlackEventMessage.createSafeList(Arrays.asList(elements), true, false));
        return new SlackEventMessage(this.type, this.ts, this.subtype, newValue, this.channelId, this.threadTs, this.botId, this.userId, this.text, this.files);
    }

    public final SlackEventMessage withAttachments(Iterable<? extends Attachment> elements) {
        if (this.attachments == elements) {
            return this;
        }
        List<Attachment> newValue = SlackEventMessage.createUnmodifiableList(false, SlackEventMessage.createSafeList(elements, true, false));
        return new SlackEventMessage(this.type, this.ts, this.subtype, newValue, this.channelId, this.threadTs, this.botId, this.userId, this.text, this.files);
    }

    public final SlackEventMessage withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new SlackEventMessage(this.type, this.ts, this.subtype, this.attachments, newValue, this.threadTs, this.botId, this.userId, this.text, this.files);
    }

    public final SlackEventMessage withThreadTs(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.threadTs, newValue)) {
            return this;
        }
        return new SlackEventMessage(this.type, this.ts, this.subtype, this.attachments, this.channelId, newValue, this.botId, this.userId, this.text, this.files);
    }

    public final SlackEventMessage withThreadTs(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.threadTs, value)) {
            return this;
        }
        return new SlackEventMessage(this.type, this.ts, this.subtype, this.attachments, this.channelId, value, this.botId, this.userId, this.text, this.files);
    }

    public final SlackEventMessage withBotId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.botId, newValue)) {
            return this;
        }
        return new SlackEventMessage(this.type, this.ts, this.subtype, this.attachments, this.channelId, this.threadTs, newValue, this.userId, this.text, this.files);
    }

    public final SlackEventMessage withBotId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.botId, value)) {
            return this;
        }
        return new SlackEventMessage(this.type, this.ts, this.subtype, this.attachments, this.channelId, this.threadTs, value, this.userId, this.text, this.files);
    }

    public final SlackEventMessage withUserId(String value) {
        String newValue = Objects.requireNonNull(value, "userId");
        if (this.userId.equals(newValue)) {
            return this;
        }
        return new SlackEventMessage(this.type, this.ts, this.subtype, this.attachments, this.channelId, this.threadTs, this.botId, newValue, this.text, this.files);
    }

    public final SlackEventMessage withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new SlackEventMessage(this.type, this.ts, this.subtype, this.attachments, this.channelId, this.threadTs, this.botId, this.userId, newValue, this.files);
    }

    public final SlackEventMessage withFiles(SlackFile ... elements) {
        List<SlackFile> newValue = SlackEventMessage.createUnmodifiableList(false, SlackEventMessage.createSafeList(Arrays.asList(elements), true, false));
        return new SlackEventMessage(this.type, this.ts, this.subtype, this.attachments, this.channelId, this.threadTs, this.botId, this.userId, this.text, newValue);
    }

    public final SlackEventMessage withFiles(Iterable<? extends SlackFile> elements) {
        if (this.files == elements) {
            return this;
        }
        List<SlackFile> newValue = SlackEventMessage.createUnmodifiableList(false, SlackEventMessage.createSafeList(elements, true, false));
        return new SlackEventMessage(this.type, this.ts, this.subtype, this.attachments, this.channelId, this.threadTs, this.botId, this.userId, this.text, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackEventMessage && this.equalTo(0, (SlackEventMessage)another);
    }

    private boolean equalTo(int synthetic, SlackEventMessage another) {
        return this.type.equals((Object)another.type) && this.ts.equals(another.ts) && Objects.equals((Object)this.subtype, (Object)another.subtype) && this.attachments.equals(another.attachments) && this.channelId.equals(another.channelId) && Objects.equals(this.threadTs, another.threadTs) && Objects.equals(this.botId, another.botId) && this.userId.equals(another.userId) && this.text.equals(another.text) && this.files.equals(another.files);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.ts.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.subtype);
        h += (h << 5) + this.attachments.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + Objects.hashCode(this.threadTs);
        h += (h << 5) + Objects.hashCode(this.botId);
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.files.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackEventMessage{");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("ts=").append(this.ts);
        if (this.subtype != null) {
            builder.append(", ");
            builder.append("subtype=").append((Object)this.subtype);
        }
        builder.append(", ");
        builder.append("attachments=").append(this.attachments);
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        if (this.threadTs != null) {
            builder.append(", ");
            builder.append("threadTs=").append(this.threadTs);
        }
        if (this.botId != null) {
            builder.append(", ");
            builder.append("botId=").append(this.botId);
        }
        builder.append(", ");
        builder.append("userId=").append(this.userId);
        builder.append(", ");
        builder.append("text=").append(this.text);
        builder.append(", ");
        builder.append("files=").append(this.files);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackEventMessage fromJson(Json json) {
        Builder builder = SlackEventMessage.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.ts != null) {
            builder.setTs(json.ts);
        }
        if (json.subtype != null) {
            builder.setSubtype(json.subtype);
        }
        if (json.attachments != null) {
            builder.addAllAttachments(json.attachments);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.threadTs != null) {
            builder.setThreadTs(json.threadTs);
        }
        if (json.botId != null) {
            builder.setBotId(json.botId);
        }
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.files != null) {
            builder.addAllFiles(json.files);
        }
        return builder.build();
    }

    public static SlackEventMessage copyOf(AbstractSlackEventMessage instance) {
        if (instance instanceof SlackEventMessage) {
            return (SlackEventMessage)instance;
        }
        return SlackEventMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AbstractSlackEventMessage", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_TS = 2L;
        private static final long INIT_BIT_CHANNEL_ID = 4L;
        private static final long INIT_BIT_USER_ID = 8L;
        private static final long INIT_BIT_TEXT = 16L;
        private long initBits = 31L;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String ts;
        @Nullable
        private SlackMessageSubtype subtype;
        private List<Attachment> attachments = new ArrayList<Attachment>();
        @Nullable
        private String channelId;
        @Nullable
        private String threadTs;
        @Nullable
        private String botId;
        @Nullable
        private String userId;
        @Nullable
        private String text;
        private List<SlackFile> files = new ArrayList<SlackFile>();

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEventMessageBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractSlackEventMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(HasUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<SlackMessageSubtype> subtypeOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 0x10L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 0x10L;
                }
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setTs(instance.getTs());
                    bits |= 0x20L;
                }
            }
            if (object instanceof SlackEventMessageBase) {
                instance = (SlackEventMessageBase)object;
                if ((bits & 1L) == 0L) {
                    this.addAllAttachments(((SlackEventMessageBase)instance).getAttachments());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    subtypeOptional = ((SlackEventMessageBase)instance).getSubtype();
                    if (subtypeOptional.isPresent()) {
                        this.setSubtype(subtypeOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setTs(instance.getTs());
                    bits |= 0x20L;
                }
            }
            if (object instanceof AbstractSlackEventMessage) {
                Optional<String> threadTsOptional;
                instance = (AbstractSlackEventMessage)object;
                if ((bits & 1L) == 0L) {
                    this.addAllAttachments(((SlackEventMessageBase)instance).getAttachments());
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    subtypeOptional = ((SlackEventMessageBase)instance).getSubtype();
                    if (subtypeOptional.isPresent()) {
                        this.setSubtype(subtypeOptional);
                    }
                    bits |= 8L;
                }
                this.addAllFiles(((AbstractSlackEventMessage)instance).getFiles());
                Optional<String> botIdOptional = ((AbstractSlackEventMessage)instance).getBotId();
                if (botIdOptional.isPresent()) {
                    this.setBotId(botIdOptional);
                }
                this.setText(((AbstractSlackEventMessage)instance).getText());
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
                if ((threadTsOptional = ((AbstractSlackEventMessage)instance).getThreadTs()).isPresent()) {
                    this.setThreadTs(threadTsOptional);
                }
                if ((bits & 4L) == 0L) {
                    this.setUserId(((AbstractSlackEventMessage)instance).getUserId());
                    bits |= 4L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.setChannelId(((AbstractSlackEventMessage)instance).getChannelId());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setTs(instance.getTs());
                    bits |= 0x20L;
                }
            }
            if (object instanceof HasUser) {
                instance = (HasUser)object;
                if ((bits & 4L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 4L;
                }
            }
        }

        @JsonProperty
        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        public final Builder setTs(String ts) {
            this.ts = Objects.requireNonNull(ts, "ts");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setSubtype(@Nullable SlackMessageSubtype subtype) {
            this.subtype = subtype;
            return this;
        }

        @JsonProperty
        public final Builder setSubtype(Optional<? extends SlackMessageSubtype> subtype) {
            this.subtype = subtype.orElse(null);
            return this;
        }

        public final Builder addAttachments(Attachment element) {
            this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            return this;
        }

        public final Builder addAttachments(Attachment ... elements) {
            for (Attachment element : elements) {
                this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            }
            return this;
        }

        @JsonProperty
        public final Builder setAttachments(Iterable<? extends Attachment> elements) {
            this.attachments.clear();
            return this.addAllAttachments(elements);
        }

        public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
            for (Attachment attachment : elements) {
                this.attachments.add(Objects.requireNonNull(attachment, "attachments element"));
            }
            return this;
        }

        @JsonProperty(value="channel")
        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setThreadTs(@Nullable String threadTs) {
            this.threadTs = threadTs;
            return this;
        }

        @JsonProperty
        public final Builder setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs.orElse(null);
            return this;
        }

        public final Builder setBotId(@Nullable String botId) {
            this.botId = botId;
            return this;
        }

        @JsonProperty
        public final Builder setBotId(Optional<String> botId) {
            this.botId = botId.orElse(null);
            return this;
        }

        @JsonProperty(value="user")
        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty
        public final Builder setText(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder addFiles(SlackFile element) {
            this.files.add(Objects.requireNonNull(element, "files element"));
            return this;
        }

        public final Builder addFiles(SlackFile ... elements) {
            for (SlackFile element : elements) {
                this.files.add(Objects.requireNonNull(element, "files element"));
            }
            return this;
        }

        @JsonProperty
        public final Builder setFiles(Iterable<? extends SlackFile> elements) {
            this.files.clear();
            return this.addAllFiles(elements);
        }

        public final Builder addAllFiles(Iterable<? extends SlackFile> elements) {
            for (SlackFile slackFile : elements) {
                this.files.add(Objects.requireNonNull(slackFile, "files element"));
            }
            return this;
        }

        public SlackEventMessage build() {
            this.checkRequiredAttributes();
            return new SlackEventMessage(this.type, this.ts, this.subtype, SlackEventMessage.createUnmodifiableList(true, this.attachments), this.channelId, this.threadTs, this.botId, this.userId, this.text, SlackEventMessage.createUnmodifiableList(true, this.files));
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean tsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean userIdIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean textIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.tsIsSet()) {
                attributes.add("ts");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            if (!this.textIsSet()) {
                attributes.add("text");
            }
            return "Cannot build SlackEventMessage, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractSlackEventMessage", generator="Immutables")
    static final class Json
    extends AbstractSlackEventMessage {
        @Nullable
        SlackEventType type;
        @Nullable
        String ts;
        @Nullable
        Optional<SlackMessageSubtype> subtype = Optional.empty();
        @Nullable
        List<Attachment> attachments = Collections.emptyList();
        @Nullable
        String channelId;
        @Nullable
        Optional<String> threadTs = Optional.empty();
        @Nullable
        Optional<String> botId = Optional.empty();
        @Nullable
        String userId;
        @Nullable
        String text;
        @Nullable
        List<SlackFile> files = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty
        public void setTs(String ts) {
            this.ts = ts;
        }

        @JsonProperty
        public void setSubtype(Optional<SlackMessageSubtype> subtype) {
            this.subtype = subtype;
        }

        @JsonProperty
        public void setAttachments(List<Attachment> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs;
        }

        @JsonProperty
        public void setBotId(Optional<String> botId) {
            this.botId = botId;
        }

        @JsonProperty(value="user")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty
        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty
        public void setFiles(List<SlackFile> files) {
            this.files = files;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SlackMessageSubtype> getSubtype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Attachment> getAttachments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThreadTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getBotId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SlackFile> getFiles() {
            throw new UnsupportedOperationException();
        }
    }
}

