/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.events.AbstractSlackEventBotMessage;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventMessageBase;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.SlackMessageSubtype;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AbstractSlackEventBotMessage", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackEventBotMessage
extends AbstractSlackEventBotMessage {
    private final SlackEventType type;
    private final String ts;
    @Nullable
    private final SlackMessageSubtype subtype;
    private final String channelId;
    @Nullable
    private final String threadTs;
    @Nullable
    private final String text;
    private final List<Attachment> attachments;
    private final String botId;
    private final List<Block> blocks;

    private SlackEventBotMessage(SlackEventType type, String ts, @Nullable SlackMessageSubtype subtype, String channelId, @Nullable String threadTs, @Nullable String text, List<Attachment> attachments, String botId, List<Block> blocks) {
        this.type = type;
        this.ts = ts;
        this.subtype = subtype;
        this.channelId = channelId;
        this.threadTs = threadTs;
        this.text = text;
        this.attachments = attachments;
        this.botId = botId;
        this.blocks = blocks;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getTs() {
        return this.ts;
    }

    @Override
    @JsonProperty
    public Optional<SlackMessageSubtype> getSubtype() {
        return Optional.ofNullable(this.subtype);
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public Optional<String> getThreadTs() {
        return Optional.ofNullable(this.threadTs);
    }

    @Override
    @JsonProperty
    public Optional<String> getText() {
        return Optional.ofNullable(this.text);
    }

    @Override
    @JsonProperty
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    @JsonProperty
    public String getBotId() {
        return this.botId;
    }

    @Override
    @JsonProperty
    public List<Block> getBlocks() {
        return this.blocks;
    }

    public final SlackEventBotMessage withType(SlackEventType value) {
        SlackEventType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new SlackEventBotMessage(newValue, this.ts, this.subtype, this.channelId, this.threadTs, this.text, this.attachments, this.botId, this.blocks);
    }

    public final SlackEventBotMessage withTs(String value) {
        String newValue = Objects.requireNonNull(value, "ts");
        if (this.ts.equals(newValue)) {
            return this;
        }
        return new SlackEventBotMessage(this.type, newValue, this.subtype, this.channelId, this.threadTs, this.text, this.attachments, this.botId, this.blocks);
    }

    public final SlackEventBotMessage withSubtype(@Nullable SlackMessageSubtype value) {
        SlackMessageSubtype newValue = value;
        if (this.subtype == newValue) {
            return this;
        }
        return new SlackEventBotMessage(this.type, this.ts, newValue, this.channelId, this.threadTs, this.text, this.attachments, this.botId, this.blocks);
    }

    public final SlackEventBotMessage withSubtype(Optional<? extends SlackMessageSubtype> optional) {
        SlackMessageSubtype value = optional.orElse(null);
        if (this.subtype == value) {
            return this;
        }
        return new SlackEventBotMessage(this.type, this.ts, value, this.channelId, this.threadTs, this.text, this.attachments, this.botId, this.blocks);
    }

    public final SlackEventBotMessage withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new SlackEventBotMessage(this.type, this.ts, this.subtype, newValue, this.threadTs, this.text, this.attachments, this.botId, this.blocks);
    }

    public final SlackEventBotMessage withThreadTs(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.threadTs, newValue)) {
            return this;
        }
        return new SlackEventBotMessage(this.type, this.ts, this.subtype, this.channelId, newValue, this.text, this.attachments, this.botId, this.blocks);
    }

    public final SlackEventBotMessage withThreadTs(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.threadTs, value)) {
            return this;
        }
        return new SlackEventBotMessage(this.type, this.ts, this.subtype, this.channelId, value, this.text, this.attachments, this.botId, this.blocks);
    }

    public final SlackEventBotMessage withText(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.text, newValue)) {
            return this;
        }
        return new SlackEventBotMessage(this.type, this.ts, this.subtype, this.channelId, this.threadTs, newValue, this.attachments, this.botId, this.blocks);
    }

    public final SlackEventBotMessage withText(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.text, value)) {
            return this;
        }
        return new SlackEventBotMessage(this.type, this.ts, this.subtype, this.channelId, this.threadTs, value, this.attachments, this.botId, this.blocks);
    }

    public final SlackEventBotMessage withAttachments(Attachment ... elements) {
        List<Attachment> newValue = SlackEventBotMessage.createUnmodifiableList(false, SlackEventBotMessage.createSafeList(Arrays.asList(elements), true, false));
        return new SlackEventBotMessage(this.type, this.ts, this.subtype, this.channelId, this.threadTs, this.text, newValue, this.botId, this.blocks);
    }

    public final SlackEventBotMessage withAttachments(Iterable<? extends Attachment> elements) {
        if (this.attachments == elements) {
            return this;
        }
        List<Attachment> newValue = SlackEventBotMessage.createUnmodifiableList(false, SlackEventBotMessage.createSafeList(elements, true, false));
        return new SlackEventBotMessage(this.type, this.ts, this.subtype, this.channelId, this.threadTs, this.text, newValue, this.botId, this.blocks);
    }

    public final SlackEventBotMessage withBotId(String value) {
        String newValue = Objects.requireNonNull(value, "botId");
        if (this.botId.equals(newValue)) {
            return this;
        }
        return new SlackEventBotMessage(this.type, this.ts, this.subtype, this.channelId, this.threadTs, this.text, this.attachments, newValue, this.blocks);
    }

    public final SlackEventBotMessage withBlocks(Block ... elements) {
        List<Block> newValue = SlackEventBotMessage.createUnmodifiableList(false, SlackEventBotMessage.createSafeList(Arrays.asList(elements), true, false));
        return new SlackEventBotMessage(this.type, this.ts, this.subtype, this.channelId, this.threadTs, this.text, this.attachments, this.botId, newValue);
    }

    public final SlackEventBotMessage withBlocks(Iterable<? extends Block> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<Block> newValue = SlackEventBotMessage.createUnmodifiableList(false, SlackEventBotMessage.createSafeList(elements, true, false));
        return new SlackEventBotMessage(this.type, this.ts, this.subtype, this.channelId, this.threadTs, this.text, this.attachments, this.botId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackEventBotMessage && this.equalTo(0, (SlackEventBotMessage)another);
    }

    private boolean equalTo(int synthetic, SlackEventBotMessage another) {
        return this.type.equals((Object)another.type) && this.ts.equals(another.ts) && Objects.equals((Object)this.subtype, (Object)another.subtype) && this.channelId.equals(another.channelId) && Objects.equals(this.threadTs, another.threadTs) && Objects.equals(this.text, another.text) && this.attachments.equals(another.attachments) && this.botId.equals(another.botId) && this.blocks.equals(another.blocks);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.ts.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.subtype);
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + Objects.hashCode(this.threadTs);
        h += (h << 5) + Objects.hashCode(this.text);
        h += (h << 5) + this.attachments.hashCode();
        h += (h << 5) + this.botId.hashCode();
        h += (h << 5) + this.blocks.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackEventBotMessage{");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("ts=").append(this.ts);
        if (this.subtype != null) {
            builder.append(", ");
            builder.append("subtype=").append((Object)this.subtype);
        }
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        if (this.threadTs != null) {
            builder.append(", ");
            builder.append("threadTs=").append(this.threadTs);
        }
        if (this.text != null) {
            builder.append(", ");
            builder.append("text=").append(this.text);
        }
        builder.append(", ");
        builder.append("attachments=").append(this.attachments);
        builder.append(", ");
        builder.append("botId=").append(this.botId);
        builder.append(", ");
        builder.append("blocks=").append(this.blocks);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackEventBotMessage fromJson(Json json) {
        Builder builder = SlackEventBotMessage.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.ts != null) {
            builder.setTs(json.ts);
        }
        if (json.subtype != null) {
            builder.setSubtype(json.subtype);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.threadTs != null) {
            builder.setThreadTs(json.threadTs);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.attachments != null) {
            builder.addAllAttachments(json.attachments);
        }
        if (json.botId != null) {
            builder.setBotId(json.botId);
        }
        if (json.blocks != null) {
            builder.addAllBlocks(json.blocks);
        }
        return builder.build();
    }

    public static SlackEventBotMessage copyOf(AbstractSlackEventBotMessage instance) {
        if (instance instanceof SlackEventBotMessage) {
            return (SlackEventBotMessage)instance;
        }
        return SlackEventBotMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AbstractSlackEventBotMessage", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_TS = 2L;
        private static final long INIT_BIT_CHANNEL_ID = 4L;
        private static final long INIT_BIT_BOT_ID = 8L;
        private long initBits = 15L;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String ts;
        @Nullable
        private SlackMessageSubtype subtype;
        @Nullable
        private String channelId;
        @Nullable
        private String threadTs;
        @Nullable
        private String text;
        private List<Attachment> attachments = new ArrayList<Attachment>();
        @Nullable
        private String botId;
        private List<Block> blocks = new ArrayList<Block>();

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEventMessageBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractSlackEventBotMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<SlackMessageSubtype> subtypeOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 8L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 8L;
                }
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.setTs(instance.getTs());
                    bits |= 0x10L;
                }
            }
            if (object instanceof SlackEventMessageBase) {
                instance = (SlackEventMessageBase)object;
                if ((bits & 1L) == 0L) {
                    this.addAllAttachments(((SlackEventMessageBase)instance).getAttachments());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    subtypeOptional = ((SlackEventMessageBase)instance).getSubtype();
                    if (subtypeOptional.isPresent()) {
                        this.setSubtype(subtypeOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.setTs(instance.getTs());
                    bits |= 0x10L;
                }
            }
            if (object instanceof AbstractSlackEventBotMessage) {
                Optional<String> threadTsOptional;
                instance = (AbstractSlackEventBotMessage)object;
                if ((bits & 1L) == 0L) {
                    this.addAllAttachments(((AbstractSlackEventBotMessage)instance).getAttachments());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    subtypeOptional = ((SlackEventMessageBase)instance).getSubtype();
                    if (subtypeOptional.isPresent()) {
                        this.setSubtype(subtypeOptional);
                    }
                    bits |= 4L;
                }
                this.addAllBlocks(((AbstractSlackEventBotMessage)instance).getBlocks());
                Optional<String> textOptional = ((AbstractSlackEventBotMessage)instance).getText();
                if (textOptional.isPresent()) {
                    this.setText(textOptional);
                }
                this.setBotId(((AbstractSlackEventBotMessage)instance).getBotId());
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
                if ((threadTsOptional = ((AbstractSlackEventBotMessage)instance).getThreadTs()).isPresent()) {
                    this.setThreadTs(threadTsOptional);
                }
                if ((bits & 8L) == 0L) {
                    this.setChannelId(((AbstractSlackEventBotMessage)instance).getChannelId());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.setTs(instance.getTs());
                    bits |= 0x10L;
                }
            }
        }

        @JsonProperty
        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        public final Builder setTs(String ts) {
            this.ts = Objects.requireNonNull(ts, "ts");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setSubtype(@Nullable SlackMessageSubtype subtype) {
            this.subtype = subtype;
            return this;
        }

        @JsonProperty
        public final Builder setSubtype(Optional<? extends SlackMessageSubtype> subtype) {
            this.subtype = subtype.orElse(null);
            return this;
        }

        @JsonProperty(value="channel")
        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setThreadTs(@Nullable String threadTs) {
            this.threadTs = threadTs;
            return this;
        }

        @JsonProperty
        public final Builder setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs.orElse(null);
            return this;
        }

        public final Builder setText(@Nullable String text) {
            this.text = text;
            return this;
        }

        @JsonProperty
        public final Builder setText(Optional<String> text) {
            this.text = text.orElse(null);
            return this;
        }

        public final Builder addAttachments(Attachment element) {
            this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            return this;
        }

        public final Builder addAttachments(Attachment ... elements) {
            for (Attachment element : elements) {
                this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            }
            return this;
        }

        @JsonProperty
        public final Builder setAttachments(Iterable<? extends Attachment> elements) {
            this.attachments.clear();
            return this.addAllAttachments(elements);
        }

        public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
            for (Attachment attachment : elements) {
                this.attachments.add(Objects.requireNonNull(attachment, "attachments element"));
            }
            return this;
        }

        @JsonProperty
        public final Builder setBotId(String botId) {
            this.botId = Objects.requireNonNull(botId, "botId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder addBlocks(Block element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            return this;
        }

        public final Builder addBlocks(Block ... elements) {
            for (Block element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            return this;
        }

        @JsonProperty
        public final Builder setBlocks(Iterable<? extends Block> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Builder addAllBlocks(Iterable<? extends Block> elements) {
            for (Block block : elements) {
                this.blocks.add(Objects.requireNonNull(block, "blocks element"));
            }
            return this;
        }

        public SlackEventBotMessage build() {
            this.checkRequiredAttributes();
            return new SlackEventBotMessage(this.type, this.ts, this.subtype, this.channelId, this.threadTs, this.text, SlackEventBotMessage.createUnmodifiableList(true, this.attachments), this.botId, SlackEventBotMessage.createUnmodifiableList(true, this.blocks));
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean tsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean botIdIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.tsIsSet()) {
                attributes.add("ts");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.botIdIsSet()) {
                attributes.add("botId");
            }
            return "Cannot build SlackEventBotMessage, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractSlackEventBotMessage", generator="Immutables")
    static final class Json
    extends AbstractSlackEventBotMessage {
        @Nullable
        SlackEventType type;
        @Nullable
        String ts;
        @Nullable
        Optional<SlackMessageSubtype> subtype = Optional.empty();
        @Nullable
        String channelId;
        @Nullable
        Optional<String> threadTs = Optional.empty();
        @Nullable
        Optional<String> text = Optional.empty();
        @Nullable
        List<Attachment> attachments = Collections.emptyList();
        @Nullable
        String botId;
        @Nullable
        List<Block> blocks = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty
        public void setTs(String ts) {
            this.ts = ts;
        }

        @JsonProperty
        public void setSubtype(Optional<SlackMessageSubtype> subtype) {
            this.subtype = subtype;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs;
        }

        @JsonProperty
        public void setText(Optional<String> text) {
            this.text = text;
        }

        @JsonProperty
        public void setAttachments(List<Attachment> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty
        public void setBotId(String botId) {
            this.botId = botId;
        }

        @JsonProperty
        public void setBlocks(List<Block> blocks) {
            this.blocks = blocks;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SlackMessageSubtype> getSubtype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThreadTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Attachment> getAttachments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBotId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Block> getBlocks() {
            throw new UnsupportedOperationException();
        }
    }
}

