/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.dialog.form.elements.helpers;

import com.google.common.collect.Iterables;
import com.hubspot.slack.client.models.dialog.form.elements.AbstractSlackDialogFormTextElement;
import com.hubspot.slack.client.models.dialog.form.elements.AbstractSlackFormSelectElement;
import com.hubspot.slack.client.models.dialog.form.elements.AbstractSlackFormTextElement;
import com.hubspot.slack.client.models.dialog.form.elements.AbstractSlackFormTextareaElement;
import com.hubspot.slack.client.models.dialog.form.elements.HasLabel;
import com.hubspot.slack.client.models.dialog.form.elements.HasOptions;
import com.hubspot.slack.client.models.dialog.form.elements.SlackDialogFormElement;
import com.hubspot.slack.client.models.dialog.form.elements.SlackDialogFormElementLengthLimits;
import com.hubspot.slack.client.models.dialog.form.elements.SlackFormOption;
import com.hubspot.slack.client.models.dialog.form.elements.SlackFormOptionGroup;
import com.hubspot.slack.client.models.dialog.form.elements.SlackFormOptionGroupIF;
import com.hubspot.slack.client.models.dialog.form.elements.SlackFormOptionIF;
import com.hubspot.slack.client.models.dialog.form.elements.SlackFormSelectElement;
import com.hubspot.slack.client.models.dialog.form.elements.SlackFormTextElement;
import com.hubspot.slack.client.models.dialog.form.elements.SlackFormTextareaElement;
import java.util.List;
import java.util.Optional;

public class SlackDialogElementNormalizer {
    private SlackDialogElementNormalizer() {
    }

    public static AbstractSlackFormTextElement normalize(AbstractSlackFormTextElement element) {
        if (SlackDialogElementNormalizer.shouldNormalizePlaceholder(element) || SlackDialogElementNormalizer.shouldNormalizeLabel(element, SlackDialogFormElementLengthLimits.MAX_LABEL_LENGTH) || SlackDialogElementNormalizer.shouldNormalize(element.getHint(), SlackDialogFormElementLengthLimits.MAX_HINT_LENGTH)) {
            return SlackFormTextElement.builder().from(element).setPlaceholder(SlackDialogElementNormalizer.normalizePlaceholder(element)).setLabel(SlackDialogElementNormalizer.normalizeLabel(element)).setHint(SlackDialogElementNormalizer.normalizeHint(element)).build();
        }
        return element;
    }

    public static AbstractSlackFormTextareaElement normalize(AbstractSlackFormTextareaElement element) {
        if (SlackDialogElementNormalizer.shouldNormalizePlaceholder(element) || SlackDialogElementNormalizer.shouldNormalizeLabel(element, SlackDialogFormElementLengthLimits.MAX_LABEL_LENGTH) || SlackDialogElementNormalizer.shouldNormalize(element.getHint(), SlackDialogFormElementLengthLimits.MAX_HINT_LENGTH)) {
            return SlackFormTextareaElement.builder().from(element).setPlaceholder(SlackDialogElementNormalizer.normalizePlaceholder(element)).setLabel(SlackDialogElementNormalizer.normalizeLabel(element)).setHint(SlackDialogElementNormalizer.normalizeHint(element)).build();
        }
        return element;
    }

    public static AbstractSlackFormSelectElement normalize(AbstractSlackFormSelectElement element) {
        if (SlackDialogElementNormalizer.shouldNormalizePlaceholder(element) || SlackDialogElementNormalizer.shouldNormalizeLabel(element, SlackDialogFormElementLengthLimits.MAX_LABEL_LENGTH) || SlackDialogElementNormalizer.shouldNormalize(element.getOptionGroups(), SlackDialogFormElementLengthLimits.MAX_OPTION_GROUPS_NUMBER) || SlackDialogElementNormalizer.shouldNormalizeOptions(element)) {
            return SlackFormSelectElement.builder().from(element).setPlaceholder(SlackDialogElementNormalizer.normalizePlaceholder(element)).setLabel(SlackDialogElementNormalizer.normalizeLabel(element)).setOptionGroups(SlackDialogElementNormalizer.normalizeOptionGroups(element)).setOptions(SlackDialogElementNormalizer.normalizeOptions(element)).build();
        }
        return element;
    }

    public static SlackFormOptionGroupIF normalize(SlackFormOptionGroupIF element) {
        if (SlackDialogElementNormalizer.shouldNormalizeLabel(element, SlackDialogFormElementLengthLimits.MAX_OPTION_LABEL_LENGTH) || SlackDialogElementNormalizer.shouldNormalizeOptions(element)) {
            return SlackFormOptionGroup.builder().from(element).setLabel(SlackDialogElementNormalizer.normalizeLabel(element)).setOptions(SlackDialogElementNormalizer.normalizeOptions(element)).build();
        }
        return element;
    }

    private static boolean shouldNormalizeOptions(HasOptions element) {
        return SlackDialogElementNormalizer.shouldNormalize(element.getOptions(), SlackDialogFormElementLengthLimits.MAX_OPTIONS_NUMBER);
    }

    public static SlackFormOptionIF normalize(SlackFormOptionIF element) {
        if (SlackDialogElementNormalizer.shouldNormalizeLabel(element, SlackDialogFormElementLengthLimits.MAX_OPTION_LABEL_LENGTH)) {
            return SlackFormOption.copyOf(element).withLabel(SlackDialogElementNormalizer.normalizeLabel(element));
        }
        return element;
    }

    private static boolean shouldNormalize(List listOfFormElements, SlackDialogFormElementLengthLimits maxListSize) {
        return listOfFormElements.size() > maxListSize.getLimit();
    }

    private static boolean shouldNormalizePlaceholder(SlackDialogFormElement element) {
        return SlackDialogElementNormalizer.shouldNormalize(element.getPlaceholder(), SlackDialogFormElementLengthLimits.MAX_PLACEHOLDER_LENGTH);
    }

    private static boolean shouldNormalizeLabel(HasLabel element, SlackDialogFormElementLengthLimits maxLabelLength) {
        return SlackDialogElementNormalizer.shouldNormalize(element.getLabel(), maxLabelLength);
    }

    private static boolean shouldNormalize(Optional<String> stringOptional, SlackDialogFormElementLengthLimits maxPlaceholderLength) {
        return stringOptional.isPresent() && SlackDialogElementNormalizer.shouldNormalize(stringOptional.get(), maxPlaceholderLength);
    }

    private static boolean shouldNormalize(String string, SlackDialogFormElementLengthLimits maxPlaceholderLength) {
        return string.length() > maxPlaceholderLength.getLimit();
    }

    private static String normalizeLabel(SlackFormOptionIF option) {
        return SlackDialogElementNormalizer.normalizeIfLongerThan(option.getLabel(), SlackDialogFormElementLengthLimits.MAX_OPTION_LABEL_LENGTH.getLimit());
    }

    private static String normalizeLabel(SlackFormOptionGroupIF optionGroup) {
        return SlackDialogElementNormalizer.normalizeIfLongerThan(optionGroup.getLabel(), SlackDialogFormElementLengthLimits.MAX_OPTION_LABEL_LENGTH.getLimit());
    }

    private static Iterable<SlackFormOptionGroup> normalizeOptionGroups(AbstractSlackFormSelectElement element) {
        return Iterables.limit(element.getOptionGroups(), (int)SlackDialogFormElementLengthLimits.MAX_OPTION_GROUPS_NUMBER.getLimit());
    }

    private static Iterable<SlackFormOption> normalizeOptions(AbstractSlackFormSelectElement element) {
        return Iterables.limit(element.getOptions(), (int)SlackDialogFormElementLengthLimits.MAX_OPTIONS_NUMBER.getLimit());
    }

    private static Iterable<SlackFormOption> normalizeOptions(SlackFormOptionGroupIF element) {
        return Iterables.limit(element.getOptions(), (int)SlackDialogFormElementLengthLimits.MAX_OPTIONS_NUMBER.getLimit());
    }

    private static String normalizeLabel(SlackDialogFormElement element) {
        return SlackDialogElementNormalizer.normalizeIfLongerThan(element.getLabel(), SlackDialogFormElementLengthLimits.MAX_LABEL_LENGTH.getLimit());
    }

    private static Optional<String> normalizePlaceholder(SlackDialogFormElement element) {
        return element.getPlaceholder().map(placeholder -> SlackDialogElementNormalizer.normalizeIfLongerThan(placeholder, SlackDialogFormElementLengthLimits.MAX_PLACEHOLDER_LENGTH.getLimit()));
    }

    private static Optional<String> normalizeHint(AbstractSlackDialogFormTextElement element) {
        return element.getHint().map(hint -> SlackDialogElementNormalizer.normalizeIfLongerThan(hint, SlackDialogFormElementLengthLimits.MAX_HINT_LENGTH.getLimit()));
    }

    private static String normalizeIfLongerThan(String label, int maxLength) {
        if (label.length() > maxLength) {
            String ellipsis = "...";
            int endIndex = maxLength - ellipsis.length() - 1;
            return label.substring(0, endIndex) + ellipsis;
        }
        return label;
    }
}

