/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.dialog.form.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.actions.SlackDataSource;
import com.hubspot.slack.client.models.dialog.form.SlackFormElementTypes;
import com.hubspot.slack.client.models.dialog.form.elements.AbstractSlackFormSelectElement;
import com.hubspot.slack.client.models.dialog.form.elements.HasLabel;
import com.hubspot.slack.client.models.dialog.form.elements.HasOptions;
import com.hubspot.slack.client.models.dialog.form.elements.SlackDialogFormElement;
import com.hubspot.slack.client.models.dialog.form.elements.SlackFormOption;
import com.hubspot.slack.client.models.dialog.form.elements.SlackFormOptionGroup;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AbstractSlackFormSelectElement", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackFormSelectElement
extends AbstractSlackFormSelectElement {
    private final List<SlackFormOption> options;
    private final String label;
    private final String name;
    @Nullable
    private final String placeholder;
    @Nullable
    private final Boolean optional;
    private final SlackFormElementTypes type;
    private final SlackDataSource dataSource;
    private final List<SlackFormOptionGroup> optionGroups;
    @Nullable
    private final String value;
    private final List<SlackFormOption> selectedOptions;
    @Nullable
    private final Integer minQueryLength;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SlackFormSelectElement(Builder builder) {
        this.options = SlackFormSelectElement.createUnmodifiableList(true, builder.options);
        this.label = builder.label;
        this.name = builder.name;
        this.placeholder = builder.placeholder;
        this.optional = builder.optional;
        this.optionGroups = SlackFormSelectElement.createUnmodifiableList(true, builder.optionGroups);
        this.value = builder.value;
        this.selectedOptions = SlackFormSelectElement.createUnmodifiableList(true, builder.selectedOptions);
        this.minQueryLength = builder.minQueryLength;
        if (builder.type != null) {
            this.initShim.setType(builder.type);
        }
        if (builder.dataSource != null) {
            this.initShim.setDataSource(builder.dataSource);
        }
        this.type = this.initShim.getType();
        this.dataSource = this.initShim.getDataSource();
        this.initShim = null;
    }

    private SlackFormSelectElement(List<SlackFormOption> options, String label, String name, @Nullable String placeholder, @Nullable Boolean optional, SlackFormElementTypes type, SlackDataSource dataSource, List<SlackFormOptionGroup> optionGroups, @Nullable String value, List<SlackFormOption> selectedOptions, @Nullable Integer minQueryLength) {
        this.options = options;
        this.label = label;
        this.name = name;
        this.placeholder = placeholder;
        this.optional = optional;
        this.type = type;
        this.dataSource = dataSource;
        this.optionGroups = optionGroups;
        this.value = value;
        this.selectedOptions = selectedOptions;
        this.minQueryLength = minQueryLength;
        this.initShim = null;
    }

    @Override
    @JsonProperty
    public List<SlackFormOption> getOptions() {
        return this.options;
    }

    @Override
    @JsonProperty
    public String getLabel() {
        return this.label;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public Optional<String> getPlaceholder() {
        return Optional.ofNullable(this.placeholder);
    }

    @Override
    @JsonProperty(value="optional")
    public Optional<Boolean> isOptional() {
        return Optional.ofNullable(this.optional);
    }

    @Override
    @JsonProperty
    public SlackFormElementTypes getType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getType() : this.type;
    }

    @Override
    @JsonProperty
    public SlackDataSource getDataSource() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDataSource() : this.dataSource;
    }

    @Override
    @JsonProperty
    public List<SlackFormOptionGroup> getOptionGroups() {
        return this.optionGroups;
    }

    @Override
    @JsonProperty
    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    @JsonProperty
    public List<SlackFormOption> getSelectedOptions() {
        return this.selectedOptions;
    }

    @Override
    @JsonProperty
    public Optional<Integer> getMinQueryLength() {
        return Optional.ofNullable(this.minQueryLength);
    }

    public final SlackFormSelectElement withOptions(SlackFormOption ... elements) {
        List<SlackFormOption> newValue = SlackFormSelectElement.createUnmodifiableList(false, SlackFormSelectElement.createSafeList(Arrays.asList(elements), true, false));
        return SlackFormSelectElement.validate(new SlackFormSelectElement(newValue, this.label, this.name, this.placeholder, this.optional, this.type, this.dataSource, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength));
    }

    public final SlackFormSelectElement withOptions(Iterable<? extends SlackFormOption> elements) {
        if (this.options == elements) {
            return this;
        }
        List<SlackFormOption> newValue = SlackFormSelectElement.createUnmodifiableList(false, SlackFormSelectElement.createSafeList(elements, true, false));
        return SlackFormSelectElement.validate(new SlackFormSelectElement(newValue, this.label, this.name, this.placeholder, this.optional, this.type, this.dataSource, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength));
    }

    public final SlackFormSelectElement withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (this.label.equals(newValue)) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.options, newValue, this.name, this.placeholder, this.optional, this.type, this.dataSource, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength));
    }

    public final SlackFormSelectElement withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.options, this.label, newValue, this.placeholder, this.optional, this.type, this.dataSource, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength));
    }

    public final SlackFormSelectElement withPlaceholder(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.placeholder, newValue)) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.options, this.label, this.name, newValue, this.optional, this.type, this.dataSource, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength));
    }

    public final SlackFormSelectElement withPlaceholder(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.placeholder, value)) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.options, this.label, this.name, value, this.optional, this.type, this.dataSource, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength));
    }

    public final SlackFormSelectElement withOptional(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.optional, newValue)) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.options, this.label, this.name, this.placeholder, newValue, this.type, this.dataSource, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength));
    }

    public final SlackFormSelectElement withOptional(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.optional, value)) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.options, this.label, this.name, this.placeholder, value, this.type, this.dataSource, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength));
    }

    public final SlackFormSelectElement withType(SlackFormElementTypes value) {
        SlackFormElementTypes newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.options, this.label, this.name, this.placeholder, this.optional, newValue, this.dataSource, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength));
    }

    public final SlackFormSelectElement withDataSource(SlackDataSource value) {
        SlackDataSource newValue = Objects.requireNonNull(value, "dataSource");
        if (this.dataSource == newValue) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.options, this.label, this.name, this.placeholder, this.optional, this.type, newValue, this.optionGroups, this.value, this.selectedOptions, this.minQueryLength));
    }

    public final SlackFormSelectElement withOptionGroups(SlackFormOptionGroup ... elements) {
        List<SlackFormOptionGroup> newValue = SlackFormSelectElement.createUnmodifiableList(false, SlackFormSelectElement.createSafeList(Arrays.asList(elements), true, false));
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.options, this.label, this.name, this.placeholder, this.optional, this.type, this.dataSource, newValue, this.value, this.selectedOptions, this.minQueryLength));
    }

    public final SlackFormSelectElement withOptionGroups(Iterable<? extends SlackFormOptionGroup> elements) {
        if (this.optionGroups == elements) {
            return this;
        }
        List<SlackFormOptionGroup> newValue = SlackFormSelectElement.createUnmodifiableList(false, SlackFormSelectElement.createSafeList(elements, true, false));
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.options, this.label, this.name, this.placeholder, this.optional, this.type, this.dataSource, newValue, this.value, this.selectedOptions, this.minQueryLength));
    }

    public final SlackFormSelectElement withValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.value, newValue)) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.options, this.label, this.name, this.placeholder, this.optional, this.type, this.dataSource, this.optionGroups, newValue, this.selectedOptions, this.minQueryLength));
    }

    public final SlackFormSelectElement withValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.value, value)) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.options, this.label, this.name, this.placeholder, this.optional, this.type, this.dataSource, this.optionGroups, value, this.selectedOptions, this.minQueryLength));
    }

    public final SlackFormSelectElement withSelectedOptions(SlackFormOption ... elements) {
        List<SlackFormOption> newValue = SlackFormSelectElement.createUnmodifiableList(false, SlackFormSelectElement.createSafeList(Arrays.asList(elements), true, false));
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.options, this.label, this.name, this.placeholder, this.optional, this.type, this.dataSource, this.optionGroups, this.value, newValue, this.minQueryLength));
    }

    public final SlackFormSelectElement withSelectedOptions(Iterable<? extends SlackFormOption> elements) {
        if (this.selectedOptions == elements) {
            return this;
        }
        List<SlackFormOption> newValue = SlackFormSelectElement.createUnmodifiableList(false, SlackFormSelectElement.createSafeList(elements, true, false));
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.options, this.label, this.name, this.placeholder, this.optional, this.type, this.dataSource, this.optionGroups, this.value, newValue, this.minQueryLength));
    }

    public final SlackFormSelectElement withMinQueryLength(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.minQueryLength, newValue)) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.options, this.label, this.name, this.placeholder, this.optional, this.type, this.dataSource, this.optionGroups, this.value, this.selectedOptions, newValue));
    }

    public final SlackFormSelectElement withMinQueryLength(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.minQueryLength, value)) {
            return this;
        }
        return SlackFormSelectElement.validate(new SlackFormSelectElement(this.options, this.label, this.name, this.placeholder, this.optional, this.type, this.dataSource, this.optionGroups, this.value, this.selectedOptions, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackFormSelectElement && this.equalTo(0, (SlackFormSelectElement)another);
    }

    private boolean equalTo(int synthetic, SlackFormSelectElement another) {
        return this.options.equals(another.options) && this.label.equals(another.label) && this.name.equals(another.name) && Objects.equals(this.placeholder, another.placeholder) && Objects.equals(this.optional, another.optional) && this.type.equals((Object)another.type) && this.dataSource.equals((Object)another.dataSource) && this.optionGroups.equals(another.optionGroups) && Objects.equals(this.value, another.value) && this.selectedOptions.equals(another.selectedOptions) && Objects.equals(this.minQueryLength, another.minQueryLength);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.options.hashCode();
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.placeholder);
        h += (h << 5) + Objects.hashCode(this.optional);
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.dataSource.hashCode();
        h += (h << 5) + this.optionGroups.hashCode();
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + this.selectedOptions.hashCode();
        h += (h << 5) + Objects.hashCode(this.minQueryLength);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackFormSelectElement{");
        builder.append("options=").append(this.options);
        builder.append(", ");
        builder.append("label=").append(this.label);
        builder.append(", ");
        builder.append("name=").append(this.name);
        if (this.placeholder != null) {
            builder.append(", ");
            builder.append("placeholder=").append(this.placeholder);
        }
        if (this.optional != null) {
            builder.append(", ");
            builder.append("optional=").append(this.optional);
        }
        builder.append(", ");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("dataSource=").append((Object)this.dataSource);
        builder.append(", ");
        builder.append("optionGroups=").append(this.optionGroups);
        if (this.value != null) {
            builder.append(", ");
            builder.append("value=").append(this.value);
        }
        builder.append(", ");
        builder.append("selectedOptions=").append(this.selectedOptions);
        if (this.minQueryLength != null) {
            builder.append(", ");
            builder.append("minQueryLength=").append(this.minQueryLength);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackFormSelectElement fromJson(Json json) {
        Builder builder = SlackFormSelectElement.builder();
        if (json.options != null) {
            builder.addAllOptions(json.options);
        }
        if (json.label != null) {
            builder.setLabel(json.label);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.placeholder != null) {
            builder.setPlaceholder(json.placeholder);
        }
        if (json.optional != null) {
            builder.setOptional(json.optional);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.dataSource != null) {
            builder.setDataSource(json.dataSource);
        }
        if (json.optionGroups != null) {
            builder.addAllOptionGroups(json.optionGroups);
        }
        if (json.value != null) {
            builder.setValue(json.value);
        }
        if (json.selectedOptions != null) {
            builder.addAllSelectedOptions(json.selectedOptions);
        }
        if (json.minQueryLength != null) {
            builder.setMinQueryLength(json.minQueryLength);
        }
        return builder.build();
    }

    private static SlackFormSelectElement validate(SlackFormSelectElement instance) {
        instance = (SlackFormSelectElement)instance.validate();
        return instance;
    }

    public static SlackFormSelectElement copyOf(AbstractSlackFormSelectElement instance) {
        if (instance instanceof SlackFormSelectElement) {
            return (SlackFormSelectElement)instance;
        }
        return SlackFormSelectElement.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AbstractSlackFormSelectElement", generator="Immutables")
    private final class InitShim {
        private byte typeBuildStage = 0;
        private SlackFormElementTypes type;
        private byte dataSourceBuildStage = 0;
        private SlackDataSource dataSource;

        private InitShim() {
        }

        SlackFormElementTypes getType() {
            if (this.typeBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.typeBuildStage == 0) {
                this.typeBuildStage = (byte)-1;
                this.type = Objects.requireNonNull(SlackFormSelectElement.super.getType(), "type");
                this.typeBuildStage = 1;
            }
            return this.type;
        }

        void setType(SlackFormElementTypes type) {
            this.type = type;
            this.typeBuildStage = 1;
        }

        SlackDataSource getDataSource() {
            if (this.dataSourceBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.dataSourceBuildStage == 0) {
                this.dataSourceBuildStage = (byte)-1;
                this.dataSource = Objects.requireNonNull(SlackFormSelectElement.super.getDataSource(), "dataSource");
                this.dataSourceBuildStage = 1;
            }
            return this.dataSource;
        }

        void setDataSource(SlackDataSource dataSource) {
            this.dataSource = dataSource;
            this.dataSourceBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.typeBuildStage == -1) {
                attributes.add("type");
            }
            if (this.dataSourceBuildStage == -1) {
                attributes.add("dataSource");
            }
            return "Cannot build SlackFormSelectElement, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="AbstractSlackFormSelectElement", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LABEL = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        private List<SlackFormOption> options = new ArrayList<SlackFormOption>();
        @Nullable
        private String label;
        @Nullable
        private String name;
        @Nullable
        private String placeholder;
        @Nullable
        private Boolean optional;
        @Nullable
        private SlackFormElementTypes type;
        @Nullable
        private SlackDataSource dataSource;
        private List<SlackFormOptionGroup> optionGroups = new ArrayList<SlackFormOptionGroup>();
        @Nullable
        private String value;
        private List<SlackFormOption> selectedOptions = new ArrayList<SlackFormOption>();
        @Nullable
        private Integer minQueryLength;

        private Builder() {
        }

        public final Builder from(HasLabel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackDialogFormElement instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractSlackFormSelectElement instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(HasOptions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof HasLabel) {
                instance = (HasLabel)object;
                if ((bits & 2L) == 0L) {
                    this.setLabel(instance.getLabel());
                    bits |= 2L;
                }
            }
            if (object instanceof SlackDialogFormElement) {
                instance = (SlackDialogFormElement)object;
                if ((bits & 0x10L) == 0L) {
                    this.setName(((SlackDialogFormElement)instance).getName());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    Optional<Boolean> optionalOptional = ((SlackDialogFormElement)instance).isOptional();
                    if (optionalOptional.isPresent()) {
                        this.setOptional(optionalOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setLabel(instance.getLabel());
                    bits |= 2L;
                }
                if ((bits & 0x20L) == 0L) {
                    Optional<String> placeholderOptional = ((SlackDialogFormElement)instance).getPlaceholder();
                    if (placeholderOptional.isPresent()) {
                        this.setPlaceholder(placeholderOptional);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 4L) == 0L) {
                    this.setType(((SlackDialogFormElement)instance).getType());
                    bits |= 4L;
                }
            }
            if (object instanceof AbstractSlackFormSelectElement) {
                instance = (AbstractSlackFormSelectElement)object;
                Optional<Integer> minQueryLengthOptional = ((AbstractSlackFormSelectElement)instance).getMinQueryLength();
                if (minQueryLengthOptional.isPresent()) {
                    this.setMinQueryLength(minQueryLengthOptional);
                }
                if ((bits & 8L) == 0L) {
                    this.addAllOptions(instance.getOptions());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.setName(((SlackDialogFormElement)instance).getName());
                    bits |= 0x10L;
                }
                this.addAllSelectedOptions(((AbstractSlackFormSelectElement)instance).getSelectedOptions());
                this.addAllOptionGroups(((AbstractSlackFormSelectElement)instance).getOptionGroups());
                if ((bits & 1L) == 0L) {
                    Optional<Boolean> optionalOptional = ((SlackDialogFormElement)instance).isOptional();
                    if (optionalOptional.isPresent()) {
                        this.setOptional(optionalOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setLabel(instance.getLabel());
                    bits |= 2L;
                }
                if ((bits & 0x20L) == 0L) {
                    Optional<String> placeholderOptional = ((SlackDialogFormElement)instance).getPlaceholder();
                    if (placeholderOptional.isPresent()) {
                        this.setPlaceholder(placeholderOptional);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 4L) == 0L) {
                    this.setType(((AbstractSlackFormSelectElement)instance).getType());
                    bits |= 4L;
                }
                this.setDataSource(((AbstractSlackFormSelectElement)instance).getDataSource());
                Optional<String> valueOptional = ((AbstractSlackFormSelectElement)instance).getValue();
                if (valueOptional.isPresent()) {
                    this.setValue(valueOptional);
                }
            }
            if (object instanceof HasOptions) {
                instance = (HasOptions)object;
                if ((bits & 8L) == 0L) {
                    this.addAllOptions(instance.getOptions());
                    bits |= 8L;
                }
            }
        }

        public final Builder addOptions(SlackFormOption element) {
            this.options.add(Objects.requireNonNull(element, "options element"));
            return this;
        }

        public final Builder addOptions(SlackFormOption ... elements) {
            for (SlackFormOption element : elements) {
                this.options.add(Objects.requireNonNull(element, "options element"));
            }
            return this;
        }

        public final Builder setOptions(Iterable<? extends SlackFormOption> elements) {
            this.options.clear();
            return this.addAllOptions(elements);
        }

        public final Builder addAllOptions(Iterable<? extends SlackFormOption> elements) {
            for (SlackFormOption slackFormOption : elements) {
                this.options.add(Objects.requireNonNull(slackFormOption, "options element"));
            }
            return this;
        }

        public final Builder setLabel(String label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setPlaceholder(@Nullable String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public final Builder setPlaceholder(Optional<String> placeholder) {
            this.placeholder = placeholder.orElse(null);
            return this;
        }

        public final Builder setOptional(@Nullable Boolean optional) {
            this.optional = optional;
            return this;
        }

        public final Builder setOptional(Optional<Boolean> optional) {
            this.optional = optional.orElse(null);
            return this;
        }

        public final Builder setType(SlackFormElementTypes type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        public final Builder setDataSource(SlackDataSource dataSource) {
            this.dataSource = Objects.requireNonNull(dataSource, "dataSource");
            return this;
        }

        public final Builder addOptionGroups(SlackFormOptionGroup element) {
            this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
            return this;
        }

        public final Builder addOptionGroups(SlackFormOptionGroup ... elements) {
            for (SlackFormOptionGroup element : elements) {
                this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
            }
            return this;
        }

        public final Builder setOptionGroups(Iterable<? extends SlackFormOptionGroup> elements) {
            this.optionGroups.clear();
            return this.addAllOptionGroups(elements);
        }

        public final Builder addAllOptionGroups(Iterable<? extends SlackFormOptionGroup> elements) {
            for (SlackFormOptionGroup slackFormOptionGroup : elements) {
                this.optionGroups.add(Objects.requireNonNull(slackFormOptionGroup, "optionGroups element"));
            }
            return this;
        }

        public final Builder setValue(@Nullable String value) {
            this.value = value;
            return this;
        }

        public final Builder setValue(Optional<String> value) {
            this.value = value.orElse(null);
            return this;
        }

        public final Builder addSelectedOptions(SlackFormOption element) {
            this.selectedOptions.add(Objects.requireNonNull(element, "selectedOptions element"));
            return this;
        }

        public final Builder addSelectedOptions(SlackFormOption ... elements) {
            for (SlackFormOption element : elements) {
                this.selectedOptions.add(Objects.requireNonNull(element, "selectedOptions element"));
            }
            return this;
        }

        public final Builder setSelectedOptions(Iterable<? extends SlackFormOption> elements) {
            this.selectedOptions.clear();
            return this.addAllSelectedOptions(elements);
        }

        public final Builder addAllSelectedOptions(Iterable<? extends SlackFormOption> elements) {
            for (SlackFormOption slackFormOption : elements) {
                this.selectedOptions.add(Objects.requireNonNull(slackFormOption, "selectedOptions element"));
            }
            return this;
        }

        public final Builder setMinQueryLength(@Nullable Integer minQueryLength) {
            this.minQueryLength = minQueryLength;
            return this;
        }

        public final Builder setMinQueryLength(Optional<Integer> minQueryLength) {
            this.minQueryLength = minQueryLength.orElse(null);
            return this;
        }

        public SlackFormSelectElement build() {
            this.checkRequiredAttributes();
            return SlackFormSelectElement.validate(new SlackFormSelectElement(this));
        }

        private boolean labelIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean nameIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.labelIsSet()) {
                attributes.add("label");
            }
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            return "Cannot build SlackFormSelectElement, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractSlackFormSelectElement", generator="Immutables")
    static final class Json
    extends AbstractSlackFormSelectElement {
        @Nullable
        List<SlackFormOption> options = Collections.emptyList();
        @Nullable
        String label;
        @Nullable
        String name;
        @Nullable
        Optional<String> placeholder = Optional.empty();
        @Nullable
        Optional<Boolean> optional = Optional.empty();
        @Nullable
        SlackFormElementTypes type;
        @Nullable
        SlackDataSource dataSource;
        @Nullable
        List<SlackFormOptionGroup> optionGroups = Collections.emptyList();
        @Nullable
        Optional<String> value = Optional.empty();
        @Nullable
        List<SlackFormOption> selectedOptions = Collections.emptyList();
        @Nullable
        Optional<Integer> minQueryLength = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setOptions(List<SlackFormOption> options) {
            this.options = options;
        }

        @JsonProperty
        public void setLabel(String label) {
            this.label = label;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setPlaceholder(Optional<String> placeholder) {
            this.placeholder = placeholder;
        }

        @JsonProperty(value="optional")
        public void setOptional(Optional<Boolean> optional) {
            this.optional = optional;
        }

        @JsonProperty
        public void setType(SlackFormElementTypes type) {
            this.type = type;
        }

        @JsonProperty
        public void setDataSource(SlackDataSource dataSource) {
            this.dataSource = dataSource;
        }

        @JsonProperty
        public void setOptionGroups(List<SlackFormOptionGroup> optionGroups) {
            this.optionGroups = optionGroups;
        }

        @JsonProperty
        public void setValue(Optional<String> value) {
            this.value = value;
        }

        @JsonProperty
        public void setSelectedOptions(List<SlackFormOption> selectedOptions) {
            this.selectedOptions = selectedOptions;
        }

        @JsonProperty
        public void setMinQueryLength(Optional<Integer> minQueryLength) {
            this.minQueryLength = minQueryLength;
        }

        @Override
        public List<SlackFormOption> getOptions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPlaceholder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isOptional() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackFormElementTypes getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackDataSource getDataSource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SlackFormOptionGroup> getOptionGroups() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SlackFormOption> getSelectedOptions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getMinQueryLength() {
            throw new UnsupportedOperationException();
        }
    }
}

