/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.dialog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.dialog.SlackDialogIF;
import com.hubspot.slack.client.models.dialog.form.elements.SlackDialogFormElement;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackDialogIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackDialog
implements SlackDialogIF {
    private final String title;
    private final String callbackId;
    private final List<SlackDialogFormElement> elements;
    @Nullable
    private final String state;
    @Nullable
    private final String submitLabel;
    @Nullable
    private final Boolean notifyOnCancel;

    private SlackDialog(String title, String callbackId, List<SlackDialogFormElement> elements, @Nullable String state, @Nullable String submitLabel, @Nullable Boolean notifyOnCancel) {
        this.title = title;
        this.callbackId = callbackId;
        this.elements = elements;
        this.state = state;
        this.submitLabel = submitLabel;
        this.notifyOnCancel = notifyOnCancel;
    }

    @Override
    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty
    public String getCallbackId() {
        return this.callbackId;
    }

    @Override
    @JsonProperty
    public List<SlackDialogFormElement> getElements() {
        return this.elements;
    }

    @Override
    @JsonProperty
    public Optional<String> getState() {
        return Optional.ofNullable(this.state);
    }

    @Override
    @JsonProperty
    public Optional<String> getSubmitLabel() {
        return Optional.ofNullable(this.submitLabel);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getNotifyOnCancel() {
        return Optional.ofNullable(this.notifyOnCancel);
    }

    public final SlackDialog withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return SlackDialog.validate(new SlackDialog(newValue, this.callbackId, this.elements, this.state, this.submitLabel, this.notifyOnCancel));
    }

    public final SlackDialog withCallbackId(String value) {
        String newValue = Objects.requireNonNull(value, "callbackId");
        if (this.callbackId.equals(newValue)) {
            return this;
        }
        return SlackDialog.validate(new SlackDialog(this.title, newValue, this.elements, this.state, this.submitLabel, this.notifyOnCancel));
    }

    public final SlackDialog withElements(SlackDialogFormElement ... elements) {
        List<SlackDialogFormElement> newValue = SlackDialog.createUnmodifiableList(false, SlackDialog.createSafeList(Arrays.asList(elements), true, false));
        return SlackDialog.validate(new SlackDialog(this.title, this.callbackId, newValue, this.state, this.submitLabel, this.notifyOnCancel));
    }

    public final SlackDialog withElements(Iterable<? extends SlackDialogFormElement> elements) {
        if (this.elements == elements) {
            return this;
        }
        List<SlackDialogFormElement> newValue = SlackDialog.createUnmodifiableList(false, SlackDialog.createSafeList(elements, true, false));
        return SlackDialog.validate(new SlackDialog(this.title, this.callbackId, newValue, this.state, this.submitLabel, this.notifyOnCancel));
    }

    public final SlackDialog withState(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.state, newValue)) {
            return this;
        }
        return SlackDialog.validate(new SlackDialog(this.title, this.callbackId, this.elements, newValue, this.submitLabel, this.notifyOnCancel));
    }

    public final SlackDialog withState(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return SlackDialog.validate(new SlackDialog(this.title, this.callbackId, this.elements, value, this.submitLabel, this.notifyOnCancel));
    }

    public final SlackDialog withSubmitLabel(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.submitLabel, newValue)) {
            return this;
        }
        return SlackDialog.validate(new SlackDialog(this.title, this.callbackId, this.elements, this.state, newValue, this.notifyOnCancel));
    }

    public final SlackDialog withSubmitLabel(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.submitLabel, value)) {
            return this;
        }
        return SlackDialog.validate(new SlackDialog(this.title, this.callbackId, this.elements, this.state, value, this.notifyOnCancel));
    }

    public final SlackDialog withNotifyOnCancel(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.notifyOnCancel, newValue)) {
            return this;
        }
        return SlackDialog.validate(new SlackDialog(this.title, this.callbackId, this.elements, this.state, this.submitLabel, newValue));
    }

    public final SlackDialog withNotifyOnCancel(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.notifyOnCancel, value)) {
            return this;
        }
        return SlackDialog.validate(new SlackDialog(this.title, this.callbackId, this.elements, this.state, this.submitLabel, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackDialog && this.equalTo(0, (SlackDialog)another);
    }

    private boolean equalTo(int synthetic, SlackDialog another) {
        return this.title.equals(another.title) && this.callbackId.equals(another.callbackId) && this.elements.equals(another.elements) && Objects.equals(this.state, another.state) && Objects.equals(this.submitLabel, another.submitLabel) && Objects.equals(this.notifyOnCancel, another.notifyOnCancel);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.callbackId.hashCode();
        h += (h << 5) + this.elements.hashCode();
        h += (h << 5) + Objects.hashCode(this.state);
        h += (h << 5) + Objects.hashCode(this.submitLabel);
        h += (h << 5) + Objects.hashCode(this.notifyOnCancel);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackDialog{");
        builder.append("title=").append(this.title);
        builder.append(", ");
        builder.append("callbackId=").append(this.callbackId);
        builder.append(", ");
        builder.append("elements=").append(this.elements);
        if (this.state != null) {
            builder.append(", ");
            builder.append("state=").append(this.state);
        }
        if (this.submitLabel != null) {
            builder.append(", ");
            builder.append("submitLabel=").append(this.submitLabel);
        }
        if (this.notifyOnCancel != null) {
            builder.append(", ");
            builder.append("notifyOnCancel=").append(this.notifyOnCancel);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackDialog fromJson(Json json) {
        Builder builder = SlackDialog.builder();
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.callbackId != null) {
            builder.setCallbackId(json.callbackId);
        }
        if (json.elements != null) {
            builder.addAllElements(json.elements);
        }
        if (json.state != null) {
            builder.setState(json.state);
        }
        if (json.submitLabel != null) {
            builder.setSubmitLabel(json.submitLabel);
        }
        if (json.notifyOnCancel != null) {
            builder.setNotifyOnCancel(json.notifyOnCancel);
        }
        return builder.build();
    }

    private static SlackDialog validate(SlackDialog instance) {
        instance.validate();
        return instance;
    }

    public static SlackDialog copyOf(SlackDialogIF instance) {
        if (instance instanceof SlackDialog) {
            return (SlackDialog)instance;
        }
        return SlackDialog.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="SlackDialogIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long INIT_BIT_CALLBACK_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private String title;
        @Nullable
        private String callbackId;
        private List<SlackDialogFormElement> elements = new ArrayList<SlackDialogFormElement>();
        @Nullable
        private String state;
        @Nullable
        private String submitLabel;
        @Nullable
        private Boolean notifyOnCancel;

        private Builder() {
        }

        public final Builder from(SlackDialogIF instance) {
            Optional<Boolean> notifyOnCancelOptional;
            Optional<String> submitLabelOptional;
            Objects.requireNonNull(instance, "instance");
            this.setTitle(instance.getTitle());
            this.setCallbackId(instance.getCallbackId());
            this.addAllElements(instance.getElements());
            Optional<String> stateOptional = instance.getState();
            if (stateOptional.isPresent()) {
                this.setState(stateOptional);
            }
            if ((submitLabelOptional = instance.getSubmitLabel()).isPresent()) {
                this.setSubmitLabel(submitLabelOptional);
            }
            if ((notifyOnCancelOptional = instance.getNotifyOnCancel()).isPresent()) {
                this.setNotifyOnCancel(notifyOnCancelOptional);
            }
            return this;
        }

        public final Builder setTitle(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setCallbackId(String callbackId) {
            this.callbackId = Objects.requireNonNull(callbackId, "callbackId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addElements(SlackDialogFormElement element) {
            this.elements.add(Objects.requireNonNull(element, "elements element"));
            return this;
        }

        public final Builder addElements(SlackDialogFormElement ... elements) {
            for (SlackDialogFormElement element : elements) {
                this.elements.add(Objects.requireNonNull(element, "elements element"));
            }
            return this;
        }

        public final Builder setElements(Iterable<? extends SlackDialogFormElement> elements) {
            this.elements.clear();
            return this.addAllElements(elements);
        }

        public final Builder addAllElements(Iterable<? extends SlackDialogFormElement> elements) {
            for (SlackDialogFormElement slackDialogFormElement : elements) {
                this.elements.add(Objects.requireNonNull(slackDialogFormElement, "elements element"));
            }
            return this;
        }

        public final Builder setState(@Nullable String state) {
            this.state = state;
            return this;
        }

        public final Builder setState(Optional<String> state) {
            this.state = state.orElse(null);
            return this;
        }

        public final Builder setSubmitLabel(@Nullable String submitLabel) {
            this.submitLabel = submitLabel;
            return this;
        }

        public final Builder setSubmitLabel(Optional<String> submitLabel) {
            this.submitLabel = submitLabel.orElse(null);
            return this;
        }

        public final Builder setNotifyOnCancel(@Nullable Boolean notifyOnCancel) {
            this.notifyOnCancel = notifyOnCancel;
            return this;
        }

        public final Builder setNotifyOnCancel(Optional<Boolean> notifyOnCancel) {
            this.notifyOnCancel = notifyOnCancel.orElse(null);
            return this;
        }

        public SlackDialog build() {
            this.checkRequiredAttributes();
            return SlackDialog.validate(new SlackDialog(this.title, this.callbackId, SlackDialog.createUnmodifiableList(true, this.elements), this.state, this.submitLabel, this.notifyOnCancel));
        }

        private boolean titleIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean callbackIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.titleIsSet()) {
                attributes.add("title");
            }
            if (!this.callbackIdIsSet()) {
                attributes.add("callbackId");
            }
            return "Cannot build SlackDialog, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackDialogIF", generator="Immutables")
    static final class Json
    implements SlackDialogIF {
        @Nullable
        String title;
        @Nullable
        String callbackId;
        @Nullable
        List<SlackDialogFormElement> elements = Collections.emptyList();
        @Nullable
        Optional<String> state = Optional.empty();
        @Nullable
        Optional<String> submitLabel = Optional.empty();
        @Nullable
        Optional<Boolean> notifyOnCancel = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty
        public void setCallbackId(String callbackId) {
            this.callbackId = callbackId;
        }

        @JsonProperty
        public void setElements(List<SlackDialogFormElement> elements) {
            this.elements = elements;
        }

        @JsonProperty
        public void setState(Optional<String> state) {
            this.state = state;
        }

        @JsonProperty
        public void setSubmitLabel(Optional<String> submitLabel) {
            this.submitLabel = submitLabel;
        }

        @JsonProperty
        public void setNotifyOnCancel(Optional<Boolean> notifyOnCancel) {
            this.notifyOnCancel = notifyOnCancel;
        }

        @Override
        public String getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCallbackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SlackDialogFormElement> getElements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getSubmitLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getNotifyOnCancel() {
            throw new UnsupportedOperationException();
        }
    }
}

