/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.objects;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.objects.Option;
import com.hubspot.slack.client.models.blocks.objects.OptionGroupIF;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="OptionGroupIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class OptionGroup
implements OptionGroupIF {
    private final Text label;
    private final List<Option> options;

    private OptionGroup(Text label, Iterable<? extends Option> options) {
        this.label = Objects.requireNonNull(label, "label");
        this.options = OptionGroup.createUnmodifiableList(false, OptionGroup.createSafeList(options, true, false));
    }

    private OptionGroup(OptionGroup original, Text label, List<Option> options) {
        this.label = label;
        this.options = options;
    }

    @Override
    @JsonProperty
    public Text getLabel() {
        return this.label;
    }

    @Override
    @JsonProperty
    public List<Option> getOptions() {
        return this.options;
    }

    public final OptionGroup withLabel(Text value) {
        if (this.label == value) {
            return this;
        }
        Text newValue = Objects.requireNonNull(value, "label");
        return OptionGroup.validate(new OptionGroup(this, newValue, this.options));
    }

    public final OptionGroup withOptions(Option ... elements) {
        List<Option> newValue = OptionGroup.createUnmodifiableList(false, OptionGroup.createSafeList(Arrays.asList(elements), true, false));
        return OptionGroup.validate(new OptionGroup(this, this.label, newValue));
    }

    public final OptionGroup withOptions(Iterable<? extends Option> elements) {
        if (this.options == elements) {
            return this;
        }
        List<Option> newValue = OptionGroup.createUnmodifiableList(false, OptionGroup.createSafeList(elements, true, false));
        return OptionGroup.validate(new OptionGroup(this, this.label, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OptionGroup && this.equalTo(0, (OptionGroup)another);
    }

    private boolean equalTo(int synthetic, OptionGroup another) {
        return this.label.equals(another.label) && this.options.equals(another.options);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.options.hashCode();
        return h;
    }

    public String toString() {
        return "OptionGroup{label=" + String.valueOf(this.label) + ", options=" + String.valueOf(this.options) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static OptionGroup fromJson(Json json) {
        Builder builder = OptionGroup.builder();
        if (json.label != null) {
            builder.setLabel(json.label);
        }
        if (json.options != null) {
            builder.addAllOptions(json.options);
        }
        return builder.build();
    }

    public static OptionGroup of(Text label, List<Option> options) {
        return OptionGroup.of(label, options);
    }

    public static OptionGroup of(Text label, Iterable<? extends Option> options) {
        return OptionGroup.validate(new OptionGroup(label, options));
    }

    private static OptionGroup validate(OptionGroup instance) {
        instance = (OptionGroup)instance.validate();
        return instance;
    }

    public static OptionGroup copyOf(OptionGroupIF instance) {
        if (instance instanceof OptionGroup) {
            return (OptionGroup)instance;
        }
        return OptionGroup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="OptionGroupIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LABEL = 1L;
        private long initBits = 1L;
        @Nullable
        private Text label;
        private List<Option> options = new ArrayList<Option>();

        private Builder() {
        }

        public final Builder from(OptionGroupIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setLabel(instance.getLabel());
            this.addAllOptions(instance.getOptions());
            return this;
        }

        public final Builder setLabel(Text label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addOptions(Option element) {
            this.options.add(Objects.requireNonNull(element, "options element"));
            return this;
        }

        public final Builder addOptions(Option ... elements) {
            for (Option element : elements) {
                this.options.add(Objects.requireNonNull(element, "options element"));
            }
            return this;
        }

        public final Builder setOptions(Iterable<? extends Option> elements) {
            this.options.clear();
            return this.addAllOptions(elements);
        }

        public final Builder addAllOptions(Iterable<? extends Option> elements) {
            for (Option option : elements) {
                this.options.add(Objects.requireNonNull(option, "options element"));
            }
            return this;
        }

        public OptionGroup build() {
            this.checkRequiredAttributes();
            return OptionGroup.validate(new OptionGroup(null, this.label, OptionGroup.createUnmodifiableList(true, this.options)));
        }

        private boolean labelIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.labelIsSet()) {
                attributes.add("label");
            }
            return "Cannot build OptionGroup, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OptionGroupIF", generator="Immutables")
    static final class Json
    implements OptionGroupIF {
        @Nullable
        Text label;
        @Nullable
        List<Option> options = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setLabel(Text label) {
            this.label = label;
        }

        @JsonProperty
        public void setOptions(List<Option> options) {
            this.options = options;
        }

        @Override
        public Text getLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Option> getOptions() {
            throw new UnsupportedOperationException();
        }
    }
}

