/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.HasActionId;
import com.hubspot.slack.client.models.blocks.elements.TimePickerIF;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="TimePickerIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class TimePicker
implements TimePickerIF {
    private final transient String type;
    private final String actionId;
    @Nullable
    private final Text placeholder;
    @Nullable
    private final String timezone;
    @Nullable
    private final LocalTime initialTime;
    @Nullable
    private final ConfirmationDialog confirmationDialog;

    private TimePicker(String actionId) {
        this.actionId = Objects.requireNonNull(actionId, "actionId");
        this.placeholder = null;
        this.timezone = null;
        this.initialTime = null;
        this.confirmationDialog = null;
        this.type = Objects.requireNonNull(TimePickerIF.super.getType(), "type");
    }

    private TimePicker(String actionId, @Nullable Text placeholder, @Nullable String timezone, @Nullable LocalTime initialTime, @Nullable ConfirmationDialog confirmationDialog) {
        this.actionId = actionId;
        this.placeholder = placeholder;
        this.timezone = timezone;
        this.initialTime = initialTime;
        this.confirmationDialog = confirmationDialog;
        this.type = Objects.requireNonNull(TimePickerIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty
    public Optional<Text> getPlaceholder() {
        return Optional.ofNullable(this.placeholder);
    }

    @Override
    @JsonProperty
    public Optional<String> getTimezone() {
        return Optional.ofNullable(this.timezone);
    }

    @Override
    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="HH:mm")
    public Optional<LocalTime> getInitialTime() {
        return Optional.ofNullable(this.initialTime);
    }

    @Override
    @JsonProperty(value="confirm")
    public Optional<ConfirmationDialog> getConfirmationDialog() {
        return Optional.ofNullable(this.confirmationDialog);
    }

    public final TimePicker withActionId(String value) {
        String newValue = Objects.requireNonNull(value, "actionId");
        if (this.actionId.equals(newValue)) {
            return this;
        }
        return new TimePicker(newValue, this.placeholder, this.timezone, this.initialTime, this.confirmationDialog);
    }

    public final TimePicker withPlaceholder(@Nullable Text value) {
        Text newValue = value;
        if (this.placeholder == newValue) {
            return this;
        }
        return new TimePicker(this.actionId, newValue, this.timezone, this.initialTime, this.confirmationDialog);
    }

    public final TimePicker withPlaceholder(Optional<? extends Text> optional) {
        Text value = optional.orElse(null);
        if (this.placeholder == value) {
            return this;
        }
        return new TimePicker(this.actionId, value, this.timezone, this.initialTime, this.confirmationDialog);
    }

    public final TimePicker withTimezone(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.timezone, newValue)) {
            return this;
        }
        return new TimePicker(this.actionId, this.placeholder, newValue, this.initialTime, this.confirmationDialog);
    }

    public final TimePicker withTimezone(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.timezone, value)) {
            return this;
        }
        return new TimePicker(this.actionId, this.placeholder, value, this.initialTime, this.confirmationDialog);
    }

    public final TimePicker withInitialTime(@Nullable LocalTime value) {
        LocalTime newValue = value;
        if (this.initialTime == newValue) {
            return this;
        }
        return new TimePicker(this.actionId, this.placeholder, this.timezone, newValue, this.confirmationDialog);
    }

    public final TimePicker withInitialTime(Optional<? extends LocalTime> optional) {
        LocalTime value = optional.orElse(null);
        if (this.initialTime == value) {
            return this;
        }
        return new TimePicker(this.actionId, this.placeholder, this.timezone, value, this.confirmationDialog);
    }

    public final TimePicker withConfirmationDialog(@Nullable ConfirmationDialog value) {
        ConfirmationDialog newValue = value;
        if (this.confirmationDialog == newValue) {
            return this;
        }
        return new TimePicker(this.actionId, this.placeholder, this.timezone, this.initialTime, newValue);
    }

    public final TimePicker withConfirmationDialog(Optional<? extends ConfirmationDialog> optional) {
        ConfirmationDialog value = optional.orElse(null);
        if (this.confirmationDialog == value) {
            return this;
        }
        return new TimePicker(this.actionId, this.placeholder, this.timezone, this.initialTime, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TimePicker && this.equalTo(0, (TimePicker)another);
    }

    private boolean equalTo(int synthetic, TimePicker another) {
        return this.type.equals(another.type) && this.actionId.equals(another.actionId) && Objects.equals(this.placeholder, another.placeholder) && Objects.equals(this.timezone, another.timezone) && Objects.equals(this.initialTime, another.initialTime) && Objects.equals(this.confirmationDialog, another.confirmationDialog);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.actionId.hashCode();
        h += (h << 5) + Objects.hashCode(this.placeholder);
        h += (h << 5) + Objects.hashCode(this.timezone);
        h += (h << 5) + Objects.hashCode(this.initialTime);
        h += (h << 5) + Objects.hashCode(this.confirmationDialog);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("TimePicker{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        if (this.placeholder != null) {
            builder.append(", ");
            builder.append("placeholder=").append(this.placeholder);
        }
        if (this.timezone != null) {
            builder.append(", ");
            builder.append("timezone=").append(this.timezone);
        }
        if (this.initialTime != null) {
            builder.append(", ");
            builder.append("initialTime=").append(this.initialTime);
        }
        if (this.confirmationDialog != null) {
            builder.append(", ");
            builder.append("confirmationDialog=").append(this.confirmationDialog);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static TimePicker fromJson(Json json) {
        Builder builder = TimePicker.builder();
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.placeholder != null) {
            builder.setPlaceholder(json.placeholder);
        }
        if (json.timezone != null) {
            builder.setTimezone(json.timezone);
        }
        if (json.initialTime != null) {
            builder.setInitialTime(json.initialTime);
        }
        if (json.confirmationDialog != null) {
            builder.setConfirmationDialog(json.confirmationDialog);
        }
        return builder.build();
    }

    public static TimePicker of(String actionId) {
        return new TimePicker(actionId);
    }

    public static TimePicker copyOf(TimePickerIF instance) {
        if (instance instanceof TimePicker) {
            return (TimePicker)instance;
        }
        return TimePicker.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TimePickerIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACTION_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String actionId;
        @Nullable
        private Text placeholder;
        @Nullable
        private String timezone;
        @Nullable
        private LocalTime initialTime;
        @Nullable
        private ConfirmationDialog confirmationDialog;

        private Builder() {
        }

        public final Builder from(HasActionId instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(TimePickerIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasActionId instance;
            long bits = 0L;
            if (object instanceof HasActionId) {
                instance = (HasActionId)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
            }
            if (object instanceof TimePickerIF) {
                Optional<String> timezoneOptional;
                Optional<Text> placeholderOptional;
                Optional<ConfirmationDialog> confirmationDialogOptional;
                Optional<LocalTime> initialTimeOptional;
                instance = (TimePickerIF)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
                if ((initialTimeOptional = instance.getInitialTime()).isPresent()) {
                    this.setInitialTime(initialTimeOptional);
                }
                if ((confirmationDialogOptional = instance.getConfirmationDialog()).isPresent()) {
                    this.setConfirmationDialog(confirmationDialogOptional);
                }
                if ((placeholderOptional = instance.getPlaceholder()).isPresent()) {
                    this.setPlaceholder(placeholderOptional);
                }
                if ((timezoneOptional = instance.getTimezone()).isPresent()) {
                    this.setTimezone(timezoneOptional);
                }
            }
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setPlaceholder(@Nullable Text placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public final Builder setPlaceholder(Optional<? extends Text> placeholder) {
            this.placeholder = placeholder.orElse(null);
            return this;
        }

        public final Builder setTimezone(@Nullable String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final Builder setTimezone(Optional<String> timezone) {
            this.timezone = timezone.orElse(null);
            return this;
        }

        public final Builder setInitialTime(@Nullable LocalTime initialTime) {
            this.initialTime = initialTime;
            return this;
        }

        public final Builder setInitialTime(Optional<? extends LocalTime> initialTime) {
            this.initialTime = initialTime.orElse(null);
            return this;
        }

        public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
            return this;
        }

        public final Builder setConfirmationDialog(Optional<? extends ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog.orElse(null);
            return this;
        }

        public TimePicker build() {
            this.checkRequiredAttributes();
            return new TimePicker(this.actionId, this.placeholder, this.timezone, this.initialTime, this.confirmationDialog);
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            return "Cannot build TimePicker, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TimePickerIF", generator="Immutables")
    static final class Json
    implements TimePickerIF {
        @Nullable
        String actionId;
        @Nullable
        Optional<Text> placeholder = Optional.empty();
        @Nullable
        Optional<String> timezone = Optional.empty();
        @Nullable
        Optional<LocalTime> initialTime = Optional.empty();
        @Nullable
        Optional<ConfirmationDialog> confirmationDialog = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty
        public void setPlaceholder(Optional<Text> placeholder) {
            this.placeholder = placeholder;
        }

        @JsonProperty
        public void setTimezone(Optional<String> timezone) {
            this.timezone = timezone;
        }

        @JsonProperty
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="HH:mm")
        public void setInitialTime(Optional<LocalTime> initialTime) {
            this.initialTime = initialTime;
        }

        @JsonProperty(value="confirm")
        public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Text> getPlaceholder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTimezone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LocalTime> getInitialTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ConfirmationDialog> getConfirmationDialog() {
            throw new UnsupportedOperationException();
        }
    }
}

