/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.HasActionId;
import com.hubspot.slack.client.models.blocks.elements.PlainTextInputIF;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="PlainTextInputIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class PlainTextInput
implements PlainTextInputIF {
    private final transient String type;
    private final String actionId;
    @Nullable
    private final Text placeholder;
    @Nullable
    private final String initialValue;
    @Nullable
    private final Boolean multiline;
    @Nullable
    private final Integer minLength;
    @Nullable
    private final Integer maxLength;

    private PlainTextInput(String actionId) {
        this.actionId = Objects.requireNonNull(actionId, "actionId");
        this.placeholder = null;
        this.initialValue = null;
        this.multiline = null;
        this.minLength = null;
        this.maxLength = null;
        this.type = Objects.requireNonNull(PlainTextInputIF.super.getType(), "type");
    }

    private PlainTextInput(String actionId, @Nullable Text placeholder, @Nullable String initialValue, @Nullable Boolean multiline, @Nullable Integer minLength, @Nullable Integer maxLength) {
        this.actionId = actionId;
        this.placeholder = placeholder;
        this.initialValue = initialValue;
        this.multiline = multiline;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.type = Objects.requireNonNull(PlainTextInputIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty
    public Optional<Text> getPlaceholder() {
        return Optional.ofNullable(this.placeholder);
    }

    @Override
    @JsonProperty
    public Optional<String> getInitialValue() {
        return Optional.ofNullable(this.initialValue);
    }

    @Override
    @JsonProperty(value="multiline")
    public Optional<Boolean> isMultiline() {
        return Optional.ofNullable(this.multiline);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getMinLength() {
        return Optional.ofNullable(this.minLength);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getMaxLength() {
        return Optional.ofNullable(this.maxLength);
    }

    public final PlainTextInput withActionId(String value) {
        String newValue = Objects.requireNonNull(value, "actionId");
        if (this.actionId.equals(newValue)) {
            return this;
        }
        return PlainTextInput.validate(new PlainTextInput(newValue, this.placeholder, this.initialValue, this.multiline, this.minLength, this.maxLength));
    }

    public final PlainTextInput withPlaceholder(@Nullable Text value) {
        Text newValue = value;
        if (this.placeholder == newValue) {
            return this;
        }
        return PlainTextInput.validate(new PlainTextInput(this.actionId, newValue, this.initialValue, this.multiline, this.minLength, this.maxLength));
    }

    public final PlainTextInput withPlaceholder(Optional<? extends Text> optional) {
        Text value = optional.orElse(null);
        if (this.placeholder == value) {
            return this;
        }
        return PlainTextInput.validate(new PlainTextInput(this.actionId, value, this.initialValue, this.multiline, this.minLength, this.maxLength));
    }

    public final PlainTextInput withInitialValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.initialValue, newValue)) {
            return this;
        }
        return PlainTextInput.validate(new PlainTextInput(this.actionId, this.placeholder, newValue, this.multiline, this.minLength, this.maxLength));
    }

    public final PlainTextInput withInitialValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.initialValue, value)) {
            return this;
        }
        return PlainTextInput.validate(new PlainTextInput(this.actionId, this.placeholder, value, this.multiline, this.minLength, this.maxLength));
    }

    public final PlainTextInput withMultiline(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.multiline, newValue)) {
            return this;
        }
        return PlainTextInput.validate(new PlainTextInput(this.actionId, this.placeholder, this.initialValue, newValue, this.minLength, this.maxLength));
    }

    public final PlainTextInput withMultiline(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.multiline, value)) {
            return this;
        }
        return PlainTextInput.validate(new PlainTextInput(this.actionId, this.placeholder, this.initialValue, value, this.minLength, this.maxLength));
    }

    public final PlainTextInput withMinLength(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.minLength, newValue)) {
            return this;
        }
        return PlainTextInput.validate(new PlainTextInput(this.actionId, this.placeholder, this.initialValue, this.multiline, newValue, this.maxLength));
    }

    public final PlainTextInput withMinLength(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.minLength, value)) {
            return this;
        }
        return PlainTextInput.validate(new PlainTextInput(this.actionId, this.placeholder, this.initialValue, this.multiline, value, this.maxLength));
    }

    public final PlainTextInput withMaxLength(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.maxLength, newValue)) {
            return this;
        }
        return PlainTextInput.validate(new PlainTextInput(this.actionId, this.placeholder, this.initialValue, this.multiline, this.minLength, newValue));
    }

    public final PlainTextInput withMaxLength(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.maxLength, value)) {
            return this;
        }
        return PlainTextInput.validate(new PlainTextInput(this.actionId, this.placeholder, this.initialValue, this.multiline, this.minLength, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PlainTextInput && this.equalTo(0, (PlainTextInput)another);
    }

    private boolean equalTo(int synthetic, PlainTextInput another) {
        return this.type.equals(another.type) && this.actionId.equals(another.actionId) && Objects.equals(this.placeholder, another.placeholder) && Objects.equals(this.initialValue, another.initialValue) && Objects.equals(this.multiline, another.multiline) && Objects.equals(this.minLength, another.minLength) && Objects.equals(this.maxLength, another.maxLength);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.actionId.hashCode();
        h += (h << 5) + Objects.hashCode(this.placeholder);
        h += (h << 5) + Objects.hashCode(this.initialValue);
        h += (h << 5) + Objects.hashCode(this.multiline);
        h += (h << 5) + Objects.hashCode(this.minLength);
        h += (h << 5) + Objects.hashCode(this.maxLength);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PlainTextInput{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        if (this.placeholder != null) {
            builder.append(", ");
            builder.append("placeholder=").append(this.placeholder);
        }
        if (this.initialValue != null) {
            builder.append(", ");
            builder.append("initialValue=").append(this.initialValue);
        }
        if (this.multiline != null) {
            builder.append(", ");
            builder.append("multiline=").append(this.multiline);
        }
        if (this.minLength != null) {
            builder.append(", ");
            builder.append("minLength=").append(this.minLength);
        }
        if (this.maxLength != null) {
            builder.append(", ");
            builder.append("maxLength=").append(this.maxLength);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static PlainTextInput fromJson(Json json) {
        Builder builder = PlainTextInput.builder();
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.placeholder != null) {
            builder.setPlaceholder(json.placeholder);
        }
        if (json.initialValue != null) {
            builder.setInitialValue(json.initialValue);
        }
        if (json.multiline != null) {
            builder.setMultiline(json.multiline);
        }
        if (json.minLength != null) {
            builder.setMinLength(json.minLength);
        }
        if (json.maxLength != null) {
            builder.setMaxLength(json.maxLength);
        }
        return builder.build();
    }

    public static PlainTextInput of(String actionId) {
        return PlainTextInput.validate(new PlainTextInput(actionId));
    }

    private static PlainTextInput validate(PlainTextInput instance) {
        instance = (PlainTextInput)instance.validate();
        return instance;
    }

    public static PlainTextInput copyOf(PlainTextInputIF instance) {
        if (instance instanceof PlainTextInput) {
            return (PlainTextInput)instance;
        }
        return PlainTextInput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PlainTextInputIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACTION_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String actionId;
        @Nullable
        private Text placeholder;
        @Nullable
        private String initialValue;
        @Nullable
        private Boolean multiline;
        @Nullable
        private Integer minLength;
        @Nullable
        private Integer maxLength;

        private Builder() {
        }

        public final Builder from(HasActionId instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(PlainTextInputIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasActionId instance;
            long bits = 0L;
            if (object instanceof HasActionId) {
                instance = (HasActionId)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
            }
            if (object instanceof PlainTextInputIF) {
                Optional<Boolean> multilineOptional;
                Optional<Integer> minLengthOptional;
                Optional<Integer> maxLengthOptional;
                Optional<String> initialValueOptional;
                Optional<Text> placeholderOptional;
                instance = (PlainTextInputIF)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
                if ((placeholderOptional = instance.getPlaceholder()).isPresent()) {
                    this.setPlaceholder(placeholderOptional);
                }
                if ((initialValueOptional = instance.getInitialValue()).isPresent()) {
                    this.setInitialValue(initialValueOptional);
                }
                if ((maxLengthOptional = instance.getMaxLength()).isPresent()) {
                    this.setMaxLength(maxLengthOptional);
                }
                if ((minLengthOptional = instance.getMinLength()).isPresent()) {
                    this.setMinLength(minLengthOptional);
                }
                if ((multilineOptional = instance.isMultiline()).isPresent()) {
                    this.setMultiline(multilineOptional);
                }
            }
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setPlaceholder(@Nullable Text placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public final Builder setPlaceholder(Optional<? extends Text> placeholder) {
            this.placeholder = placeholder.orElse(null);
            return this;
        }

        public final Builder setInitialValue(@Nullable String initialValue) {
            this.initialValue = initialValue;
            return this;
        }

        public final Builder setInitialValue(Optional<String> initialValue) {
            this.initialValue = initialValue.orElse(null);
            return this;
        }

        public final Builder setMultiline(@Nullable Boolean multiline) {
            this.multiline = multiline;
            return this;
        }

        public final Builder setMultiline(Optional<Boolean> multiline) {
            this.multiline = multiline.orElse(null);
            return this;
        }

        public final Builder setMinLength(@Nullable Integer minLength) {
            this.minLength = minLength;
            return this;
        }

        public final Builder setMinLength(Optional<Integer> minLength) {
            this.minLength = minLength.orElse(null);
            return this;
        }

        public final Builder setMaxLength(@Nullable Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public final Builder setMaxLength(Optional<Integer> maxLength) {
            this.maxLength = maxLength.orElse(null);
            return this;
        }

        public PlainTextInput build() {
            this.checkRequiredAttributes();
            return PlainTextInput.validate(new PlainTextInput(this.actionId, this.placeholder, this.initialValue, this.multiline, this.minLength, this.maxLength));
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            return "Cannot build PlainTextInput, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PlainTextInputIF", generator="Immutables")
    static final class Json
    implements PlainTextInputIF {
        @Nullable
        String actionId;
        @Nullable
        Optional<Text> placeholder = Optional.empty();
        @Nullable
        Optional<String> initialValue = Optional.empty();
        @Nullable
        Optional<Boolean> multiline = Optional.empty();
        @Nullable
        Optional<Integer> minLength = Optional.empty();
        @Nullable
        Optional<Integer> maxLength = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty
        public void setPlaceholder(Optional<Text> placeholder) {
            this.placeholder = placeholder;
        }

        @JsonProperty
        public void setInitialValue(Optional<String> initialValue) {
            this.initialValue = initialValue;
        }

        @JsonProperty(value="multiline")
        public void setMultiline(Optional<Boolean> multiline) {
            this.multiline = multiline;
        }

        @JsonProperty
        public void setMinLength(Optional<Integer> minLength) {
            this.minLength = minLength;
        }

        @JsonProperty
        public void setMaxLength(Optional<Integer> maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Text> getPlaceholder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getInitialValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isMultiline() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getMinLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getMaxLength() {
            throw new UnsupportedOperationException();
        }
    }
}

