/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.ExternalMultiSelectMenuIF;
import com.hubspot.slack.client.models.blocks.elements.HasActionId;
import com.hubspot.slack.client.models.blocks.json.OptionOrOptionGroupDeserializer;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.OptionOrOptionGroup;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ExternalMultiSelectMenuIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ExternalMultiSelectMenu
implements ExternalMultiSelectMenuIF {
    private final transient String type;
    private final Text placeholder;
    private final String actionId;
    @Nullable
    private final Integer minQueryLength;
    private final List<OptionOrOptionGroup> initialOptions;
    @Nullable
    private final ConfirmationDialog confirmationDialog;

    private ExternalMultiSelectMenu(Text placeholder, String actionId) {
        this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
        this.actionId = Objects.requireNonNull(actionId, "actionId");
        this.minQueryLength = null;
        this.initialOptions = Collections.emptyList();
        this.confirmationDialog = null;
        this.type = Objects.requireNonNull(ExternalMultiSelectMenuIF.super.getType(), "type");
    }

    private ExternalMultiSelectMenu(Text placeholder, String actionId, @Nullable Integer minQueryLength, List<OptionOrOptionGroup> initialOptions, @Nullable ConfirmationDialog confirmationDialog) {
        this.placeholder = placeholder;
        this.actionId = actionId;
        this.minQueryLength = minQueryLength;
        this.initialOptions = initialOptions;
        this.confirmationDialog = confirmationDialog;
        this.type = Objects.requireNonNull(ExternalMultiSelectMenuIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Text getPlaceholder() {
        return this.placeholder;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty
    public Optional<Integer> getMinQueryLength() {
        return Optional.ofNullable(this.minQueryLength);
    }

    @Override
    @JsonProperty
    @JsonDeserialize(contentUsing=OptionOrOptionGroupDeserializer.class)
    public List<OptionOrOptionGroup> getInitialOptions() {
        return this.initialOptions;
    }

    @Override
    @JsonProperty(value="confirm")
    public Optional<ConfirmationDialog> getConfirmationDialog() {
        return Optional.ofNullable(this.confirmationDialog);
    }

    public final ExternalMultiSelectMenu withPlaceholder(Text value) {
        if (this.placeholder == value) {
            return this;
        }
        Text newValue = Objects.requireNonNull(value, "placeholder");
        return new ExternalMultiSelectMenu(newValue, this.actionId, this.minQueryLength, this.initialOptions, this.confirmationDialog);
    }

    public final ExternalMultiSelectMenu withActionId(String value) {
        String newValue = Objects.requireNonNull(value, "actionId");
        if (this.actionId.equals(newValue)) {
            return this;
        }
        return new ExternalMultiSelectMenu(this.placeholder, newValue, this.minQueryLength, this.initialOptions, this.confirmationDialog);
    }

    public final ExternalMultiSelectMenu withMinQueryLength(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.minQueryLength, newValue)) {
            return this;
        }
        return new ExternalMultiSelectMenu(this.placeholder, this.actionId, newValue, this.initialOptions, this.confirmationDialog);
    }

    public final ExternalMultiSelectMenu withMinQueryLength(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.minQueryLength, value)) {
            return this;
        }
        return new ExternalMultiSelectMenu(this.placeholder, this.actionId, value, this.initialOptions, this.confirmationDialog);
    }

    public final ExternalMultiSelectMenu withInitialOptions(OptionOrOptionGroup ... elements) {
        List<OptionOrOptionGroup> newValue = ExternalMultiSelectMenu.createUnmodifiableList(false, ExternalMultiSelectMenu.createSafeList(Arrays.asList(elements), true, false));
        return new ExternalMultiSelectMenu(this.placeholder, this.actionId, this.minQueryLength, newValue, this.confirmationDialog);
    }

    public final ExternalMultiSelectMenu withInitialOptions(Iterable<? extends OptionOrOptionGroup> elements) {
        if (this.initialOptions == elements) {
            return this;
        }
        List<OptionOrOptionGroup> newValue = ExternalMultiSelectMenu.createUnmodifiableList(false, ExternalMultiSelectMenu.createSafeList(elements, true, false));
        return new ExternalMultiSelectMenu(this.placeholder, this.actionId, this.minQueryLength, newValue, this.confirmationDialog);
    }

    public final ExternalMultiSelectMenu withConfirmationDialog(@Nullable ConfirmationDialog value) {
        ConfirmationDialog newValue = value;
        if (this.confirmationDialog == newValue) {
            return this;
        }
        return new ExternalMultiSelectMenu(this.placeholder, this.actionId, this.minQueryLength, this.initialOptions, newValue);
    }

    public final ExternalMultiSelectMenu withConfirmationDialog(Optional<? extends ConfirmationDialog> optional) {
        ConfirmationDialog value = optional.orElse(null);
        if (this.confirmationDialog == value) {
            return this;
        }
        return new ExternalMultiSelectMenu(this.placeholder, this.actionId, this.minQueryLength, this.initialOptions, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ExternalMultiSelectMenu && this.equalTo(0, (ExternalMultiSelectMenu)another);
    }

    private boolean equalTo(int synthetic, ExternalMultiSelectMenu another) {
        return this.type.equals(another.type) && this.placeholder.equals(another.placeholder) && this.actionId.equals(another.actionId) && Objects.equals(this.minQueryLength, another.minQueryLength) && this.initialOptions.equals(another.initialOptions) && Objects.equals(this.confirmationDialog, another.confirmationDialog);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.placeholder.hashCode();
        h += (h << 5) + this.actionId.hashCode();
        h += (h << 5) + Objects.hashCode(this.minQueryLength);
        h += (h << 5) + this.initialOptions.hashCode();
        h += (h << 5) + Objects.hashCode(this.confirmationDialog);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ExternalMultiSelectMenu{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("placeholder=").append(this.placeholder);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        if (this.minQueryLength != null) {
            builder.append(", ");
            builder.append("minQueryLength=").append(this.minQueryLength);
        }
        builder.append(", ");
        builder.append("initialOptions=").append(this.initialOptions);
        if (this.confirmationDialog != null) {
            builder.append(", ");
            builder.append("confirmationDialog=").append(this.confirmationDialog);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ExternalMultiSelectMenu fromJson(Json json) {
        Builder builder = ExternalMultiSelectMenu.builder();
        if (json.placeholder != null) {
            builder.setPlaceholder(json.placeholder);
        }
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.minQueryLength != null) {
            builder.setMinQueryLength(json.minQueryLength);
        }
        if (json.initialOptions != null) {
            builder.addAllInitialOptions(json.initialOptions);
        }
        if (json.confirmationDialog != null) {
            builder.setConfirmationDialog(json.confirmationDialog);
        }
        return builder.build();
    }

    public static ExternalMultiSelectMenu of(Text placeholder, String actionId) {
        return new ExternalMultiSelectMenu(placeholder, actionId);
    }

    public static ExternalMultiSelectMenu copyOf(ExternalMultiSelectMenuIF instance) {
        if (instance instanceof ExternalMultiSelectMenu) {
            return (ExternalMultiSelectMenu)instance;
        }
        return ExternalMultiSelectMenu.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ExternalMultiSelectMenuIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PLACEHOLDER = 1L;
        private static final long INIT_BIT_ACTION_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private Text placeholder;
        @Nullable
        private String actionId;
        @Nullable
        private Integer minQueryLength;
        private List<OptionOrOptionGroup> initialOptions = new ArrayList<OptionOrOptionGroup>();
        @Nullable
        private ConfirmationDialog confirmationDialog;

        private Builder() {
        }

        public final Builder from(HasActionId instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ExternalMultiSelectMenuIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasActionId instance;
            long bits = 0L;
            if (object instanceof HasActionId) {
                instance = (HasActionId)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
            }
            if (object instanceof ExternalMultiSelectMenuIF) {
                Optional<ConfirmationDialog> confirmationDialogOptional;
                instance = (ExternalMultiSelectMenuIF)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
                if ((confirmationDialogOptional = instance.getConfirmationDialog()).isPresent()) {
                    this.setConfirmationDialog(confirmationDialogOptional);
                }
                this.setPlaceholder(instance.getPlaceholder());
                Optional<Integer> minQueryLengthOptional = instance.getMinQueryLength();
                if (minQueryLengthOptional.isPresent()) {
                    this.setMinQueryLength(minQueryLengthOptional);
                }
                this.addAllInitialOptions(instance.getInitialOptions());
            }
        }

        public final Builder setPlaceholder(Text placeholder) {
            this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setMinQueryLength(@Nullable Integer minQueryLength) {
            this.minQueryLength = minQueryLength;
            return this;
        }

        public final Builder setMinQueryLength(Optional<Integer> minQueryLength) {
            this.minQueryLength = minQueryLength.orElse(null);
            return this;
        }

        public final Builder addInitialOptions(OptionOrOptionGroup element) {
            this.initialOptions.add(Objects.requireNonNull(element, "initialOptions element"));
            return this;
        }

        public final Builder addInitialOptions(OptionOrOptionGroup ... elements) {
            for (OptionOrOptionGroup element : elements) {
                this.initialOptions.add(Objects.requireNonNull(element, "initialOptions element"));
            }
            return this;
        }

        public final Builder setInitialOptions(Iterable<? extends OptionOrOptionGroup> elements) {
            this.initialOptions.clear();
            return this.addAllInitialOptions(elements);
        }

        public final Builder addAllInitialOptions(Iterable<? extends OptionOrOptionGroup> elements) {
            for (OptionOrOptionGroup optionOrOptionGroup : elements) {
                this.initialOptions.add(Objects.requireNonNull(optionOrOptionGroup, "initialOptions element"));
            }
            return this;
        }

        public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
            return this;
        }

        public final Builder setConfirmationDialog(Optional<? extends ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog.orElse(null);
            return this;
        }

        public ExternalMultiSelectMenu build() {
            this.checkRequiredAttributes();
            return new ExternalMultiSelectMenu(this.placeholder, this.actionId, this.minQueryLength, ExternalMultiSelectMenu.createUnmodifiableList(true, this.initialOptions), this.confirmationDialog);
        }

        private boolean placeholderIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.placeholderIsSet()) {
                attributes.add("placeholder");
            }
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            return "Cannot build ExternalMultiSelectMenu, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ExternalMultiSelectMenuIF", generator="Immutables")
    static final class Json
    implements ExternalMultiSelectMenuIF {
        @Nullable
        Text placeholder;
        @Nullable
        String actionId;
        @Nullable
        Optional<Integer> minQueryLength = Optional.empty();
        @Nullable
        List<OptionOrOptionGroup> initialOptions = Collections.emptyList();
        @Nullable
        Optional<ConfirmationDialog> confirmationDialog = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setPlaceholder(Text placeholder) {
            this.placeholder = placeholder;
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty
        public void setMinQueryLength(Optional<Integer> minQueryLength) {
            this.minQueryLength = minQueryLength;
        }

        @JsonProperty
        @JsonDeserialize(contentUsing=OptionOrOptionGroupDeserializer.class)
        public void setInitialOptions(List<OptionOrOptionGroup> initialOptions) {
            this.initialOptions = initialOptions;
        }

        @JsonProperty(value="confirm")
        public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getPlaceholder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getMinQueryLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<OptionOrOptionGroup> getInitialOptions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ConfirmationDialog> getConfirmationDialog() {
            throw new UnsupportedOperationException();
        }
    }
}

