/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.DatePickerIF;
import com.hubspot.slack.client.models.blocks.elements.HasActionId;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="DatePickerIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class DatePicker
implements DatePickerIF {
    private final transient String type;
    private final String actionId;
    @Nullable
    private final Text placeholder;
    @Nullable
    private final LocalDate initialDate;
    @Nullable
    private final ConfirmationDialog confirmationDialog;

    private DatePicker(String actionId) {
        this.actionId = Objects.requireNonNull(actionId, "actionId");
        this.placeholder = null;
        this.initialDate = null;
        this.confirmationDialog = null;
        this.type = Objects.requireNonNull(DatePickerIF.super.getType(), "type");
    }

    private DatePicker(String actionId, @Nullable Text placeholder, @Nullable LocalDate initialDate, @Nullable ConfirmationDialog confirmationDialog) {
        this.actionId = actionId;
        this.placeholder = placeholder;
        this.initialDate = initialDate;
        this.confirmationDialog = confirmationDialog;
        this.type = Objects.requireNonNull(DatePickerIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty
    public Optional<Text> getPlaceholder() {
        return Optional.ofNullable(this.placeholder);
    }

    @Override
    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    public Optional<LocalDate> getInitialDate() {
        return Optional.ofNullable(this.initialDate);
    }

    @Override
    @JsonProperty(value="confirm")
    public Optional<ConfirmationDialog> getConfirmationDialog() {
        return Optional.ofNullable(this.confirmationDialog);
    }

    public final DatePicker withActionId(String value) {
        String newValue = Objects.requireNonNull(value, "actionId");
        if (this.actionId.equals(newValue)) {
            return this;
        }
        return new DatePicker(newValue, this.placeholder, this.initialDate, this.confirmationDialog);
    }

    public final DatePicker withPlaceholder(@Nullable Text value) {
        Text newValue = value;
        if (this.placeholder == newValue) {
            return this;
        }
        return new DatePicker(this.actionId, newValue, this.initialDate, this.confirmationDialog);
    }

    public final DatePicker withPlaceholder(Optional<? extends Text> optional) {
        Text value = optional.orElse(null);
        if (this.placeholder == value) {
            return this;
        }
        return new DatePicker(this.actionId, value, this.initialDate, this.confirmationDialog);
    }

    public final DatePicker withInitialDate(@Nullable LocalDate value) {
        LocalDate newValue = value;
        if (this.initialDate == newValue) {
            return this;
        }
        return new DatePicker(this.actionId, this.placeholder, newValue, this.confirmationDialog);
    }

    public final DatePicker withInitialDate(Optional<? extends LocalDate> optional) {
        LocalDate value = optional.orElse(null);
        if (this.initialDate == value) {
            return this;
        }
        return new DatePicker(this.actionId, this.placeholder, value, this.confirmationDialog);
    }

    public final DatePicker withConfirmationDialog(@Nullable ConfirmationDialog value) {
        ConfirmationDialog newValue = value;
        if (this.confirmationDialog == newValue) {
            return this;
        }
        return new DatePicker(this.actionId, this.placeholder, this.initialDate, newValue);
    }

    public final DatePicker withConfirmationDialog(Optional<? extends ConfirmationDialog> optional) {
        ConfirmationDialog value = optional.orElse(null);
        if (this.confirmationDialog == value) {
            return this;
        }
        return new DatePicker(this.actionId, this.placeholder, this.initialDate, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DatePicker && this.equalTo(0, (DatePicker)another);
    }

    private boolean equalTo(int synthetic, DatePicker another) {
        return this.type.equals(another.type) && this.actionId.equals(another.actionId) && Objects.equals(this.placeholder, another.placeholder) && Objects.equals(this.initialDate, another.initialDate) && Objects.equals(this.confirmationDialog, another.confirmationDialog);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.actionId.hashCode();
        h += (h << 5) + Objects.hashCode(this.placeholder);
        h += (h << 5) + Objects.hashCode(this.initialDate);
        h += (h << 5) + Objects.hashCode(this.confirmationDialog);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DatePicker{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        if (this.placeholder != null) {
            builder.append(", ");
            builder.append("placeholder=").append(this.placeholder);
        }
        if (this.initialDate != null) {
            builder.append(", ");
            builder.append("initialDate=").append(this.initialDate);
        }
        if (this.confirmationDialog != null) {
            builder.append(", ");
            builder.append("confirmationDialog=").append(this.confirmationDialog);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static DatePicker fromJson(Json json) {
        Builder builder = DatePicker.builder();
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.placeholder != null) {
            builder.setPlaceholder(json.placeholder);
        }
        if (json.initialDate != null) {
            builder.setInitialDate(json.initialDate);
        }
        if (json.confirmationDialog != null) {
            builder.setConfirmationDialog(json.confirmationDialog);
        }
        return builder.build();
    }

    public static DatePicker of(String actionId) {
        return new DatePicker(actionId);
    }

    public static DatePicker copyOf(DatePickerIF instance) {
        if (instance instanceof DatePicker) {
            return (DatePicker)instance;
        }
        return DatePicker.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DatePickerIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACTION_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String actionId;
        @Nullable
        private Text placeholder;
        @Nullable
        private LocalDate initialDate;
        @Nullable
        private ConfirmationDialog confirmationDialog;

        private Builder() {
        }

        public final Builder from(DatePickerIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(HasActionId instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasActionId instance;
            long bits = 0L;
            if (object instanceof DatePickerIF) {
                Optional<LocalDate> initialDateOptional;
                Optional<Text> placeholderOptional;
                Optional<ConfirmationDialog> confirmationDialogOptional;
                instance = (DatePickerIF)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
                if ((confirmationDialogOptional = instance.getConfirmationDialog()).isPresent()) {
                    this.setConfirmationDialog(confirmationDialogOptional);
                }
                if ((placeholderOptional = instance.getPlaceholder()).isPresent()) {
                    this.setPlaceholder(placeholderOptional);
                }
                if ((initialDateOptional = instance.getInitialDate()).isPresent()) {
                    this.setInitialDate(initialDateOptional);
                }
            }
            if (object instanceof HasActionId) {
                instance = (HasActionId)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
            }
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setPlaceholder(@Nullable Text placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public final Builder setPlaceholder(Optional<? extends Text> placeholder) {
            this.placeholder = placeholder.orElse(null);
            return this;
        }

        public final Builder setInitialDate(@Nullable LocalDate initialDate) {
            this.initialDate = initialDate;
            return this;
        }

        public final Builder setInitialDate(Optional<? extends LocalDate> initialDate) {
            this.initialDate = initialDate.orElse(null);
            return this;
        }

        public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
            return this;
        }

        public final Builder setConfirmationDialog(Optional<? extends ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog.orElse(null);
            return this;
        }

        public DatePicker build() {
            this.checkRequiredAttributes();
            return new DatePicker(this.actionId, this.placeholder, this.initialDate, this.confirmationDialog);
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            return "Cannot build DatePicker, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DatePickerIF", generator="Immutables")
    static final class Json
    implements DatePickerIF {
        @Nullable
        String actionId;
        @Nullable
        Optional<Text> placeholder = Optional.empty();
        @Nullable
        Optional<LocalDate> initialDate = Optional.empty();
        @Nullable
        Optional<ConfirmationDialog> confirmationDialog = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty
        public void setPlaceholder(Optional<Text> placeholder) {
            this.placeholder = placeholder;
        }

        @JsonProperty
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
        public void setInitialDate(Optional<LocalDate> initialDate) {
            this.initialDate = initialDate;
        }

        @JsonProperty(value="confirm")
        public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Text> getPlaceholder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LocalDate> getInitialDate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ConfirmationDialog> getConfirmationDialog() {
            throw new UnsupportedOperationException();
        }
    }
}

