/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.ConversationsMultiSelectMenuIF;
import com.hubspot.slack.client.models.blocks.elements.HasActionId;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ConversationsMultiSelectMenuIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ConversationsMultiSelectMenu
implements ConversationsMultiSelectMenuIF {
    private final transient String type;
    private final Text placeholder;
    private final String actionId;
    private final List<String> initialChannelIds;
    @Nullable
    private final ConfirmationDialog confirmationDialog;

    private ConversationsMultiSelectMenu(Text placeholder, String actionId) {
        this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
        this.actionId = Objects.requireNonNull(actionId, "actionId");
        this.initialChannelIds = Collections.emptyList();
        this.confirmationDialog = null;
        this.type = Objects.requireNonNull(ConversationsMultiSelectMenuIF.super.getType(), "type");
    }

    private ConversationsMultiSelectMenu(Text placeholder, String actionId, List<String> initialChannelIds, @Nullable ConfirmationDialog confirmationDialog) {
        this.placeholder = placeholder;
        this.actionId = actionId;
        this.initialChannelIds = initialChannelIds;
        this.confirmationDialog = confirmationDialog;
        this.type = Objects.requireNonNull(ConversationsMultiSelectMenuIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Text getPlaceholder() {
        return this.placeholder;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty(value="initial_conversations")
    public List<String> getInitialChannelIds() {
        return this.initialChannelIds;
    }

    @Override
    @JsonProperty(value="confirm")
    public Optional<ConfirmationDialog> getConfirmationDialog() {
        return Optional.ofNullable(this.confirmationDialog);
    }

    public final ConversationsMultiSelectMenu withPlaceholder(Text value) {
        if (this.placeholder == value) {
            return this;
        }
        Text newValue = Objects.requireNonNull(value, "placeholder");
        return new ConversationsMultiSelectMenu(newValue, this.actionId, this.initialChannelIds, this.confirmationDialog);
    }

    public final ConversationsMultiSelectMenu withActionId(String value) {
        String newValue = Objects.requireNonNull(value, "actionId");
        if (this.actionId.equals(newValue)) {
            return this;
        }
        return new ConversationsMultiSelectMenu(this.placeholder, newValue, this.initialChannelIds, this.confirmationDialog);
    }

    public final ConversationsMultiSelectMenu withInitialChannelIds(String ... elements) {
        List<String> newValue = ConversationsMultiSelectMenu.createUnmodifiableList(false, ConversationsMultiSelectMenu.createSafeList(Arrays.asList(elements), true, false));
        return new ConversationsMultiSelectMenu(this.placeholder, this.actionId, newValue, this.confirmationDialog);
    }

    public final ConversationsMultiSelectMenu withInitialChannelIds(Iterable<String> elements) {
        if (this.initialChannelIds == elements) {
            return this;
        }
        List<String> newValue = ConversationsMultiSelectMenu.createUnmodifiableList(false, ConversationsMultiSelectMenu.createSafeList(elements, true, false));
        return new ConversationsMultiSelectMenu(this.placeholder, this.actionId, newValue, this.confirmationDialog);
    }

    public final ConversationsMultiSelectMenu withConfirmationDialog(@Nullable ConfirmationDialog value) {
        ConfirmationDialog newValue = value;
        if (this.confirmationDialog == newValue) {
            return this;
        }
        return new ConversationsMultiSelectMenu(this.placeholder, this.actionId, this.initialChannelIds, newValue);
    }

    public final ConversationsMultiSelectMenu withConfirmationDialog(Optional<? extends ConfirmationDialog> optional) {
        ConfirmationDialog value = optional.orElse(null);
        if (this.confirmationDialog == value) {
            return this;
        }
        return new ConversationsMultiSelectMenu(this.placeholder, this.actionId, this.initialChannelIds, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationsMultiSelectMenu && this.equalTo(0, (ConversationsMultiSelectMenu)another);
    }

    private boolean equalTo(int synthetic, ConversationsMultiSelectMenu another) {
        return this.type.equals(another.type) && this.placeholder.equals(another.placeholder) && this.actionId.equals(another.actionId) && this.initialChannelIds.equals(another.initialChannelIds) && Objects.equals(this.confirmationDialog, another.confirmationDialog);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.placeholder.hashCode();
        h += (h << 5) + this.actionId.hashCode();
        h += (h << 5) + this.initialChannelIds.hashCode();
        h += (h << 5) + Objects.hashCode(this.confirmationDialog);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ConversationsMultiSelectMenu{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("placeholder=").append(this.placeholder);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        builder.append(", ");
        builder.append("initialChannelIds=").append(this.initialChannelIds);
        if (this.confirmationDialog != null) {
            builder.append(", ");
            builder.append("confirmationDialog=").append(this.confirmationDialog);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ConversationsMultiSelectMenu fromJson(Json json) {
        Builder builder = ConversationsMultiSelectMenu.builder();
        if (json.placeholder != null) {
            builder.setPlaceholder(json.placeholder);
        }
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.initialChannelIds != null) {
            builder.addAllInitialChannelIds(json.initialChannelIds);
        }
        if (json.confirmationDialog != null) {
            builder.setConfirmationDialog(json.confirmationDialog);
        }
        return builder.build();
    }

    public static ConversationsMultiSelectMenu of(Text placeholder, String actionId) {
        return new ConversationsMultiSelectMenu(placeholder, actionId);
    }

    public static ConversationsMultiSelectMenu copyOf(ConversationsMultiSelectMenuIF instance) {
        if (instance instanceof ConversationsMultiSelectMenu) {
            return (ConversationsMultiSelectMenu)instance;
        }
        return ConversationsMultiSelectMenu.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ConversationsMultiSelectMenuIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PLACEHOLDER = 1L;
        private static final long INIT_BIT_ACTION_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private Text placeholder;
        @Nullable
        private String actionId;
        private List<String> initialChannelIds = new ArrayList<String>();
        @Nullable
        private ConfirmationDialog confirmationDialog;

        private Builder() {
        }

        public final Builder from(HasActionId instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ConversationsMultiSelectMenuIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasActionId instance;
            long bits = 0L;
            if (object instanceof HasActionId) {
                instance = (HasActionId)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
            }
            if (object instanceof ConversationsMultiSelectMenuIF) {
                instance = (ConversationsMultiSelectMenuIF)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
                this.addAllInitialChannelIds(instance.getInitialChannelIds());
                Optional<ConfirmationDialog> confirmationDialogOptional = instance.getConfirmationDialog();
                if (confirmationDialogOptional.isPresent()) {
                    this.setConfirmationDialog(confirmationDialogOptional);
                }
                this.setPlaceholder(instance.getPlaceholder());
            }
        }

        public final Builder setPlaceholder(Text placeholder) {
            this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addInitialChannelIds(String element) {
            this.initialChannelIds.add(Objects.requireNonNull(element, "initialChannelIds element"));
            return this;
        }

        public final Builder addInitialChannelIds(String ... elements) {
            for (String element : elements) {
                this.initialChannelIds.add(Objects.requireNonNull(element, "initialChannelIds element"));
            }
            return this;
        }

        public final Builder setInitialChannelIds(Iterable<String> elements) {
            this.initialChannelIds.clear();
            return this.addAllInitialChannelIds(elements);
        }

        public final Builder addAllInitialChannelIds(Iterable<String> elements) {
            for (String element : elements) {
                this.initialChannelIds.add(Objects.requireNonNull(element, "initialChannelIds element"));
            }
            return this;
        }

        public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
            return this;
        }

        public final Builder setConfirmationDialog(Optional<? extends ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog.orElse(null);
            return this;
        }

        public ConversationsMultiSelectMenu build() {
            this.checkRequiredAttributes();
            return new ConversationsMultiSelectMenu(this.placeholder, this.actionId, ConversationsMultiSelectMenu.createUnmodifiableList(true, this.initialChannelIds), this.confirmationDialog);
        }

        private boolean placeholderIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.placeholderIsSet()) {
                attributes.add("placeholder");
            }
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            return "Cannot build ConversationsMultiSelectMenu, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConversationsMultiSelectMenuIF", generator="Immutables")
    static final class Json
    implements ConversationsMultiSelectMenuIF {
        @Nullable
        Text placeholder;
        @Nullable
        String actionId;
        @Nullable
        List<String> initialChannelIds = Collections.emptyList();
        @Nullable
        Optional<ConfirmationDialog> confirmationDialog = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setPlaceholder(Text placeholder) {
            this.placeholder = placeholder;
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty(value="initial_conversations")
        public void setInitialChannelIds(List<String> initialChannelIds) {
            this.initialChannelIds = initialChannelIds;
        }

        @JsonProperty(value="confirm")
        public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getPlaceholder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getInitialChannelIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ConfirmationDialog> getConfirmationDialog() {
            throw new UnsupportedOperationException();
        }
    }
}

