/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.ButtonIF;
import com.hubspot.slack.client.models.blocks.elements.HasActionId;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ButtonIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Button
implements ButtonIF {
    private final transient String type;
    private final Text text;
    private final String actionId;
    @Nullable
    private final String url;
    @Nullable
    private final String value;
    @Nullable
    private final String style;
    @Nullable
    private final ConfirmationDialog confirmationDialog;

    private Button(Text text, String actionId) {
        this.text = Objects.requireNonNull(text, "text");
        this.actionId = Objects.requireNonNull(actionId, "actionId");
        this.url = null;
        this.value = null;
        this.style = null;
        this.confirmationDialog = null;
        this.type = Objects.requireNonNull(ButtonIF.super.getType(), "type");
    }

    private Button(Text text, String actionId, @Nullable String url, @Nullable String value, @Nullable String style, @Nullable ConfirmationDialog confirmationDialog) {
        this.text = text;
        this.actionId = actionId;
        this.url = url;
        this.value = value;
        this.style = style;
        this.confirmationDialog = confirmationDialog;
        this.type = Objects.requireNonNull(ButtonIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Text getText() {
        return this.text;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty
    public Optional<String> getUrl() {
        return Optional.ofNullable(this.url);
    }

    @Override
    @JsonProperty
    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    @JsonProperty
    public Optional<String> getStyle() {
        return Optional.ofNullable(this.style);
    }

    @Override
    @JsonProperty(value="confirm")
    public Optional<ConfirmationDialog> getConfirmationDialog() {
        return Optional.ofNullable(this.confirmationDialog);
    }

    public final Button withText(Text value) {
        if (this.text == value) {
            return this;
        }
        Text newValue = Objects.requireNonNull(value, "text");
        return new Button(newValue, this.actionId, this.url, this.value, this.style, this.confirmationDialog);
    }

    public final Button withActionId(String value) {
        String newValue = Objects.requireNonNull(value, "actionId");
        if (this.actionId.equals(newValue)) {
            return this;
        }
        return new Button(this.text, newValue, this.url, this.value, this.style, this.confirmationDialog);
    }

    public final Button withUrl(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.url, newValue)) {
            return this;
        }
        return new Button(this.text, this.actionId, newValue, this.value, this.style, this.confirmationDialog);
    }

    public final Button withUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.url, value)) {
            return this;
        }
        return new Button(this.text, this.actionId, value, this.value, this.style, this.confirmationDialog);
    }

    public final Button withValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.value, newValue)) {
            return this;
        }
        return new Button(this.text, this.actionId, this.url, newValue, this.style, this.confirmationDialog);
    }

    public final Button withValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.value, value)) {
            return this;
        }
        return new Button(this.text, this.actionId, this.url, value, this.style, this.confirmationDialog);
    }

    public final Button withStyle(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.style, newValue)) {
            return this;
        }
        return new Button(this.text, this.actionId, this.url, this.value, newValue, this.confirmationDialog);
    }

    public final Button withStyle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.style, value)) {
            return this;
        }
        return new Button(this.text, this.actionId, this.url, this.value, value, this.confirmationDialog);
    }

    public final Button withConfirmationDialog(@Nullable ConfirmationDialog value) {
        ConfirmationDialog newValue = value;
        if (this.confirmationDialog == newValue) {
            return this;
        }
        return new Button(this.text, this.actionId, this.url, this.value, this.style, newValue);
    }

    public final Button withConfirmationDialog(Optional<? extends ConfirmationDialog> optional) {
        ConfirmationDialog value = optional.orElse(null);
        if (this.confirmationDialog == value) {
            return this;
        }
        return new Button(this.text, this.actionId, this.url, this.value, this.style, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Button && this.equalTo(0, (Button)another);
    }

    private boolean equalTo(int synthetic, Button another) {
        return this.type.equals(another.type) && this.text.equals(another.text) && this.actionId.equals(another.actionId) && Objects.equals(this.url, another.url) && Objects.equals(this.value, another.value) && Objects.equals(this.style, another.style) && Objects.equals(this.confirmationDialog, another.confirmationDialog);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.actionId.hashCode();
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + Objects.hashCode(this.style);
        h += (h << 5) + Objects.hashCode(this.confirmationDialog);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Button{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("text=").append(this.text);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        if (this.url != null) {
            builder.append(", ");
            builder.append("url=").append(this.url);
        }
        if (this.value != null) {
            builder.append(", ");
            builder.append("value=").append(this.value);
        }
        if (this.style != null) {
            builder.append(", ");
            builder.append("style=").append(this.style);
        }
        if (this.confirmationDialog != null) {
            builder.append(", ");
            builder.append("confirmationDialog=").append(this.confirmationDialog);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Button fromJson(Json json) {
        Builder builder = Button.builder();
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.url != null) {
            builder.setUrl(json.url);
        }
        if (json.value != null) {
            builder.setValue(json.value);
        }
        if (json.style != null) {
            builder.setStyle(json.style);
        }
        if (json.confirmationDialog != null) {
            builder.setConfirmationDialog(json.confirmationDialog);
        }
        return builder.build();
    }

    public static Button of(Text text, String actionId) {
        return new Button(text, actionId);
    }

    public static Button copyOf(ButtonIF instance) {
        if (instance instanceof Button) {
            return (Button)instance;
        }
        return Button.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ButtonIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long INIT_BIT_ACTION_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private Text text;
        @Nullable
        private String actionId;
        @Nullable
        private String url;
        @Nullable
        private String value;
        @Nullable
        private String style;
        @Nullable
        private ConfirmationDialog confirmationDialog;

        private Builder() {
        }

        public final Builder from(HasActionId instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ButtonIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasActionId instance;
            long bits = 0L;
            if (object instanceof HasActionId) {
                instance = (HasActionId)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
            }
            if (object instanceof ButtonIF) {
                Optional<String> urlOptional;
                Optional<ConfirmationDialog> confirmationDialogOptional;
                Optional<String> styleOptional;
                instance = (ButtonIF)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
                if ((styleOptional = instance.getStyle()).isPresent()) {
                    this.setStyle(styleOptional);
                }
                if ((confirmationDialogOptional = instance.getConfirmationDialog()).isPresent()) {
                    this.setConfirmationDialog(confirmationDialogOptional);
                }
                this.setText(instance.getText());
                Optional<String> valueOptional = instance.getValue();
                if (valueOptional.isPresent()) {
                    this.setValue(valueOptional);
                }
                if ((urlOptional = instance.getUrl()).isPresent()) {
                    this.setUrl(urlOptional);
                }
            }
        }

        public final Builder setText(Text text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setUrl(@Nullable String url) {
            this.url = url;
            return this;
        }

        public final Builder setUrl(Optional<String> url) {
            this.url = url.orElse(null);
            return this;
        }

        public final Builder setValue(@Nullable String value) {
            this.value = value;
            return this;
        }

        public final Builder setValue(Optional<String> value) {
            this.value = value.orElse(null);
            return this;
        }

        public final Builder setStyle(@Nullable String style) {
            this.style = style;
            return this;
        }

        public final Builder setStyle(Optional<String> style) {
            this.style = style.orElse(null);
            return this;
        }

        public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
            return this;
        }

        public final Builder setConfirmationDialog(Optional<? extends ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog.orElse(null);
            return this;
        }

        public Button build() {
            this.checkRequiredAttributes();
            return new Button(this.text, this.actionId, this.url, this.value, this.style, this.confirmationDialog);
        }

        private boolean textIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.textIsSet()) {
                attributes.add("text");
            }
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            return "Cannot build Button, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ButtonIF", generator="Immutables")
    static final class Json
    implements ButtonIF {
        @Nullable
        Text text;
        @Nullable
        String actionId;
        @Nullable
        Optional<String> url = Optional.empty();
        @Nullable
        Optional<String> value = Optional.empty();
        @Nullable
        Optional<String> style = Optional.empty();
        @Nullable
        Optional<ConfirmationDialog> confirmationDialog = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setText(Text text) {
            this.text = text;
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty
        public void setUrl(Optional<String> url) {
            this.url = url;
        }

        @JsonProperty
        public void setValue(Optional<String> value) {
            this.value = value;
        }

        @JsonProperty
        public void setStyle(Optional<String> style) {
            this.style = style;
        }

        @JsonProperty(value="confirm")
        public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getStyle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ConfirmationDialog> getConfirmationDialog() {
            throw new UnsupportedOperationException();
        }
    }
}

