/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.InputIF;
import com.hubspot.slack.client.models.blocks.elements.BlockElement;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="InputIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Input
implements InputIF {
    @Nullable
    private final String blockId;
    private final transient String type;
    private final Text label;
    private final BlockElement element;
    @Nullable
    private final Text hint;
    @Nullable
    private final Boolean optional;
    @Nullable
    private final Boolean dispatchAction;

    private Input(Text label, BlockElement element) {
        this.label = Objects.requireNonNull(label, "label");
        this.element = Objects.requireNonNull(element, "element");
        this.blockId = null;
        this.hint = null;
        this.optional = null;
        this.dispatchAction = null;
        this.type = Objects.requireNonNull(InputIF.super.getType(), "type");
    }

    private Input(@Nullable String blockId, Text label, BlockElement element, @Nullable Text hint, @Nullable Boolean optional, @Nullable Boolean dispatchAction) {
        this.blockId = blockId;
        this.label = label;
        this.element = element;
        this.hint = hint;
        this.optional = optional;
        this.dispatchAction = dispatchAction;
        this.type = Objects.requireNonNull(InputIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public Optional<String> getBlockId() {
        return Optional.ofNullable(this.blockId);
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Text getLabel() {
        return this.label;
    }

    @Override
    @JsonProperty
    public BlockElement getElement() {
        return this.element;
    }

    @Override
    @JsonProperty
    public Optional<Text> getHint() {
        return Optional.ofNullable(this.hint);
    }

    @Override
    @JsonProperty(value="optional")
    public Optional<Boolean> isOptional() {
        return Optional.ofNullable(this.optional);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getDispatchAction() {
        return Optional.ofNullable(this.dispatchAction);
    }

    public final Input withBlockId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.blockId, newValue)) {
            return this;
        }
        return Input.validate(new Input(newValue, this.label, this.element, this.hint, this.optional, this.dispatchAction));
    }

    public final Input withBlockId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.blockId, value)) {
            return this;
        }
        return Input.validate(new Input(value, this.label, this.element, this.hint, this.optional, this.dispatchAction));
    }

    public final Input withLabel(Text value) {
        if (this.label == value) {
            return this;
        }
        Text newValue = Objects.requireNonNull(value, "label");
        return Input.validate(new Input(this.blockId, newValue, this.element, this.hint, this.optional, this.dispatchAction));
    }

    public final Input withElement(BlockElement value) {
        if (this.element == value) {
            return this;
        }
        BlockElement newValue = Objects.requireNonNull(value, "element");
        return Input.validate(new Input(this.blockId, this.label, newValue, this.hint, this.optional, this.dispatchAction));
    }

    public final Input withHint(@Nullable Text value) {
        Text newValue = value;
        if (this.hint == newValue) {
            return this;
        }
        return Input.validate(new Input(this.blockId, this.label, this.element, newValue, this.optional, this.dispatchAction));
    }

    public final Input withHint(Optional<? extends Text> optional) {
        Text value = optional.orElse(null);
        if (this.hint == value) {
            return this;
        }
        return Input.validate(new Input(this.blockId, this.label, this.element, value, this.optional, this.dispatchAction));
    }

    public final Input withOptional(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.optional, newValue)) {
            return this;
        }
        return Input.validate(new Input(this.blockId, this.label, this.element, this.hint, newValue, this.dispatchAction));
    }

    public final Input withOptional(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.optional, value)) {
            return this;
        }
        return Input.validate(new Input(this.blockId, this.label, this.element, this.hint, value, this.dispatchAction));
    }

    public final Input withDispatchAction(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.dispatchAction, newValue)) {
            return this;
        }
        return Input.validate(new Input(this.blockId, this.label, this.element, this.hint, this.optional, newValue));
    }

    public final Input withDispatchAction(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.dispatchAction, value)) {
            return this;
        }
        return Input.validate(new Input(this.blockId, this.label, this.element, this.hint, this.optional, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Input && this.equalTo(0, (Input)another);
    }

    private boolean equalTo(int synthetic, Input another) {
        return Objects.equals(this.blockId, another.blockId) && this.type.equals(another.type) && this.label.equals(another.label) && this.element.equals(another.element) && Objects.equals(this.hint, another.hint) && Objects.equals(this.optional, another.optional) && Objects.equals(this.dispatchAction, another.dispatchAction);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.blockId);
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.element.hashCode();
        h += (h << 5) + Objects.hashCode(this.hint);
        h += (h << 5) + Objects.hashCode(this.optional);
        h += (h << 5) + Objects.hashCode(this.dispatchAction);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Input{");
        if (this.blockId != null) {
            builder.append("blockId=").append(this.blockId);
        }
        if (builder.length() > 6) {
            builder.append(", ");
        }
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("label=").append(this.label);
        builder.append(", ");
        builder.append("element=").append(this.element);
        if (this.hint != null) {
            builder.append(", ");
            builder.append("hint=").append(this.hint);
        }
        if (this.optional != null) {
            builder.append(", ");
            builder.append("optional=").append(this.optional);
        }
        if (this.dispatchAction != null) {
            builder.append(", ");
            builder.append("dispatchAction=").append(this.dispatchAction);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Input fromJson(Json json) {
        Builder builder = Input.builder();
        if (json.blockId != null) {
            builder.setBlockId(json.blockId);
        }
        if (json.label != null) {
            builder.setLabel(json.label);
        }
        if (json.element != null) {
            builder.setElement(json.element);
        }
        if (json.hint != null) {
            builder.setHint(json.hint);
        }
        if (json.optional != null) {
            builder.setOptional(json.optional);
        }
        if (json.dispatchAction != null) {
            builder.setDispatchAction(json.dispatchAction);
        }
        return builder.build();
    }

    public static Input of(Text label, BlockElement element) {
        return Input.validate(new Input(label, element));
    }

    private static Input validate(Input instance) {
        instance = (Input)instance.validate();
        return instance;
    }

    public static Input copyOf(InputIF instance) {
        if (instance instanceof Input) {
            return (Input)instance;
        }
        return Input.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InputIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LABEL = 1L;
        private static final long INIT_BIT_ELEMENT = 2L;
        private long initBits = 3L;
        @Nullable
        private String blockId;
        @Nullable
        private Text label;
        @Nullable
        private BlockElement element;
        @Nullable
        private Text hint;
        @Nullable
        private Boolean optional;
        @Nullable
        private Boolean dispatchAction;

        private Builder() {
        }

        public final Builder from(InputIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Block instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> blockIdOptional;
            Block instance;
            long bits = 0L;
            if (object instanceof InputIF) {
                Optional<Boolean> dispatchActionOptional;
                Optional<Boolean> optionalOptional;
                instance = (InputIF)object;
                if ((bits & 1L) == 0L) {
                    blockIdOptional = instance.getBlockId();
                    if (blockIdOptional.isPresent()) {
                        this.setBlockId(blockIdOptional);
                    }
                    bits |= 1L;
                }
                if ((optionalOptional = instance.isOptional()).isPresent()) {
                    this.setOptional(optionalOptional);
                }
                if ((dispatchActionOptional = instance.getDispatchAction()).isPresent()) {
                    this.setDispatchAction(dispatchActionOptional);
                }
                this.setLabel(instance.getLabel());
                Optional<Text> hintOptional = instance.getHint();
                if (hintOptional.isPresent()) {
                    this.setHint(hintOptional);
                }
                this.setElement(instance.getElement());
            }
            if (object instanceof Block) {
                instance = (Block)object;
                if ((bits & 1L) == 0L) {
                    blockIdOptional = instance.getBlockId();
                    if (blockIdOptional.isPresent()) {
                        this.setBlockId(blockIdOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setBlockId(@Nullable String blockId) {
            this.blockId = blockId;
            return this;
        }

        public final Builder setBlockId(Optional<String> blockId) {
            this.blockId = blockId.orElse(null);
            return this;
        }

        public final Builder setLabel(Text label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setElement(BlockElement element) {
            this.element = Objects.requireNonNull(element, "element");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setHint(@Nullable Text hint) {
            this.hint = hint;
            return this;
        }

        public final Builder setHint(Optional<? extends Text> hint) {
            this.hint = hint.orElse(null);
            return this;
        }

        public final Builder setOptional(@Nullable Boolean optional) {
            this.optional = optional;
            return this;
        }

        public final Builder setOptional(Optional<Boolean> optional) {
            this.optional = optional.orElse(null);
            return this;
        }

        public final Builder setDispatchAction(@Nullable Boolean dispatchAction) {
            this.dispatchAction = dispatchAction;
            return this;
        }

        public final Builder setDispatchAction(Optional<Boolean> dispatchAction) {
            this.dispatchAction = dispatchAction.orElse(null);
            return this;
        }

        public Input build() {
            this.checkRequiredAttributes();
            return Input.validate(new Input(this.blockId, this.label, this.element, this.hint, this.optional, this.dispatchAction));
        }

        private boolean labelIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean elementIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.labelIsSet()) {
                attributes.add("label");
            }
            if (!this.elementIsSet()) {
                attributes.add("element");
            }
            return "Cannot build Input, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="InputIF", generator="Immutables")
    static final class Json
    implements InputIF {
        @Nullable
        Optional<String> blockId = Optional.empty();
        @Nullable
        Text label;
        @Nullable
        BlockElement element;
        @Nullable
        Optional<Text> hint = Optional.empty();
        @Nullable
        Optional<Boolean> optional = Optional.empty();
        @Nullable
        Optional<Boolean> dispatchAction = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setBlockId(Optional<String> blockId) {
            this.blockId = blockId;
        }

        @JsonProperty
        public void setLabel(Text label) {
            this.label = label;
        }

        @JsonProperty
        public void setElement(BlockElement element) {
            this.element = element;
        }

        @JsonProperty
        public void setHint(Optional<Text> hint) {
            this.hint = hint;
        }

        @JsonProperty(value="optional")
        public void setOptional(Optional<Boolean> optional) {
            this.optional = optional;
        }

        @JsonProperty
        public void setDispatchAction(Optional<Boolean> dispatchAction) {
            this.dispatchAction = dispatchAction;
        }

        @Override
        public Optional<String> getBlockId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BlockElement getElement() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Text> getHint() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isOptional() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getDispatchAction() {
            throw new UnsupportedOperationException();
        }
    }
}

