/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.ImageIF;
import com.hubspot.slack.client.models.blocks.SlackFileObject;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ImageIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Image
implements ImageIF {
    @Nullable
    private final String blockId;
    private final transient String type;
    @Nullable
    private final String imageUrl;
    private final String altText;
    @Nullable
    private final Text title;
    @Nullable
    private final SlackFileObject slackFile;

    private Image(Optional<String> imageUrl, String altText) {
        this.imageUrl = imageUrl.orElse(null);
        this.altText = Objects.requireNonNull(altText, "altText");
        this.blockId = null;
        this.title = null;
        this.slackFile = null;
        this.type = Objects.requireNonNull(ImageIF.super.getType(), "type");
    }

    private Image(@Nullable String imageUrl, String altText) {
        this.imageUrl = imageUrl;
        this.altText = Objects.requireNonNull(altText, "altText");
        this.blockId = null;
        this.title = null;
        this.slackFile = null;
        this.type = Objects.requireNonNull(ImageIF.super.getType(), "type");
    }

    private Image(@Nullable String blockId, @Nullable String imageUrl, String altText, @Nullable Text title, @Nullable SlackFileObject slackFile) {
        this.blockId = blockId;
        this.imageUrl = imageUrl;
        this.altText = altText;
        this.title = title;
        this.slackFile = slackFile;
        this.type = Objects.requireNonNull(ImageIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public Optional<String> getBlockId() {
        return Optional.ofNullable(this.blockId);
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Optional<String> getImageUrl() {
        return Optional.ofNullable(this.imageUrl);
    }

    @Override
    @JsonProperty
    public String getAltText() {
        return this.altText;
    }

    @Override
    @JsonProperty
    public Optional<Text> getTitle() {
        return Optional.ofNullable(this.title);
    }

    @Override
    @JsonProperty
    public Optional<SlackFileObject> getSlackFile() {
        return Optional.ofNullable(this.slackFile);
    }

    public final Image withBlockId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.blockId, newValue)) {
            return this;
        }
        return new Image(newValue, this.imageUrl, this.altText, this.title, this.slackFile);
    }

    public final Image withBlockId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.blockId, value)) {
            return this;
        }
        return new Image(value, this.imageUrl, this.altText, this.title, this.slackFile);
    }

    public final Image withImageUrl(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.imageUrl, newValue)) {
            return this;
        }
        return new Image(this.blockId, newValue, this.altText, this.title, this.slackFile);
    }

    public final Image withImageUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.imageUrl, value)) {
            return this;
        }
        return new Image(this.blockId, value, this.altText, this.title, this.slackFile);
    }

    public final Image withAltText(String value) {
        String newValue = Objects.requireNonNull(value, "altText");
        if (this.altText.equals(newValue)) {
            return this;
        }
        return new Image(this.blockId, this.imageUrl, newValue, this.title, this.slackFile);
    }

    public final Image withTitle(@Nullable Text value) {
        Text newValue = value;
        if (this.title == newValue) {
            return this;
        }
        return new Image(this.blockId, this.imageUrl, this.altText, newValue, this.slackFile);
    }

    public final Image withTitle(Optional<? extends Text> optional) {
        Text value = optional.orElse(null);
        if (this.title == value) {
            return this;
        }
        return new Image(this.blockId, this.imageUrl, this.altText, value, this.slackFile);
    }

    public final Image withSlackFile(@Nullable SlackFileObject value) {
        SlackFileObject newValue = value;
        if (this.slackFile == newValue) {
            return this;
        }
        return new Image(this.blockId, this.imageUrl, this.altText, this.title, newValue);
    }

    public final Image withSlackFile(Optional<? extends SlackFileObject> optional) {
        SlackFileObject value = optional.orElse(null);
        if (this.slackFile == value) {
            return this;
        }
        return new Image(this.blockId, this.imageUrl, this.altText, this.title, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Image && this.equalTo(0, (Image)another);
    }

    private boolean equalTo(int synthetic, Image another) {
        return Objects.equals(this.blockId, another.blockId) && this.type.equals(another.type) && Objects.equals(this.imageUrl, another.imageUrl) && this.altText.equals(another.altText) && Objects.equals(this.title, another.title) && Objects.equals(this.slackFile, another.slackFile);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.blockId);
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.imageUrl);
        h += (h << 5) + this.altText.hashCode();
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.slackFile);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Image{");
        if (this.blockId != null) {
            builder.append("blockId=").append(this.blockId);
        }
        if (builder.length() > 6) {
            builder.append(", ");
        }
        builder.append("type=").append(this.type);
        if (this.imageUrl != null) {
            builder.append(", ");
            builder.append("imageUrl=").append(this.imageUrl);
        }
        builder.append(", ");
        builder.append("altText=").append(this.altText);
        if (this.title != null) {
            builder.append(", ");
            builder.append("title=").append(this.title);
        }
        if (this.slackFile != null) {
            builder.append(", ");
            builder.append("slackFile=").append(this.slackFile);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Image fromJson(Json json) {
        Builder builder = Image.builder();
        if (json.blockId != null) {
            builder.setBlockId(json.blockId);
        }
        if (json.imageUrl != null) {
            builder.setImageUrl(json.imageUrl);
        }
        if (json.altText != null) {
            builder.setAltText(json.altText);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.slackFile != null) {
            builder.setSlackFile(json.slackFile);
        }
        return builder.build();
    }

    public static Image of(Optional<String> imageUrl, String altText) {
        return new Image(imageUrl, altText);
    }

    public static Image of(@Nullable String imageUrl, String altText) {
        return new Image(imageUrl, altText);
    }

    public static Image copyOf(ImageIF instance) {
        if (instance instanceof Image) {
            return (Image)instance;
        }
        return Image.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ImageIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ALT_TEXT = 1L;
        private long initBits = 1L;
        @Nullable
        private String blockId;
        @Nullable
        private String imageUrl;
        @Nullable
        private String altText;
        @Nullable
        private Text title;
        @Nullable
        private SlackFileObject slackFile;

        private Builder() {
        }

        public final Builder from(ImageIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Block instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> blockIdOptional;
            Block instance;
            long bits = 0L;
            if (object instanceof ImageIF) {
                Optional<String> imageUrlOptional;
                Optional<SlackFileObject> slackFileOptional;
                instance = (ImageIF)object;
                if ((bits & 1L) == 0L) {
                    blockIdOptional = instance.getBlockId();
                    if (blockIdOptional.isPresent()) {
                        this.setBlockId(blockIdOptional);
                    }
                    bits |= 1L;
                }
                if ((slackFileOptional = instance.getSlackFile()).isPresent()) {
                    this.setSlackFile(slackFileOptional);
                }
                this.setAltText(instance.getAltText());
                Optional<Text> titleOptional = instance.getTitle();
                if (titleOptional.isPresent()) {
                    this.setTitle(titleOptional);
                }
                if ((imageUrlOptional = instance.getImageUrl()).isPresent()) {
                    this.setImageUrl(imageUrlOptional);
                }
            }
            if (object instanceof Block) {
                instance = (Block)object;
                if ((bits & 1L) == 0L) {
                    blockIdOptional = instance.getBlockId();
                    if (blockIdOptional.isPresent()) {
                        this.setBlockId(blockIdOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setBlockId(@Nullable String blockId) {
            this.blockId = blockId;
            return this;
        }

        public final Builder setBlockId(Optional<String> blockId) {
            this.blockId = blockId.orElse(null);
            return this;
        }

        public final Builder setImageUrl(@Nullable String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final Builder setImageUrl(Optional<String> imageUrl) {
            this.imageUrl = imageUrl.orElse(null);
            return this;
        }

        public final Builder setAltText(String altText) {
            this.altText = Objects.requireNonNull(altText, "altText");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setTitle(@Nullable Text title) {
            this.title = title;
            return this;
        }

        public final Builder setTitle(Optional<? extends Text> title) {
            this.title = title.orElse(null);
            return this;
        }

        public final Builder setSlackFile(@Nullable SlackFileObject slackFile) {
            this.slackFile = slackFile;
            return this;
        }

        public final Builder setSlackFile(Optional<? extends SlackFileObject> slackFile) {
            this.slackFile = slackFile.orElse(null);
            return this;
        }

        public Image build() {
            this.checkRequiredAttributes();
            return new Image(this.blockId, this.imageUrl, this.altText, this.title, this.slackFile);
        }

        private boolean altTextIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.altTextIsSet()) {
                attributes.add("altText");
            }
            return "Cannot build Image, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ImageIF", generator="Immutables")
    static final class Json
    implements ImageIF {
        @Nullable
        Optional<String> blockId = Optional.empty();
        @Nullable
        Optional<String> imageUrl = Optional.empty();
        @Nullable
        String altText;
        @Nullable
        Optional<Text> title = Optional.empty();
        @Nullable
        Optional<SlackFileObject> slackFile = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setBlockId(Optional<String> blockId) {
            this.blockId = blockId;
        }

        @JsonProperty
        public void setImageUrl(Optional<String> imageUrl) {
            this.imageUrl = imageUrl;
        }

        @JsonProperty
        public void setAltText(String altText) {
            this.altText = altText;
        }

        @JsonProperty
        public void setTitle(Optional<Text> title) {
            this.title = title;
        }

        @JsonProperty
        public void setSlackFile(Optional<SlackFileObject> slackFile) {
            this.slackFile = slackFile;
        }

        @Override
        public Optional<String> getBlockId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getImageUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAltText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Text> getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SlackFileObject> getSlackFile() {
            throw new UnsupportedOperationException();
        }
    }
}

