/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.FileIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FileIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class File
implements FileIF {
    @Nullable
    private final String blockId;
    private final transient String type;
    private final String externalId;
    private final String source;

    private File(String externalId, String source) {
        this.externalId = Objects.requireNonNull(externalId, "externalId");
        this.source = Objects.requireNonNull(source, "source");
        this.blockId = null;
        this.type = Objects.requireNonNull(FileIF.super.getType(), "type");
    }

    private File(@Nullable String blockId, String externalId, String source) {
        this.blockId = blockId;
        this.externalId = externalId;
        this.source = source;
        this.type = Objects.requireNonNull(FileIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public Optional<String> getBlockId() {
        return Optional.ofNullable(this.blockId);
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    @JsonProperty
    public String getSource() {
        return this.source;
    }

    public final File withBlockId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.blockId, newValue)) {
            return this;
        }
        return new File(newValue, this.externalId, this.source);
    }

    public final File withBlockId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.blockId, value)) {
            return this;
        }
        return new File(value, this.externalId, this.source);
    }

    public final File withExternalId(String value) {
        String newValue = Objects.requireNonNull(value, "externalId");
        if (this.externalId.equals(newValue)) {
            return this;
        }
        return new File(this.blockId, newValue, this.source);
    }

    public final File withSource(String value) {
        String newValue = Objects.requireNonNull(value, "source");
        if (this.source.equals(newValue)) {
            return this;
        }
        return new File(this.blockId, this.externalId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof File && this.equalTo(0, (File)another);
    }

    private boolean equalTo(int synthetic, File another) {
        return Objects.equals(this.blockId, another.blockId) && this.type.equals(another.type) && this.externalId.equals(another.externalId) && this.source.equals(another.source);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.blockId);
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.externalId.hashCode();
        h += (h << 5) + this.source.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("File{");
        if (this.blockId != null) {
            builder.append("blockId=").append(this.blockId);
        }
        if (builder.length() > 5) {
            builder.append(", ");
        }
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("externalId=").append(this.externalId);
        builder.append(", ");
        builder.append("source=").append(this.source);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static File fromJson(Json json) {
        Builder builder = File.builder();
        if (json.blockId != null) {
            builder.setBlockId(json.blockId);
        }
        if (json.externalId != null) {
            builder.setExternalId(json.externalId);
        }
        if (json.source != null) {
            builder.setSource(json.source);
        }
        return builder.build();
    }

    public static File of(String externalId, String source) {
        return new File(externalId, source);
    }

    public static File copyOf(FileIF instance) {
        if (instance instanceof File) {
            return (File)instance;
        }
        return File.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FileIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EXTERNAL_ID = 1L;
        private static final long INIT_BIT_SOURCE = 2L;
        private long initBits = 3L;
        @Nullable
        private String blockId;
        @Nullable
        private String externalId;
        @Nullable
        private String source;

        private Builder() {
        }

        public final Builder from(FileIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Block instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> blockIdOptional;
            Block instance;
            long bits = 0L;
            if (object instanceof FileIF) {
                instance = (FileIF)object;
                if ((bits & 1L) == 0L) {
                    blockIdOptional = instance.getBlockId();
                    if (blockIdOptional.isPresent()) {
                        this.setBlockId(blockIdOptional);
                    }
                    bits |= 1L;
                }
                this.setExternalId(instance.getExternalId());
                this.setSource(instance.getSource());
            }
            if (object instanceof Block) {
                instance = (Block)object;
                if ((bits & 1L) == 0L) {
                    blockIdOptional = instance.getBlockId();
                    if (blockIdOptional.isPresent()) {
                        this.setBlockId(blockIdOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setBlockId(@Nullable String blockId) {
            this.blockId = blockId;
            return this;
        }

        public final Builder setBlockId(Optional<String> blockId) {
            this.blockId = blockId.orElse(null);
            return this;
        }

        public final Builder setExternalId(String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setSource(String source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public File build() {
            this.checkRequiredAttributes();
            return new File(this.blockId, this.externalId, this.source);
        }

        private boolean externalIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean sourceIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.externalIdIsSet()) {
                attributes.add("externalId");
            }
            if (!this.sourceIsSet()) {
                attributes.add("source");
            }
            return "Cannot build File, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FileIF", generator="Immutables")
    static final class Json
    implements FileIF {
        @Nullable
        Optional<String> blockId = Optional.empty();
        @Nullable
        String externalId;
        @Nullable
        String source;

        Json() {
        }

        @JsonProperty
        public void setBlockId(Optional<String> blockId) {
            this.blockId = blockId;
        }

        @JsonProperty
        public void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @JsonProperty
        public void setSource(String source) {
            this.source = source;
        }

        @Override
        public Optional<String> getBlockId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExternalId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSource() {
            throw new UnsupportedOperationException();
        }
    }
}

