/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.CallIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="CallIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Call
implements CallIF {
    @Nullable
    private final String blockId;
    private final transient String type;
    private final String callId;

    private Call(@Nullable String blockId, String callId) {
        this.blockId = blockId;
        this.callId = callId;
        this.type = Objects.requireNonNull(CallIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public Optional<String> getBlockId() {
        return Optional.ofNullable(this.blockId);
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getCallId() {
        return this.callId;
    }

    public final Call withBlockId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.blockId, newValue)) {
            return this;
        }
        return new Call(newValue, this.callId);
    }

    public final Call withBlockId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.blockId, value)) {
            return this;
        }
        return new Call(value, this.callId);
    }

    public final Call withCallId(String value) {
        String newValue = Objects.requireNonNull(value, "callId");
        if (this.callId.equals(newValue)) {
            return this;
        }
        return new Call(this.blockId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Call && this.equalTo(0, (Call)another);
    }

    private boolean equalTo(int synthetic, Call another) {
        return Objects.equals(this.blockId, another.blockId) && this.type.equals(another.type) && this.callId.equals(another.callId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.blockId);
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.callId.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Call{");
        if (this.blockId != null) {
            builder.append("blockId=").append(this.blockId);
        }
        if (builder.length() > 5) {
            builder.append(", ");
        }
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("callId=").append(this.callId);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Call fromJson(Json json) {
        Builder builder = Call.builder();
        if (json.blockId != null) {
            builder.setBlockId(json.blockId);
        }
        if (json.callId != null) {
            builder.setCallId(json.callId);
        }
        return builder.build();
    }

    public static Call copyOf(CallIF instance) {
        if (instance instanceof Call) {
            return (Call)instance;
        }
        return Call.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CallIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CALL_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String blockId;
        @Nullable
        private String callId;

        private Builder() {
        }

        public final Builder from(Block instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(CallIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> blockIdOptional;
            Block instance;
            long bits = 0L;
            if (object instanceof Block) {
                instance = (Block)object;
                if ((bits & 1L) == 0L) {
                    blockIdOptional = instance.getBlockId();
                    if (blockIdOptional.isPresent()) {
                        this.setBlockId(blockIdOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof CallIF) {
                instance = (CallIF)object;
                this.setCallId(instance.getCallId());
                if ((bits & 1L) == 0L) {
                    blockIdOptional = instance.getBlockId();
                    if (blockIdOptional.isPresent()) {
                        this.setBlockId(blockIdOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setBlockId(@Nullable String blockId) {
            this.blockId = blockId;
            return this;
        }

        public final Builder setBlockId(Optional<String> blockId) {
            this.blockId = blockId.orElse(null);
            return this;
        }

        public final Builder setCallId(String callId) {
            this.callId = Objects.requireNonNull(callId, "callId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Call build() {
            this.checkRequiredAttributes();
            return new Call(this.blockId, this.callId);
        }

        private boolean callIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.callIdIsSet()) {
                attributes.add("callId");
            }
            return "Cannot build Call, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CallIF", generator="Immutables")
    static final class Json
    implements CallIF {
        @Nullable
        Optional<String> blockId = Optional.empty();
        @Nullable
        String callId;

        Json() {
        }

        @JsonProperty
        public void setBlockId(Optional<String> blockId) {
            this.blockId = blockId;
        }

        @JsonProperty
        public void setCallId(String callId) {
            this.callId = callId;
        }

        @Override
        public Optional<String> getBlockId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCallId() {
            throw new UnsupportedOperationException();
        }
    }
}

