/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.ScheduledMessageIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ScheduledMessageIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ScheduledMessage
implements ScheduledMessageIF {
    private final String id;
    private final String channelId;
    private final long postAt;
    private final long dateCreated;
    private final String text;

    private ScheduledMessage(String id, String channelId, long postAt, long dateCreated, String text) {
        this.id = id;
        this.channelId = channelId;
        this.postAt = postAt;
        this.dateCreated = dateCreated;
        this.text = text;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public long getPostAt() {
        return this.postAt;
    }

    @Override
    @JsonProperty
    public long getDateCreated() {
        return this.dateCreated;
    }

    @Override
    @JsonProperty
    public String getText() {
        return this.text;
    }

    public final ScheduledMessage withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ScheduledMessage(newValue, this.channelId, this.postAt, this.dateCreated, this.text);
    }

    public final ScheduledMessage withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new ScheduledMessage(this.id, newValue, this.postAt, this.dateCreated, this.text);
    }

    public final ScheduledMessage withPostAt(long value) {
        if (this.postAt == value) {
            return this;
        }
        return new ScheduledMessage(this.id, this.channelId, value, this.dateCreated, this.text);
    }

    public final ScheduledMessage withDateCreated(long value) {
        if (this.dateCreated == value) {
            return this;
        }
        return new ScheduledMessage(this.id, this.channelId, this.postAt, value, this.text);
    }

    public final ScheduledMessage withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ScheduledMessage(this.id, this.channelId, this.postAt, this.dateCreated, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ScheduledMessage && this.equalTo(0, (ScheduledMessage)another);
    }

    private boolean equalTo(int synthetic, ScheduledMessage another) {
        return this.id.equals(another.id) && this.channelId.equals(another.channelId) && this.postAt == another.postAt && this.dateCreated == another.dateCreated && this.text.equals(another.text);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + Long.hashCode(this.postAt);
        h += (h << 5) + Long.hashCode(this.dateCreated);
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public String toString() {
        return "ScheduledMessage{id=" + this.id + ", channelId=" + this.channelId + ", postAt=" + this.postAt + ", dateCreated=" + this.dateCreated + ", text=" + this.text + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ScheduledMessage fromJson(Json json) {
        Builder builder = ScheduledMessage.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.postAtIsSet) {
            builder.setPostAt(json.postAt);
        }
        if (json.dateCreatedIsSet) {
            builder.setDateCreated(json.dateCreated);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        return builder.build();
    }

    public static ScheduledMessage copyOf(ScheduledMessageIF instance) {
        if (instance instanceof ScheduledMessage) {
            return (ScheduledMessage)instance;
        }
        return ScheduledMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ScheduledMessageIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_CHANNEL_ID = 2L;
        private static final long INIT_BIT_POST_AT = 4L;
        private static final long INIT_BIT_DATE_CREATED = 8L;
        private static final long INIT_BIT_TEXT = 16L;
        private long initBits = 31L;
        @Nullable
        private String id;
        @Nullable
        private String channelId;
        private long postAt;
        private long dateCreated;
        @Nullable
        private String text;

        private Builder() {
        }

        public final Builder from(ScheduledMessageIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setId(instance.getId());
            this.setChannelId(instance.getChannelId());
            this.setPostAt(instance.getPostAt());
            this.setDateCreated(instance.getDateCreated());
            this.setText(instance.getText());
            return this;
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setPostAt(long postAt) {
            this.postAt = postAt;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setDateCreated(long dateCreated) {
            this.dateCreated = dateCreated;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setText(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ScheduledMessage build() {
            this.checkRequiredAttributes();
            return new ScheduledMessage(this.id, this.channelId, this.postAt, this.dateCreated, this.text);
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean postAtIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean dateCreatedIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean textIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.postAtIsSet()) {
                attributes.add("postAt");
            }
            if (!this.dateCreatedIsSet()) {
                attributes.add("dateCreated");
            }
            if (!this.textIsSet()) {
                attributes.add("text");
            }
            return "Cannot build ScheduledMessage, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ScheduledMessageIF", generator="Immutables")
    static final class Json
    implements ScheduledMessageIF {
        @Nullable
        String id;
        @Nullable
        String channelId;
        long postAt;
        boolean postAtIsSet;
        long dateCreated;
        boolean dateCreatedIsSet;
        @Nullable
        String text;

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setPostAt(long postAt) {
            this.postAt = postAt;
            this.postAtIsSet = true;
        }

        @JsonProperty
        public void setDateCreated(long dateCreated) {
            this.dateCreated = dateCreated;
            this.dateCreatedIsSet = true;
        }

        @JsonProperty
        public void setText(String text) {
            this.text = text;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getPostAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getDateCreated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getText() {
            throw new UnsupportedOperationException();
        }
    }
}

