/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.FieldIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FieldIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Field
implements FieldIF {
    @Nullable
    private final String title;
    private final String value;
    private final boolean isShort;

    private Field(@Nullable String title, String value, boolean isShort) {
        this.title = title;
        this.value = value;
        this.isShort = isShort;
    }

    @Override
    @JsonProperty
    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    @Override
    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @Override
    @JsonProperty(value="short")
    public boolean isShort() {
        return this.isShort;
    }

    public final Field withTitle(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.title, newValue)) {
            return this;
        }
        return new Field(newValue, this.value, this.isShort);
    }

    public final Field withTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new Field(value, this.value, this.isShort);
    }

    public final Field withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new Field(this.title, newValue, this.isShort);
    }

    public final Field withShort(boolean value) {
        if (this.isShort == value) {
            return this;
        }
        return new Field(this.title, this.value, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Field && this.equalTo(0, (Field)another);
    }

    private boolean equalTo(int synthetic, Field another) {
        return Objects.equals(this.title, another.title) && this.value.equals(another.value) && this.isShort == another.isShort;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isShort);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Field{");
        if (this.title != null) {
            builder.append("title=").append(this.title);
        }
        if (builder.length() > 6) {
            builder.append(", ");
        }
        builder.append("value=").append(this.value);
        builder.append(", ");
        builder.append("short=").append(this.isShort);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Field fromJson(Json json) {
        Builder builder = Field.builder();
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.value != null) {
            builder.setValue(json.value);
        }
        if (json.isShortIsSet) {
            builder.setShort(json.isShort);
        }
        return builder.build();
    }

    public static Field copyOf(FieldIF instance) {
        if (instance instanceof Field) {
            return (Field)instance;
        }
        return Field.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FieldIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_IS_SHORT = 2L;
        private long initBits = 3L;
        @Nullable
        private String title;
        @Nullable
        private String value;
        private boolean isShort;

        private Builder() {
        }

        public final Builder from(FieldIF instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> titleOptional = instance.getTitle();
            if (titleOptional.isPresent()) {
                this.setTitle(titleOptional);
            }
            this.setValue(instance.getValue());
            this.setShort(instance.isShort());
            return this;
        }

        public final Builder setTitle(@Nullable String title) {
            this.title = title;
            return this;
        }

        public final Builder setTitle(Optional<String> title) {
            this.title = title.orElse(null);
            return this;
        }

        public final Builder setValue(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setShort(boolean isShort) {
            this.isShort = isShort;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Field build() {
            this.checkRequiredAttributes();
            return new Field(this.title, this.value, this.isShort);
        }

        private boolean valueIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean shortIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.valueIsSet()) {
                attributes.add("value");
            }
            if (!this.shortIsSet()) {
                attributes.add("short");
            }
            return "Cannot build Field, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FieldIF", generator="Immutables")
    static final class Json
    implements FieldIF {
        @Nullable
        Optional<String> title = Optional.empty();
        @Nullable
        String value;
        boolean isShort;
        boolean isShortIsSet;

        Json() {
        }

        @JsonProperty
        public void setTitle(Optional<String> title) {
            this.title = title;
        }

        @JsonProperty
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="short")
        public void setShort(boolean isShort) {
            this.isShort = isShort;
            this.isShortIsSet = true;
        }

        @Override
        public Optional<String> getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShort() {
            throw new UnsupportedOperationException();
        }
    }
}

