/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.views.UpdateViewParamsIF;
import com.hubspot.slack.client.models.views.ModalViewPayload;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="UpdateViewParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class UpdateViewParams
implements UpdateViewParamsIF {
    private final ModalViewPayload view;
    @Nullable
    private final String externalId;
    @Nullable
    private final String hash;
    @Nullable
    private final String viewId;

    private UpdateViewParams(ModalViewPayload view) {
        this.view = Objects.requireNonNull(view, "view");
        this.externalId = null;
        this.hash = null;
        this.viewId = null;
    }

    private UpdateViewParams(ModalViewPayload view, @Nullable String externalId, @Nullable String hash, @Nullable String viewId) {
        this.view = view;
        this.externalId = externalId;
        this.hash = hash;
        this.viewId = viewId;
    }

    @Override
    @JsonProperty
    public ModalViewPayload getView() {
        return this.view;
    }

    @Override
    @JsonProperty
    public Optional<String> getExternalId() {
        return Optional.ofNullable(this.externalId);
    }

    @Override
    @JsonProperty
    public Optional<String> getHash() {
        return Optional.ofNullable(this.hash);
    }

    @Override
    @JsonProperty
    public Optional<String> getViewId() {
        return Optional.ofNullable(this.viewId);
    }

    public final UpdateViewParams withView(ModalViewPayload value) {
        if (this.view == value) {
            return this;
        }
        ModalViewPayload newValue = Objects.requireNonNull(value, "view");
        return UpdateViewParams.validate(new UpdateViewParams(newValue, this.externalId, this.hash, this.viewId));
    }

    public final UpdateViewParams withExternalId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.externalId, newValue)) {
            return this;
        }
        return UpdateViewParams.validate(new UpdateViewParams(this.view, newValue, this.hash, this.viewId));
    }

    public final UpdateViewParams withExternalId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.externalId, value)) {
            return this;
        }
        return UpdateViewParams.validate(new UpdateViewParams(this.view, value, this.hash, this.viewId));
    }

    public final UpdateViewParams withHash(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.hash, newValue)) {
            return this;
        }
        return UpdateViewParams.validate(new UpdateViewParams(this.view, this.externalId, newValue, this.viewId));
    }

    public final UpdateViewParams withHash(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.hash, value)) {
            return this;
        }
        return UpdateViewParams.validate(new UpdateViewParams(this.view, this.externalId, value, this.viewId));
    }

    public final UpdateViewParams withViewId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.viewId, newValue)) {
            return this;
        }
        return UpdateViewParams.validate(new UpdateViewParams(this.view, this.externalId, this.hash, newValue));
    }

    public final UpdateViewParams withViewId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.viewId, value)) {
            return this;
        }
        return UpdateViewParams.validate(new UpdateViewParams(this.view, this.externalId, this.hash, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateViewParams && this.equalTo(0, (UpdateViewParams)another);
    }

    private boolean equalTo(int synthetic, UpdateViewParams another) {
        return this.view.equals(another.view) && Objects.equals(this.externalId, another.externalId) && Objects.equals(this.hash, another.hash) && Objects.equals(this.viewId, another.viewId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.view.hashCode();
        h += (h << 5) + Objects.hashCode(this.externalId);
        h += (h << 5) + Objects.hashCode(this.hash);
        h += (h << 5) + Objects.hashCode(this.viewId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UpdateViewParams{");
        builder.append("view=").append(this.view);
        if (this.externalId != null) {
            builder.append(", ");
            builder.append("externalId=").append(this.externalId);
        }
        if (this.hash != null) {
            builder.append(", ");
            builder.append("hash=").append(this.hash);
        }
        if (this.viewId != null) {
            builder.append(", ");
            builder.append("viewId=").append(this.viewId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UpdateViewParams fromJson(Json json) {
        Builder builder = UpdateViewParams.builder();
        if (json.view != null) {
            builder.setView(json.view);
        }
        if (json.externalId != null) {
            builder.setExternalId(json.externalId);
        }
        if (json.hash != null) {
            builder.setHash(json.hash);
        }
        if (json.viewId != null) {
            builder.setViewId(json.viewId);
        }
        return builder.build();
    }

    public static UpdateViewParams of(ModalViewPayload view) {
        return UpdateViewParams.validate(new UpdateViewParams(view));
    }

    private static UpdateViewParams validate(UpdateViewParams instance) {
        instance.check();
        return instance;
    }

    public static UpdateViewParams copyOf(UpdateViewParamsIF instance) {
        if (instance instanceof UpdateViewParams) {
            return (UpdateViewParams)instance;
        }
        return UpdateViewParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UpdateViewParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VIEW = 1L;
        private long initBits = 1L;
        @Nullable
        private ModalViewPayload view;
        @Nullable
        private String externalId;
        @Nullable
        private String hash;
        @Nullable
        private String viewId;

        private Builder() {
        }

        public final Builder from(UpdateViewParamsIF instance) {
            Optional<String> viewIdOptional;
            Optional<String> hashOptional;
            Objects.requireNonNull(instance, "instance");
            this.setView(instance.getView());
            Optional<String> externalIdOptional = instance.getExternalId();
            if (externalIdOptional.isPresent()) {
                this.setExternalId(externalIdOptional);
            }
            if ((hashOptional = instance.getHash()).isPresent()) {
                this.setHash(hashOptional);
            }
            if ((viewIdOptional = instance.getViewId()).isPresent()) {
                this.setViewId(viewIdOptional);
            }
            return this;
        }

        public final Builder setView(ModalViewPayload view) {
            this.view = Objects.requireNonNull(view, "view");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setExternalId(@Nullable String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final Builder setExternalId(Optional<String> externalId) {
            this.externalId = externalId.orElse(null);
            return this;
        }

        public final Builder setHash(@Nullable String hash) {
            this.hash = hash;
            return this;
        }

        public final Builder setHash(Optional<String> hash) {
            this.hash = hash.orElse(null);
            return this;
        }

        public final Builder setViewId(@Nullable String viewId) {
            this.viewId = viewId;
            return this;
        }

        public final Builder setViewId(Optional<String> viewId) {
            this.viewId = viewId.orElse(null);
            return this;
        }

        public UpdateViewParams build() {
            this.checkRequiredAttributes();
            return UpdateViewParams.validate(new UpdateViewParams(this.view, this.externalId, this.hash, this.viewId));
        }

        private boolean viewIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.viewIsSet()) {
                attributes.add("view");
            }
            return "Cannot build UpdateViewParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UpdateViewParamsIF", generator="Immutables")
    static final class Json
    implements UpdateViewParamsIF {
        @Nullable
        ModalViewPayload view;
        @Nullable
        Optional<String> externalId = Optional.empty();
        @Nullable
        Optional<String> hash = Optional.empty();
        @Nullable
        Optional<String> viewId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setView(ModalViewPayload view) {
            this.view = view;
        }

        @JsonProperty
        public void setExternalId(Optional<String> externalId) {
            this.externalId = externalId;
        }

        @JsonProperty
        public void setHash(Optional<String> hash) {
            this.hash = hash;
        }

        @JsonProperty
        public void setViewId(Optional<String> viewId) {
            this.viewId = viewId;
        }

        @Override
        public ModalViewPayload getView() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getExternalId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getViewId() {
            throw new UnsupportedOperationException();
        }
    }
}

