/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasUser;
import com.hubspot.slack.client.methods.params.users.UsersInfoParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="UsersInfoParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class UsersInfoParams
implements UsersInfoParamsIF {
    private final String userId;
    private final boolean includeLocale;

    private UsersInfoParams(String userId) {
        this.userId = Objects.requireNonNull(userId, "userId");
        this.includeLocale = UsersInfoParamsIF.super.getIncludeLocale();
    }

    private UsersInfoParams(Builder builder) {
        this.userId = builder.userId;
        this.includeLocale = builder.includeLocaleIsSet() ? builder.includeLocale : UsersInfoParamsIF.super.getIncludeLocale();
    }

    private UsersInfoParams(String userId, boolean includeLocale) {
        this.userId = userId;
        this.includeLocale = includeLocale;
    }

    @Override
    @JsonProperty(value="user")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="include_local")
    public boolean getIncludeLocale() {
        return this.includeLocale;
    }

    public final UsersInfoParams withUserId(String value) {
        String newValue = Objects.requireNonNull(value, "userId");
        if (this.userId.equals(newValue)) {
            return this;
        }
        return new UsersInfoParams(newValue, this.includeLocale);
    }

    public final UsersInfoParams withIncludeLocale(boolean value) {
        if (this.includeLocale == value) {
            return this;
        }
        return new UsersInfoParams(this.userId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UsersInfoParams && this.equalTo(0, (UsersInfoParams)another);
    }

    private boolean equalTo(int synthetic, UsersInfoParams another) {
        return this.userId.equals(another.userId) && this.includeLocale == another.includeLocale;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + Boolean.hashCode(this.includeLocale);
        return h;
    }

    public String toString() {
        return "UsersInfoParams{userId=" + this.userId + ", includeLocale=" + this.includeLocale + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UsersInfoParams fromJson(Json json) {
        Builder builder = UsersInfoParams.builder();
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.includeLocaleIsSet) {
            builder.setIncludeLocale(json.includeLocale);
        }
        return builder.build();
    }

    public static UsersInfoParams of(String userId) {
        return new UsersInfoParams(userId);
    }

    public static UsersInfoParams copyOf(UsersInfoParamsIF instance) {
        if (instance instanceof UsersInfoParams) {
            return (UsersInfoParams)instance;
        }
        return UsersInfoParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UsersInfoParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long OPT_BIT_INCLUDE_LOCALE = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String userId;
        private boolean includeLocale;

        private Builder() {
        }

        public final Builder from(UsersInfoParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(HasUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasUser instance;
            long bits = 0L;
            if (object instanceof UsersInfoParamsIF) {
                instance = (UsersInfoParamsIF)object;
                if ((bits & 1L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 1L;
                }
                this.setIncludeLocale(instance.getIncludeLocale());
            }
            if (object instanceof HasUser) {
                instance = (HasUser)object;
                if ((bits & 1L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 1L;
                }
            }
        }

        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setIncludeLocale(boolean includeLocale) {
            this.includeLocale = includeLocale;
            this.optBits |= 1L;
            return this;
        }

        public UsersInfoParams build() {
            this.checkRequiredAttributes();
            return new UsersInfoParams(this);
        }

        private boolean includeLocaleIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean userIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            return "Cannot build UsersInfoParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UsersInfoParamsIF", generator="Immutables")
    static final class Json
    implements UsersInfoParamsIF {
        @Nullable
        String userId;
        boolean includeLocale;
        boolean includeLocaleIsSet;

        Json() {
        }

        @JsonProperty(value="user")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="include_local")
        public void setIncludeLocale(boolean includeLocale) {
            this.includeLocale = includeLocale;
            this.includeLocaleIsSet = true;
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getIncludeLocale() {
            throw new UnsupportedOperationException();
        }
    }
}

