/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasUser;
import com.hubspot.slack.client.methods.params.users.SetUserProfileParamsIF;
import com.hubspot.slack.client.models.users.UserProfile;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SetUserProfileParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SetUserProfileParams
implements SetUserProfileParamsIF {
    private final String userId;
    @Nullable
    private final UserProfile userProfile;
    @Nullable
    private final String name;
    @Nullable
    private final String value;

    private SetUserProfileParams(String userId) {
        this.userId = Objects.requireNonNull(userId, "userId");
        this.userProfile = null;
        this.name = null;
        this.value = null;
    }

    private SetUserProfileParams(String userId, @Nullable UserProfile userProfile, @Nullable String name, @Nullable String value) {
        this.userId = userId;
        this.userProfile = userProfile;
        this.name = name;
        this.value = value;
    }

    @Override
    @JsonProperty(value="user")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="profile")
    public Optional<UserProfile> getUserProfile() {
        return Optional.ofNullable(this.userProfile);
    }

    @Override
    @JsonProperty(value="name")
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    @JsonProperty(value="value")
    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    public final SetUserProfileParams withUserId(String value) {
        String newValue = Objects.requireNonNull(value, "userId");
        if (this.userId.equals(newValue)) {
            return this;
        }
        return new SetUserProfileParams(newValue, this.userProfile, this.name, this.value);
    }

    public final SetUserProfileParams withUserProfile(@Nullable UserProfile value) {
        UserProfile newValue = value;
        if (this.userProfile == newValue) {
            return this;
        }
        return new SetUserProfileParams(this.userId, newValue, this.name, this.value);
    }

    public final SetUserProfileParams withUserProfile(Optional<? extends UserProfile> optional) {
        UserProfile value = optional.orElse(null);
        if (this.userProfile == value) {
            return this;
        }
        return new SetUserProfileParams(this.userId, value, this.name, this.value);
    }

    public final SetUserProfileParams withName(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return new SetUserProfileParams(this.userId, this.userProfile, newValue, this.value);
    }

    public final SetUserProfileParams withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new SetUserProfileParams(this.userId, this.userProfile, value, this.value);
    }

    public final SetUserProfileParams withValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.value, newValue)) {
            return this;
        }
        return new SetUserProfileParams(this.userId, this.userProfile, this.name, newValue);
    }

    public final SetUserProfileParams withValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.value, value)) {
            return this;
        }
        return new SetUserProfileParams(this.userId, this.userProfile, this.name, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SetUserProfileParams && this.equalTo(0, (SetUserProfileParams)another);
    }

    private boolean equalTo(int synthetic, SetUserProfileParams another) {
        return this.userId.equals(another.userId) && Objects.equals(this.userProfile, another.userProfile) && Objects.equals(this.name, another.name) && Objects.equals(this.value, another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + Objects.hashCode(this.userProfile);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.value);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SetUserProfileParams{");
        builder.append("userId=").append(this.userId);
        if (this.userProfile != null) {
            builder.append(", ");
            builder.append("userProfile=").append(this.userProfile);
        }
        if (this.name != null) {
            builder.append(", ");
            builder.append("name=").append(this.name);
        }
        if (this.value != null) {
            builder.append(", ");
            builder.append("value=").append(this.value);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SetUserProfileParams fromJson(Json json) {
        Builder builder = SetUserProfileParams.builder();
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.userProfile != null) {
            builder.setUserProfile(json.userProfile);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.value != null) {
            builder.setValue(json.value);
        }
        return builder.build();
    }

    public static SetUserProfileParams of(String userId) {
        return new SetUserProfileParams(userId);
    }

    public static SetUserProfileParams copyOf(SetUserProfileParamsIF instance) {
        if (instance instanceof SetUserProfileParams) {
            return (SetUserProfileParams)instance;
        }
        return SetUserProfileParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SetUserProfileParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String userId;
        @Nullable
        private UserProfile userProfile;
        @Nullable
        private String name;
        @Nullable
        private String value;

        private Builder() {
        }

        public final Builder from(SetUserProfileParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(HasUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasUser instance;
            long bits = 0L;
            if (object instanceof SetUserProfileParamsIF) {
                Optional<UserProfile> userProfileOptional;
                Optional<String> valueOptional;
                instance = (SetUserProfileParamsIF)object;
                Optional<String> nameOptional = instance.getName();
                if (nameOptional.isPresent()) {
                    this.setName(nameOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 1L;
                }
                if ((valueOptional = instance.getValue()).isPresent()) {
                    this.setValue(valueOptional);
                }
                if ((userProfileOptional = instance.getUserProfile()).isPresent()) {
                    this.setUserProfile(userProfileOptional);
                }
            }
            if (object instanceof HasUser) {
                instance = (HasUser)object;
                if ((bits & 1L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 1L;
                }
            }
        }

        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setUserProfile(@Nullable UserProfile userProfile) {
            this.userProfile = userProfile;
            return this;
        }

        public final Builder setUserProfile(Optional<? extends UserProfile> userProfile) {
            this.userProfile = userProfile.orElse(null);
            return this;
        }

        public final Builder setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder setName(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        public final Builder setValue(@Nullable String value) {
            this.value = value;
            return this;
        }

        public final Builder setValue(Optional<String> value) {
            this.value = value.orElse(null);
            return this;
        }

        public SetUserProfileParams build() {
            this.checkRequiredAttributes();
            return new SetUserProfileParams(this.userId, this.userProfile, this.name, this.value);
        }

        private boolean userIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            return "Cannot build SetUserProfileParams, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SetUserProfileParamsIF", generator="Immutables")
    static final class Json
    implements SetUserProfileParamsIF {
        @Nullable
        String userId;
        @Nullable
        Optional<UserProfile> userProfile = Optional.empty();
        @Nullable
        Optional<String> name = Optional.empty();
        @Nullable
        Optional<String> value = Optional.empty();

        Json() {
        }

        @JsonProperty(value="user")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="profile")
        public void setUserProfile(Optional<UserProfile> userProfile) {
            this.userProfile = userProfile;
        }

        @JsonProperty(value="name")
        public void setName(Optional<String> name) {
            this.name = name;
        }

        @JsonProperty(value="value")
        public void setValue(Optional<String> value) {
            this.value = value;
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UserProfile> getUserProfile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getValue() {
            throw new UnsupportedOperationException();
        }
    }
}

